/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.engine;

import java.lang.annotation.ElementType;
import javax.validation.groups.Default;
import org.hibernate.validator.engine.PathImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueContext<T, V> {
    private final T currentBean;
    private final Class<T> currentBeanType;
    private PathImpl propertyPath;
    private Class<?> currentGroup;
    private V currentValue;
    private ElementType elementType;

    public static <T, V> ValueContext<T, V> getLocalExecutionContext(T value) {
        Class<?> rootBeanClass = value.getClass();
        return new ValueContext<T, V>(value, rootBeanClass);
    }

    public static <T, V> ValueContext<T, V> getLocalExecutionContext(Class<T> type2) {
        return new ValueContext<Object, V>(null, type2);
    }

    public ValueContext(T currentBean, Class<T> currentBeanType) {
        this.currentBean = currentBean;
        this.currentBeanType = currentBeanType;
    }

    public PathImpl getPropertyPath() {
        return this.propertyPath;
    }

    public Class<?> getCurrentGroup() {
        return this.currentGroup;
    }

    public T getCurrentBean() {
        return this.currentBean;
    }

    public Class<T> getCurrentBeanType() {
        return this.currentBeanType;
    }

    public V getCurrentValidatedValue() {
        return this.currentValue;
    }

    public void setPropertyPath(PathImpl propertyPath) {
        this.propertyPath = propertyPath;
    }

    public void setCurrentGroup(Class<?> currentGroup) {
        this.currentGroup = currentGroup;
    }

    public void setCurrentValidatedValue(V currentValue) {
        this.currentValue = currentValue;
    }

    public void markCurrentPropertyAsIterable() {
        this.propertyPath.getLeafNode().setInIterable(true);
    }

    public boolean validatingDefault() {
        return this.getCurrentGroup() != null && this.getCurrentGroup().getName().equals(Default.class.getName());
    }

    public ElementType getElementType() {
        return this.elementType;
    }

    public void setElementType(ElementType elementType) {
        this.elementType = elementType;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ValueContext");
        sb.append("{currentBean=").append(this.currentBean);
        sb.append(", currentBeanType=").append(this.currentBeanType);
        sb.append(", propertyPath=").append(this.propertyPath);
        sb.append(", currentGroup=").append(this.currentGroup);
        sb.append(", currentValue=").append(this.currentValue);
        sb.append(", elementType=").append((Object)this.elementType);
        sb.append('}');
        return sb.toString();
    }
}

