/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resolution;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InterceptionType;
import org.jboss.weld.Container;
import org.jboss.weld.exceptions.IllegalArgumentException;
import org.jboss.weld.logging.messages.BeanManagerMessage;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.resolution.InterceptorResolvable;
import org.jboss.weld.resolution.Resolvable;
import org.jboss.weld.resolution.ResolvableBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptorResolvableBuilder
extends ResolvableBuilder {
    private InterceptionType interceptionType;

    public InterceptorResolvableBuilder() {
    }

    public InterceptorResolvableBuilder(Type type2) {
        super(type2);
    }

    @Override
    protected void checkQualifier(Annotation qualifier) {
        if (!Container.instance().services().get(MetaAnnotationStore.class).getInterceptorBindingModel(qualifier.annotationType()).isValid()) {
            throw new IllegalArgumentException(BeanManagerMessage.INTERCEPTOR_RESOLUTION_WITH_NONBINDING_TYPE, qualifier);
        }
        if (this.qualifiers.contains(qualifier)) {
            throw new IllegalArgumentException(BeanManagerMessage.DUPLICATE_INTERCEPTOR_BINDING, this.qualifiers);
        }
    }

    public InterceptorResolvableBuilder setInterceptionType(InterceptionType interceptionType) {
        this.interceptionType = interceptionType;
        return this;
    }

    @Override
    public InterceptorResolvableBuilder addQualifier(Annotation qualifier) {
        super.addQualifier(qualifier);
        return this;
    }

    @Override
    public InterceptorResolvableBuilder addQualifiers(Annotation[] qualifiers) {
        super.addQualifiers(qualifiers);
        return this;
    }

    @Override
    public InterceptorResolvableBuilder addQualifiers(Set<Annotation> qualifiers) {
        super.addQualifiers(qualifiers);
        return this;
    }

    @Override
    public InterceptorResolvableBuilder addType(Type type2) {
        super.addType(type2);
        return this;
    }

    @Override
    public InterceptorResolvableBuilder addTypes(Set<Type> types) {
        super.addTypes(types);
        return this;
    }

    @Override
    public InterceptorResolvableBuilder setDeclaringBean(Bean<?> declaringBean) {
        super.setDeclaringBean(declaringBean);
        return this;
    }

    @Override
    public InterceptorResolvable create() {
        if (this.qualifiers.size() == 0) {
            throw new IllegalArgumentException(BeanManagerMessage.INTERCEPTOR_BINDINGS_EMPTY, new Object[0]);
        }
        return new InterceptorResolvableImpl(this.rawType, this.types, this.qualifiers, this.mappedQualifiers, this.declaringBean, this.interceptionType);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InterceptorResolvableImpl
    extends ResolvableBuilder.ResolvableImpl
    implements InterceptorResolvable {
        private final InterceptionType interceptionType;

        private InterceptorResolvableImpl(Class<?> rawType, Set<Type> typeClosure, Set<Annotation> qualifiers, Map<Class<? extends Annotation>, Annotation> mappedQualifiers, Bean<?> declaringBean, InterceptionType interceptionType) {
            super(rawType, typeClosure, qualifiers, mappedQualifiers, declaringBean);
            this.interceptionType = interceptionType;
        }

        @Override
        public InterceptionType getInterceptionType() {
            return this.interceptionType;
        }

        @Override
        public int hashCode() {
            return 31 * super.hashCode() + this.getInterceptionType().hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof Resolvable) {
                Resolvable r = (Resolvable)o;
                return super.equals(r) && r instanceof InterceptorResolvable && this.getInterceptionType().equals((Object)((InterceptorResolvable)r).getInterceptionType());
            }
            return false;
        }
    }
}

