/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.component.internal.runlevel;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jvnet.hk2.annotations.RunLevel;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.HabitatListener;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.RunLevelService;
import org.jvnet.hk2.component.internal.runlevel.RunLevelServiceStub;

public class RunLevelServices {
    private Map<Habitat, Map<Class<?>, RunLevelServiceStub>> map = new HashMap();

    public synchronized RunLevelService<?> get(Habitat habitat, RunLevel rl) {
        assert (null != rl);
        RunLevelService<?> rls = this.getFromMap(habitat, rl.environment());
        if (null == rls) {
            rls = RunLevelServices.getFromHabitat(habitat, rl.environment());
        }
        if (null == rls) {
            rls = this.create(habitat, rl);
        }
        return rls;
    }

    static RunLevelService<?> getFromHabitat(Habitat habitat, Class<?> environment) {
        if (null == habitat) {
            return null;
        }
        Collection<RunLevelService> coll = habitat.getAllByContract(RunLevelService.class);
        RunLevelService theOne = null;
        for (RunLevelService hrls : coll) {
            if (null == hrls.getState() || hrls.getState().getEnvironment() != environment) continue;
            if (null != theOne) {
                throw new ComponentException("constraint violation - competing RunLevelServices: " + theOne + " and " + hrls);
            }
            theOne = hrls;
        }
        return theOne;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RunLevelService<?> getFromMap(Habitat habitat, Class<?> env) {
        RunLevelService rls;
        Map<Class<?>, RunLevelServiceStub> envMap;
        Map<Habitat, Map<Class<?>, RunLevelServiceStub>> map = this.map;
        synchronized (map) {
            envMap = this.map.get(habitat);
            if (null == envMap) {
                return null;
            }
        }
        Map<Class<?>, RunLevelServiceStub> map2 = envMap;
        synchronized (map2) {
            rls = envMap.get(env);
        }
        return rls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RunLevelService<?> create(Habitat habitat, RunLevel rl) {
        RunLevelServiceStub rls;
        Map<Class<?>, RunLevelServiceStub> envMap;
        this.initialize(habitat, rl);
        Map<Habitat, Map<Class<?>, RunLevelServiceStub>> map = this.map;
        synchronized (map) {
            envMap = this.map.get(habitat);
            if (null == envMap) {
                envMap = new HashMap();
                this.map.put(habitat, envMap);
            }
        }
        Map<Class<?>, RunLevelServiceStub> map2 = envMap;
        synchronized (map2) {
            rls = envMap.get(rl.environment());
            if (null == rls) {
                rls = new RunLevelServiceStub(habitat, rl.environment());
                envMap.put(rl.environment(), rls);
            }
        }
        return rls;
    }

    private void initialize(Habitat habitat, RunLevel rl) {
        if (null == habitat) {
            return;
        }
        if (habitat.isInitialized()) {
            throw new ComponentException("no RunLevelService found appropriate for RunLevel: " + rl);
        }
        habitat.addHabitatListener(new HabitatListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean inhabitantChanged(HabitatListener.EventType eventType, Habitat habitat, Inhabitant<?> inhabitant) {
                if (HabitatListener.EventType.HABITAT_INITIALIZED == eventType) {
                    Map rlss;
                    Map map = RunLevelServices.this.map;
                    synchronized (map) {
                        rlss = (Map)RunLevelServices.this.map.remove(habitat);
                    }
                    if (null != rlss) {
                        for (RunLevelServiceStub rls : rlss.values()) {
                            RunLevelService<?> realRls = RunLevelServices.getFromHabitat(rls.getHabitat(), rls.getEnvironment());
                            rls.activate(realRls);
                        }
                    }
                    return false;
                }
                return true;
            }

            @Override
            public boolean inhabitantIndexChanged(HabitatListener.EventType eventType, Habitat habitat, Inhabitant<?> inhabitant, String index, String name, Object service) {
                return true;
            }
        });
    }
}

