/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.classmodel;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.component.classmodel.ClassPath;

public class CodeSourceFilter {
    private final Logger logger = Logger.getLogger(CodeSourceFilter.class.getName());
    private final ClassPath filter;
    private final HashMap<String, File> classes = new HashMap();

    public CodeSourceFilter(ClassPath filter) {
        this.filter = filter;
        try {
            if (null != filter) {
                this.initialize();
            }
        }
        catch (IOException e) {
            Logger.getAnonymousLogger().log(Level.FINE, "error occurred", e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.classes.toString();
    }

    public boolean matches(String className) {
        return this.classes.containsKey(className);
    }

    public File codeSourceOf(String className) {
        return this.classes.get(className);
    }

    private void initialize() throws IOException {
        for (File file : this.filter.getFileEntries()) {
            if (!file.exists()) continue;
            if (file.isFile()) {
                this.indexJar(new JarFile(file), file);
                continue;
            }
            if (!file.isDirectory()) continue;
            this.indexDir("", file);
        }
    }

    private void indexJar(JarFile jarFile, File file) throws IOException {
        Enumeration<JarEntry> en = jarFile.entries();
        while (en.hasMoreElements()) {
            JarEntry entry = en.nextElement();
            this.index(entry.getName().replace("/", "."), file);
        }
        jarFile.close();
    }

    private void indexDir(String baseName, File directory) {
        File[] files = directory.listFiles();
        if (null == files) {
            return;
        }
        for (File file : files) {
            if (file.isHidden()) continue;
            if (file.isDirectory()) {
                this.indexDir(baseName + (baseName.isEmpty() ? "" : ".") + file.getName(), file);
                continue;
            }
            this.index(baseName + (baseName.isEmpty() ? "" : ".") + file.getName(), directory);
        }
    }

    private void index(String name, File codeSource) {
        File oldFile;
        if (name.endsWith(".class") && !this.isnum(name.charAt(0)) && null != (oldFile = this.classes.put(name = name.substring(0, name.length() - 6), codeSource))) {
            this.classes.put(name, oldFile);
            this.logger.log(Level.WARNING, "duplicate class: {0} in {1} and {2}", new Object[]{name, oldFile, codeSource});
        }
    }

    private boolean isnum(char ch) {
        return ch >= '0' && ch <= '9';
    }
}

