/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.classmodel;

import com.sun.enterprise.tools.InhabitantsDescriptor;
import com.sun.enterprise.tools.classmodel.CodeSourceFilter;
import com.sun.enterprise.tools.classmodel.Constants;
import com.sun.enterprise.tools.classmodel.InhabitantsGenerator;
import com.sun.enterprise.tools.classmodel.Utilities;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.component.classmodel.ClassPath;

public class InhabitantsFilter
extends Constants {
    private static Logger logger = Logger.getLogger(InhabitantsFilter.class.getName());

    protected InhabitantsFilter() {
    }

    public static void main(String[] args) throws Exception {
        File sourceInhabitantFile = InhabitantsGenerator.getInhabitantFile("inhabitants.source.file", false);
        if (!sourceInhabitantFile.exists()) {
            logger.log(Level.INFO, "Nothing to do.");
            return;
        }
        File targetInhabitantFile = InhabitantsGenerator.getInhabitantFile("inhabitants.target.file", false);
        ClassPath targetClassPath = InhabitantsGenerator.getScopedInhabitantCodeSources();
        CodeSourceFilter filter = new CodeSourceFilter(targetClassPath);
        logger.log(Level.FINE, "filter is {0}", filter);
        InhabitantsDescriptor inDescriptor = new InhabitantsDescriptor();
        logger.log(Level.FINE, "source file is {0}", sourceInhabitantFile);
        inDescriptor.load(sourceInhabitantFile);
        InhabitantsDescriptor outDescriptor = new InhabitantsDescriptor();
        outDescriptor.enableDateOutput(false);
        boolean sorted = Boolean.getBoolean("inhabitants.sorted");
        InhabitantsFilter.process(inDescriptor, outDescriptor, filter);
        InhabitantsFilter.writeInhabitantsFile(targetInhabitantFile, outDescriptor, sorted);
    }

    public static void process(InhabitantsDescriptor inDescriptor, InhabitantsDescriptor outDescriptor, CodeSourceFilter filter) {
        for (Map.Entry entry : inDescriptor.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            String clazz = InhabitantsFilter.classOf(value);
            if (null != filter && !filter.matches(clazz)) continue;
            outDescriptor.put(key, value);
        }
    }

    public static void writeInhabitantsFile(File targetInhabitantFile, InhabitantsDescriptor outDescriptor, boolean sorted) throws FileNotFoundException, IOException {
        if (outDescriptor.isEmpty()) {
            targetInhabitantFile.delete();
        } else {
            logger.log(Level.INFO, "writing file {0}", targetInhabitantFile);
            if (!sorted) {
                outDescriptor.write(targetInhabitantFile);
            } else {
                File parent = targetInhabitantFile.getParentFile();
                if (null != parent) {
                    parent.mkdirs();
                }
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                PrintWriter w = new PrintWriter(out);
                outDescriptor.write(w);
                w.close();
                String sorterdInhabitants = Utilities.sortInhabitantsDescriptor(out.toString(), sorted);
                FileOutputStream fos = new FileOutputStream(targetInhabitantFile);
                fos.write(sorterdInhabitants.getBytes());
                fos.close();
            }
        }
    }

    static String classOf(String value) {
        return (String)Utilities.split(value).getOne((Object)"class");
    }
}

