/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.util;

import com.sun.faces.RIConstants;
import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.facelets.component.UIRepeat;
import com.sun.faces.io.FastStringWriter;
import com.sun.faces.util.DebugUtil;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.LRUMap;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.ReflectionUtils;
import com.sun.faces.util.RequestStateManager;
import jakarta.el.ValueExpression;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.faces.FacesException;
import jakarta.faces.application.Application;
import jakarta.faces.application.ProjectStage;
import jakarta.faces.application.StateManager;
import jakarta.faces.application.ViewHandler;
import jakarta.faces.component.NamingContainer;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIData;
import jakarta.faces.component.UINamingContainer;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.convert.Converter;
import jakarta.faces.event.AbortProcessingException;
import jakarta.faces.webapp.FacesServlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRegistration;
import java.beans.FeatureDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.validation.SchemaFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;

public class Util {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    private static boolean unitTestModeEnabled = false;
    private static final String PATTERN_CACHE_KEY = "com.sun.faces.patternCache";
    private static final String CLIENT_ID_NESTED_IN_ITERATOR_PATTERN = "CLIENT_ID_NESTED_IN_ITERATOR_PATTERN";
    private static final String FACES_SERVLET_CLASS = FacesServlet.class.getName();
    private static final String EXACT_MARKER = "* *";
    private static final String FACES_CONTEXT_ATTRIBUTES_DOCTYPE_KEY = Util.class.getName() + "_FACES_CONTEXT_ATTRS_DOCTYPE_KEY";
    private static final String FACES_CONTEXT_ATTRIBUTES_XMLDECL_KEY = Util.class.getName() + "_FACES_CONTEXT_ATTRS_XMLDECL_KEY";

    private Util() {
        throw new IllegalStateException();
    }

    private static Map<String, Pattern> getPatternCache(Map<String, Object> appMap) {
        LRUMap result = (LRUMap)appMap.get(PATTERN_CACHE_KEY);
        if (result == null) {
            result = new LRUMap(15);
            appMap.put(PATTERN_CACHE_KEY, result);
        }
        return result;
    }

    private static Map<String, Pattern> getPatternCache(ServletContext sc) {
        LRUMap result = (LRUMap)sc.getAttribute(PATTERN_CACHE_KEY);
        if (result == null) {
            result = new LRUMap(15);
            sc.setAttribute(PATTERN_CACHE_KEY, result);
        }
        return result;
    }

    private static Collection<String> getFacesServletMappings(ServletContext servletContext) {
        Collection mappings = (Collection)servletContext.getAttribute("com.sun.faces.FacesServletMappings");
        if (mappings != null) {
            return mappings;
        }
        ServletRegistration facesRegistration = Util.getExistingFacesServletRegistration(servletContext);
        if (facesRegistration != null) {
            return facesRegistration.getMappings();
        }
        return Collections.emptyList();
    }

    private static ServletRegistration getExistingFacesServletRegistration(ServletContext servletContext) {
        Map existing = servletContext.getServletRegistrations();
        for (ServletRegistration registration : existing.values()) {
            if (!FACES_SERVLET_CLASS.equals(registration.getClassName())) continue;
            return registration;
        }
        return null;
    }

    public static boolean isPortletRequest(FacesContext context) {
        return context.getExternalContext().getRequestMap().get("javax.portlet.faces.phase") != null;
    }

    public static String generateCreatedBy(FacesContext facesContext) {
        String applicationContextPath = "unitTest";
        try {
            applicationContextPath = facesContext.getExternalContext().getApplicationContextPath();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return applicationContextPath + " " + Thread.currentThread().toString() + " " + System.currentTimeMillis();
    }

    public static Object getListenerInstance(ValueExpression type, ValueExpression binding) {
        FacesContext faces = FacesContext.getCurrentInstance();
        Object instance = null;
        if (faces == null) {
            return null;
        }
        if (binding != null) {
            instance = binding.getValue(faces.getELContext());
        }
        if (instance == null && type != null) {
            try {
                instance = ReflectionUtils.newInstance((String)type.getValue(faces.getELContext()));
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new AbortProcessingException(e.getMessage(), e);
            }
            if (binding != null) {
                binding.setValue(faces.getELContext(), instance);
            }
        }
        return instance;
    }

    public static void setUnitTestModeEnabled(boolean enabled) {
        unitTestModeEnabled = enabled;
    }

    public static boolean isUnitTestModeEnabled() {
        return unitTestModeEnabled;
    }

    public static TransformerFactory createTransformerFactory() {
        TransformerFactory factory;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(Util.class.getClassLoader());
            factory = TransformerFactory.newInstance();
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
        return factory;
    }

    public static SAXParserFactory createSAXParserFactory() {
        SAXParserFactory factory;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(Util.class.getClassLoader());
            factory = SAXParserFactory.newInstance();
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
        return factory;
    }

    public static DocumentBuilderFactory createDocumentBuilderFactory() {
        DocumentBuilderFactory factory;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(Util.class.getClassLoader());
            factory = DocumentBuilderFactory.newInstance();
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
        return factory;
    }

    public static SchemaFactory createSchemaFactory(String uri) {
        SchemaFactory factory;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(Util.class.getClassLoader());
            factory = SchemaFactory.newInstance(uri);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
        return factory;
    }

    public static Class loadClass(String name, Object fallbackClass) throws ClassNotFoundException {
        ClassLoader loader = Util.getCurrentLoader(fallbackClass);
        String[] primitiveNames = new String[]{"byte", "short", "int", "long", "float", "double", "boolean", "char"};
        Class[] primitiveClasses = new Class[]{Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Boolean.TYPE, Character.TYPE};
        for (int i = 0; i < primitiveNames.length; ++i) {
            if (!primitiveNames[i].equals(name)) continue;
            return primitiveClasses[i];
        }
        return Class.forName(name, true, loader);
    }

    public static Class<?> loadClass2(String name, Object fallbackClass) {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (loader == null) {
                loader = fallbackClass.getClass().getClassLoader();
            }
            return Class.forName(name, true, loader);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public static <T> T newInstance(Class<?> clazz) {
        try {
            return (T)clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public static ClassLoader getCurrentLoader(Object fallbackClass) {
        ClassLoader loader = Util.getContextClassLoader();
        if (loader == null) {
            loader = fallbackClass.getClass().getClassLoader();
        }
        return loader;
    }

    private static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return (ClassLoader)AccessController.doPrivileged(() -> Thread.currentThread().getContextClassLoader());
    }

    public static ClassLoader getContextClassLoader2() throws FacesException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            throw new FacesException("getContextClassLoader");
        }
        return classLoader;
    }

    public static String removeAllButLastSlashPathSegment(String input) {
        int slash;
        int len;
        if (input.charAt(0) == '/') {
            input = input.substring(1);
        }
        if (input.charAt((len = input.length()) - 1) == '/') {
            input = input.substring(0, len - 1);
        }
        if (-1 != (slash = input.lastIndexOf("/"))) {
            input = input.substring(slash + 1);
        }
        return input;
    }

    public static String removeAllButNextToLastSlashPathSegment(String input) {
        int lastSlash;
        int len;
        if (input.charAt(0) == '/') {
            input = input.substring(1);
        }
        if (input.charAt((len = input.length()) - 1) == '/') {
            input = input.substring(0, len - 1);
        }
        if (-1 != (lastSlash = input.lastIndexOf("/"))) {
            int startOrPreviousSlash = input.lastIndexOf("/", lastSlash - 1);
            startOrPreviousSlash = -1 == startOrPreviousSlash ? 0 : startOrPreviousSlash;
            input = input.substring(startOrPreviousSlash, lastSlash);
        }
        return input;
    }

    public static String removeLastPathSegment(String input) {
        int slash = input.lastIndexOf("/");
        if (-1 != slash) {
            input = input.substring(0, slash);
        }
        return input;
    }

    public static void notNegative(String varname, long number) {
        if (number < 0L) {
            throw new IllegalArgumentException("\"" + varname + "\" is negative");
        }
    }

    public static void notNull(String varname, Object var) {
        if (var == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", varname));
        }
    }

    public static void notNullViewId(String viewId) {
        if (viewId == null) {
            throw new IllegalArgumentException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_VIEW_ID", new Object[0]));
        }
    }

    public static void notNullNamedObject(Object object, String objectId, String logMsg) {
        if (object == null) {
            Object[] params = new Object[]{objectId};
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, logMsg, params);
            }
            throw new FacesException(MessageUtils.getExceptionMessageString("com.sun.faces.NAMED_OBJECT_NOT_FOUND_ERROR", params));
        }
    }

    public static void canSetAppArtifact(ApplicationAssociate applicationAssociate, String artifactName) {
        if (applicationAssociate.hasRequestBeenServiced()) {
            throw new IllegalStateException(MessageUtils.getExceptionMessageString("com.sun.faces.ILLEGAL_ATTEMPT_SETTING_APPLICATION_ARTIFACT", artifactName));
        }
    }

    public static void notNullAttribute(String attributeName, Object attribute) {
        if (attribute == null) {
            throw new FacesException("The \"" + attributeName + "\" attribute is required");
        }
    }

    public static ValueExpression getValueExpressionNullSafe(UIComponent component, String name) {
        ValueExpression valueExpression = component.getValueExpression(name);
        Util.notNullAttribute(name, valueExpression);
        return valueExpression;
    }

    public static boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof String) {
            return ((String)value).isEmpty();
        }
        if (value instanceof Collection) {
            return ((Collection)value).isEmpty();
        }
        if (value instanceof Map) {
            return ((Map)value).isEmpty();
        }
        if (value instanceof Optional) {
            return !((Optional)value).isPresent();
        }
        if (value.getClass().isArray()) {
            return Array.getLength(value) == 0;
        }
        return value.toString() == null || value.toString().isEmpty();
    }

    public static boolean isAllEmpty(Object ... values) {
        for (Object value : values) {
            if (Util.isEmpty(value)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAnyEmpty(Object ... values) {
        for (Object value : values) {
            if (!Util.isEmpty(value)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllNull(Object ... values) {
        for (Object value : values) {
            if (value == null) continue;
            return false;
        }
        return true;
    }

    public static boolean isAnyNull(Object ... values) {
        for (Object value : values) {
            if (value != null) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    public static <T> boolean isOneOf(T object, T ... objects) {
        for (T other : objects) {
            if (!(object == null ? other == null : object.equals(other))) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    public static <T> T coalesce(T ... objects) {
        for (T object : objects) {
            if (object == null) continue;
            return object;
        }
        return null;
    }

    public static <T> List<T> reverse(List<T> list) {
        int length = list.size();
        ArrayList<T> result = new ArrayList<T>(length);
        for (int i = length - 1; i >= 0; --i) {
            result.add(list.get(i));
        }
        return result;
    }

    public static boolean startsWithOneOf(String string, String ... prefixes) {
        if (prefixes == null) {
            return false;
        }
        for (String prefix : prefixes) {
            if (!string.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public static Locale getLocaleFromContextOrSystem(FacesContext context) {
        UIViewRoot root;
        Locale temp;
        Locale result = temp = Locale.getDefault();
        if (null != context && null != (root = context.getViewRoot()) && null == (result = root.getLocale())) {
            result = temp;
        }
        return result;
    }

    public static Converter getConverterForClass(Class converterClass, FacesContext context) {
        if (converterClass == null) {
            return null;
        }
        try {
            Application application = context.getApplication();
            return application.createConverter(converterClass);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Converter getConverterForIdentifer(String converterId, FacesContext context) {
        if (converterId == null) {
            return null;
        }
        try {
            Application application = context.getApplication();
            return application.createConverter(converterId);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static StateManager getStateManager(FacesContext context) throws FacesException {
        return context.getApplication().getStateManager();
    }

    public static Class getTypeFromString(String type) throws ClassNotFoundException {
        Class result;
        switch (type) {
            case "byte": {
                result = Byte.TYPE;
                break;
            }
            case "short": {
                result = Short.TYPE;
                break;
            }
            case "int": {
                result = Integer.TYPE;
                break;
            }
            case "long": {
                result = Long.TYPE;
                break;
            }
            case "float": {
                result = Float.TYPE;
                break;
            }
            case "double": {
                result = Double.TYPE;
                break;
            }
            case "boolean": {
                result = Boolean.TYPE;
                break;
            }
            case "char": {
                result = Character.TYPE;
                break;
            }
            case "void": {
                result = Void.TYPE;
                break;
            }
            default: {
                if (type.indexOf(46) == -1) {
                    type = "java.lang." + type;
                }
                result = Util.loadClass(type, Void.TYPE);
            }
        }
        return result;
    }

    public static ViewHandler getViewHandler(FacesContext context) throws FacesException {
        Application application = context.getApplication();
        assert (application != null);
        ViewHandler viewHandler = application.getViewHandler();
        assert (viewHandler != null);
        return viewHandler;
    }

    public static boolean componentIsDisabled(UIComponent component) {
        return Boolean.valueOf(String.valueOf(component.getAttributes().get("disabled")));
    }

    public static boolean componentIsDisabledOrReadonly(UIComponent component) {
        return Boolean.valueOf(String.valueOf(component.getAttributes().get("disabled"))) != false || Boolean.valueOf(String.valueOf(component.getAttributes().get("readonly"))) != false;
    }

    public static Locale getLocaleFromString(String localeStr) throws IllegalArgumentException {
        if (null == localeStr || localeStr.length() < 2) {
            throw new IllegalArgumentException("Illegal locale String: " + localeStr);
        }
        Locale result = null;
        try {
            Method method = Locale.class.getMethod("forLanguageTag", String.class);
            if (method != null) {
                result = (Locale)method.invoke(null, localeStr);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException method) {
            // empty catch block
        }
        if (result == null || result.getLanguage().equals("")) {
            String lang = null;
            String country = null;
            String variant = null;
            char[] seps = new char[]{'-', '_'};
            int inputLength = localeStr.length();
            int i = 0;
            int j = 0;
            if (inputLength >= 2 && (i = Util.indexOfSet(localeStr, seps, 0)) == -1) {
                if (2 != localeStr.length()) {
                    throw new IllegalArgumentException("Illegal locale String: " + localeStr);
                }
                lang = localeStr.toLowerCase();
            }
            if (i != -1) {
                lang = localeStr.substring(0, i);
                if (inputLength >= 5 && (j = Util.indexOfSet(localeStr, seps, i + 1)) == -1) {
                    if (inputLength != 5) {
                        throw new IllegalArgumentException("Illegal locale String: " + localeStr);
                    }
                    country = localeStr.substring(i + 1);
                }
                if (j != -1) {
                    country = localeStr.substring(i + 1, j);
                    if (inputLength >= 8) {
                        variant = localeStr.substring(j + 1);
                    } else {
                        throw new IllegalArgumentException("Illegal locale String: " + localeStr);
                    }
                }
            }
            if (variant != null && country != null && lang != null) {
                result = new Locale(lang, country, variant);
            } else if (lang != null && country != null) {
                result = new Locale(lang, country);
            } else if (lang != null) {
                result = new Locale(lang, "");
            }
        }
        return result;
    }

    public static int indexOfSet(String str, char[] set, int fromIndex) {
        int result = -1;
        int len = str.length();
        for (int i = fromIndex; i < len; ++i) {
            int innerLen = set.length;
            for (int j = 0; j < innerLen; ++j) {
                if (str.charAt(i) != set[j]) continue;
                result = i;
                break;
            }
            if (-1 != result) break;
        }
        return result;
    }

    public static String getStackTraceString(Throwable e) {
        if (null == e) {
            return "";
        }
        StackTraceElement[] stacks = e.getStackTrace();
        StringBuffer sb = new StringBuffer();
        for (StackTraceElement stack : stacks) {
            sb.append(stack.toString()).append('\n');
        }
        return sb.toString();
    }

    public static String getContentTypeFromResponse(Object response) {
        String result = null;
        if (null != response) {
            try {
                Object obj;
                Method method = ReflectionUtils.lookupMethod(response.getClass(), "getContentType", RIConstants.EMPTY_CLASS_ARGS);
                if (null != method && null != (obj = method.invoke(response, RIConstants.EMPTY_METH_ARGS))) {
                    result = obj.toString();
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new FacesException(e);
            }
        }
        return result;
    }

    public static FeatureDescriptor getFeatureDescriptor(String name, String displayName, String desc, boolean expert, boolean hidden, boolean preferred, Object type, Boolean designTime) {
        FeatureDescriptor fd = new FeatureDescriptor();
        fd.setName(name);
        fd.setDisplayName(displayName);
        fd.setShortDescription(desc);
        fd.setExpert(expert);
        fd.setHidden(hidden);
        fd.setPreferred(preferred);
        fd.setValue("type", type);
        fd.setValue("resolvableAtDesignTime", designTime);
        return fd;
    }

    public static synchronized String[] split(Map<String, Object> appMap, String toSplit, String regex) {
        return Util.split(appMap, toSplit, regex, 0);
    }

    public static synchronized String[] split(Map<String, Object> appMap, String toSplit, String regex, int splitLimit) {
        Map<String, Pattern> patternCache = Util.getPatternCache(appMap);
        Pattern pattern = patternCache.get(regex);
        if (pattern == null) {
            pattern = Pattern.compile(regex);
            patternCache.put(regex, pattern);
        }
        return pattern.split(toSplit, splitLimit);
    }

    public static synchronized String[] split(ServletContext sc, String toSplit, String regex) {
        Map<String, Pattern> patternCache = Util.getPatternCache(sc);
        Pattern pattern = patternCache.get(regex);
        if (pattern == null) {
            pattern = Pattern.compile(regex);
            patternCache.put(regex, pattern);
        }
        return pattern.split(toSplit, 0);
    }

    public static String getFacesMapping(FacesContext context) {
        Util.notNull("context", context);
        String mapping = (String)RequestStateManager.get(context, "com.sun.faces.INVOCATION_PATH");
        if (mapping == null) {
            String pathInfo;
            String servletPath;
            ExternalContext externalContext = context.getExternalContext();
            mapping = Util.getMappingForRequest(externalContext, servletPath = externalContext.getRequestServletPath(), pathInfo = externalContext.getRequestPathInfo());
            if (mapping == null && LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "jsf.faces_servlet_mapping_cannot_be_determined_error", new Object[]{servletPath});
            }
            if (mapping != null) {
                RequestStateManager.set(context, "com.sun.faces.INVOCATION_PATH", mapping);
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "URL pattern of the FacesServlet executing the current request " + mapping);
        }
        return mapping;
    }

    private static String getMappingForRequest(ExternalContext externalContext, String servletPath, String pathInfo) {
        if (servletPath == null) {
            return null;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "servletPath " + servletPath);
            LOGGER.log(Level.FINE, "pathInfo " + pathInfo);
        }
        if (servletPath.length() == 0) {
            return "/*";
        }
        if (pathInfo != null) {
            return servletPath;
        }
        if (servletPath.indexOf(46) < 0) {
            Collection<String> servletMappings;
            Object context = externalContext.getContext();
            if (context instanceof ServletContext && (servletMappings = Util.getFacesServletMappings((ServletContext)context)).contains(servletPath)) {
                return Util.addExactMappedMarker(servletPath);
            }
            return servletPath;
        }
        return servletPath.substring(servletPath.lastIndexOf(46));
    }

    public static boolean isViewIdExactMappedToFacesServlet(String viewId) {
        return Util.isResourceExactMappedToFacesServlet(FacesContext.getCurrentInstance().getExternalContext(), viewId);
    }

    public static boolean isResourceExactMappedToFacesServlet(ExternalContext externalContext, String resource) {
        Object context = externalContext.getContext();
        if (context instanceof ServletContext) {
            return Util.getFacesServletMappings((ServletContext)context).contains(resource);
        }
        return false;
    }

    public static String getFirstWildCardMappingToFacesServlet(ExternalContext externalContext) {
        Object context = externalContext.getContext();
        if (context instanceof ServletContext) {
            return Util.getFacesServletMappings((ServletContext)context).stream().filter(mapping -> mapping.contains("*")).findFirst().orElse(null);
        }
        return null;
    }

    public static String addExactMappedMarker(String mapping) {
        return EXACT_MARKER + mapping;
    }

    public static String removeExactMappedMarker(String mapping) {
        return mapping.substring(EXACT_MARKER.length());
    }

    public static boolean isExactMapped(String mapping) {
        return mapping.startsWith(EXACT_MARKER);
    }

    public static boolean isPrefixMapped(String mapping) {
        return mapping.charAt(0) == '/';
    }

    public static boolean isSpecialAttributeName(String name) {
        boolean isSpecialAttributeName = name.equals("action") || name.equals("actionListener") || name.equals("validator") || name.equals("valueChangeListener");
        return isSpecialAttributeName;
    }

    public static boolean isViewPopulated(FacesContext ctx, UIViewRoot viewToRender) {
        return ctx.getAttributes().containsKey(viewToRender);
    }

    public static void setViewPopulated(FacesContext ctx, UIViewRoot viewToRender) {
        ctx.getAttributes().put(viewToRender, Boolean.TRUE);
    }

    public static void checkIdUniqueness(FacesContext context, UIComponent component, Set<String> componentIds) {
        boolean uniquenessCheckDisabled = false;
        if (context.isProjectStage(ProjectStage.Production)) {
            WebConfiguration config = WebConfiguration.getInstance(context.getExternalContext());
            uniquenessCheckDisabled = config.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.DisableIdUniquenessCheck);
        }
        if (!uniquenessCheckDisabled) {
            Iterator<UIComponent> kids = component.getFacetsAndChildren();
            while (kids.hasNext()) {
                UIComponent kid = kids.next();
                String id = kid.getClientId(context);
                if (componentIds.add(id)) {
                    Util.checkIdUniqueness(context, kid, componentIds);
                    continue;
                }
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, "jsf.duplicate_component_id_error", id);
                    FastStringWriter writer = new FastStringWriter(128);
                    DebugUtil.simplePrintTree(context.getViewRoot(), id, writer);
                    LOGGER.severe(writer.toString());
                }
                String message = MessageUtils.getExceptionMessageString("com.sun.faces.DUPLICATE_COMPONENT_ID_ERROR", id);
                throw new IllegalStateException(message);
            }
        }
    }

    public static boolean classHasAnnotations(Class<?> clazz) {
        if (clazz != null) {
            while (clazz != Object.class) {
                try {
                    Method[] methods;
                    Field[] fields = clazz.getDeclaredFields();
                    if (fields != null) {
                        for (Field field : fields) {
                            if (field.getAnnotations().length <= 0) continue;
                            return true;
                        }
                    }
                    if ((methods = clazz.getDeclaredMethods()) != null) {
                        for (Method method : methods) {
                            if (method.getDeclaredAnnotations().length <= 0) continue;
                            return true;
                        }
                    }
                }
                catch (NoClassDefFoundError e) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "Cannot inspect " + clazz + " because of missing dependency " + e.getMessage());
                    }
                    return false;
                }
                clazz = clazz.getSuperclass();
            }
        }
        return false;
    }

    public static String getNamingContainerPrefix(FacesContext context) {
        UIViewRoot viewRoot = context.getViewRoot();
        if (viewRoot == null) {
            Application application = context.getApplication();
            viewRoot = (UIViewRoot)application.createComponent("jakarta.faces.ViewRoot");
        }
        if (viewRoot instanceof NamingContainer) {
            return viewRoot.getContainerClientId(context) + UINamingContainer.getSeparatorChar(context);
        }
        return "";
    }

    public static String getViewStateId(FacesContext context) {
        String result = null;
        String viewStateCounterKey = "com.sun.faces.util.ViewStateCounterKey";
        Map<Object, Object> contextAttrs = context.getAttributes();
        Integer counter = (Integer)contextAttrs.get("com.sun.faces.util.ViewStateCounterKey");
        if (null == counter) {
            counter = 0;
        }
        char sep = UINamingContainer.getSeparatorChar(context);
        UIViewRoot root = context.getViewRoot();
        result = root.getContainerClientId(context) + sep + "jakarta.faces.ViewState" + sep + counter;
        counter = counter + 1;
        contextAttrs.put("com.sun.faces.util.ViewStateCounterKey", counter);
        return result;
    }

    public static String getClientWindowId(FacesContext context) {
        String result = null;
        String clientWindowIdCounterKey = "com.sun.faces.util.ClientWindowCounterKey";
        Map<Object, Object> contextAttrs = context.getAttributes();
        Integer counter = (Integer)contextAttrs.get("com.sun.faces.util.ClientWindowCounterKey");
        if (null == counter) {
            counter = 0;
        }
        char sep = UINamingContainer.getSeparatorChar(context);
        result = context.getViewRoot().getContainerClientId(context) + sep + "jakarta.faces.ClientWindow" + sep + counter;
        counter = counter + 1;
        contextAttrs.put("com.sun.faces.util.ClientWindowCounterKey", counter);
        return result;
    }

    public static void saveDOCTYPEToFacesContextAttributes(String DOCTYPE) {
        FacesContext context = FacesContext.getCurrentInstance();
        if (null == context) {
            return;
        }
        Map<Object, Object> attrs = context.getAttributes();
        attrs.put(FACES_CONTEXT_ATTRIBUTES_DOCTYPE_KEY, DOCTYPE);
    }

    public static String getDOCTYPEFromFacesContextAttributes(FacesContext context) {
        if (null == context) {
            return null;
        }
        Map<Object, Object> attrs = context.getAttributes();
        return (String)attrs.get(FACES_CONTEXT_ATTRIBUTES_DOCTYPE_KEY);
    }

    public static void saveXMLDECLToFacesContextAttributes(String XMLDECL) {
        FacesContext context = FacesContext.getCurrentInstance();
        if (null == context) {
            return;
        }
        Map<Object, Object> attrs = context.getAttributes();
        attrs.put(FACES_CONTEXT_ATTRIBUTES_XMLDECL_KEY, XMLDECL);
    }

    public static String getXMLDECLFromFacesContextAttributes(FacesContext context) {
        if (null == context) {
            return null;
        }
        Map<Object, Object> attrs = context.getAttributes();
        return (String)attrs.get(FACES_CONTEXT_ATTRIBUTES_XMLDECL_KEY);
    }

    public static long getLastModified(URL url) {
        long lastModified;
        InputStream is = null;
        try {
            URLConnection conn = url.openConnection();
            if (conn instanceof JarURLConnection) {
                JarURLConnection jarUrlConnection = (JarURLConnection)conn;
                URL jarFileUrl = jarUrlConnection.getJarFileURL();
                URLConnection jarFileConnection = jarFileUrl.openConnection();
                lastModified = jarFileConnection.getLastModified();
                jarFileConnection.getInputStream().close();
            } else {
                is = conn.getInputStream();
                lastModified = conn.getLastModified();
            }
        }
        catch (Exception e) {
            throw new FacesException("Error Checking Last Modified for " + url, e);
        }
        finally {
            block13: {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception e) {
                        if (!LOGGER.isLoggable(Level.FINEST)) break block13;
                        LOGGER.log(Level.FINEST, "Closing stream", e);
                    }
                }
            }
        }
        return lastModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFacesConfigXmlVersion(FacesContext facesContext) {
        String result;
        block19: {
            result = "";
            InputStream stream = null;
            try {
                URL url = facesContext.getExternalContext().getResource("/WEB-INF/faces-config.xml");
                if (url == null) break block19;
                XPathFactory factory = XPathFactory.newInstance();
                XPath xpath = factory.newXPath();
                xpath.setNamespaceContext(new JavaeeNamespaceContext());
                stream = url.openStream();
                DocumentBuilderFactory dbf = Util.createDocumentBuilderFactory();
                try {
                    dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
                    dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                    dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    // empty catch block
                }
                dbf.setNamespaceAware(true);
                dbf.setValidating(false);
                dbf.setXIncludeAware(false);
                dbf.setExpandEntityReferences(false);
                result = xpath.evaluate("string(/javaee:faces-config/@version)", dbf.newDocumentBuilder().parse(stream));
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException | XPathExpressionException exception) {
            }
            catch (Exception exception) {
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getWebXmlVersion(FacesContext facesContext) {
        String result;
        block19: {
            result = "";
            InputStream stream = null;
            try {
                URL url = facesContext.getExternalContext().getResource("/WEB-INF/web.xml");
                if (url == null) break block19;
                XPathFactory factory = XPathFactory.newInstance();
                XPath xpath = factory.newXPath();
                xpath.setNamespaceContext(new JavaeeNamespaceContext());
                stream = url.openStream();
                DocumentBuilderFactory dbf = Util.createDocumentBuilderFactory();
                try {
                    dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
                    dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                    dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    // empty catch block
                }
                dbf.setNamespaceAware(true);
                dbf.setValidating(false);
                dbf.setXIncludeAware(false);
                dbf.setExpandEntityReferences(false);
                result = xpath.evaluate("string(/javaee:web-app/@version)", dbf.newDocumentBuilder().parse(stream));
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException | XPathExpressionException exception) {
            }
            catch (Exception exception) {
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return result;
    }

    public static BeanManager getCdiBeanManager(FacesContext facesContext) {
        BeanManager result = null;
        if (facesContext != null && facesContext.getAttributes().containsKey("com.sun.faces.cdi.BeanManager")) {
            result = (BeanManager)facesContext.getAttributes().get("com.sun.faces.cdi.BeanManager");
        } else if (facesContext != null && facesContext.getExternalContext().getApplicationMap().containsKey("com.sun.faces.cdi.BeanManager")) {
            result = (BeanManager)facesContext.getExternalContext().getApplicationMap().get("com.sun.faces.cdi.BeanManager");
        } else {
            try {
                InitialContext initialContext = new InitialContext();
                result = (BeanManager)initialContext.lookup("java:comp/BeanManager");
            }
            catch (NamingException ne) {
                try {
                    InitialContext initialContext = new InitialContext();
                    result = (BeanManager)initialContext.lookup("java:comp/env/BeanManager");
                }
                catch (NamingException ne2) {
                    try {
                        CDI cdi = CDI.current();
                        result = cdi.getBeanManager();
                    }
                    catch (Exception | LinkageError throwable) {
                        // empty catch block
                    }
                }
            }
            if (result == null && facesContext != null) {
                Map<String, Object> applicationMap = facesContext.getExternalContext().getApplicationMap();
                result = (BeanManager)applicationMap.get("org.jboss.weld.environment.servlet.jakarta.enterprise.inject.spi.BeanManager");
            }
            if (result != null && facesContext != null) {
                facesContext.getAttributes().put("com.sun.faces.cdi.BeanManager", result);
                facesContext.getExternalContext().getApplicationMap().put("com.sun.faces.cdi.BeanManager", result);
            }
        }
        return result;
    }

    public static boolean isCdiAvailable(FacesContext facesContext) {
        boolean result;
        if (facesContext != null && facesContext.getAttributes().containsKey("com.sun.faces.cdi.AvailableFlag")) {
            result = (Boolean)facesContext.getAttributes().get("com.sun.faces.cdi.AvailableFlag");
        } else if (facesContext != null && facesContext.getExternalContext().getApplicationMap().containsKey("com.sun.faces.cdi.AvailableFlag")) {
            result = (Boolean)facesContext.getExternalContext().getApplicationMap().get("com.sun.faces.cdi.AvailableFlag");
        } else {
            boolean bl = result = Util.getCdiBeanManager(facesContext) != null;
            if (result && facesContext != null) {
                facesContext.getAttributes().put("com.sun.faces.cdi.AvailableFlag", result);
                facesContext.getExternalContext().getApplicationMap().put("com.sun.faces.cdi.AvailableFlag", result);
            }
        }
        return result;
    }

    public static boolean isCdiAvailable(ServletContext servletContext) {
        boolean result;
        Object value = servletContext.getAttribute("com.sun.faces.cdi.AvailableFlag");
        if (value != null) {
            result = (Boolean)value;
        } else {
            boolean bl = result = Util.getCdiBeanManager(null) != null;
            if (result) {
                servletContext.setAttribute("com.sun.faces.cdi.AvailableFlag", (Object)result);
            }
        }
        return result;
    }

    public static boolean isCdiOneOneOrLater(FacesContext facesContext) {
        boolean result = false;
        if (facesContext != null && facesContext.getAttributes().containsKey("com.sun.faces.cdi.OneOneOrLater")) {
            result = (Boolean)facesContext.getAttributes().get("com.sun.faces.cdi.OneOneOrLater");
        } else if (facesContext != null && facesContext.getExternalContext().getApplicationMap().containsKey("com.sun.faces.cdi.OneOneOrLater")) {
            result = facesContext.getExternalContext().getApplicationMap().containsKey("com.sun.faces.cdi.OneOneOrLater");
        } else {
            block7: {
                try {
                    Class.forName("jakarta.enterprise.context.Initialized");
                    result = true;
                }
                catch (ClassNotFoundException ignored) {
                    if (!LOGGER.isLoggable(Level.FINEST)) break block7;
                    LOGGER.log(Level.FINEST, "Detected CDI 1.0", ignored);
                }
            }
            if (facesContext != null) {
                facesContext.getAttributes().put("com.sun.faces.cdi.OneOneOrLater", result);
                facesContext.getExternalContext().getApplicationMap().put("com.sun.faces.cdi.OneOneOrLater", result);
            }
        }
        return result;
    }

    public static boolean isNestedInIterator(FacesContext context, UIComponent component) {
        UIComponent parent = component.getParent();
        if (parent == null) {
            return false;
        }
        for (UIComponent p = parent; p != null; p = p.getParent()) {
            if (!(p instanceof UIData) && !(p instanceof UIRepeat)) continue;
            return true;
        }
        Pattern clientIdNestedInIteratorPattern = Util.getPatternCache(context.getExternalContext().getApplicationMap()).computeIfAbsent(CLIENT_ID_NESTED_IN_ITERATOR_PATTERN, k -> {
            String separatorChar = Pattern.quote(String.valueOf(UINamingContainer.getSeparatorChar(context)));
            return Pattern.compile(".+" + separatorChar + "[0-9]+" + separatorChar + ".+");
        });
        return clientIdNestedInIteratorPattern.matcher(parent.getClientId(context)).matches();
    }

    public static String ensureLeadingSlash(String s) {
        if (s == null || !s.isEmpty() && s.charAt(0) == '/') {
            return s;
        }
        return '/' + s;
    }

    public static class JavaeeNamespaceContext
    implements NamespaceContext {
        @Override
        public String getNamespaceURI(String prefix) {
            return "http://xmlns.jcp.org/xml/ns/javaee";
        }

        @Override
        public String getPrefix(String namespaceURI) {
            return "javaee";
        }

        public Iterator getPrefixes(String namespaceURI) {
            return null;
        }
    }
}

