/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.annotation;

import com.sun.faces.application.annotation.ConfigAnnotationHandler;
import com.sun.faces.util.FacesLogger;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.Application;
import javax.faces.context.FacesContext;
import javax.faces.convert.FacesConverter;

public class ConverterConfigHandler
implements ConfigAnnotationHandler {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    private static final Collection<Class<? extends Annotation>> HANDLES;
    private Map<Object, String> converters;

    @Override
    public Collection<Class<? extends Annotation>> getHandledAnnotations() {
        return HANDLES;
    }

    @Override
    public void collect(Class<?> target, Annotation annotation) {
        FacesConverter converterAnnotation;
        if (this.converters == null) {
            this.converters = new HashMap<Object, String>();
        }
        if ((converterAnnotation = (FacesConverter)annotation).value().length() > 0 && converterAnnotation.forClass() != null && converterAnnotation.forClass() != Object.class && LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "@FacesConverter is using both value and forClass, only value will be applied.");
        }
        Object key = 0 == converterAnnotation.value().length() ? converterAnnotation.forClass() : converterAnnotation.value();
        this.converters.put(key, target.getName());
    }

    @Override
    public void push(FacesContext ctx) {
        if (this.converters != null) {
            Application app = ctx.getApplication();
            for (Map.Entry<Object, String> entry : this.converters.entrySet()) {
                if (entry.getKey() instanceof Class) {
                    app.addConverter((Class)entry.getKey(), entry.getValue());
                    continue;
                }
                app.addConverter((String)entry.getKey(), entry.getValue());
            }
        }
    }

    static {
        ArrayList<Class<FacesConverter>> handles = new ArrayList<Class<FacesConverter>>(1);
        handles.add(FacesConverter.class);
        HANDLES = Collections.unmodifiableCollection(handles);
    }
}

