/*
 * Copyright (c) 1997, 2022 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Distribution License v. 1.0, which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

package org.glassfish.jaxb.runtime.v2.runtime.reflect.opt;

import org.glassfish.jaxb.runtime.v2.runtime.reflect.Accessor;

/**
 * Template {@link Accessor} for byte fields.
 *
 * <p>
 * All the FieldAccessors are generated from <code>FieldAccessor_Byte</code>
 * 
 * @author Kohsuke Kawaguchi
 */
public class FieldAccessor_Byte<B> extends Accessor<B, Byte> {
    public FieldAccessor_Byte() {
        super(Byte.class);
    }

    @Override
    public Byte get(B bean) {
        return ((Bean)bean).f_byte;
    }

    @Override
    public void set(B bean, Byte value) {
        ((Bean)bean).f_byte = value==null ? Const.default_value_byte : value;
    }
}
