/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.reader;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JType;
import com.sun.tools.xjc.ErrorReceiver;
import com.sun.tools.xjc.reader.Messages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;

public class TypeUtil {
    private static final Comparator<JType> typeComparator = new Comparator<JType>(){

        @Override
        public int compare(JType t1, JType t2) {
            return t1.fullName().compareTo(t2.fullName());
        }
    };

    public static JType getCommonBaseType(JCodeModel codeModel, Collection<? extends JType> types) {
        return TypeUtil.getCommonBaseType(codeModel, types.toArray(new JType[types.size()]));
    }

    public static JType getCommonBaseType(JCodeModel codeModel, JType ... t) {
        TreeSet<JType> uniqueTypes = new TreeSet<JType>(typeComparator);
        for (JType type : t) {
            uniqueTypes.add(type);
        }
        if (uniqueTypes.size() == 1) {
            return (JType)uniqueTypes.iterator().next();
        }
        assert (!uniqueTypes.isEmpty());
        uniqueTypes.remove(codeModel.NULL);
        Set<JClass> s = null;
        for (JType type : uniqueTypes) {
            JClass cls = type.boxify();
            if (s == null) {
                s = TypeUtil.getAssignableTypes(cls);
                continue;
            }
            s.retainAll(TypeUtil.getAssignableTypes(cls));
        }
        s.add(codeModel.ref(Object.class));
        JClass[] raw = s.toArray(new JClass[s.size()]);
        s.clear();
        for (int i = 0; i < raw.length; ++i) {
            int j;
            for (j = 0; !(j >= raw.length || i != j && raw[i].isAssignableFrom(raw[j])); ++j) {
            }
            if (j != raw.length) continue;
            s.add(raw[i]);
        }
        assert (!s.isEmpty());
        JClass result = TypeUtil.pickOne(s);
        if (result.isParameterized()) {
            return result;
        }
        ArrayList<List> parameters = new ArrayList<List>(uniqueTypes.size());
        int paramLen = -1;
        for (JType type : uniqueTypes) {
            JClass cls = type.boxify();
            JClass bp = cls.getBaseClass(result);
            if (bp.equals(result)) {
                return result;
            }
            assert (bp.isParameterized());
            List tp = bp.getTypeParameters();
            parameters.add(tp);
            assert (paramLen == -1 || paramLen == tp.size());
            paramLen = tp.size();
        }
        ArrayList<JClass> paramResult = new ArrayList<JClass>();
        ArrayList argList = new ArrayList(parameters.size());
        for (int i = 0; i < paramLen; ++i) {
            argList.clear();
            for (List list : parameters) {
                argList.add(list.get(i));
            }
            JClass bound = (JClass)TypeUtil.getCommonBaseType(codeModel, argList);
            boolean allSame = true;
            for (JClass a : argList) {
                allSame &= a.equals(bound);
            }
            if (!allSame) {
                bound = bound.wildcard();
            }
            paramResult.add(bound);
        }
        return result.narrow(paramResult);
    }

    private static JClass pickOne(Set<JClass> s) {
        for (JClass c : s) {
            if (!(c instanceof JDefinedClass)) continue;
            return c;
        }
        return s.iterator().next();
    }

    private static Set<JClass> getAssignableTypes(JClass t) {
        TreeSet<JType> r = new TreeSet<JType>(typeComparator);
        TypeUtil.getAssignableTypes(t, r);
        return r;
    }

    private static void getAssignableTypes(JClass t, Set<JClass> s) {
        if (!s.add(t)) {
            return;
        }
        s.add(t.erasure());
        JClass _super = t._extends();
        if (_super != null) {
            TypeUtil.getAssignableTypes(_super, s);
        }
        Iterator itr = t._implements();
        while (itr.hasNext()) {
            TypeUtil.getAssignableTypes((JClass)itr.next(), s);
        }
    }

    public static JType getType(JCodeModel codeModel, String typeName, ErrorReceiver errorHandler, Locator errorSource) {
        try {
            return codeModel.parseType(typeName);
        }
        catch (ClassNotFoundException ee) {
            errorHandler.warning(new SAXParseException(Messages.ERR_CLASS_NOT_FOUND.format(typeName), errorSource));
            return codeModel.directClass(typeName);
        }
    }
}

