/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.netty.connector.internal;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;

public class NettyInputStream
extends InputStream {
    private volatile boolean end = false;
    private Throwable cause;
    private final ArrayDeque<ByteBuf> isList = new ArrayDeque();
    private ByteBuf current;
    private ByteBuffer buffer;
    private byte[] ONE_BYTE;
    private boolean reading;

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int rem;
        if (this.current == null) {
            this.buffer = this.awaitNext();
            if (this.buffer == null) {
                if (this.cause == null) {
                    return -1;
                }
                throw new IOException(this.cause);
            }
        }
        if ((rem = this.buffer.remaining()) < len) {
            len = rem;
        }
        this.buffer.get(b, off, len);
        if (rem == len) {
            this.releaseByteBuf();
        }
        return len;
    }

    @Override
    public int read() throws IOException {
        int r;
        if (this.ONE_BYTE == null) {
            this.ONE_BYTE = new byte[1];
        }
        if ((r = this.read(this.ONE_BYTE, 0, 1)) < 0) {
            return r;
        }
        return this.ONE_BYTE[0] & 0xFF;
    }

    @Override
    public void close() {
        this.releaseByteBuf();
        this.cleanup(true);
    }

    private void releaseByteBuf() {
        if (this.current != null) {
            this.current.release();
        }
        this.current = null;
        this.buffer = null;
    }

    protected synchronized ByteBuffer awaitNext() {
        while (this.isList.isEmpty()) {
            if (this.end) {
                return null;
            }
            try {
                this.reading = true;
                this.wait();
                this.reading = false;
            }
            catch (InterruptedException interruptedException) {}
        }
        this.current = this.isList.poll();
        return this.current.nioBuffer().asReadOnlyBuffer();
    }

    public void complete(Throwable cause) {
        this.cause = cause;
        this.cleanup(cause != null);
    }

    protected synchronized void cleanup(boolean drain) {
        if (drain) {
            while (!this.isList.isEmpty()) {
                this.isList.poll().release();
            }
        }
        this.end = true;
        if (this.reading) {
            this.notifyAll();
        }
    }

    @Override
    public int available() throws IOException {
        return this.buffer == null ? 0 : this.buffer.remaining();
    }

    public synchronized void publish(ByteBuf content) {
        if (this.end || content.nioBuffer().remaining() == 0) {
            content.release();
            return;
        }
        this.isList.add(content);
        if (this.reading) {
            this.notifyAll();
        }
    }

    public void clear() {
        this.end = false;
        this.reading = false;
        this.cause = null;
        this.buffer = null;
        this.current = null;
        this.isList.clear();
    }
}

