/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.netty.httpserver;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpChunkedInput;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.stream.ChunkedInput;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.jersey.netty.connector.internal.JerseyChunkedInput;
import org.glassfish.jersey.netty.httpserver.NettyHttpContainer;
import org.glassfish.jersey.server.ContainerException;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.spi.ContainerResponseWriter;

class NettyResponseWriter
implements ContainerResponseWriter {
    private static final Logger LOGGER = Logger.getLogger(NettyResponseWriter.class.getName());
    static final ChannelFutureListener FLUSH_FUTURE = new ChannelFutureListener(){

        public void operationComplete(ChannelFuture future) throws Exception {
            future.channel().flush();
        }
    };
    private final ChannelHandlerContext ctx;
    private final HttpRequest req;
    private final NettyHttpContainer container;
    private volatile ScheduledFuture<?> suspendTimeoutFuture;
    private volatile Runnable suspendTimeoutHandler;
    private boolean responseWritten = false;

    NettyResponseWriter(ChannelHandlerContext ctx, HttpRequest req, NettyHttpContainer container) {
        this.ctx = ctx;
        this.req = req;
        this.container = container;
    }

    public synchronized OutputStream writeResponseStatusAndHeaders(long contentLength, ContainerResponse responseContext) throws ContainerException {
        if (this.responseWritten) {
            LOGGER.log(Level.FINE, "Response already written.");
            return null;
        }
        this.responseWritten = true;
        String reasonPhrase = responseContext.getStatusInfo().getReasonPhrase();
        int statusCode = responseContext.getStatus();
        HttpResponseStatus status = reasonPhrase == null ? HttpResponseStatus.valueOf((int)statusCode) : new HttpResponseStatus(statusCode, reasonPhrase);
        Object response = contentLength == 0L ? new DefaultFullHttpResponse(this.req.protocolVersion(), status) : new DefaultHttpResponse(this.req.protocolVersion(), status);
        for (Map.Entry e : responseContext.getStringHeaders().entrySet()) {
            response.headers().add((String)e.getKey(), (Iterable)e.getValue());
        }
        if (contentLength == -1L) {
            HttpUtil.setTransferEncodingChunked((HttpMessage)response, (boolean)true);
        } else if (this.req.method() != HttpMethod.HEAD || !response.headers().contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH)) {
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)contentLength);
        }
        if (HttpUtil.isKeepAlive((HttpMessage)this.req)) {
            response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        }
        this.ctx.writeAndFlush(response);
        if (this.req.method() != HttpMethod.HEAD && (contentLength > 0L || contentLength == -1L)) {
            JerseyChunkedInput jerseyChunkedInput = new JerseyChunkedInput(this.ctx.channel());
            if (HttpUtil.isTransferEncodingChunked((HttpMessage)response)) {
                this.ctx.writeAndFlush((Object)new HttpChunkedInput((ChunkedInput)jerseyChunkedInput));
            } else {
                this.ctx.write((Object)new HttpChunkedInput((ChunkedInput)jerseyChunkedInput)).addListener((GenericFutureListener)FLUSH_FUTURE);
            }
            return jerseyChunkedInput;
        }
        this.ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        return null;
    }

    public boolean suspend(long timeOut, TimeUnit timeUnit, final ContainerResponseWriter.TimeoutHandler timeoutHandler) {
        this.suspendTimeoutHandler = new Runnable(){

            @Override
            public void run() {
                timeoutHandler.onTimeout((ContainerResponseWriter)NettyResponseWriter.this);
            }
        };
        if (timeOut <= 0L) {
            return true;
        }
        this.suspendTimeoutFuture = this.container.getScheduledExecutorService().schedule(this.suspendTimeoutHandler, timeOut, timeUnit);
        return true;
    }

    public void setSuspendTimeout(long timeOut, TimeUnit timeUnit) throws IllegalStateException {
        if (this.suspendTimeoutFuture != null) {
            this.suspendTimeoutFuture.cancel(true);
        }
        if (timeOut <= 0L) {
            return;
        }
        this.suspendTimeoutFuture = this.container.getScheduledExecutorService().schedule(this.suspendTimeoutHandler, timeOut, timeUnit);
    }

    public void commit() {
        this.ctx.flush();
    }

    public void failure(Throwable error) {
        this.ctx.writeAndFlush((Object)new DefaultFullHttpResponse(this.req.protocolVersion(), HttpResponseStatus.INTERNAL_SERVER_ERROR)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    public boolean enableResponseBuffering() {
        return true;
    }
}

