/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client.rx.guava;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.SyncInvoker;
import jakarta.ws.rs.core.GenericType;
import java.util.concurrent.ExecutorService;
import org.glassfish.jersey.client.AbstractRxInvoker;
import org.glassfish.jersey.client.rx.guava.RxListenableFutureInvoker;
import org.glassfish.jersey.internal.util.collection.LazyValue;
import org.glassfish.jersey.internal.util.collection.Value;
import org.glassfish.jersey.internal.util.collection.Values;

final class JerseyRxListenableFutureInvoker
extends AbstractRxInvoker<ListenableFuture>
implements RxListenableFutureInvoker {
    private static final LazyValue<ListeningExecutorService> DEFAULT_EXECUTOR_SERVICE = Values.lazy((Value)new Value<ListeningExecutorService>(){

        public ListeningExecutorService get() {
            return MoreExecutors.newDirectExecutorService();
        }
    });
    private final ListeningExecutorService service;

    JerseyRxListenableFutureInvoker(SyncInvoker syncInvoker, ExecutorService executor) {
        super(syncInvoker, executor);
        this.service = executor == null ? (ListeningExecutorService)DEFAULT_EXECUTOR_SERVICE.get() : MoreExecutors.listeningDecorator((ExecutorService)executor);
    }

    @Override
    public <T> ListenableFuture<T> method(String name, Entity<?> entity, Class<T> responseType) {
        return this.service.submit(() -> this.getSyncInvoker().method(name, entity, responseType));
    }

    @Override
    public <T> ListenableFuture<T> method(String name, Entity<?> entity, GenericType<T> responseType) {
        return this.service.submit(() -> this.getSyncInvoker().method(name, entity, responseType));
    }
}

