/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.test.util.runner;

import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.jersey.Beta;
import org.glassfish.jersey.test.util.runner.RunSeparately;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;

@Deprecated
@Beta
public class ConcurrentRunner
extends BlockJUnit4ClassRunner {
    public final int FINISH_WAIT_CYCLE_MS = 2000;
    public final int TEST_THREADS = 124;
    private static final Logger LOGGER = Logger.getLogger(ConcurrentRunner.class.getName());
    private final ExecutorService executor = Executors.newFixedThreadPool(124);
    private final Semaphore permitToGo = new Semaphore(1);
    private final AtomicInteger invocations = new AtomicInteger(1);
    private final List<FrameworkMethod> concurrentTestMethods = new LinkedList<FrameworkMethod>(super.computeTestMethods());

    public ConcurrentRunner(Class<?> clazz) throws Throwable {
        super(clazz);
        this.concurrentTestMethods.removeAll(this.getTestClass().getAnnotatedMethods(RunSeparately.class));
        List ignored = this.getTestClass().getAnnotatedMethods(Ignore.class);
        this.concurrentTestMethods.removeAll(ignored);
    }

    protected void validateTestMethods(List<Throwable> errors) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        Semaphore semaphore = this.permitToGo;
        synchronized (semaphore) {
            if (this.concurrentTestMethods.contains(method)) {
                if (this.invocations.compareAndSet(1, 0)) {
                    this.runThemAll(this.concurrentTestMethods, notifier);
                }
            } else {
                super.runChild(method, notifier);
            }
        }
    }

    private void runThemAll(List<FrameworkMethod> methods, final RunNotifier notifier) {
        Object testInstance;
        try {
            testInstance = super.createTest();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        List befores = this.getTestClass().getAnnotatedMethods(Before.class);
        for (FrameworkMethod before : befores) {
            try {
                before.getMethod().invoke(testInstance, new Object[0]);
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, null, ex);
            }
            final AtomicInteger submitted = new AtomicInteger(0);
            for (final FrameworkMethod method : methods) {
                try {
                    notifier.fireTestStarted(this.describeChild(method));
                    final Method javaTestMethod = method.getMethod();
                    final Object[] javaMethodArgs = new Object[]{};
                    submitted.incrementAndGet();
                    this.executor.submit(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                javaTestMethod.invoke(testInstance, javaMethodArgs);
                            }
                            catch (Exception ex) {
                                notifier.fireTestFailure(new Failure(ConcurrentRunner.this.describeChild(method), (Throwable)ex));
                            }
                            finally {
                                submitted.decrementAndGet();
                            }
                        }
                    });
                }
                catch (Exception ex) {
                    notifier.fireTestFailure(new Failure(this.describeChild(method), (Throwable)ex));
                    return;
                }
                notifier.fireTestFinished(this.describeChild(method));
            }
            while (submitted.intValue() > 0) {
                LOGGER.info(String.format("Waiting for %d requests to finish...%n", submitted.intValue()));
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            List afters = this.getTestClass().getAnnotatedMethods(After.class);
            for (FrameworkMethod after : afters) {
                try {
                    after.getMethod().invoke(testInstance, new Object[0]);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.SEVERE, null, ex);
                }
            }
        }
    }
}

