/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.test.util.server;

import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.SecurityContext;
import java.io.InputStream;
import java.net.URI;
import java.util.Arrays;
import org.glassfish.jersey.internal.MapPropertiesDelegate;
import org.glassfish.jersey.internal.PropertiesDelegate;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.message.internal.HeaderUtils;
import org.glassfish.jersey.server.ApplicationHandler;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.test.util.server.TestContainerRequest;

public final class ContainerRequestBuilder {
    private final TestContainerRequest request;
    private final Configuration configuration;

    public static ContainerRequestBuilder from(String requestUri, String method, Configuration configuration) {
        return ContainerRequestBuilder.from(null, requestUri, method, configuration);
    }

    public static ContainerRequestBuilder from(String baseUri, String requestUri, String method, Configuration configuration) {
        return ContainerRequestBuilder.from(baseUri, requestUri, method, null, null, configuration);
    }

    public static ContainerRequestBuilder from(String baseUri, String requestUri, String method, SecurityContext securityContext, PropertiesDelegate propertiesDelegate, Configuration configuration) {
        return new ContainerRequestBuilder(baseUri, requestUri, method, securityContext, propertiesDelegate, configuration);
    }

    public static ContainerRequestBuilder from(URI requestUri, String method, Configuration configuration) {
        return ContainerRequestBuilder.from(null, requestUri, method, configuration);
    }

    public static ContainerRequestBuilder from(URI baseUri, URI requestUri, String method, Configuration configuration) {
        return ContainerRequestBuilder.from(baseUri, requestUri, method, null, null, configuration);
    }

    public static ContainerRequestBuilder from(URI baseUri, URI requestUri, String method, SecurityContext securityContext, PropertiesDelegate propertiesDelegate, Configuration configuration) {
        return new ContainerRequestBuilder(baseUri, requestUri, method, securityContext, propertiesDelegate, configuration);
    }

    private static URI slash(URI uri) {
        String strUri = uri.toString();
        return uri.isAbsolute() || strUri.charAt(0) == '/' ? uri : URI.create("/" + strUri);
    }

    private ContainerRequestBuilder(String baseUri, String requestUri, String method, SecurityContext securityContext, PropertiesDelegate propertiesDelegate, Configuration configuration) {
        this(baseUri == null || baseUri.isEmpty() ? null : URI.create(baseUri), URI.create(requestUri), method, securityContext, propertiesDelegate, configuration);
    }

    private ContainerRequestBuilder(URI baseUri, URI requestUri, String method, SecurityContext securityContext, PropertiesDelegate propertiesDelegate, Configuration configuration) {
        this.configuration = configuration;
        this.request = new TestContainerRequest(baseUri, ContainerRequestBuilder.slash(requestUri), method, securityContext, (PropertiesDelegate)(propertiesDelegate == null ? new MapPropertiesDelegate() : propertiesDelegate), configuration);
    }

    public ContainerRequest build() {
        return this.request;
    }

    public ContainerRequestBuilder accept(String ... mediaTypes) {
        this.putHeaders("Accept", mediaTypes);
        return this;
    }

    public ContainerRequestBuilder accept(MediaType ... mediaTypes) {
        this.putHeaders("Accept", mediaTypes);
        return this;
    }

    public ContainerRequestBuilder entity(InputStream stream) {
        if (stream != null) {
            this.request.setEntity(stream);
        }
        return this;
    }

    public ContainerRequestBuilder entity(Object entity, MessageBodyWorkers workers) {
        if (entity != null) {
            if (entity instanceof InputStream) {
                return this.entity((InputStream)entity);
            }
            this.request.setEntity(entity, workers);
        }
        return this;
    }

    public ContainerRequestBuilder entity(Object entity, ApplicationHandler handler) {
        return this.entity(entity, (MessageBodyWorkers)handler.getInjectionManager().getInstance(MessageBodyWorkers.class));
    }

    public ContainerRequestBuilder type(String contentType) {
        this.request.getHeaders().putSingle((Object)"Content-Type", (Object)contentType);
        return this;
    }

    public ContainerRequestBuilder type(MediaType contentType) {
        this.request.getHeaders().putSingle((Object)"Content-Type", (Object)HeaderUtils.asString((Object)contentType, (Configuration)this.configuration));
        return this;
    }

    public ContainerRequestBuilder header(String name, Object value) {
        this.putHeader(name, value);
        return this;
    }

    public ContainerRequestBuilder cookie(Cookie cookie) {
        this.putHeader("Cookie", cookie);
        return this;
    }

    public ContainerRequestBuilder cookies(Cookie ... cookies) {
        this.putHeaders("Cookie", cookies);
        return this;
    }

    private void putHeader(String name, Object value) {
        if (value == null) {
            this.request.getHeaders().remove((Object)name);
            return;
        }
        this.request.header(name, HeaderUtils.asString((Object)value, (Configuration)this.configuration));
    }

    private void putHeaders(String name, Object ... values) {
        if (values == null) {
            this.request.getHeaders().remove((Object)name);
            return;
        }
        this.request.getHeaders().addAll((Object)name, HeaderUtils.asStringList(Arrays.asList(values), (Configuration)this.configuration));
    }

    private void putHeaders(String name, String ... values) {
        if (values == null) {
            this.request.getHeaders().remove((Object)name);
            return;
        }
        this.request.getHeaders().addAll((Object)name, (Object[])values);
    }
}

