/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.test.util.server;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.GenericEntity;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.SecurityContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.jersey.internal.PropertiesDelegate;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.server.ContainerRequest;

final class TestContainerRequest
extends ContainerRequest {
    private static final Logger LOGGER = Logger.getLogger(TestContainerRequest.class.getName());

    TestContainerRequest(URI baseUri, URI requestUri, String method, SecurityContext securityContext, PropertiesDelegate propertiesDelegate, Configuration configuration) {
        super(baseUri, requestUri, method, securityContext, propertiesDelegate, configuration);
    }

    void setEntity(InputStream stream) {
        this.setEntityStream(stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setEntity(Object requestEntity, MessageBodyWorkers workers) {
        byte[] entityBytes;
        GenericType entityType;
        Object entity;
        if (requestEntity instanceof GenericEntity) {
            entity = ((GenericEntity)requestEntity).getEntity();
            entityType = new GenericType(((GenericEntity)requestEntity).getType());
        } else {
            entity = requestEntity;
            entityType = new GenericType(requestEntity.getClass());
        }
        if (entity != null) {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            OutputStream stream = null;
            try {
                stream = workers.writeTo(entity, entity.getClass(), entityType.getType(), new Annotation[0], this.getMediaType(), (MultivaluedMap)new MultivaluedHashMap(this.getHeaders()), this.getPropertiesDelegate(), (OutputStream)output, Collections.emptyList());
            }
            catch (WebApplicationException | IOException ex) {
                LOGGER.log(Level.SEVERE, "Transforming entity to input stream failed.", ex);
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            entityBytes = output.toByteArray();
        } else {
            entityBytes = new byte[]{};
        }
        this.setEntity(new ByteArrayInputStream(entityBytes));
    }
}

