/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.io.FileUtils;
import jakarta.inject.Inject;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.glassfish.admin.payload.PayloadImpl;
import org.glassfish.api.admin.Job;
import org.glassfish.api.admin.JobManager;
import org.glassfish.api.admin.Payload;
import org.glassfish.common.util.ObjectInputOutputStreamFactory;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.security.services.api.authentication.AuthenticationService;
import org.jvnet.hk2.annotations.Service;

@Service
public class CheckpointHelper {
    private static final LocalStringManagerImpl strings = new LocalStringManagerImpl(CheckpointHelper.class);
    @Inject
    AuthenticationService authenticationService;
    @Inject
    ServiceLocator serviceLocator;
    @Inject
    ObjectInputOutputStreamFactory factory;
    private static final String CONTENT_TYPE_NAME = "Content-Type";

    public void save(JobManager.Checkpoint checkpoint) throws IOException {
        CheckpointFilename cf = CheckpointFilename.createBasic(checkpoint.getJob());
        ObjectOutputStream oos = null;
        FileOutputStream fos = null;
        try {
            Payload.Inbound inboundPayload;
            fos = new FileOutputStream(cf.getFile());
            oos = this.factory.createObjectOutputStream((OutputStream)fos);
            oos.writeObject(checkpoint);
            oos.close();
            Payload.Outbound outboundPayload = checkpoint.getContext().getOutboundPayload();
            if (outboundPayload != null && outboundPayload.isDirty()) {
                this.saveOutbound(outboundPayload, cf.getForPayload(false).getFile());
            }
            if ((inboundPayload = checkpoint.getContext().getInboundPayload()) != null) {
                this.saveInbound(inboundPayload, cf.getForPayload(true).getFile());
            }
        }
        catch (IOException e) {
            try {
                oos.close();
            }
            catch (Exception inboundPayload) {
                // empty catch block
            }
            try {
                fos.close();
            }
            catch (Exception inboundPayload) {
                // empty catch block
            }
            File file = cf.getFile();
            if (file.exists()) {
                file.delete();
            }
            if ((file = cf.getForPayload(true).getFile()).exists()) {
                file.delete();
            }
            if ((file = cf.getForPayload(false).getFile()).exists()) {
                file.delete();
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAttachment(Serializable data, Job job, String attachmentId) throws IOException {
        ObjectOutputStream oos = null;
        FileOutputStream fos = null;
        CheckpointFilename cf = CheckpointFilename.createAttachment(job, attachmentId);
        try {
            fos = new FileOutputStream(cf.getFile());
            oos = this.factory.createObjectOutputStream((OutputStream)fos);
            oos.writeObject(data);
        }
        finally {
            try {
                oos.close();
            }
            catch (Exception exception) {}
            try {
                fos.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobManager.Checkpoint load(CheckpointFilename cf, Payload.Outbound outbound) throws IOException, ClassNotFoundException {
        JobManager.Checkpoint checkpoint;
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        try {
            fis = new FileInputStream(cf.getFile());
            ois = this.factory.createObjectInputStream((InputStream)fis);
            checkpoint = (JobManager.Checkpoint)ois.readObject();
        }
        finally {
            try {
                ois.close();
            }
            catch (Exception exception) {}
            try {
                fis.close();
            }
            catch (Exception exception) {}
        }
        if (outbound != null) {
            this.loadOutbound(outbound, cf.getForPayload(false).getFile());
            checkpoint.getContext().setOutboundPayload(outbound);
        }
        Payload.Inbound inbound = this.loadInbound(cf.getForPayload(true).getFile());
        checkpoint.getContext().setInboundPayload(inbound);
        try {
            String username = (String)checkpoint.getJob().getSubjectUsernames().get(0);
            Subject subject = this.authenticationService.impersonate(username, null, null, false);
            checkpoint.getContext().setSubject(subject);
        }
        catch (LoginException e) {
            throw new RuntimeException(e);
        }
        return checkpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Serializable> T loadAttachment(Job job, String attachmentId) throws IOException, ClassNotFoundException {
        CheckpointFilename cf = CheckpointFilename.createAttachment(job, attachmentId);
        File file = cf.getFile();
        if (!file.exists()) {
            return null;
        }
        ObjectInputStream ois = null;
        FileInputStream fis = null;
        fis = new FileInputStream(cf.getFile());
        ois = this.factory.createObjectInputStream((InputStream)fis);
        Serializable serializable = (Serializable)ois.readObject();
        return (T)serializable;
        finally {
            try {
                ois.close();
            }
            catch (Exception exception) {}
            try {
                fis.close();
            }
            catch (Exception exception) {}
        }
    }

    public Collection<CheckpointFilename> listCheckpoints(File dir) {
        if (dir == null || !dir.exists()) {
            return Collections.emptyList();
        }
        final String extension = (String)CheckpointFilename.EXTENSIONS.get((Object)CheckpointFilename.ExtensionType.BASIC);
        File[] checkpointFiles = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(extension);
            }
        });
        if (checkpointFiles != null) {
            ArrayList<CheckpointFilename> result = new ArrayList<CheckpointFilename>(checkpointFiles.length);
            for (File checkpointFile : checkpointFiles) {
                try {
                    result.add(new CheckpointFilename(checkpointFile));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return result;
        }
        return Collections.emptyList();
    }

    private void saveOutbound(Payload.Outbound outbound, File outboundFile) throws IOException {
        FileOutputStream os = new FileOutputStream(outboundFile);
        this.writePartsTo(outbound.parts(), os);
        outbound.resetDirty();
    }

    private void loadOutbound(Payload.Outbound outbound, File outboundFile) throws IOException {
        if (outbound == null || !outboundFile.exists()) {
            return;
        }
        Payload.Inbound outboundSource = this.loadInbound(outboundFile);
        Iterator parts = outboundSource.parts();
        File topDir = this.createTempDir("checkpoint", "");
        topDir.deleteOnExit();
        while (parts.hasNext()) {
            Payload.Part part = (Payload.Part)parts.next();
            File sourceFile = File.createTempFile("source", "", topDir);
            FileUtils.copy((InputStream)part.getInputStream(), (FileOutputStream)new FileOutputStream(sourceFile), (long)Long.MAX_VALUE);
            outbound.addPart(part.getContentType(), part.getName(), part.getProperties(), (InputStream)new FileInputStream(sourceFile));
        }
        outbound.resetDirty();
    }

    private void saveInbound(Payload.Inbound inbound, File inboundFile) throws IOException {
        if (!inboundFile.exists()) {
            FileOutputStream os = new FileOutputStream(inboundFile);
            this.writePartsTo(inbound.parts(), os);
        }
    }

    private Payload.Inbound loadInbound(File inboundFile) throws IOException {
        if (inboundFile == null || !inboundFile.exists()) {
            return null;
        }
        FileInputStream is = new FileInputStream(inboundFile);
        PayloadImpl.Inbound inboundSource = PayloadImpl.Inbound.newInstance((String)"application/zip", (InputStream)is);
        return inboundSource;
    }

    private void writePartsTo(Iterator<Payload.Part> parts, OutputStream os) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(os);
        while (parts.hasNext()) {
            Payload.Part part = parts.next();
            this.prepareEntry(part, zos);
            part.copy((OutputStream)zos);
            zos.closeEntry();
        }
        zos.close();
    }

    private void prepareEntry(Payload.Part part, ZipOutputStream zos) throws IOException {
        ZipEntry entry = new ZipEntry(part.getName());
        entry.setExtra(this.getExtraBytes(part));
        zos.putNextEntry(entry);
    }

    private byte[] getExtraBytes(Payload.Part part) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Properties props = part.getProperties();
        Properties fullProps = new Properties();
        if (props != null) {
            fullProps.putAll((Map<?, ?>)props);
        }
        fullProps.setProperty(CONTENT_TYPE_NAME, part.getContentType());
        try {
            fullProps.store(baos, null);
            return baos.toByteArray();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private File createTempDir(String prefix, String suffix) throws IOException {
        File temp = File.createTempFile(prefix, suffix);
        if (!temp.delete()) {
            throw new IOException("Cannot delete temp file " + temp.getAbsolutePath());
        }
        if (!temp.mkdirs()) {
            throw new IOException("Cannot create temp directory" + temp.getAbsolutePath());
        }
        return temp;
    }

    public static class CheckpointFilename {
        private static final Map<ExtensionType, String> EXTENSIONS;
        private final ExtensionType ext;
        private final String jobId;
        private String attachmentId;
        private final File parentDir;
        private String cachedFileName;

        private CheckpointFilename(String jobId, File parentDir, ExtensionType ext) {
            this.ext = ext;
            this.jobId = jobId;
            this.parentDir = parentDir;
        }

        private CheckpointFilename(CheckpointFilename basic, ExtensionType ext) {
            this.ext = ext;
            this.jobId = basic.jobId;
            this.attachmentId = basic.attachmentId;
            this.parentDir = basic.parentDir;
        }

        private CheckpointFilename(Job job, String attachmentId) {
            this(job.getId(), job.getJobsFile().getParentFile(), ExtensionType.ATTACHMENT);
            this.attachmentId = attachmentId;
        }

        public CheckpointFilename(File file) throws IOException {
            String name;
            this.parentDir = file.getParentFile();
            this.cachedFileName = name = file.getName();
            int ind = name.lastIndexOf(46);
            if (ind <= 0) {
                throw new IOException(strings.getLocalString("checkpointhelper.wrongfileextension", "Wrong checkpoint file extension {0}", new Object[]{file.getName()}));
            }
            String extensionStr = name.substring(ind);
            ExtensionType extension = null;
            for (Map.Entry<ExtensionType, String> entry : EXTENSIONS.entrySet()) {
                if (!extensionStr.equals(entry.getValue())) continue;
                extension = entry.getKey();
                break;
            }
            if (extension == null) {
                throw new IOException(strings.getLocalString("checkpointhelper.wrongfileextension", "Wrong checkpoint file extension {0}", new Object[]{file.getName()}));
            }
            this.ext = extension;
            name = name.substring(0, ind);
            if (this.ext == ExtensionType.ATTACHMENT) {
                ind = name.indexOf(45);
                if (ind < 0) {
                    throw new IOException(strings.getLocalString("checkpointhelepr.wrongfilename", "Wrong checkpoint filename format: {0}.", new Object[]{file.getName()}));
                }
                this.jobId = name.substring(0, ind);
                this.attachmentId = name.substring(ind + 1);
            } else {
                this.jobId = name;
            }
        }

        public ExtensionType getExt() {
            return this.ext;
        }

        public String getJobId() {
            return this.jobId;
        }

        public String getAttachmentId() {
            return this.attachmentId;
        }

        public File getParentDir() {
            return this.parentDir;
        }

        public String toString() {
            if (this.cachedFileName == null) {
                StringBuilder result = new StringBuilder();
                result.append(this.jobId);
                if (this.ext == ExtensionType.ATTACHMENT) {
                    result.append("-");
                    if (this.attachmentId == null) {
                        result.append("null");
                    } else if (!this.attachmentId.isEmpty()) {
                        try {
                            MessageDigest md = MessageDigest.getInstance("MD5");
                            byte[] thedigest = md.digest(this.attachmentId.getBytes("UTF-8"));
                            for (int i = 0; i < thedigest.length; ++i) {
                                result.append(Integer.toString((thedigest[i] & 0xFF) + 256, 16).substring(1));
                            }
                        }
                        catch (Exception ex) {
                            result.append(this.attachmentId);
                        }
                    }
                }
                result.append(EXTENSIONS.get((Object)this.ext));
                this.cachedFileName = result.toString();
            }
            return this.cachedFileName;
        }

        public File getFile() {
            return new File(this.parentDir, this.toString());
        }

        public CheckpointFilename getForPayload(boolean inbound) {
            return new CheckpointFilename(this, inbound ? ExtensionType.PAYLOAD_INBOUD : ExtensionType.PAYLOAD_OUTBOUND);
        }

        public static CheckpointFilename createBasic(Job job) {
            return CheckpointFilename.createBasic(job.getId(), job.getJobsFile().getParentFile());
        }

        public static CheckpointFilename createBasic(String jobId, File dir) {
            return new CheckpointFilename(jobId, dir, ExtensionType.BASIC);
        }

        public static CheckpointFilename createAttachment(Job job, String attachmentId) {
            return new CheckpointFilename(job, attachmentId);
        }

        static {
            EnumMap<ExtensionType, String> extMap = new EnumMap<ExtensionType, String>(ExtensionType.class);
            extMap.put(ExtensionType.BASIC, ".checkpoint");
            extMap.put(ExtensionType.ATTACHMENT, ".checkpoint_attach");
            extMap.put(ExtensionType.PAYLOAD_INBOUD, ".checkpoint_inb");
            extMap.put(ExtensionType.PAYLOAD_OUTBOUND, ".checkpoint_outb");
            EXTENSIONS = Collections.unmodifiableMap(extMap);
        }

        static enum ExtensionType {
            BASIC,
            ATTACHMENT,
            PAYLOAD_INBOUD,
            PAYLOAD_OUTBOUND;

        }
    }
}

