/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.customvalidators.JavaClassName;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.universal.collections.ManifestUtils;
import com.sun.enterprise.v3.common.PropsFileActionReporter;
import jakarta.inject.Inject;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.Payload;
import jakarta.validation.constraints.Pattern;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Filter;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.jvnet.hk2.annotations.Service;

@Service(name="_get-habitat-info")
@PerLookup
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="_get-habitat-info", description="_get-habitat-info")})
@Constraint
@AccessRequired(resource={"domain"}, action={"dump"})
public class GetHabitatInfo
implements AdminCommand {
    @Inject
    ServiceLocator serviceLocator;
    @Inject
    ModulesRegistry modulesRegistry;
    @JavaClassName
    @Param(primary=true, optional=true)
    String contract;
    @Pattern(regexp="true|false")
    @Param(optional=true)
    @Pattern(regexp="true|false") String started = "false";

    public void execute(AdminCommandContext context) {
        StringBuilder sb = new StringBuilder();
        if (this.contract == null) {
            this.dumpContracts(sb);
            this.dumpModules(sb);
            this.dumpTypes(sb);
        } else {
            this.dumpInhabitantsImplementingContractPattern(this.contract, sb);
        }
        String msg = sb.toString();
        ActionReport report = context.getActionReport();
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        if (report instanceof PropsFileActionReporter) {
            msg = ManifestUtils.encode((String)msg);
        }
        report.setMessage(msg);
    }

    private void dumpContracts(StringBuilder sb) {
        sb.append("\n*********** Sorted List of all Registered Contracts in the Habitat **************\n");
        List allDescriptors = this.serviceLocator.getDescriptors(BuilderHelper.allFilter());
        TreeSet allContracts = new TreeSet();
        for (ActiveDescriptor aDescriptor : allDescriptors) {
            allContracts.addAll(aDescriptor.getAdvertisedContracts());
        }
        Iterator it = allContracts.iterator();
        int i = 1;
        while (it.hasNext()) {
            sb.append("Contract-" + i + ": " + (String)it.next() + "\n");
            ++i;
        }
    }

    private void dumpInhabitantsImplementingContractPattern(String pattern, StringBuilder sb) {
        sb.append("\n*********** List of all services for contract named like " + this.contract + " **************\n");
        List allDescriptors = this.serviceLocator.getDescriptors(BuilderHelper.allFilter());
        HashSet allContracts = new HashSet();
        for (ActiveDescriptor aDescriptor : allDescriptors) {
            allContracts.addAll(aDescriptor.getAdvertisedContracts());
        }
        for (String cn : allContracts) {
            if (cn.toLowerCase(Locale.ENGLISH).indexOf(pattern.toLowerCase(Locale.ENGLISH)) < 0) continue;
            sb.append("\n-----------------------------\n");
            for (ActiveDescriptor descriptor : this.serviceLocator.getDescriptors((Filter)BuilderHelper.createContractFilter((String)cn))) {
                sb.append("Inhabitant-Metadata: " + descriptor.getMetadata());
                sb.append("\n");
                boolean isStarted = Boolean.parseBoolean(this.started);
                if (!isStarted) continue;
                ServiceHandle handle = this.serviceLocator.getServiceHandle(descriptor);
                sb.append(handle.isActive() ? " started" : " not started");
            }
        }
    }

    private void dumpTypes(StringBuilder sb) {
        sb.append("\n\n*********** Sorted List of all Types in the Habitat **************\n\n");
        List allDescriptors = this.serviceLocator.getDescriptors(BuilderHelper.allFilter());
        HashSet<String> allTypes = new HashSet<String>();
        for (ActiveDescriptor aDescriptor : allDescriptors) {
            allTypes.add(aDescriptor.getImplementation());
        }
        Iterator it = allTypes.iterator();
        if (it == null) {
            return;
        }
        TreeSet types = new TreeSet();
        while (it.hasNext()) {
            types.add(it.next());
        }
        it = types.iterator();
        int i = 1;
        while (it.hasNext()) {
            sb.append("Type-" + i + ": " + (String)it.next() + "\n");
            ++i;
        }
    }

    private void dumpModules(StringBuilder sb) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.modulesRegistry.dumpState(new PrintStream(baos));
        sb.append("\n\n*********** List of all Registered Modules **************\n\n");
        sb.append(baos.toString());
    }

    public static class Validator
    implements ConstraintValidator<Constraint, GetHabitatInfo>,
    Payload {
        public void initialize(Constraint constraint) {
        }

        public boolean isValid(GetHabitatInfo bean, ConstraintValidatorContext constraintValidatorContext) {
            return !bean.contract.equals("test") || !bean.started.equals("true");
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    @jakarta.validation.Constraint(validatedBy={Validator.class})
    public static @interface Constraint {
        public String message() default "The contract argument is test but started is true.";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};
    }
}

