/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.io;

import com.sun.messaging.jmq.io.InvalidSysMessageIDException;
import com.sun.messaging.jmq.util.Bits;
import com.sun.messaging.jmq.util.net.IPAddress;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;

public class SysMessageID
implements Cloneable {
    public static final int ID_SIZE = 32;
    public static final String ID_PREFIX = "ID:";
    protected int sequence;
    protected int port;
    protected long timestamp;
    protected IPAddress ip = new IPAddress();
    private String msgID = null;
    private boolean dirty = true;
    protected transient int hashcodeVal = 0;

    public SysMessageID() {
        this.clear();
    }

    public static void main(String[] args) throws Exception {
        SysMessageID trystr = new SysMessageID();
        System.out.println("With MAC Address");
        System.out.println("------------------------");
        InetAddress inet = null;
        inet = InetAddress.getLocalHost();
        trystr.setIPAddress(inet.getAddress(), IPAddress.getRandomMac());
        trystr.setPort(123);
        trystr.setTimestamp(123456L);
        trystr.setSequence(5);
        System.out.println("\tOriginal: " + trystr);
        SysMessageID newid = SysMessageID.get(trystr.toString());
        System.out.println("\tDecoded: " + newid);
        System.out.println("\tHash[o,n]=[" + trystr.hashCode() + "," + newid.hashCode() + "]");
        System.out.println("\tEquals: " + trystr.equals(newid) + " , " + newid.equals(trystr));
        System.out.println("\n\nWithout MAC Address");
        System.out.println("------------------------");
        trystr = new SysMessageID();
        trystr.setIPAddress(inet.getAddress());
        trystr.setPort(664);
        trystr.setTimestamp(789012L);
        trystr.setSequence(2);
        System.out.println("\tOriginal: " + trystr);
        newid = SysMessageID.get(trystr.toString());
        System.out.println("\tHash[o,n]=[" + trystr.hashCode() + "," + newid.hashCode() + "]");
        System.out.println("\tEquals: " + trystr.equals(newid) + " , " + newid.equals(trystr));
        System.out.println("\tDecoded: " + SysMessageID.get(trystr.toString()));
        System.out.println("\n\nIPV6");
        System.out.println("------------------------");
        System.out.println("Testing IPV6 requires changes to OS");
    }

    public static SysMessageID get(String sid) {
        String[] ss;
        SysMessageID id = new SysMessageID();
        if (sid.startsWith(ID_PREFIX)) {
            sid = sid.substring(ID_PREFIX.length());
        }
        if ((ss = sid.split("-")).length != 4) {
            if (ss.length == 5 && ss[2].length() == 0) {
                ss[2] = "-" + ss[3];
                ss[3] = ss[4];
            } else {
                throw new InvalidSysMessageIDException("Bad SysMessageID [" + sid + "]");
            }
        }
        try {
            int sequence = Integer.parseInt(ss[0]);
            int port = Integer.parseInt(ss[2]);
            long ts = Long.parseLong(ss[3]);
            IPAddress ip = IPAddress.readFromString(ss[1]);
            id.setPort(port);
            id.setSequence(sequence);
            id.setTimestamp(ts);
            id.ip = ip;
            return id;
        }
        catch (NumberFormatException e) {
            throw new InvalidSysMessageIDException("Bad SysMessageID [" + sid + "]:" + e.getMessage(), e);
        }
    }

    public void clear() {
        this.port = 0;
        this.sequence = 0;
        this.timestamp = 0L;
        this.ip.clear();
        this.dirty = true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SysMessageID)) {
            return false;
        }
        SysMessageID id = (SysMessageID)o;
        return this.sequence == id.sequence && this.timestamp == id.timestamp && this.port == id.port && this.ip.equals(id.ip);
    }

    public int hashCode() {
        if (this.hashcodeVal == 0) {
            int p = this.port == 0 ? 1 : this.port;
            this.hashcodeVal = (int)this.timestamp * p * this.sequence;
        }
        return this.hashcodeVal;
    }

    public String toString() {
        if (this.msgID == null || this.dirty) {
            this.msgID = new StringBuilder(128).append(this.sequence).append('-').append(this.ip.toString()).append('-').append(this.port).append('-').append(this.timestamp).toString();
            this.dirty = false;
        }
        return this.msgID;
    }

    public String getUniqueName() {
        return this.toString();
    }

    public String getUniqueNameOldFormat() {
        String uniqueName = String.valueOf(this.sequence) + String.valueOf(this.timestamp) + String.valueOf(this.port) + IPAddress.rawIPToString(this.ip.getAddress(), false);
        return uniqueName;
    }

    public int getSequence() {
        return this.sequence;
    }

    public int getPort() {
        return this.port;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public byte[] getIPAddress() {
        return this.ip.getAddress();
    }

    public void setSequence(int n) {
        this.dirty = true;
        this.sequence = n;
    }

    public void setPort(int n) {
        this.dirty = true;
        this.port = n;
    }

    public void setTimestamp(long n) {
        this.dirty = true;
        this.timestamp = n;
    }

    public void setIPAddress(byte[] newip) throws IllegalArgumentException {
        this.ip.setAddress(newip);
        this.dirty = true;
    }

    public void setIPAddress(byte[] newip, byte[] mac) throws IllegalArgumentException {
        this.ip.setAddress(newip);
        if (mac != null && this.ip.getType() != 2) {
            this.ip.setMac(mac);
        }
        this.dirty = true;
    }

    public void writeID(DataOutput out) throws IOException {
        out.writeLong(this.timestamp);
        this.ip.writeAddress(out);
        out.writeInt(this.port);
        out.writeInt(this.sequence);
        if (out instanceof DataOutputStream) {
            ((DataOutputStream)out).flush();
        }
    }

    public byte[] getRawID() {
        byte[] buf = new byte[32];
        int i = 0;
        i = Bits.put(buf, i, this.timestamp);
        i = Bits.put(buf, i, this.ip.getAddressUnsafe());
        i = Bits.put(buf, i, this.port);
        Bits.put(buf, i, this.sequence);
        return buf;
    }

    public void readID(DataInput in) throws IOException {
        this.timestamp = in.readLong();
        this.ip.readAddress(in);
        this.port = in.readInt();
        this.sequence = in.readInt();
    }

    public Object clone() {
        try {
            SysMessageID newID = (SysMessageID)super.clone();
            newID.ip = (IPAddress)this.ip.clone();
            return newID;
        }
        catch (CloneNotSupportedException e) {
            System.out.println("SysMessageID: Could not clone: " + e);
            return null;
        }
    }
}

