/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.jmq.io.ReadOnlyPacket;
import com.sun.messaging.jmq.jmsclient.AsyncSendCallback;
import com.sun.messaging.jmq.jmsclient.ConnectionImpl;
import com.sun.messaging.jmq.jmsclient.Consumer;
import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsclient.ExceptionHandler;
import com.sun.messaging.jmq.jmsclient.MessageImpl;
import com.sun.messaging.jmq.jmsclient.ProtocolHandler;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import java.io.IOException;

public class WriteChannel {
    private boolean debug = Debug.debug;
    private ProtocolHandler protocolHandler = null;
    private ConnectionImpl connection = null;
    public static final String JMQSize = "JMQSize";
    private int flowCount = -1;
    protected boolean turnOffFlowControl = false;
    protected boolean noFlowControl = false;

    public WriteChannel(ConnectionImpl conn) {
        this.connection = conn;
        this.protocolHandler = conn.getProtocolHandler();
        if (System.getProperty("NoimqProducerFlowControl") != null) {
            this.turnOffFlowControl = true;
        }
        if (System.getProperty("imq.producer.flowControl.disabled") != null) {
            this.noFlowControl = true;
            ConnectionImpl.getConnectionLogger().info("Producer flow control is turned off.");
        }
    }

    protected void addInterest(Consumer consumer) throws JMSException {
        this.protocolHandler.addInterest(consumer);
    }

    protected void removeInterest(Consumer consumer) throws JMSException {
        this.protocolHandler.removeInterest(consumer);
    }

    protected void unsubscribe(String durableName) throws JMSException {
        this.protocolHandler.unsubscribe(durableName);
    }

    protected void writeJMSMessage(Message message, AsyncSendCallback asynccb) throws JMSException {
        if (this.noFlowControl) {
            this.protocolHandler.writeJMSMessage(message, asynccb);
        } else if (this.turnOffFlowControl && this.connection.getBrokerProtocolLevel() < 350) {
            this.protocolHandler.writeJMSMessage(message, asynccb);
        } else {
            this.sendWithFlowControl(message, asynccb);
        }
    }

    protected void updateFlowControl(ReadOnlyPacket pkt) throws JMSException {
        int jmqSize = -1;
        try {
            Integer prop = (Integer)pkt.getProperties().get(JMQSize);
            if (prop != null) {
                jmqSize = prop;
            }
        }
        catch (IOException e) {
            ExceptionHandler.handleException(e, "C4005", true);
        }
        catch (ClassNotFoundException e) {
            ExceptionHandler.handleException(e, "C4005", true);
        }
        this.setFlowCount(jmqSize);
    }

    private synchronized void setFlowCount(int jmqSize) {
        this.flowCount = jmqSize;
        this.notifyAll();
    }

    private void sendWithFlowControl(Message message, AsyncSendCallback asynccb) throws JMSException {
        this.pause(message, true);
        this.protocolHandler.writeJMSMessage(message, asynccb);
    }

    private synchronized void pause(Message message, boolean block) throws JMSException {
        while (this.flowCount == 0) {
            if (this.debug) {
                Debug.println("WriteChannel : Waiting for RESUME_FLOW with bock=" + block);
            }
            if (!block) {
                throw new JMSException("XXXWOULD-BLOCK");
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.debug) {
            Debug.println("WriteChannel : wait() returned...");
        }
        if (this.flowCount > 0) {
            --this.flowCount;
        }
        if (this.flowCount == 0) {
            ((MessageImpl)message).getPacket().setFlowPaused(true);
        } else {
            ((MessageImpl)message).getPacket().setFlowPaused(false);
        }
    }

    protected void close() {
        if (this.debug) {
            Debug.println("WriteChannel.close() : Waking up blocked producers");
        }
        this.setFlowCount(-1);
    }
}

