/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.auth.file;

import com.sun.messaging.jmq.auth.api.server.model.UserRepository;
import com.sun.messaging.jmq.auth.jaas.MQAdminGroup;
import com.sun.messaging.jmq.auth.jaas.MQGroup;
import com.sun.messaging.jmq.auth.jaas.MQUser;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.util.MD5;
import com.sun.messaging.jmq.util.StringUtil;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.security.auth.Refreshable;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;

public class JMQFileUserRepository
implements UserRepository {
    public static final String TYPE = "file";
    public static final String PROP_FILENAME_SUFFIX = "file.filename";
    public static final String PROP_DIRPATH_SUFFIX = "file.dirpath";
    public static final String DEFAULT_PW_FILENAME = "passwd";
    private static boolean DEBUG = false;
    private transient Logger logger = Globals.getLogger();
    private static String ADMINGROUP = "admin";
    private String authType;
    private Properties authProps = null;

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void open(String authType, Properties authProperties, Refreshable cacheData) throws LoginException {
        this.authType = authType;
        this.authProps = authProperties;
    }

    @Override
    public Subject findMatch(String user, Object credential, Object extra, String matchType) throws LoginException {
        if (matchType == null || !matchType.equals("basic") && !matchType.equals("digest")) {
            String matchtyp = matchType == null ? "null" : matchType;
            Object[] args = new String[]{matchtyp, this.authType, this.getType(), "basic:digest"};
            throw new LoginException(Globals.getBrokerResources().getKString("B4079", args));
        }
        HashMap userPTable = new HashMap();
        HashMap userRTable = new HashMap();
        try {
            this.loadUserTable(userPTable, userRTable);
        }
        catch (IOException e) {
            this.logger.logStack(32, e.getMessage(), e);
            userPTable = null;
            userRTable = null;
            throw new LoginException(e.getMessage());
        }
        Subject subject = null;
        if (matchType.equals("basic")) {
            subject = this.basicFindMatch(user, (String)credential, userPTable, userRTable);
        } else if (matchType.equals("digest")) {
            subject = this.digestFindMatch(user, (String)credential, (String)extra, userPTable, userRTable);
        }
        userPTable = null;
        userRTable = null;
        return subject;
    }

    private Subject basicFindMatch(String user, String userpwd, HashMap userPTable, HashMap userRTable) throws LoginException {
        Subject subject = null;
        String passwd = (String)userPTable.get(user);
        if (DEBUG) {
            this.logger.log(8, "basicFindMatch(user=" + user + ",userpwd=" + userpwd + "), passwd=" + passwd);
        }
        if (passwd != null) {
            String passwdhash = MD5.getHashString(user + ":" + userpwd);
            if (passwd.equals(passwdhash)) {
                subject = this.getSubject(user, userRTable);
            } else if (DEBUG) {
                this.logger.log(8, "basicFindMatch(user=" + user + ",userpwd=" + userpwd + "), passwdhash=" + passwdhash);
            }
        }
        return subject;
    }

    private Subject digestFindMatch(String user, String credential, String nonce, HashMap userPTable, HashMap userRTable) throws LoginException {
        Subject subject = null;
        String passwd = (String)userPTable.get(user);
        if (DEBUG) {
            this.logger.log(8, "digestFindMatch(user=" + user + ",credential=" + credential + ",nonce=" + nonce + "), passwd=" + passwd);
        }
        if (passwd != null) {
            String passwdhash = MD5.getHashString(passwd + ":" + nonce);
            if (credential.equals(passwdhash)) {
                subject = this.getSubject(user, userRTable);
            } else if (DEBUG) {
                this.logger.log(8, "digestFindMatch(user=" + user + ",credential=" + credential + ",nonce=" + nonce + "), passwdhash=" + passwdhash);
            }
        }
        return subject;
    }

    private Subject getSubject(String user, HashMap userRTable) {
        Subject subject = null;
        final String rolestr = (String)userRTable.get(user);
        final String tempUser = user;
        subject = (Subject)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Subject tempSubject = new Subject();
                tempSubject.getPrincipals().add(new MQUser(tempUser));
                if (rolestr != null && !rolestr.trim().equals("")) {
                    tempSubject.getPrincipals().add(new MQGroup(rolestr));
                }
                if (rolestr != null && rolestr.equals(ADMINGROUP)) {
                    tempSubject.getPrincipals().add(new MQAdminGroup(ADMINGROUP));
                }
                return tempSubject;
            }
        });
        return subject;
    }

    private void loadUserTable(HashMap userPTable, HashMap userRTable) throws IOException {
        String rep = this.authProps.getProperty("imq.authentication." + this.authType + ".user_repository");
        if (rep == null) {
            throw new IOException(Globals.getBrokerResources().getKString("B4041", this.authType));
        }
        if (!rep.equals(TYPE)) {
            Object[] args = new String[]{rep, TYPE, this.getClass().getName()};
            throw new IOException(Globals.getBrokerResources().getKString("B4070", args));
        }
        File pwdfile = JMQFileUserRepository.getPasswordFile(this.authProps, false);
        InputStreamReader fr = null;
        BufferedReader br = null;
        try {
            String line;
            fr = new InputStreamReader((InputStream)new FileInputStream(pwdfile), "UTF8");
            br = new BufferedReader(fr);
            while ((line = br.readLine()) != null) {
                String active = null;
                String role = null;
                String passwd = null;
                String name = null;
                StringTokenizer st = new StringTokenizer(line, ":", false);
                if (st.hasMoreTokens()) {
                    name = st.nextToken();
                }
                if (st.hasMoreTokens()) {
                    passwd = st.nextToken();
                }
                if (st.hasMoreTokens() && (role = st.nextToken()) != null && role.trim().length() == 0) {
                    role = null;
                }
                if (st.hasMoreTokens()) {
                    active = st.nextToken();
                }
                if (DEBUG) {
                    this.logger.log(8, "passwd entry " + name + ":" + passwd + ":" + role + ":" + active);
                }
                if (name == null || passwd == null || active == null || !active.equals("1")) continue;
                userPTable.put(name, passwd);
                if (role == null) continue;
                userRTable.put(name, role);
            }
            br.close();
            fr.close();
        }
        catch (IOException ioe) {
            try {
                if (br != null) {
                    br.close();
                }
                if (fr != null) {
                    fr.close();
                }
            }
            catch (IOException name) {
                // empty catch block
            }
            IOException ex = new IOException(Globals.getBrokerResources().getKString("B3052", pwdfile.toString(), ioe.getMessage()));
            ex.initCause(ioe);
            throw ex;
        }
    }

    @Override
    public Refreshable getCacheData() {
        return null;
    }

    @Override
    public void close() throws LoginException {
    }

    public static String getPasswordDirPath(Properties props, boolean fromUserManager) {
        String passwd_loc = props.getProperty("imq.user_repository.file.dirpath", Globals.getInstanceEtcDir());
        if (fromUserManager) {
            passwd_loc = StringUtil.expandVariables(passwd_loc, props);
        }
        return passwd_loc;
    }

    public static File getPasswordFile(Properties props, boolean fromUserManager) {
        String passwd_loc = JMQFileUserRepository.getPasswordDirPath(props, fromUserManager);
        String f = props.getProperty("imq.user_repository.file.filename", DEFAULT_PW_FILENAME);
        String pwdfile = passwd_loc + File.separator + f;
        return new File(pwdfile);
    }
}

