/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.bridge.api.BridgeServiceManager;
import com.sun.messaging.bridge.api.JMSBridgeStore;
import com.sun.messaging.jmq.Version;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.BrokerState;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.multibroker.ChangeRecord;
import com.sun.messaging.jmq.jmsserver.persist.api.ChangeRecordInfo;
import com.sun.messaging.jmq.jmsserver.persist.api.HABrokerInfo;
import com.sun.messaging.jmq.jmsserver.persist.api.Store;
import com.sun.messaging.jmq.jmsserver.persist.api.StoreManager;
import com.sun.messaging.jmq.jmsserver.persist.api.TransactionInfo;
import com.sun.messaging.jmq.jmsserver.persist.file.FileStore;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BrokerDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DAOFactory;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBConstants;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.JDBCStore;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.PropertyDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.StoreSessionDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.UpgradeHAStore;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.UpgradeStore;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.VersionDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.comm.BaseDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.comm.CommDBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.sharecc.ShareConfigChangeDBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.sharecc.ShareConfigRecordDAO;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.PassfileObfuscatorImpl;
import com.sun.messaging.jmq.util.StringUtil;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class DBTool
implements DBConstants {
    static final String SQLFILEDIR_PROP = "imq.persist.jdbcsqlfile.dirpath";
    static final String SQLFILENAME_PROP = "imq.persist.jdbcsqlfile.name";
    static final String STORE_PROPERTY_HABROKERS = "imq.cluster.haBrokers";
    static final String STORE_PROPERTY_SUPPORT_JMSBRIDGE = "imq.bridge.jmsbridge.tables";
    private static int EXTRA_CMD_SPECIFIED = 0;
    private static int BAD_CMD_ARG = 1;
    private static int BAD_OPT = 2;
    private static int BAD_OPT_ARG = 3;
    private static int MISSING_OPT_ARG = 4;
    private static int MISSING_CMD_ARG = 5;
    private static int MISSING_OPT = 6;
    private static String CMD_NAME = "dbmgrcmd";
    private static String CREATE_ALL_CMD = "createall";
    private static String CREATE_TBL_CMD = "createtbl";
    private static String CREATE_SHARECCTBL_CMD = "create sharecc_tbl";
    private static String DELETE_TBL_CMD = "deletetbl";
    private static String DELETE_SHARECCTBL_CMD = "delete sharecc_tbl";
    private static String RECREATE_TBL_CMD = "recreatetbl";
    private static String RECREATE_SHARECCTBL_CMD = "recreate sharecc_tbl";
    private static String REMOVE_BKR_CMD = "removebkr";
    private static String REMOVE_JMSBRIDGE_CMD = "removejmsbridge";
    private static String DUMP_CMD = "dump";
    private static String DUMP_SHARECCTBL_CMD = "dump sharecc_tbl";
    private static String DROPTBL_CMD = "droptbl";
    private static String RESET_CMD = "reset";
    private static String BACKUP_CMD = "backup";
    private static String BACKUP_SHARECCTBL_CMD = "backup sharecc_tbl";
    private static String RESTORE_CMD = "restore";
    private static String RESTORE_SHARECCTBL_CMD = "restore sharecc_tbl";
    private static String UPGRADE_STORE_CMD = "upgradestore";
    private static String UPGRADE_HASTORE_CMD = "upgradehastore";
    private static String QUERY_CMD = "query";
    private static String ARG_NAME = "dbmgrarg";
    private static String CREATE_CMD_STR = "create";
    private static String DELETE_CMD_STR = "delete";
    private static String RECREATE_CMD_STR = "recreate";
    private static String REMOVE_CMD_STR = "remove";
    private static String UPGRADE_CMD_STR = "upgrade";
    private static String ARGU_ALL = "all";
    private static String ARGU_TBL = "tbl";
    private static String ARGU_SHARECCTBL = "sharecc_tbl";
    private static String ARGU_BKR = "bkr";
    private static String ARGU_JMSBRIDGE = "jmsbridge";
    private static String ARGU_OLDTBL = "oldtbl";
    private static String ARGU_LCK = "lck";
    private static String ARGU_STORE = "store";
    private static String ARGU_HASTORE = "hastore";
    private static String OPT_H = "-h";
    private static String OPT_LH = "-help";
    private static String OPT_V = "-v";
    private static String OPT_LV = "-version";
    private static String OPT_B = "-b";
    private static String OPT_N = "-n";
    private static String OPT_U = "-u";
    private static String OPT_P = "-p";
    private static String OPT_PW = "-pw";
    private static String OPT_PASSFILE = "-passfile";
    private static String OPT_D = "-D";
    private static String OPT_VARHOME = "-varhome";
    private static String OPT_VERBOSE = "-verbose";
    private static String OPT_DEBUG = "-debug";
    private static String OPT_DIR = "-dir";
    private static String OPT_FILE = "-file";
    private static String OPT_FORCE = "-f";
    private static String JMSBRIDGE_NAME_PROPERTY = "jmsbridge.name";
    private static BrokerResources br = Globals.getBrokerResources();
    private static BrokerConfig config;
    private static Logger logger;
    private Version version = new Version();
    private DBManager dbmgr = null;
    private boolean standalone = true;
    private boolean cliPasswdSpecified = false;
    private boolean debugSpecified = false;
    private boolean forceSpecified = false;

    DBTool(boolean standalone) {
        this.standalone = standalone;
    }

    private void doCreate(boolean createdb) throws BrokerException {
        this.doCreate(createdb, null);
    }

    private void doCreate(boolean createdb, CommDBManager mgrArg) throws BrokerException {
        CommDBManager mgr = mgrArg == null ? this.dbmgr : mgrArg;
        Connection conn = null;
        try {
            if (createdb) {
                conn = mgr.connectToCreate();
                conn.setAutoCommit(true);
            } else {
                conn = mgr.getNewConnection(true);
            }
            boolean continueOnError = false;
            int status = mgr.checkStoreExists(conn);
            if (status > 0) {
                if (!(mgr instanceof ShareConfigChangeDBManager)) {
                    throw new BrokerException(br.getKString("B3210"));
                }
                throw new BrokerException(br.getKString("B3263", Globals.getClusterID()));
            }
            if (status < 0) {
                continueOnError = true;
            }
            DBTool.createTables(conn, continueOnError, mgr);
            if (this.standalone) {
                if (Globals.getHAEnabled()) {
                    System.out.println(br.getString("B1165", Globals.getClusterID()));
                } else if (mgr instanceof ShareConfigChangeDBManager) {
                    System.out.println(br.getString("B1362", Globals.getClusterID()));
                } else {
                    System.out.println(br.getString("B1046"));
                }
            }
        }
        catch (Throwable t) {
            String url = createdb ? mgr.getCreateDBURL() : mgr.getOpenDBURL();
            throw new BrokerException(br.getKString("B3073", url), t);
        }
        finally {
            if (createdb && conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    throw new BrokerException(Globals.getBrokerResources().getKString("B3100", "Unable to close JDBC resources", e));
                }
            }
        }
    }

    static void createTables(Connection conn) throws BrokerException {
        DBTool.createTables(conn, false);
    }

    static void createTables(Connection conn, boolean continueOnError) throws BrokerException {
        DBTool.createTables(conn, continueOnError, null, null);
    }

    public static void createTables(Connection conn, boolean continueOnError, CommDBManager mgrArg) throws BrokerException {
        DBTool.createTables(conn, continueOnError, null, mgrArg);
    }

    static void createTables(Connection conn, boolean continueOnError, ArrayList tableDAOs) throws BrokerException {
        DBTool.createTables(conn, continueOnError, tableDAOs, null);
    }

    static void createTables(Connection conn, boolean continueOnError, ArrayList tableDAOs, CommDBManager mgrArg) throws BrokerException {
        CommDBManager mgr = mgrArg;
        if (mgr == null) {
            mgr = DBManager.getDBManager();
        }
        Iterator itr = null;
        itr = tableDAOs != null ? tableDAOs.iterator() : mgr.allDAOIterator();
        block8: while (itr.hasNext()) {
            BaseDAO dao = (BaseDAO)itr.next();
            try {
                Util.RetryStrategy retry = null;
                while (true) {
                    try {
                        dao.createTable(conn);
                        continue block8;
                    }
                    catch (Exception e) {
                        if (retry == null) {
                            retry = new Util.RetryStrategy(mgr);
                        }
                        retry.assertShouldRetry(e);
                        continue;
                    }
                    break;
                }
            }
            catch (BrokerException be) {
                if (Globals.getHAEnabled() || mgr instanceof ShareConfigChangeDBManager) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                if (mgr.checkStoreExists(conn) > 0) {
                    if (tableDAOs == null) {
                        Globals.getLogger().log(16, "B3073", Globals.getBrokerResources().getString("B3210"));
                        continueOnError = true;
                        break;
                    }
                    Globals.getLogger().log(16, "B3073", Globals.getBrokerResources().getString("B3237", dao.getTableName()));
                    break;
                }
                if (continueOnError) {
                    Globals.getLogger().log(16, be.toString(), be.getCause());
                    continue;
                }
                throw be;
            }
        }
        if (tableDAOs != null || !(mgr instanceof DBManager)) {
            return;
        }
        DAOFactory daoFactory = ((DBManager)mgr).getDAOFactory();
        VersionDAO versionDAO = daoFactory.getVersionDAO();
        try {
            if (continueOnError) {
                int storeVersion = versionDAO.getStoreVersion(conn);
                if (storeVersion != 410) {
                    versionDAO.insert(conn, 410);
                }
            } else {
                versionDAO.insert(conn, 410);
            }
        }
        catch (BrokerException be) {
            if (Globals.getHAEnabled()) {
                int storeVersion = versionDAO.getStoreVersion(conn);
                if (storeVersion != 410) {
                    throw be;
                }
            }
            throw be;
        }
        if (!Globals.getHAEnabled()) {
            String brokerID = Globals.getBrokerID();
            StoreSessionDAO sessionDAO = daoFactory.getStoreSessionDAO();
            if (sessionDAO.getStoreSession(conn, brokerID) <= 0L) {
                sessionDAO.insert(conn, brokerID, new UID().longValue(), true);
            }
        }
        PropertyDAO dao = daoFactory.getPropertyDAO();
        dao.update(conn, STORE_PROPERTY_SUPPORT_JMSBRIDGE, true);
        if (JDBCStore.ENABLE_STORED_PROC) {
            DBTool.createStoredProcs(conn);
        }
    }

    private static void createStoredProcs(Connection conn) throws BrokerException {
        ArrayList<BaseDAO> daos = new ArrayList<BaseDAO>();
        DBManager mgr = DBManager.getDBManager();
        Iterator itr = ((CommDBManager)mgr).allDAOIterator();
        while (itr.hasNext()) {
            BaseDAO dao = (BaseDAO)itr.next();
            try {
                Util.RetryStrategy retry = null;
                while (true) {
                    try {
                        dao.createStoredProc(conn);
                    }
                    catch (Exception e) {
                        if (retry == null) {
                            retry = new Util.RetryStrategy(mgr);
                        }
                        retry.assertShouldRetry(e);
                        continue;
                    }
                    break;
                }
                daos.add(dao);
            }
            catch (BrokerException be) {
                try {
                    DBTool.dropStoredProcs(conn, daos);
                }
                catch (Exception e) {
                    Globals.getLogger().logStack(16, be.getMessage(), be);
                }
                throw be;
            }
        }
    }

    private static void dropStoredProcs(Connection conn, ArrayList<BaseDAO> daos) throws BrokerException {
        DBManager mgr = DBManager.getDBManager();
        Iterator<BaseDAO> itr = null;
        itr = daos == null ? ((CommDBManager)mgr).allDAOIterator() : daos.iterator();
        block4: while (itr.hasNext()) {
            BaseDAO dao = itr.next();
            try {
                Util.RetryStrategy retry = null;
                while (true) {
                    try {
                        dao.dropStoredProc(conn);
                        continue block4;
                    }
                    catch (Exception e) {
                        if (retry == null) {
                            retry = new Util.RetryStrategy(mgr);
                        }
                        retry.assertShouldRetry(e);
                        continue;
                    }
                    break;
                }
            }
            catch (BrokerException be) {
                Globals.getLogger().logStack(16, be.getMessage(), be);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void updateStoreVersion410IfNecessary(Connection conn, DBManager dbMgr) throws BrokerException {
        try {
            DAOFactory daoFactory;
            VersionDAO versionDAO;
            int storeVersion;
            if (!Globals.getHAEnabled()) {
                dbMgr.lockTables(conn, true);
            }
            if ((storeVersion = (versionDAO = (daoFactory = dbMgr.getDAOFactory()).getVersionDAO()).getStoreVersion(conn)) != 410) {
                throw new BrokerException(br.getKString("B3092", String.valueOf(storeVersion), String.valueOf(410)));
            }
            PropertyDAO dao = daoFactory.getPropertyDAO();
            if (!dao.hasProperty(conn, STORE_PROPERTY_SUPPORT_JMSBRIDGE)) {
                ArrayList<BaseDAO> daos = new ArrayList<BaseDAO>();
                daos.add(daoFactory.getTMLogRecordDAOJMSBG());
                daos.add(daoFactory.getJMSBGDAO());
                DBTool.createTables(conn, false, daos);
                dao.update(conn, STORE_PROPERTY_SUPPORT_JMSBRIDGE, true);
            }
        }
        finally {
            if (!Globals.getHAEnabled()) {
                dbMgr.lockTables(conn, false);
            }
        }
    }

    private void doReset() throws BrokerException {
        Connection conn = null;
        BrokerException myex = null;
        try {
            conn = this.dbmgr.getConnection(true);
            this.dbmgr.lockTables(conn, false);
        }
        catch (BrokerException e) {
            myex = e;
            throw e;
        }
        finally {
            Util.close(null, null, conn, myex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doDelete(String arg, CommDBManager mgrArg, DeleteStatus deleteStatus) throws BrokerException {
        CommDBManager mgr = mgrArg == null ? this.dbmgr : mgrArg;
        boolean deleted = false;
        Connection conn = null;
        Exception myex = null;
        try {
            conn = mgr.getConnection(true);
            if (arg == null || arg.length() == 0) {
                String[] oldnames;
                if (mgr instanceof ShareConfigChangeDBManager && (oldnames = mgr.getAllOldTableNames()) != null && oldnames.length > 0) {
                    DBTool.dropTables(conn, mgr.getAllOldTableNames(), true, true, mgr);
                }
                boolean continueOnError = false;
                int status = mgr.checkStoreExists(conn);
                if (status > 0 && !(mgr instanceof ShareConfigChangeDBManager)) {
                    if (!this.forceSpecified && Globals.getHAEnabled() && ((DBManager)mgr).isHAClusterActive(conn)) {
                        throw new BrokerException(br.getKString("B3209", this.dbmgr.getClusterID()));
                    }
                    try {
                        if (!this.forceSpecified) {
                            mgr.lockTables(conn, true);
                        }
                    }
                    catch (BrokerException e) {
                        if (e.getStatusCode() != 404) throw e;
                        continueOnError = true;
                    }
                } else if (status <= 0 || !(mgr instanceof ShareConfigChangeDBManager)) {
                    if (status < 0) {
                        continueOnError = true;
                    } else {
                        if (deleteStatus == null) {
                            if (mgr instanceof ShareConfigChangeDBManager) throw new BrokerException(br.getKString("B3258", Globals.getClusterID()));
                            throw new BrokerException(br.getKString("B3211"));
                        }
                        deleteStatus.deleted = true;
                    }
                }
                if ((deleteStatus == null || !deleteStatus.deleted) && (deleted = DBTool.dropTables(conn, continueOnError, mgrArg)) && deleteStatus != null) {
                    deleteStatus.deleted = true;
                }
            } else if (arg.equals(ARGU_OLDTBL)) {
                int oldStoreVersion = -1;
                if (DBTool.checkVersion(conn, "IMQSV37" + this.dbmgr.getBrokerID(), this.dbmgr)) {
                    oldStoreVersion = 370;
                } else {
                    if (!DBTool.checkVersion(conn, "IMQSV35" + this.dbmgr.getBrokerID(), this.dbmgr)) throw new BrokerException("Old persistent store (version 370) not found");
                    oldStoreVersion = 350;
                }
                deleted = DBTool.dropTables(conn, this.dbmgr.getTableNames(oldStoreVersion), false, false, this.dbmgr);
            }
            if (!this.standalone) return;
            if (!deleted) return;
            if (deleteStatus != null) return;
            if (Globals.getHAEnabled()) {
                System.out.println(br.getString("B1166", Globals.getClusterID()));
                return;
            }
            if (mgr instanceof ShareConfigChangeDBManager) {
                System.out.println(br.getString("B1363", Globals.getClusterID()));
                return;
            }
            System.out.println(br.getString("B1051"));
            return;
        }
        catch (Exception e) {
            myex = e;
            if (this.debugSpecified) {
                e.printStackTrace();
            }
            if (mgr instanceof ShareConfigChangeDBManager) throw new BrokerException(br.getKString("B3257", Globals.getClusterID(), mgr.getOpenDBURL()), e);
            throw new BrokerException(br.getKString("B3075", mgr.getOpenDBURL()), e);
        }
        finally {
            Util.close(null, null, conn, myex, mgrArg);
        }
    }

    public static boolean dropTables(Connection conn, String[] oldnames, boolean oldsupplementck, boolean continueOnError, CommDBManager mgrArg) throws SQLException, BrokerException {
        if (oldnames == null || oldnames.length == 0) {
            return true;
        }
        CommDBManager mgr = mgrArg == null ? DBManager.getDBManager() : mgrArg;
        boolean deleted = false;
        Exception myex = null;
        Statement stmt = null;
        try {
            int len = oldnames.length;
            for (int i = 0; i < len; ++i) {
                try {
                    String oldname = oldnames[i];
                    stmt = conn.createStatement();
                    Globals.getLogger().logToAll(8, br.getString("B1164", oldname));
                    CommDBManager.executeUpdateStatement(stmt, "DROP TABLE " + oldname);
                    if (!oldsupplementck || !mgr.hasSupplementForCreateDrop(oldname)) continue;
                    mgr.dropOldTableSupplement(stmt, oldname, false);
                    continue;
                }
                catch (Exception e) {
                    if (continueOnError) {
                        Globals.getLogger().log(16, e.toString(), e.getCause());
                        continue;
                    }
                    myex = e;
                    throw e;
                }
            }
            deleted = true;
        }
        catch (Exception e) {
            try {
                Object[] args = new Object[]{Arrays.asList(oldnames), e.getMessage()};
                String emsg = Globals.getBrokerResources().getKString("B4424", args);
                Globals.getLogger().logStack(32, emsg, e);
                if (e instanceof SQLException) {
                    throw (SQLException)e;
                }
                if (e instanceof BrokerException) {
                    throw (BrokerException)e;
                }
                throw new BrokerException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                Util.close(null, stmt, null, myex, mgr);
                throw throwable;
            }
        }
        Util.close(null, stmt, null, myex, mgr);
        return deleted;
    }

    public static boolean dropTables(Connection conn, boolean continueOnError, CommDBManager mgrArg) throws SQLException, BrokerException {
        CommDBManager mgr = mgrArg == null ? DBManager.getDBManager() : mgrArg;
        boolean deleted = false;
        try {
            Iterator itr = mgr.allDAOIterator();
            block6: while (itr.hasNext()) {
                BaseDAO dao = (BaseDAO)itr.next();
                try {
                    Util.RetryStrategy retry = null;
                    while (true) {
                        try {
                            dao.dropTable(conn);
                            if (!(mgr instanceof DBManager)) continue block6;
                            dao.dropStoredProc(conn);
                            continue block6;
                        }
                        catch (Exception e) {
                            if (retry == null) {
                                retry = new Util.RetryStrategy(mgr);
                            }
                            retry.assertShouldRetry(e);
                            continue;
                        }
                        break;
                    }
                }
                catch (BrokerException be) {
                    if (continueOnError) {
                        Globals.getLogger().log(16, be.toString(), be.getCause());
                        continue;
                    }
                    throw be;
                }
            }
            deleted = true;
        }
        catch (Exception e) {
            if (!(mgr instanceof ShareConfigChangeDBManager)) {
                Globals.getLogger().log(32, "B3075", (Object)e.toString(), (Throwable)e);
            } else {
                Globals.getLogger().log(32, "B3257", Globals.getClusterID(), e.toString(), e);
            }
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            if (e instanceof BrokerException) {
                throw (BrokerException)e;
            }
            throw new BrokerException(e.getMessage(), e);
        }
        return deleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkVersion(Connection conn, String vtable, CommDBManager mgr) throws BrokerException {
        String selectSQL = "SELECT * FROM " + vtable;
        Statement stmt = null;
        ResultSet rs = null;
        SQLException myex = null;
        try {
            stmt = conn.createStatement();
            rs = CommDBManager.executeQueryStatement(stmt, selectSQL);
        }
        catch (SQLException e) {
            boolean bl;
            try {
                myex = e;
                bl = false;
            }
            catch (Throwable throwable) {
                Util.close(rs, stmt, null, myex);
                throw throwable;
            }
            Util.close(rs, stmt, null, myex);
            return bl;
        }
        Util.close(rs, stmt, null, myex);
        return true;
    }

    private void doRecreate() throws BrokerException {
        this.doRecreate(null);
    }

    private void doRecreate(CommDBManager mgrArg) throws BrokerException {
        Throwable myex;
        Connection conn;
        block7: {
            CommDBManager mgr = mgrArg == null ? this.dbmgr : mgrArg;
            conn = null;
            myex = null;
            try {
                DeleteStatus deleteStatus = new DeleteStatus();
                this.doDelete(null, mgr, deleteStatus);
                conn = mgr.getConnection(true);
                DBTool.createTables(conn, false, mgrArg);
                if (!this.standalone) break block7;
                if (Globals.getHAEnabled()) {
                    System.out.println(br.getString("B1165", Globals.getClusterID()));
                    break block7;
                }
                if (mgr instanceof ShareConfigChangeDBManager) {
                    System.out.println(br.getString("B1362", Globals.getClusterID()));
                    break block7;
                }
                System.out.println(br.getString("B1046"));
            }
            catch (Throwable t) {
                try {
                    myex = t;
                    if (!(mgr instanceof ShareConfigChangeDBManager)) {
                        throw new BrokerException(br.getKString("B3076", mgr.getOpenDBURL()), t);
                    }
                    throw new BrokerException(br.getKString("B3256", Globals.getClusterID(), mgr.getOpenDBURL()), t);
                }
                catch (Throwable throwable) {
                    Util.close(null, null, conn, myex, mgrArg);
                    throw throwable;
                }
            }
        }
        Util.close(null, null, conn, myex, mgrArg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRemoveBkr() throws BrokerException {
        String errorMsg;
        String brokerID;
        block15: {
            brokerID = Globals.getBrokerID();
            Connection conn = null;
            errorMsg = null;
            Exception myex = null;
            try {
                conn = this.dbmgr.getConnection(true);
                this.dbmgr.lockTables(conn, true);
                try {
                    DAOFactory daoFactory = this.dbmgr.getDAOFactory();
                    BrokerDAO brokerDAO = daoFactory.getBrokerDAO();
                    BrokerState state = brokerDAO.getState(conn, brokerID);
                    if (!state.isActiveState()) {
                        try {
                            conn.setAutoCommit(false);
                            daoFactory.getConsumerStateDAO().deleteAll(conn);
                            daoFactory.getMessageDAO().deleteAll(conn);
                            daoFactory.getDestinationDAO().deleteAll(conn);
                            daoFactory.getTransactionDAO().deleteAll(conn);
                            daoFactory.getStoreSessionDAO().deleteByBrokerID(conn, brokerID);
                            brokerDAO.delete(conn, brokerID);
                            daoFactory.getTMLogRecordDAOJMSBG().deleteAll(conn);
                            daoFactory.getJMSBGDAO().deleteAll(conn);
                            conn.commit();
                            break block15;
                        }
                        finally {
                            conn.setAutoCommit(true);
                        }
                    }
                    errorMsg = br.getString("B3182", brokerID, "broker is still active - " + state);
                }
                finally {
                    this.dbmgr.lockTables(conn, false);
                }
            }
            catch (Exception e) {
                myex = e;
                throw new BrokerException(br.getKString("B3183", brokerID), e);
            }
            finally {
                Util.close(null, null, conn, myex);
            }
        }
        if (this.standalone) {
            if (errorMsg == null) {
                System.out.println(br.getString("B1167", brokerID));
            } else {
                System.out.println(errorMsg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRemoveJMSBridge(String bname) throws BrokerException {
        if (bname == null) {
            try {
                this.checkArg(null, null, OPT_N, 0, 0);
            }
            catch (ParserException e) {
                this.handleParserException(e);
                this.exit(1);
            }
        }
        String brokerID = Globals.getBrokerID();
        Connection conn = null;
        String errorMsg = null;
        Exception myex = null;
        try {
            block20: {
                if (!this.askConfirmation("Removing JMS Bridge " + bname + ".")) {
                    return;
                }
                conn = this.dbmgr.getConnection(true);
                this.dbmgr.lockTables(conn, true);
                try {
                    DAOFactory daoFactory = this.dbmgr.getDAOFactory();
                    BrokerDAO brokerDAO = daoFactory.getBrokerDAO();
                    BrokerState state = brokerDAO.getState(conn, brokerID);
                    if (!state.isActiveState()) {
                        try {
                            conn.setAutoCommit(false);
                            daoFactory.getJMSBGDAO().delete(conn, bname, null);
                            daoFactory.getTMLogRecordDAOJMSBG().deleteAllByName(conn, bname, null);
                            conn.commit();
                            break block20;
                        }
                        finally {
                            conn.setAutoCommit(true);
                        }
                    }
                    errorMsg = br.getString("B3238");
                }
                finally {
                    this.dbmgr.lockTables(conn, false);
                }
            }
            Util.close(null, null, conn, myex);
        }
        catch (Exception e) {
            myex = e;
            throw new BrokerException(br.getString("B3239", bname, e.getMessage()), e);
        }
        finally {
            Util.close(null, null, conn, myex);
        }
        if (this.standalone) {
            if (errorMsg == null) {
                System.out.println(br.getString("B1323", bname));
            } else {
                System.out.println(errorMsg);
            }
        }
    }

    private void doUpgrade(boolean haStore) throws BrokerException {
        Connection conn = null;
        BrokerException myex = null;
        try {
            conn = this.dbmgr.getConnection(true);
            if (haStore) {
                new UpgradeHAStore().upgradeStore(conn);
            } else {
                JDBCStore store = (JDBCStore)StoreManager.getStore();
                int oldStoreVersion = -1;
                if (store.checkOldStoreVersion(conn, this.dbmgr.getTableName("MQVER40"), "STORE_VERSION", 400)) {
                    oldStoreVersion = 400;
                } else if (store.checkOldStoreVersion(conn, "IMQSV37" + this.dbmgr.getBrokerID(), "STOREVERSION", 370)) {
                    oldStoreVersion = 370;
                } else if (store.checkOldStoreVersion(conn, "IMQSV35" + this.dbmgr.getBrokerID(), "STOREVERSION", 350)) {
                    oldStoreVersion = 350;
                } else {
                    throw new BrokerException("Old persistent store (version 400) not found");
                }
                new UpgradeStore(store, oldStoreVersion).upgradeStore(conn);
            }
        }
        catch (BrokerException e) {
            myex = e;
            throw e;
        }
        finally {
            Util.close(null, null, conn, myex);
        }
    }

    private void doDump(String arg, CommDBManager mgrArg) throws SQLException, BrokerException {
        CommDBManager mgr = mgrArg == null ? this.dbmgr : mgrArg;
        String[] names = null;
        if (!(mgr instanceof ShareConfigChangeDBManager)) {
            int storeVersion = 410;
            if (arg != null) {
                try {
                    storeVersion = Integer.parseInt(arg);
                }
                catch (NumberFormatException e) {
                    storeVersion = 0;
                }
            }
            if (storeVersion != 410 && ((names = mgr.getTableNames(storeVersion)) == null || names.length == 0)) {
                throw new BrokerException("version " + arg + " not supported");
            }
        }
        Connection conn = null;
        Exception myex = null;
        try {
            conn = mgr.getConnection(true);
            DBTool.doDump(conn, names, mgr);
        }
        catch (SQLException e) {
            myex = e;
            throw e;
        }
        catch (BrokerException e) {
            myex = e;
            throw e;
        }
        finally {
            Util.close(null, null, conn, myex, mgr);
        }
    }

    static void doDump(Connection dbconn, String[] tables, CommDBManager mgrArg) throws BrokerException, SQLException {
        CommDBManager mgr = mgrArg;
        if (tables != null && tables.length > 0) {
            Statement stmt = null;
            SQLException myex = null;
            try {
                stmt = dbconn.createStatement();
                for (int i = 0; i < tables.length; ++i) {
                    ResultSet r = null;
                    String tname = tables[i];
                    String sql = "SELECT COUNT(*) FROM " + tname;
                    try {
                        r = CommDBManager.executeQueryStatement(stmt, sql);
                        if (r.next()) {
                            System.out.println(tname + ": number of row=" + r.getInt(1));
                        }
                        r.close();
                        continue;
                    }
                    catch (SQLException e) {
                        SQLException ex = CommDBManager.wrapSQLException("[" + sql + "]", e);
                        logger.log(32, "failed to dump tables", ex);
                    }
                }
            }
            catch (SQLException e) {
                myex = e;
                throw e;
            }
            finally {
                Util.close(null, stmt, null, myex, mgr);
            }
        } else {
            Iterator itr = mgr.allDAOIterator();
            while (itr.hasNext()) {
                BaseDAO dao = (BaseDAO)itr.next();
                System.out.println(dao.getDebugInfo(dbconn).toString());
            }
        }
    }

    private void doDropTablesByPattern(String arg) throws BrokerException {
        Connection conn = null;
        Exception myex = null;
        try {
            conn = this.dbmgr.getConnection(true);
            Map map = this.dbmgr.getTableNamesFromDB(conn, arg, false);
            String[] names = map.values().toArray(new String[map.size()]);
            if (names == null || names.length == 0) {
                System.out.println("There were no tables that match the name pattern 'MQ*" + arg + "'.");
                return;
            }
            System.out.println("Tables matching the name pattern 'MQ*" + arg + "':");
            int len = names.length;
            for (int i = 0; i < len; ++i) {
                System.out.println("\t" + names[i]);
            }
            if (!this.askConfirmation("Remove all tables that match 'MQ*" + arg + "'.")) {
                return;
            }
            DBTool.dropTables(conn, names, false, true, this.dbmgr);
        }
        catch (Exception e) {
            myex = e;
            System.err.println("Failed to drop tables by name pattern: " + e.getMessage());
            throw new BrokerException(br.getKString("B3075", "table name pattern '" + arg + "'"), e);
        }
        finally {
            Util.close(null, null, conn, myex);
        }
    }

    private boolean askConfirmation(String prompt) throws IOException {
        if (this.forceSpecified) {
            return true;
        }
        System.out.println(prompt + "\nDo you wish to proceed? [y/n] ");
        System.out.flush();
        String val = new BufferedReader(new InputStreamReader(System.in)).readLine();
        return "y".equalsIgnoreCase(val) || "yes".equalsIgnoreCase(val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doBackup() throws BrokerException {
        if (!Globals.getHAEnabled()) {
            throw new BrokerException(br.getKString("B1230", this.dbmgr.getBrokerID()));
        }
        Properties props = System.getProperties();
        String clusterID = Globals.getClusterID();
        String backupDir = (String)props.get("imq.backupdir") + File.separator + clusterID;
        logger.logToAll(8, "Backup persistent store for HA cluster " + clusterID);
        FileStore fileStore = new FileStore(backupDir, false);
        fileStore.clearAll(false);
        JDBCStore jdbcStore = null;
        try {
            jdbcStore = (JDBCStore)StoreManager.getStore();
            Properties properties = jdbcStore.getAllProperties();
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                fileStore.updateProperty((String)entry.getKey(), entry.getValue(), false);
            }
            Iterator<Map.Entry<Object, Object>> propItr = null;
            properties = null;
            List<ChangeRecordInfo> records = jdbcStore.getAllConfigRecords();
            int len = records.size();
            for (int i = 0; i < len; ++i) {
                fileStore.storeConfigChangeRecord(records.get(i).getTimestamp(), records.get(i).getRecord(), false);
            }
            records = null;
            Consumer[] consumerArray = jdbcStore.getAllInterests();
            for (int i = 0; i < consumerArray.length; ++i) {
                fileStore.storeInterest(consumerArray[i], false);
            }
            consumerArray = null;
            HashMap bkrMap = jdbcStore.getAllBrokerInfos(true);
            ArrayList haBrokers = new ArrayList(bkrMap.values());
            fileStore.updateProperty(STORE_PROPERTY_HABROKERS, haBrokers, true);
            for (HABrokerInfo bkrInfo : haBrokers) {
                String brokerID = bkrInfo.getId();
                logger.logToAll(8, "Backup persistent data for broker " + brokerID);
                Store bkrFS = null;
                JMSBridgeStore jmsbridgeStore = null;
                try {
                    int i;
                    String instanceRootDir = backupDir + File.separator + brokerID;
                    bkrFS = new FileStore(instanceRootDir, false);
                    ((FileStore)bkrFS).clearAll(false);
                    Destination[] dstArray = jdbcStore.getAllDestinations(brokerID);
                    int len2 = dstArray.length;
                    for (i = 0; i < len2; ++i) {
                        DestinationUID did = dstArray[i].getDestinationUID();
                        Destination dst = ((FileStore)bkrFS).getDestination(did);
                        if (dst != null) continue;
                        ((FileStore)bkrFS).storeDestination(dstArray[i], false);
                    }
                    len2 = dstArray.length;
                    for (i = 0; i < len2; ++i) {
                        Enumeration e = jdbcStore.messageEnumeration(dstArray[i]);
                        try {
                            while (e.hasMoreElements()) {
                                Packet message;
                                SysMessageID mid;
                                DestinationUID did = dstArray[i].getDestinationUID();
                                HashMap stateMap = jdbcStore.getInterestStates(did, mid = (message = (Packet)e.nextElement()).getSysMessageID());
                                if (stateMap == null || stateMap.isEmpty()) {
                                    ((FileStore)bkrFS).storeMessage(did, message, false);
                                    continue;
                                }
                                int size = stateMap.size();
                                ConsumerUID[] iids = new ConsumerUID[size];
                                int[] states = new int[size];
                                Iterator stateItr = stateMap.entrySet().iterator();
                                int j = 0;
                                while (stateItr.hasNext()) {
                                    Map.Entry entry = stateItr.next();
                                    iids[j] = (ConsumerUID)entry.getKey();
                                    states[j] = (Integer)entry.getValue();
                                    ++j;
                                }
                                ((FileStore)bkrFS).storeMessage(did, message, iids, states, false);
                            }
                            continue;
                        }
                        finally {
                            jdbcStore.closeEnumeration(e);
                        }
                    }
                    Collection txnList = jdbcStore.getTransactions(brokerID);
                    for (TransactionUID tid : txnList) {
                        TransactionInfo txnInfo = jdbcStore.getTransactionInfo(tid);
                        TransactionAcknowledgement[] txnAck = jdbcStore.getTransactionAcks(tid);
                        ((FileStore)bkrFS).storeTransaction(tid, txnInfo, false);
                        int len3 = txnAck.length;
                        for (int i2 = 0; i2 < len3; ++i2) {
                            ((FileStore)bkrFS).storeTransactionAck(tid, txnAck[i2], false);
                        }
                    }
                    Properties bp = new Properties();
                    bp.setProperty("instanceRootDir", instanceRootDir);
                    bp.setProperty("reset", "true");
                    bp.setProperty("logdomain", "imqdbmgr");
                    bp.setProperty("identityName", Globals.getIdentityName());
                    BridgeServiceManager.getExportedService(JMSBridgeStore.class, "JMS", bp);
                    List bnames = jdbcStore.getJMSBridgesByBroker(brokerID, null);
                    Collections.sort(bnames);
                    String bname2 = null;
                    String currbname = null;
                    for (String bname2 : bnames) {
                        if (currbname != null && currbname.equals(bname2)) continue;
                        currbname = bname2;
                        bp.setProperty("jmsbridge", bname2);
                        if (jmsbridgeStore != null) {
                            jmsbridgeStore.closeJMSBridgeStore();
                            jmsbridgeStore = null;
                        }
                        logger.logToAll(8, "Backup JMS bridge " + bname2);
                        jmsbridgeStore = (JMSBridgeStore)BridgeServiceManager.getExportedService(JMSBridgeStore.class, "JMS", bp);
                        List lrs = jdbcStore.getLogRecordsByNameByBroker(bname2, brokerID, null);
                        logger.logToAll(8, "\tBackup JMS bridge " + bname2 + " with " + lrs.size() + " TM log records");
                        byte[] lr2 = null;
                        for (byte[] lr2 : lrs) {
                            jmsbridgeStore.storeTMLogRecord(null, lr2, currbname, true, null);
                        }
                    }
                }
                finally {
                    bkrFS.close();
                    if (jmsbridgeStore == null) continue;
                    jmsbridgeStore.closeJMSBridgeStore();
                }
            }
            logger.logToAll(8, "Backup persistent store complete.");
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            throw new BrokerException(ex.getMessage());
        }
        finally {
            if (fileStore != null) {
                try {
                    fileStore.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            StoreManager.releaseStore(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRestore() throws BrokerException {
        if (!Globals.getHAEnabled()) {
            throw new BrokerException(br.getKString("B1230", this.dbmgr.getBrokerID()));
        }
        Properties props = System.getProperties();
        String clusterID = Globals.getClusterID();
        String backupDir = (String)props.get("imq.backupdir") + File.separator + clusterID;
        logger.logToAll(8, "Restore persistent store for HA cluster " + clusterID + " from backup dir: " + backupDir);
        FileStore fileStore = new FileStore(backupDir, false);
        JDBCStore jdbcStore = null;
        try {
            this.doRecreate();
            jdbcStore = (JDBCStore)StoreManager.getStore();
            List haBrokers = null;
            Properties properties = fileStore.getAllProperties();
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String name = (String)entry.getKey();
                if (name.equals(STORE_PROPERTY_HABROKERS)) {
                    haBrokers = (List)entry.getValue();
                    continue;
                }
                jdbcStore.updateProperty(name, entry.getValue(), false);
            }
            Iterator<Map.Entry<Object, Object>> propItr = null;
            properties = null;
            if (haBrokers == null || haBrokers.isEmpty()) {
                throw new BrokerException(br.getKString("B4221"));
            }
            List<ChangeRecordInfo> records = fileStore.getAllConfigRecords();
            int len = records.size();
            for (int i = 0; i < len; ++i) {
                jdbcStore.storeConfigChangeRecord(records.get(i).getTimestamp(), records.get(i).getRecord(), false);
            }
            records = null;
            Consumer[] consumerArray = fileStore.getAllInterests();
            for (int i = 0; i < consumerArray.length; ++i) {
                jdbcStore.storeInterest(consumerArray[i], false);
            }
            consumerArray = null;
            for (HABrokerInfo bkrInfo : haBrokers) {
                jdbcStore.addBrokerInfo(bkrInfo, false);
            }
            for (HABrokerInfo bkrInfo : haBrokers) {
                String brokerID = bkrInfo.getId();
                long sessionID = bkrInfo.getSessionID();
                logger.logToAll(8, "Restore persistent data for broker " + brokerID);
                Store bkrFS = null;
                JMSBridgeStore jmsbridgeStore = null;
                try {
                    int i;
                    String instanceRootDir = backupDir + File.separator + brokerID;
                    bkrFS = new FileStore(instanceRootDir, false);
                    Destination[] dstArray = ((FileStore)bkrFS).getAllDestinations();
                    int len2 = dstArray.length;
                    for (i = 0; i < len2; ++i) {
                        DestinationUID did = dstArray[i].getDestinationUID();
                        Destination dst = jdbcStore.getDestination(did);
                        if (dst != null) continue;
                        jdbcStore.storeDestination(dstArray[i], sessionID);
                    }
                    len2 = dstArray.length;
                    for (i = 0; i < len2; ++i) {
                        Enumeration e = ((FileStore)bkrFS).messageEnumeration(dstArray[i]);
                        while (e.hasMoreElements()) {
                            Packet message;
                            SysMessageID mid;
                            DestinationUID did = dstArray[i].getDestinationUID();
                            HashMap stateMap = ((FileStore)bkrFS).getInterestStates(did, mid = (message = (Packet)e.nextElement()).getSysMessageID());
                            if (stateMap == null || stateMap.isEmpty()) {
                                jdbcStore.storeMessage(did, message, null, null, sessionID, false);
                                continue;
                            }
                            int size = stateMap.size();
                            ConsumerUID[] iids = new ConsumerUID[size];
                            int[] states = new int[size];
                            Iterator stateItr = stateMap.entrySet().iterator();
                            int j = 0;
                            while (stateItr.hasNext()) {
                                Map.Entry entry = stateItr.next();
                                iids[j] = (ConsumerUID)entry.getKey();
                                states[j] = (Integer)entry.getValue();
                                ++j;
                            }
                            jdbcStore.storeMessage(did, message, iids, states, sessionID, false);
                        }
                    }
                    Collection txnList = ((FileStore)bkrFS).getTransactions(brokerID);
                    for (TransactionUID tid : txnList) {
                        TransactionInfo txnInfo = ((FileStore)bkrFS).getTransactionInfo(tid);
                        TransactionAcknowledgement[] txnAck = ((FileStore)bkrFS).getTransactionAcks(tid);
                        jdbcStore.storeTransaction(tid, txnInfo, sessionID);
                        int len3 = txnAck.length;
                        for (int i2 = 0; i2 < len3; ++i2) {
                            jdbcStore.storeTransactionAck(tid, txnAck[i2], false);
                        }
                    }
                    Properties bp = new Properties();
                    bp.setProperty("instanceRootDir", instanceRootDir);
                    bp.setProperty("reset", "false");
                    bp.setProperty("logdomain", "imqdbmgr");
                    jmsbridgeStore = (JMSBridgeStore)BridgeServiceManager.getExportedService(JMSBridgeStore.class, "JMS", bp);
                    if (jmsbridgeStore == null) continue;
                    List bnames = jmsbridgeStore.getJMSBridges(null);
                    String bname2 = null;
                    for (String bname2 : bnames) {
                        jdbcStore.addJMSBridge(bname2, true, null);
                    }
                    jmsbridgeStore.closeJMSBridgeStore();
                    jmsbridgeStore = null;
                    bname2 = null;
                    for (String bname2 : bnames) {
                        bp.setProperty("jmsbridge", bname2);
                        if (jmsbridgeStore != null) {
                            jmsbridgeStore.closeJMSBridgeStore();
                            jmsbridgeStore = null;
                        }
                        logger.logToAll(8, "Restore JMS bridge " + bname2);
                        jmsbridgeStore = (JMSBridgeStore)BridgeServiceManager.getExportedService(JMSBridgeStore.class, "JMS", bp);
                        List xids = jmsbridgeStore.getTMLogRecordKeysByName(bname2, null);
                        logger.logToAll(8, "\tRestore JMS bridge " + bname2 + " with " + xids.size() + " TM log records");
                        String xid2 = null;
                        byte[] lr = null;
                        for (String xid2 : xids) {
                            lr = jmsbridgeStore.getTMLogRecord(xid2, bname2, null);
                            if (lr == null) {
                                logger.logToAll(8, "JMSBridge TM log record not found for " + xid2);
                                continue;
                            }
                            jdbcStore.storeTMLogRecord(xid2, lr, bname2, true, null);
                        }
                    }
                }
                finally {
                    bkrFS.close();
                    if (jmsbridgeStore == null) continue;
                    jmsbridgeStore.closeJMSBridgeStore();
                }
            }
            logger.logToAll(8, "Restore persistent store complete.");
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            throw new BrokerException(ex.getMessage());
        }
        finally {
            if (fileStore != null) {
                try {
                    fileStore.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            StoreManager.releaseStore(true);
        }
    }

    private void doBackupSharecc() throws BrokerException {
        Properties props = System.getProperties();
        String clusterID = Globals.getClusterID();
        String backupfile = (String)props.get("imq.cluster.sharecc.backupfile");
        logger.logToAll(8, br.getKString("B1373", clusterID, backupfile));
        ShareConfigChangeDBManager mgr = ShareConfigChangeDBManager.getDBManager();
        ShareConfigRecordDAO dao = mgr.getDAOFactory().getShareConfigRecordDAO();
        try {
            List<ChangeRecordInfo> records = null;
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    records = dao.getAllRecords(null, null);
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy(mgr);
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
            Globals.getLogger().logToAll(8, br.getKString("B1370", String.valueOf(records.size()), dao.getTableName()));
            ChangeRecord.backupRecords(records, backupfile, true);
            Globals.getLogger().logToAll(8, br.getKString("B1371", Globals.getClusterID(), backupfile));
        }
        catch (BrokerException e) {
            String emsg = br.getKString("B3265", e.getMessage());
            Globals.getLogger().logToAll(32, emsg, e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRestoreSharecc() throws BrokerException {
        Properties props = System.getProperties();
        String clusterID = Globals.getClusterID();
        String backupfile = (String)props.get("imq.cluster.sharecc.backupfile");
        logger.logToAll(8, br.getKString("B1374", clusterID, backupfile));
        ShareConfigChangeDBManager mgr = ShareConfigChangeDBManager.getDBManager();
        Connection conn = null;
        Exception myex = null;
        try {
            List<ChangeRecordInfo> records = ChangeRecord.prepareRestoreRecords(backupfile);
            ShareConfigRecordDAO dao = mgr.getDAOFactory().getShareConfigRecordDAO();
            Globals.getLogger().logToAll(8, br.getKString("B1375", String.valueOf(records.size()), backupfile));
            conn = mgr.getConnection(true);
            ChangeRecordInfo resetcri = ChangeRecord.makeResetRecord(true);
            try {
                mgr.lockTables(conn, true, resetcri);
                Connection myconn = null;
                BrokerException myee = null;
                try {
                    myconn = mgr.getConnection(false);
                    Util.RetryStrategy retry = null;
                    while (true) {
                        try {
                            Iterator<ChangeRecordInfo> itr = records.iterator();
                            ChangeRecordInfo cri = null;
                            while (itr.hasNext()) {
                                cri = itr.next();
                                if (cri.getType() == 31) {
                                    itr.remove();
                                    continue;
                                }
                                cri.setResetUUID(resetcri.getUUID());
                                cri.setTimestamp(System.currentTimeMillis());
                                dao.insert(myconn, cri);
                            }
                            myconn.commit();
                        }
                        catch (Exception e) {
                            if (retry == null) {
                                retry = new Util.RetryStrategy(mgr);
                            }
                            retry.assertShouldRetry(e);
                            continue;
                        }
                        break;
                    }
                }
                catch (BrokerException e) {
                    myee = e;
                    throw e;
                }
                finally {
                    Util.close(null, null, myconn, myee, mgr);
                }
            }
            finally {
                try {
                    mgr.lockTables(conn, false);
                }
                catch (Exception e) {
                    logger.log(16, br.getKString("B4423", e.toString()), e);
                }
            }
            logger.logToAll(8, br.getKString("B1376", Globals.getClusterID(), backupfile));
        }
        catch (Exception e) {
            try {
                myex = e;
                String emsg = br.getKString("B3267", e.getMessage());
                Globals.getLogger().logToAll(32, emsg, e);
                if (e instanceof BrokerException) {
                    throw (BrokerException)e;
                }
                throw new BrokerException(emsg, e);
            }
            catch (Throwable throwable) {
                Util.close(null, null, conn, myex, mgr);
                throw throwable;
            }
        }
        Util.close(null, null, conn, myex, mgr);
    }

    private void doQuery() throws BrokerException {
        Connection conn = null;
        BrokerException myex = null;
        try {
            conn = this.dbmgr.getConnection(true);
            if (Globals.getHAEnabled()) {
                System.out.println(br.getString("B1202", Globals.getBrokerID(), Globals.getClusterID()));
            } else {
                System.out.println(br.getString("B1042"));
            }
            DBTool.updateStoreVersion410IfNecessary(conn, this.dbmgr);
            int status = this.dbmgr.checkStoreExists(conn);
            if (status == 0) {
                System.out.println(br.getString("B3132"));
            } else if (status > 0) {
                System.out.println(br.getString("B3210"));
            } else {
                System.out.println(br.getString("B3213"));
            }
        }
        catch (BrokerException e) {
            myex = e;
            throw e;
        }
        finally {
            Util.close(null, null, conn, myex);
        }
    }

    private boolean printHelp(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals(OPT_H) && !args[i].equals(OPT_LH)) continue;
            return true;
        }
        return false;
    }

    private boolean printVersion(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals(OPT_V) && !args[i].equals(OPT_LV)) continue;
            return true;
        }
        return false;
    }

    private void checkArg(String cmd, String opt, int next, int total) throws ParserException {
        this.checkArg(cmd, opt, null, next, total);
    }

    private void checkArg(String cmd, String opt, String missopt, int next, int total) throws ParserException {
        if (next >= total) {
            ParserException pe;
            if (cmd != null) {
                pe = new ParserException(MISSING_CMD_ARG);
                pe.cmd = cmd;
            } else if (missopt != null) {
                pe = new ParserException(MISSING_OPT);
                pe.opt = missopt;
            } else {
                pe = new ParserException(MISSING_OPT_ARG);
                pe.opt = opt;
            }
            throw pe;
        }
    }

    private void throwParserException(int reason, String cmd, String cmdarg, String opt, String optarg) throws ParserException {
        this.throwParserException(reason, cmd, cmdarg, opt, optarg, null);
    }

    private void throwParserException(int reason, String cmd, String cmdarg, String opt, String optarg, Throwable cause) throws ParserException {
        ParserException pe = new ParserException(reason, cause);
        pe.cmd = cmd;
        pe.cmdarg = cmdarg;
        pe.opt = opt;
        pe.optarg = optarg;
        throw pe;
    }

    private void handleParserException(ParserException e) {
        if (e.reason == MISSING_CMD_ARG) {
            System.out.println(br.getString("B3083", e.cmd));
        } else if (e.reason == MISSING_OPT_ARG) {
            System.out.println(br.getString("B3080", e.opt));
        } else if (e.reason == MISSING_OPT) {
            System.out.println(br.getString("B3240", e.opt));
        } else if (e.reason == BAD_CMD_ARG) {
            System.out.println(br.getString("B3078", e.cmd, e.cmdarg));
        } else if (e.reason == BAD_OPT) {
            if (e.opt.equals(OPT_P)) {
                System.out.println(br.getString("B3217", e.opt));
            } else {
                System.out.println(br.getString("B3079", e.opt));
            }
        } else if (e.reason == BAD_OPT_ARG) {
            System.out.println(br.getString("B3081", e.opt, e.optarg));
        } else if (e.reason == EXTRA_CMD_SPECIFIED) {
            System.out.println(br.getString("B3077", e.cmd));
        }
    }

    private Properties parseArgs(String[] args) throws ParserException {
        Properties props = System.getProperties();
        boolean gotcmd = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals(CREATE_CMD_STR)) {
                if (gotcmd) {
                    this.throwParserException(EXTRA_CMD_SPECIFIED, args[i], null, null, null);
                } else {
                    gotcmd = true;
                }
                this.checkArg(args[i], null, ++i, args.length);
                if (args[i].equals(ARGU_ALL)) {
                    props.put(CMD_NAME, CREATE_ALL_CMD);
                } else if (args[i].equals(ARGU_TBL)) {
                    props.put(CMD_NAME, CREATE_TBL_CMD);
                } else if (args[i].equals(ARGU_SHARECCTBL)) {
                    props.put(CMD_NAME, CREATE_SHARECCTBL_CMD);
                } else {
                    this.throwParserException(BAD_CMD_ARG, CREATE_CMD_STR, args[i], null, null);
                }
            } else if (args[i].equals(DELETE_CMD_STR)) {
                if (gotcmd) {
                    this.throwParserException(EXTRA_CMD_SPECIFIED, args[i], null, null, null);
                } else {
                    gotcmd = true;
                }
                this.checkArg(args[i], null, ++i, args.length);
                if (args[i].equals(ARGU_TBL)) {
                    props.put(CMD_NAME, DELETE_TBL_CMD);
                } else if (args[i].equals(ARGU_SHARECCTBL)) {
                    props.put(CMD_NAME, DELETE_SHARECCTBL_CMD);
                } else if (args[i].equals(ARGU_OLDTBL)) {
                    props.put(CMD_NAME, DELETE_TBL_CMD);
                    props.put(ARG_NAME, ARGU_OLDTBL);
                } else {
                    this.throwParserException(BAD_CMD_ARG, DELETE_CMD_STR, args[i], null, null);
                }
            } else if (args[i].equals(RECREATE_CMD_STR)) {
                if (gotcmd) {
                    this.throwParserException(EXTRA_CMD_SPECIFIED, args[i], null, null, null);
                } else {
                    gotcmd = true;
                }
                this.checkArg(args[i], null, ++i, args.length);
                if (args[i].equals(ARGU_TBL)) {
                    props.put(CMD_NAME, RECREATE_TBL_CMD);
                } else if (args[i].equals(ARGU_SHARECCTBL)) {
                    props.put(CMD_NAME, RECREATE_SHARECCTBL_CMD);
                } else {
                    this.throwParserException(BAD_CMD_ARG, RECREATE_CMD_STR, args[i], null, null);
                }
            } else if (args[i].equals(REMOVE_CMD_STR)) {
                if (gotcmd) {
                    this.throwParserException(EXTRA_CMD_SPECIFIED, args[i], null, null, null);
                } else {
                    gotcmd = true;
                }
                this.checkArg(args[i], null, ++i, args.length);
                if (args[i].equals(ARGU_BKR)) {
                    props.put(CMD_NAME, REMOVE_BKR_CMD);
                } else if (args[i].equals(ARGU_JMSBRIDGE)) {
                    props.put(CMD_NAME, REMOVE_JMSBRIDGE_CMD);
                } else {
                    this.throwParserException(BAD_CMD_ARG, REMOVE_CMD_STR, args[i], null, null);
                }
            } else if (args[i].equals(DUMP_CMD)) {
                if (gotcmd) {
                    this.throwParserException(EXTRA_CMD_SPECIFIED, args[i], null, null, null);
                } else {
                    gotcmd = true;
                }
                this.checkArg(args[i], null, ++i, args.length);
                if (args[i].equals(ARGU_SHARECCTBL)) {
                    props.put(CMD_NAME, DUMP_SHARECCTBL_CMD);
                } else {
                    try {
                        Integer.parseInt(args[i]);
                    }
                    catch (Exception e) {
                        this.throwParserException(BAD_CMD_ARG, DUMP_CMD, args[i], null, null, e);
                    }
                    props.put(CMD_NAME, DUMP_CMD);
                    props.put(ARG_NAME, args[i]);
                }
            } else if (args[i].equals(DROPTBL_CMD)) {
                if (gotcmd) {
                    this.throwParserException(EXTRA_CMD_SPECIFIED, args[i], null, null, null);
                } else {
                    gotcmd = true;
                }
                this.checkArg(args[i], null, ++i, args.length);
                props.put(CMD_NAME, DROPTBL_CMD);
                props.put(ARG_NAME, args[i]);
            } else if (args[i].equals(RESET_CMD)) {
                if (gotcmd) {
                    this.throwParserException(EXTRA_CMD_SPECIFIED, args[i], null, null, null);
                } else {
                    gotcmd = true;
                }
                this.checkArg(args[i], null, ++i, args.length);
                if (args[i].equals(ARGU_LCK)) {
                    props.put(CMD_NAME, RESET_CMD);
                } else {
                    this.throwParserException(BAD_CMD_ARG, RESET_CMD, args[i], null, null);
                }
            } else if (args[i].equals(BACKUP_CMD)) {
                if (gotcmd) {
                    this.throwParserException(EXTRA_CMD_SPECIFIED, args[i], null, null, null);
                } else {
                    gotcmd = true;
                }
                this.checkArg(args[i], null, ++i, args.length);
                if (args[i].equals(OPT_DIR)) {
                    props.put(CMD_NAME, BACKUP_CMD);
                    this.checkArg(args[i], null, ++i, args.length);
                    props.put("imq.backupdir", args[i]);
                } else if (args[i].equals(ARGU_SHARECCTBL)) {
                    props.put(CMD_NAME, BACKUP_SHARECCTBL_CMD);
                    this.checkArg(null, null, OPT_FILE, ++i, args.length);
                    if (args[i].equals(OPT_FILE)) {
                        this.checkArg(null, args[i], null, ++i, args.length);
                        props.put("imq.cluster.sharecc.backupfile", args[i]);
                    } else {
                        this.throwParserException(BAD_CMD_ARG, BACKUP_SHARECCTBL_CMD, args[i], null, null);
                    }
                } else {
                    this.throwParserException(BAD_CMD_ARG, BACKUP_CMD, args[i], null, null);
                }
            } else if (args[i].equals(RESTORE_CMD)) {
                if (gotcmd) {
                    this.throwParserException(EXTRA_CMD_SPECIFIED, args[i], null, null, null);
                } else {
                    gotcmd = true;
                }
                this.checkArg(args[i], null, ++i, args.length);
                if (args[i].equals(OPT_DIR)) {
                    props.put(CMD_NAME, RESTORE_CMD);
                    this.checkArg(args[i], null, ++i, args.length);
                    props.put("imq.backupdir", args[i]);
                } else if (args[i].equals(ARGU_SHARECCTBL)) {
                    props.put(CMD_NAME, RESTORE_SHARECCTBL_CMD);
                    this.checkArg(null, null, OPT_FILE, ++i, args.length);
                    if (args[i].equals(OPT_FILE)) {
                        this.checkArg(null, args[i], null, ++i, args.length);
                        props.put("imq.cluster.sharecc.backupfile", args[i]);
                    } else {
                        this.throwParserException(BAD_CMD_ARG, RESTORE_SHARECCTBL_CMD, args[i], null, null);
                    }
                } else {
                    this.throwParserException(BAD_CMD_ARG, RESTORE_CMD, args[i], null, null);
                }
            } else if (args[i].equals(UPGRADE_CMD_STR)) {
                if (gotcmd) {
                    this.throwParserException(EXTRA_CMD_SPECIFIED, args[i], null, null, null);
                } else {
                    gotcmd = true;
                }
                this.checkArg(args[i], null, ++i, args.length);
                if (args[i].equals(ARGU_STORE)) {
                    props.put(CMD_NAME, UPGRADE_STORE_CMD);
                } else if (args[i].equals(ARGU_HASTORE)) {
                    props.put(CMD_NAME, UPGRADE_HASTORE_CMD);
                } else {
                    this.throwParserException(BAD_CMD_ARG, UPGRADE_CMD_STR, args[i], null, null);
                }
            } else if (args[i].equals(QUERY_CMD)) {
                if (gotcmd) {
                    this.throwParserException(EXTRA_CMD_SPECIFIED, args[i], null, null, null);
                } else {
                    gotcmd = true;
                }
                props.put(CMD_NAME, QUERY_CMD);
            } else if (args[i].equals(OPT_B)) {
                this.checkArg(null, OPT_B, ++i, args.length);
                props.put("imq.instancename", args[i]);
            } else if (args[i].equals(OPT_N)) {
                this.checkArg(null, OPT_N, ++i, args.length);
                props.put("imq.brokerid", args[i]);
                props.put(JMSBRIDGE_NAME_PROPERTY, args[i]);
            } else if (args[i].equals(OPT_U)) {
                this.checkArg(null, OPT_U, ++i, args.length);
                props.put("imq.persist.jdbc.user", args[i]);
            } else if (args[i].equals(OPT_PW)) {
                this.checkArg(null, OPT_PW, ++i, args.length);
                props.put("imq.persist.jdbc.password", args[i]);
                this.cliPasswdSpecified = true;
            } else if (args[i].equals(OPT_PASSFILE)) {
                this.checkArg(null, OPT_PASSFILE, ++i, args.length);
                File passfile = null;
                try {
                    passfile = new File(args[i]).getCanonicalFile();
                }
                catch (Exception e) {
                    this.throwParserException(BAD_OPT, null, null, args[i], null);
                }
                props.put("imq.passfile.enabled", "true");
                props.put("imq.passfile.dirpath", passfile.getParent());
                props.put("imq.passfile.name", passfile.getName());
            } else if (!args[i].equals(OPT_VERBOSE)) {
                if (args[i].equals(OPT_DEBUG)) {
                    this.debugSpecified = true;
                } else if (args[i].equals(OPT_FORCE)) {
                    this.forceSpecified = true;
                } else if (args[i].equals(OPT_VARHOME)) {
                    ++i;
                } else if (args[i].startsWith(OPT_D)) {
                    int value_index = 0;
                    String prop_name = null;
                    String prop_value = "";
                    value_index = args[i].indexOf(61);
                    if (args[i].length() <= 2) continue;
                    if (value_index < 0) {
                        prop_name = args[i].substring(2);
                    } else if (value_index == args[i].length() - 1) {
                        prop_name = args[i].substring(2, value_index);
                    } else {
                        prop_name = args[i].substring(2, value_index);
                        prop_value = args[i].substring(value_index + 1);
                    }
                    props.put(prop_name, prop_value);
                } else {
                    this.throwParserException(BAD_OPT, null, null, args[i], null);
                }
            }
            if (props.getProperty(REMOVE_JMSBRIDGE_CMD) == null || props.getProperty(JMSBRIDGE_NAME_PROPERTY) != null) continue;
            this.checkArg(null, null, OPT_N, 0, 0);
        }
        return props;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parsePassfile() throws IOException {
        String pf_value = null;
        String pf_dir = null;
        String usePassfile = null;
        usePassfile = config.getProperty("imq.passfile.enabled");
        if (usePassfile == null) return;
        if (!usePassfile.equalsIgnoreCase(Boolean.TRUE.toString())) {
            return;
        }
        pf_value = config.getProperty("imq.passfile.dirpath");
        pf_dir = pf_value != null ? (pf_value = StringUtil.expandVariables(pf_value, config)) : config.getProperty("imq.etchome") + File.separator + "security";
        String passfile_location = pf_dir + File.separator + config.getProperty("imq.passfile.name");
        File pf = new File(passfile_location);
        if (!pf.exists()) throw new FileNotFoundException(br.getKString("B3020", passfile_location));
        Properties props = new Properties();
        try {
            PassfileObfuscatorImpl po = new PassfileObfuscatorImpl();
            InputStream fis = po.retrieveObfuscatedFile(passfile_location, "imq");
            props.load(fis);
            if (!po.isObfuscated(passfile_location, "imq")) {
                logger.log(16, Globals.getBrokerResources().getKString("B2287", passfile_location, "'imqusermgr encode'"));
            }
        }
        catch (IOException e) {
            String emsg = Globals.getBrokerResources().getKString("B4023", passfile_location);
            throw new IOException(emsg, e);
        }
        config.putAll((Map)props);
    }

    private void exit(int status) {
        if (this.standalone) {
            System.exit(status);
        }
    }

    void doCommand(String[] args) throws SQLException, BrokerException, IOException {
        String arg;
        Object[] msgArgs;
        String url;
        String pwd;
        String configName;
        if (args.length == 0) {
            System.out.println(this.version.getBanner(true));
            System.out.println(br.getString("B0011"));
            this.exit(0);
        }
        if (this.printHelp(args)) {
            System.out.println(br.getString("B0011"));
            this.exit(0);
        }
        if (this.printVersion(args)) {
            System.out.println(this.version.getBanner(true));
            System.out.println(br.getString("B1003") + System.getProperty("java.version") + " " + System.getProperty("java.vendor") + " " + System.getProperty("java.home"));
            System.out.println(br.getString("B1054") + System.getProperty("java.class.path"));
            this.exit(0);
        }
        Properties props = null;
        try {
            props = this.parseArgs(args);
        }
        catch (ParserException e) {
            this.handleParserException(e);
            this.exit(1);
        }
        props.getProperty("imq.persist.jdbc.connection.limit", "2");
        if (this.cliPasswdSpecified) {
            System.err.println(br.getString("B2088", OPT_PW));
            System.err.println("");
        }
        if ((configName = props.getProperty("imq.instancename")) != null && configName.length() > 0) {
            Globals.pathinit(null);
            String topname = Globals.getJMQ_INSTANCES_HOME() + File.separator + configName;
            if (!new File(topname).exists()) {
                System.err.println(br.getString("B3119", configName));
                System.exit(1);
            }
        }
        Globals.init(props, false, false);
        config = Globals.getConfig();
        logger = Globals.getLogger();
        this.parsePassfile();
        String dbVendor = config.getProperty("imq.persist.jdbc.dbVendor");
        String vendorPropPrefix = "imq.persist.jdbc." + dbVendor;
        String user = props.getProperty("imq.persist.jdbc.user");
        if (user != null && user.length() > 0) {
            config.put(vendorPropPrefix + ".user", user);
        }
        if ((pwd = props.getProperty("imq.persist.jdbc.password")) != null && pwd.length() > 0) {
            config.put(vendorPropPrefix + ".password", pwd);
        }
        String cmd = props.getProperty(CMD_NAME);
        CommDBManager mgr = null;
        if (DELETE_SHARECCTBL_CMD.equals(cmd) || RECREATE_SHARECCTBL_CMD.equals(cmd) || CREATE_SHARECCTBL_CMD.equals(cmd) || DUMP_SHARECCTBL_CMD.equals(cmd) || BACKUP_SHARECCTBL_CMD.equals(cmd) || RESTORE_SHARECCTBL_CMD.equals(cmd)) {
            if (this.debugSpecified) {
                System.out.println("cmd=" + cmd + ", use sharecc");
            }
            if (!Globals.useSharedConfigRecord()) {
                if (Globals.getHAEnabled()) {
                    logger.logToAll(32, br.getKString("B3260"));
                } else {
                    logger.logToAll(32, br.getKString("B3259", "imq.cluster.nomasterbroker"));
                }
                this.exit(1);
            }
            mgr = ShareConfigChangeDBManager.getDBManager();
        } else {
            this.dbmgr = DBManager.getDBManager();
            mgr = this.dbmgr;
        }
        String brokerid = null;
        if (mgr instanceof DBManager) {
            brokerid = ((DBManager)mgr).getBrokerID();
        }
        if ((url = CREATE_ALL_CMD.equals(cmd) ? mgr.getCreateDBURL() : mgr.getOpenDBURL()) == null) {
            url = "not specified";
        }
        if ((user = mgr.getUser()) == null) {
            user = "not specified";
        }
        if (!(mgr instanceof ShareConfigChangeDBManager)) {
            msgArgs = new String[]{String.valueOf(410), brokerid, url, user};
            logger.logToAll(8, br.getString("B1067", msgArgs));
        } else {
            msgArgs = new String[]{"", String.valueOf("50"), Globals.getClusterID(), url, user};
            logger.logToAll(8, br.getKString("B1351", msgArgs));
        }
        if (this.debugSpecified) {
            System.out.println("cmd=" + cmd);
        }
        if (CREATE_ALL_CMD.equals(cmd)) {
            this.doCreate(true);
        } else if (CREATE_TBL_CMD.equals(cmd)) {
            this.doCreate(false);
        } else if (CREATE_SHARECCTBL_CMD.equals(cmd)) {
            this.doCreate(false, ShareConfigChangeDBManager.getDBManager());
        } else if (DELETE_TBL_CMD.equals(cmd)) {
            this.doDelete(props.getProperty(ARG_NAME), null, null);
        } else if (DELETE_SHARECCTBL_CMD.equals(cmd)) {
            this.doDelete(props.getProperty(ARG_NAME), ShareConfigChangeDBManager.getDBManager(), null);
        } else if (RECREATE_TBL_CMD.equals(cmd)) {
            this.doRecreate();
        } else if (RECREATE_SHARECCTBL_CMD.equals(cmd)) {
            this.doRecreate(ShareConfigChangeDBManager.getDBManager());
        } else if (REMOVE_BKR_CMD.equals(cmd)) {
            this.doRemoveBkr();
        } else if (REMOVE_JMSBRIDGE_CMD.equals(cmd)) {
            this.doRemoveJMSBridge(props.getProperty(JMSBRIDGE_NAME_PROPERTY));
        } else if (DUMP_CMD.equals(cmd)) {
            arg = props.getProperty(ARG_NAME);
            this.doDump(arg, null);
        } else if (DUMP_SHARECCTBL_CMD.equals(cmd)) {
            this.doDump(null, ShareConfigChangeDBManager.getDBManager());
        } else if (DROPTBL_CMD.equals(cmd)) {
            arg = props.getProperty(ARG_NAME);
            this.doDropTablesByPattern(arg);
        } else if (RESET_CMD.equals(cmd)) {
            this.doReset();
        } else if (BACKUP_CMD.equals(cmd)) {
            this.doBackup();
        } else if (BACKUP_SHARECCTBL_CMD.equals(cmd)) {
            this.doBackupSharecc();
        } else if (RESTORE_CMD.equals(cmd)) {
            this.doRestore();
        } else if (RESTORE_SHARECCTBL_CMD.equals(cmd)) {
            this.doRestoreSharecc();
        } else if (UPGRADE_STORE_CMD.equals(cmd)) {
            this.doUpgrade(false);
        } else if (UPGRADE_HASTORE_CMD.equals(cmd)) {
            this.doUpgrade(true);
        } else if (QUERY_CMD.equals(cmd)) {
            this.doQuery();
        } else if (cmd == null) {
            System.out.println(br.getString("B3105"));
        } else {
            System.out.println(br.getString("B3104", cmd));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        int exitCode = 0;
        DBTool tool = new DBTool(true);
        try {
            tool.doCommand(args);
        }
        catch (Exception e) {
            Globals.getLogger().logStack(32, e.getMessage(), e);
            if (tool.debugSpecified) {
                e.printStackTrace();
            }
            exitCode = 1;
        }
        finally {
            if (tool.dbmgr != null) {
                tool.dbmgr.close();
            }
        }
        System.exit(exitCode);
    }

    private static class ParserException
    extends Exception {
        private static final long serialVersionUID = 2797707625946445308L;
        String cmd;
        String cmdarg;
        String opt;
        String optarg;
        int reason;

        ParserException(int reason) {
            this(reason, null);
        }

        ParserException(int reason, Throwable cause) {
            super(cause);
            this.reason = reason;
        }
    }

    private static class DeleteStatus {
        boolean deleted = false;

        private DeleteStatus() {
        }
    }
}

