/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq.group;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.service.Service;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQIPConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.group.MapEntry;
import com.sun.messaging.jmq.jmsserver.service.imq.group.SelectThread;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.io.EOFException;
import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;

class ReadThread
extends SelectThread {
    int selector_cnt = 0;

    public ReadThread(Service svc, MapEntry entry) throws IOException {
        super(svc, entry);
        this.type = "read";
        this.INITIAL_KEY = 1;
        this.POSSIBLE_MASK = 1;
    }

    @Override
    public Hashtable getDebugState() {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        ht.put("TYPE", "ReadThread");
        ht.put("selector_cnt", this.selector_cnt);
        return ht;
    }

    @Override
    protected void wakeup() {
        Selector s = this.selector;
        if (s != null) {
            s.wakeup();
        }
    }

    @Override
    protected void process() throws IOException {
        Selector s = this.selector;
        if (s == null) {
            throw new IOException("connection gone");
        }
        int cnt = 0;
        try {
            cnt = s.select(this.TIMEOUT);
        }
        catch (CancelledKeyException ex) {
            return;
        }
        if (cnt > 0) {
            Set<SelectionKey> keys = s.selectedKeys();
            Iterator<SelectionKey> keyitr = keys.iterator();
            while (keyitr.hasNext()) {
                SelectionKey key = keyitr.next();
                IMQIPConnection con = (IMQIPConnection)key.attachment();
                try {
                    con.readData();
                    keyitr.remove();
                }
                catch (BrokerException ex) {
                    this.removeConnection(con, ex.getMessage());
                    keyitr.remove();
                }
                catch (IOException ex) {
                    String reason = con.getDestroyReason() == null ? (ex instanceof EOFException ? Globals.getBrokerResources().getKString("B0061") : ex.toString()) : con.getDestroyReason();
                    this.removeConnection(con, reason);
                    keyitr.remove();
                }
            }
        }
    }
}

