/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.console;

import com.sun.messaging.jmq.admin.apps.console.AdminDialog;
import com.sun.messaging.jmq.admin.apps.console.BrokerCObj;
import com.sun.messaging.jmq.admin.apps.console.util.BytesField;
import com.sun.messaging.jmq.admin.apps.console.util.IntegerField;
import com.sun.messaging.jmq.admin.apps.console.util.LabelValuePanel;
import com.sun.messaging.jmq.admin.apps.console.util.LabelledComponent;
import com.sun.messaging.jmq.admin.apps.console.util.SpecialValueField;
import com.sun.messaging.jmq.admin.apps.console.util.TimeField;
import com.sun.messaging.jmq.admin.bkrutil.BrokerConstants;
import com.sun.messaging.jmq.admin.event.BrokerAdminEvent;
import com.sun.messaging.jmq.admin.resources.AdminConsoleResources;
import com.sun.messaging.jmq.admin.util.Globals;
import com.sun.messaging.jmq.util.SizeString;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Properties;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class BrokerQueryDialog
extends AdminDialog
implements BrokerConstants {
    private static final long serialVersionUID = -6285556648618742064L;
    private static final String UNLIMITED_VALUE_0 = "0";
    private static final String UNLIMITED_VALUE_NEG1 = "-1";
    private static AdminConsoleResources acr = Globals.getAdminConsoleResources();
    private Properties savedBkrProps;
    private JTabbedPane tabbedPane;
    private JLabel versionLbl;
    private JLabel instanceNameLbl;
    private IntegerField portTF;
    private JCheckBox autoCreateTopicCkb;
    private JCheckBox autoCreateQueueCkb;
    private IntegerField activeConsumerIF;
    private LabelledComponent activeConsumerLabelC;
    private SpecialValueField activeConsumerSF;
    private IntegerField failoverConsumerIF;
    private LabelledComponent failoverConsumerLabelC;
    private SpecialValueField failoverConsumerSF;
    private JComboBox logLevelCb;
    private BytesField logRolloverSizeBF;
    private SpecialValueField logRolloverSizeSF;
    private TimeField logRolloverIntervalTF;
    private SpecialValueField logRolloverIntervalSF;
    private IntegerField maxNumMsgsInMemDskTF;
    private SpecialValueField maxNumMsgsInMemDskSF;
    private BytesField maxTtlSizeMsgsInMemDskBF;
    private SpecialValueField maxTtlSizeMsgsInMemDskSF;
    private BytesField maxMsgSizeBF;
    private SpecialValueField maxMsgSizeSF;

    public BrokerQueryDialog(Frame parent) {
        super(parent, acr.getString("A1159"), 81);
        this.setHelpId("broker_configuration");
    }

    @Override
    public void doCancel() {
        this.hide();
    }

    @Override
    public void doOK() {
        Properties bkrProps = new Properties();
        String tmpStr = this.portTF.getText();
        this.setIfNotModified(bkrProps, "imq.portmapper.port", tmpStr);
        tmpStr = this.autoCreateTopicCkb.isSelected() ? "true" : "false";
        this.setIfNotModified(bkrProps, "imq.autocreate.topic", tmpStr);
        tmpStr = this.autoCreateQueueCkb.isSelected() ? "true" : "false";
        this.setIfNotModified(bkrProps, "imq.autocreate.queue", tmpStr);
        tmpStr = this.activeConsumerSF.isSpecialValueSet() ? UNLIMITED_VALUE_NEG1 : this.activeConsumerIF.getText();
        this.setIfNotModified(bkrProps, "imq.autocreate.queue.maxNumActiveConsumers", tmpStr);
        tmpStr = this.failoverConsumerSF.isSpecialValueSet() ? UNLIMITED_VALUE_NEG1 : this.failoverConsumerIF.getText();
        this.setIfNotModified(bkrProps, "imq.autocreate.queue.maxNumBackupConsumers", tmpStr);
        tmpStr = (String)this.logLevelCb.getSelectedItem();
        this.setIfNotModified(bkrProps, ".level", tmpStr);
        tmpStr = this.logRolloverSizeSF.isSpecialValueSet() ? UNLIMITED_VALUE_NEG1 : Long.toString(this.logRolloverSizeBF.getValue());
        this.setIfNotModified(bkrProps, "java.util.logging.FileHandler.limit", tmpStr);
        tmpStr = this.logRolloverIntervalSF.isSpecialValueSet() ? UNLIMITED_VALUE_NEG1 : Long.toString(this.logRolloverIntervalTF.getValue() / 1000L);
        this.setIfNotModified(bkrProps, "imq.log.file.rolloversecs", tmpStr);
        tmpStr = this.maxNumMsgsInMemDskSF.isSpecialValueSet() ? UNLIMITED_VALUE_NEG1 : this.maxNumMsgsInMemDskTF.getText();
        this.setIfNotModified(bkrProps, "imq.system.max_count", tmpStr);
        tmpStr = this.maxTtlSizeMsgsInMemDskSF.isSpecialValueSet() ? UNLIMITED_VALUE_NEG1 : this.maxTtlSizeMsgsInMemDskBF.getSizeString();
        this.setIfNotModified(bkrProps, "imq.system.max_size", tmpStr);
        tmpStr = this.maxMsgSizeSF.isSpecialValueSet() ? UNLIMITED_VALUE_NEG1 : this.maxMsgSizeBF.getSizeString();
        this.setIfNotModified(bkrProps, "imq.message.max_size", tmpStr);
        BrokerAdminEvent bae = new BrokerAdminEvent(this, 4);
        bae.setBrokerProps(bkrProps);
        bae.setOKAction(true);
        this.fireAdminEventDispatched(bae);
    }

    private void setIfNotModified(Properties newProps, String propName, String value) {
        String oldValue = this.savedBkrProps.getProperty(propName, "");
        if (!oldValue.equals(value)) {
            newProps.setProperty(propName, value);
        }
    }

    @Override
    public void doClose() {
    }

    @Override
    public void doApply() {
    }

    @Override
    public void doReset() {
    }

    @Override
    public void doClear() {
    }

    @Override
    public JPanel createWorkPanel() {
        JPanel workPanel = new JPanel();
        this.tabbedPane = new JTabbedPane();
        JPanel tab = this.makeBasicTab();
        this.tabbedPane.addTab(acr.getString("A1454"), tab);
        tab = this.makeLogTab();
        this.tabbedPane.addTab(acr.getString("A1455"), tab);
        tab = this.makeMsgTab();
        this.tabbedPane.addTab(acr.getString("A1456"), tab);
        workPanel.add(this.tabbedPane);
        return workPanel;
    }

    public JPanel makeBasicTab() {
        LabelledComponent tmpLabelC;
        JPanel workPanel = new JPanel();
        GridBagLayout workGridbag = new GridBagLayout();
        workPanel.setLayout(workGridbag);
        GridBagConstraints workConstraints = new GridBagConstraints();
        workConstraints.gridx = 0;
        workConstraints.anchor = 17;
        workConstraints.fill = 0;
        workConstraints.insets = new Insets(5, 0, 5, 0);
        workConstraints.ipadx = 0;
        workConstraints.ipady = 0;
        workConstraints.weightx = 1.0;
        LabelledComponent[] lvpItems = new LabelledComponent[7];
        this.versionLbl = new JLabel();
        lvpItems[0] = tmpLabelC = new LabelledComponent(acr.getString("A1457"), this.versionLbl);
        this.instanceNameLbl = new JLabel();
        lvpItems[1] = tmpLabelC = new LabelledComponent(acr.getString("A1411"), this.instanceNameLbl);
        this.portTF = new IntegerField(0L, Integer.MAX_VALUE, 10);
        lvpItems[2] = tmpLabelC = new LabelledComponent(acr.getString("A1404"), this.portTF);
        this.autoCreateTopicCkb = new JCheckBox();
        lvpItems[3] = tmpLabelC = new LabelledComponent(acr.getString("A1412"), this.autoCreateTopicCkb);
        this.autoCreateQueueCkb = new JCheckBox();
        this.autoCreateQueueCkb.addActionListener(this);
        lvpItems[4] = tmpLabelC = new LabelledComponent(acr.getString("A1413"), this.autoCreateQueueCkb);
        this.activeConsumerIF = new IntegerField(0L, Integer.MAX_VALUE, 10);
        this.activeConsumerSF = new SpecialValueField(this.activeConsumerIF, acr.getString("A1433"));
        lvpItems[5] = this.activeConsumerLabelC = new LabelledComponent(acr.getString("A1461"), (JComponent)this.activeConsumerSF, 0);
        this.failoverConsumerIF = new IntegerField(0L, Integer.MAX_VALUE, 10);
        this.failoverConsumerSF = new SpecialValueField(this.failoverConsumerIF, acr.getString("A1433"));
        lvpItems[6] = this.failoverConsumerLabelC = new LabelledComponent(acr.getString("A1462"), (JComponent)this.failoverConsumerSF, 0);
        LabelValuePanel lvp = new LabelValuePanel(lvpItems, 4, 5);
        workGridbag.setConstraints(lvp, workConstraints);
        workPanel.add(lvp);
        return workPanel;
    }

    public JPanel makeLogTab() {
        LabelledComponent tmpLabelC;
        JPanel workPanel = new JPanel();
        GridBagLayout workGridbag = new GridBagLayout();
        workPanel.setLayout(workGridbag);
        GridBagConstraints workConstraints = new GridBagConstraints();
        workConstraints.gridx = 0;
        workConstraints.anchor = 17;
        workConstraints.fill = 0;
        workConstraints.insets = new Insets(5, 0, 5, 0);
        workConstraints.ipadx = 0;
        workConstraints.ipady = 0;
        workConstraints.weightx = 1.0;
        LabelledComponent[] lvpItems = new LabelledComponent[3];
        this.logLevelCb = new JComboBox<String>(BKR_LOG_LEVEL_VALID_VALUES.toArray(new String[BKR_LOG_LEVEL_VALID_VALUES.size()]));
        lvpItems[0] = tmpLabelC = new LabelledComponent(acr.getString("A1414"), this.logLevelCb);
        this.logRolloverSizeBF = new BytesField(0L, Integer.MAX_VALUE, UNLIMITED_VALUE_0, 10);
        this.logRolloverSizeSF = new SpecialValueField(this.logRolloverSizeBF, acr.getString("A1433"));
        lvpItems[1] = tmpLabelC = new LabelledComponent(acr.getString("A1415"), (JComponent)this.logRolloverSizeSF, 0);
        this.logRolloverIntervalTF = new TimeField(Integer.MAX_VALUE, UNLIMITED_VALUE_0, 10);
        this.logRolloverIntervalSF = new SpecialValueField(this.logRolloverIntervalTF, acr.getString("A1433"));
        lvpItems[2] = tmpLabelC = new LabelledComponent(acr.getString("A1416"), (JComponent)this.logRolloverIntervalSF, 0);
        LabelValuePanel lvp = new LabelValuePanel(lvpItems, 4, 5);
        workGridbag.setConstraints(lvp, workConstraints);
        workPanel.add(lvp);
        return workPanel;
    }

    public JPanel makeMsgTab() {
        LabelledComponent tmpLabelC;
        JPanel workPanel = new JPanel();
        GridBagLayout workGridbag = new GridBagLayout();
        workPanel.setLayout(workGridbag);
        GridBagConstraints workConstraints = new GridBagConstraints();
        workConstraints.gridx = 0;
        workConstraints.anchor = 17;
        workConstraints.fill = 0;
        workConstraints.insets = new Insets(5, 0, 5, 0);
        workConstraints.ipadx = 0;
        workConstraints.ipady = 0;
        workConstraints.weightx = 1.0;
        LabelledComponent[] lvpItems = new LabelledComponent[3];
        this.maxNumMsgsInMemDskTF = new IntegerField(0L, Integer.MAX_VALUE, 10);
        this.maxNumMsgsInMemDskSF = new SpecialValueField(this.maxNumMsgsInMemDskTF, acr.getString("A1433"));
        lvpItems[0] = tmpLabelC = new LabelledComponent(acr.getString("A1420"), (JComponent)this.maxNumMsgsInMemDskSF, 0);
        this.maxTtlSizeMsgsInMemDskBF = new BytesField(0L, Integer.MAX_VALUE, UNLIMITED_VALUE_0, 10);
        this.maxTtlSizeMsgsInMemDskSF = new SpecialValueField(this.maxTtlSizeMsgsInMemDskBF, acr.getString("A1433"));
        lvpItems[1] = tmpLabelC = new LabelledComponent(acr.getString("A1421"), (JComponent)this.maxTtlSizeMsgsInMemDskSF, 0);
        this.maxMsgSizeBF = new BytesField(0L, Integer.MAX_VALUE, UNLIMITED_VALUE_0, 10);
        this.maxMsgSizeSF = new SpecialValueField(this.maxMsgSizeBF, acr.getString("A1433"));
        lvpItems[2] = tmpLabelC = new LabelledComponent(acr.getString("A1422"), (JComponent)this.maxMsgSizeSF, 0);
        LabelValuePanel lvp = new LabelValuePanel(lvpItems, 4, 5);
        workGridbag.setConstraints(lvp, workConstraints);
        workPanel.add(lvp);
        return workPanel;
    }

    public void show(BrokerCObj bkrCObj) {
        this.reset();
        this.setBrokerProps(bkrCObj.getBrokerProps());
        this.tabbedPane.setSelectedIndex(0);
        this.pack();
        super.show();
    }

    private void setBrokerProps(Properties bkrProps) {
        this.savedBkrProps = bkrProps;
        if (bkrProps == null) {
            return;
        }
        String value = bkrProps.getProperty("imq.product.version", "");
        if (value.equals("")) {
            value = acr.getString("A1458");
        }
        this.versionLbl.setText(value);
        value = bkrProps.getProperty("imq.instancename", "");
        this.instanceNameLbl.setText(value);
        value = bkrProps.getProperty("imq.portmapper.port", "");
        this.portTF.setText(value);
        value = bkrProps.getProperty("imq.autocreate.topic", "");
        if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("t")) {
            this.autoCreateTopicCkb.setSelected(true);
        } else if (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("f")) {
            this.autoCreateTopicCkb.setSelected(false);
        }
        value = bkrProps.getProperty("imq.autocreate.queue", "");
        if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("t")) {
            this.autoCreateQueueCkb.setSelected(true);
            this.showQueueDeliveryPolicy();
        } else if (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("f")) {
            this.autoCreateQueueCkb.setSelected(false);
            this.hideQueueDeliveryPolicy();
        }
        value = bkrProps.getProperty("imq.autocreate.queue.maxNumActiveConsumers", "");
        this.activeConsumerIF.setText(UNLIMITED_VALUE_0);
        if (!value.equals(UNLIMITED_VALUE_NEG1)) {
            this.activeConsumerIF.setText(value);
        }
        this.checkUnlimitedNeg1(this.activeConsumerSF, value);
        value = bkrProps.getProperty("imq.autocreate.queue.maxNumBackupConsumers", "");
        this.failoverConsumerIF.setText(UNLIMITED_VALUE_0);
        if (!value.equals(UNLIMITED_VALUE_NEG1)) {
            this.failoverConsumerIF.setText(value);
        }
        this.checkUnlimitedNeg1(this.failoverConsumerSF, value);
        value = bkrProps.getProperty(".level", "");
        this.logLevelCb.setSelectedItem(value);
        value = bkrProps.getProperty("java.util.logging.FileHandler.limit", "");
        if (!value.equals(UNLIMITED_VALUE_NEG1) && !value.equals(UNLIMITED_VALUE_0)) {
            this.logRolloverSizeBF.setSizeString(value);
        }
        this.checkBothUnlimited(this.logRolloverSizeSF, value);
        value = bkrProps.getProperty("imq.log.file.rolloversecs", "");
        if (!value.equals(UNLIMITED_VALUE_NEG1) && !value.equals(UNLIMITED_VALUE_0)) {
            this.logRolloverIntervalTF.setText(value);
        }
        this.checkBothUnlimited(this.logRolloverIntervalSF, value);
        value = bkrProps.getProperty("imq.system.max_count", "");
        if (!value.equals(UNLIMITED_VALUE_NEG1) && !value.equals(UNLIMITED_VALUE_0)) {
            this.maxNumMsgsInMemDskTF.setText(value);
        }
        this.checkBothUnlimited(this.maxNumMsgsInMemDskSF, value);
        value = bkrProps.getProperty("imq.system.max_size", "");
        if (!value.equals(UNLIMITED_VALUE_NEG1) && !value.equals(UNLIMITED_VALUE_0)) {
            this.maxTtlSizeMsgsInMemDskBF.setSizeString(value);
        }
        this.checkBothUnlimited(this.maxTtlSizeMsgsInMemDskSF, value);
        value = bkrProps.getProperty("imq.message.max_size", "");
        if (!value.equals(UNLIMITED_VALUE_NEG1) && !value.equals(UNLIMITED_VALUE_0)) {
            this.maxMsgSizeBF.setSizeString(value);
        }
        this.checkBothUnlimited(this.maxMsgSizeSF, value);
    }

    private boolean valueIsUnlimited0(String val) {
        SizeString ss;
        try {
            ss = new SizeString(val);
        }
        catch (Exception e) {
            return false;
        }
        return ss.getBytes() == 0L;
    }

    private void checkUnlimitedNeg1(SpecialValueField sf, String val) {
        if (this.valueIsUnlimitedNeg1(val)) {
            sf.setSpecialValueSet(true);
        } else {
            sf.setSpecialValueSet(false);
        }
    }

    private boolean valueIsUnlimitedNeg1(String val) {
        return val.equals(UNLIMITED_VALUE_NEG1);
    }

    private void checkBothUnlimited(SpecialValueField sf, String val) {
        if (this.valueIsUnlimited0(val) || this.valueIsUnlimitedNeg1(val)) {
            sf.setSpecialValueSet(true);
        } else {
            sf.setSpecialValueSet(false);
        }
    }

    private void reset() {
        this.instanceNameLbl.setText("");
        this.portTF.setText("");
        this.autoCreateTopicCkb.setSelected(true);
        this.autoCreateQueueCkb.setSelected(true);
        this.logLevelCb.setSelectedItem("INFO");
        this.logRolloverSizeBF.setText(UNLIMITED_VALUE_0);
        this.logRolloverSizeBF.setUnit(0);
        this.logRolloverIntervalTF.setText("");
        this.logRolloverIntervalTF.setUnit(1);
        this.maxNumMsgsInMemDskTF.setText("");
        this.maxTtlSizeMsgsInMemDskBF.setText(UNLIMITED_VALUE_0);
        this.maxTtlSizeMsgsInMemDskBF.setUnit(0);
        this.maxMsgSizeBF.setText(UNLIMITED_VALUE_0);
        this.maxMsgSizeBF.setUnit(0);
    }

    private void showQueueDeliveryPolicy() {
        this.activeConsumerLabelC.setEnabled(true);
        this.activeConsumerIF.setEnabled(true);
        this.activeConsumerSF.setEnabled(true);
        this.failoverConsumerLabelC.setEnabled(true);
        this.failoverConsumerIF.setEnabled(true);
        this.failoverConsumerSF.setEnabled(true);
    }

    private void hideQueueDeliveryPolicy() {
        this.activeConsumerLabelC.setEnabled(false);
        this.activeConsumerIF.setEnabled(false);
        this.activeConsumerSF.setEnabled(false);
        this.failoverConsumerLabelC.setEnabled(false);
        this.failoverConsumerIF.setEnabled(false);
        this.failoverConsumerSF.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.autoCreateQueueCkb) {
            if (this.autoCreateQueueCkb.isSelected()) {
                this.showQueueDeliveryPolicy();
            } else {
                this.hideQueueDeliveryPolicy();
            }
        } else {
            super.actionPerformed(e);
        }
    }
}

