/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.console;

import com.sun.messaging.ConnectionFactory;
import com.sun.messaging.InvalidPropertyException;
import com.sun.messaging.InvalidPropertyValueException;
import com.sun.messaging.Queue;
import com.sun.messaging.QueueConnectionFactory;
import com.sun.messaging.Topic;
import com.sun.messaging.TopicConnectionFactory;
import com.sun.messaging.XAConnectionFactory;
import com.sun.messaging.XAQueueConnectionFactory;
import com.sun.messaging.XATopicConnectionFactory;
import com.sun.messaging.jmq.admin.apps.console.AController;
import com.sun.messaging.jmq.admin.apps.console.AdminApp;
import com.sun.messaging.jmq.admin.apps.console.ConsoleObj;
import com.sun.messaging.jmq.admin.apps.console.ConsoleObjStoreManager;
import com.sun.messaging.jmq.admin.apps.console.ObjStoreAddDialog;
import com.sun.messaging.jmq.admin.apps.console.ObjStoreCObj;
import com.sun.messaging.jmq.admin.apps.console.ObjStoreConFactoryAddDialog;
import com.sun.messaging.jmq.admin.apps.console.ObjStoreConFactoryCObj;
import com.sun.messaging.jmq.admin.apps.console.ObjStoreConFactoryListCObj;
import com.sun.messaging.jmq.admin.apps.console.ObjStoreConFactoryPropsDialog;
import com.sun.messaging.jmq.admin.apps.console.ObjStoreDestAddDialog;
import com.sun.messaging.jmq.admin.apps.console.ObjStoreDestCObj;
import com.sun.messaging.jmq.admin.apps.console.ObjStoreDestListCObj;
import com.sun.messaging.jmq.admin.apps.console.ObjStoreDestPropsDialog;
import com.sun.messaging.jmq.admin.apps.console.ObjStoreListCObj;
import com.sun.messaging.jmq.admin.apps.console.ObjStorePasswdDialog;
import com.sun.messaging.jmq.admin.apps.console.ObjStorePropsDialog;
import com.sun.messaging.jmq.admin.apps.console.event.ConsoleActionEvent;
import com.sun.messaging.jmq.admin.apps.console.event.DialogEvent;
import com.sun.messaging.jmq.admin.apps.console.event.ObjAdminEvent;
import com.sun.messaging.jmq.admin.event.AdminEvent;
import com.sun.messaging.jmq.admin.event.AdminEventListener;
import com.sun.messaging.jmq.admin.objstore.AuthenticationException;
import com.sun.messaging.jmq.admin.objstore.NameAlreadyExistsException;
import com.sun.messaging.jmq.admin.objstore.NameNotFoundException;
import com.sun.messaging.jmq.admin.objstore.ObjStore;
import com.sun.messaging.jmq.admin.objstore.ObjStoreAttrs;
import com.sun.messaging.jmq.admin.objstore.ObjStoreException;
import com.sun.messaging.jmq.admin.objstore.ObjStoreManager;
import com.sun.messaging.jmq.admin.resources.AdminConsoleResources;
import com.sun.messaging.jmq.admin.util.Globals;
import com.sun.messaging.jmq.admin.util.JMSObjFactory;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.naming.NameClassPair;
import javax.swing.JOptionPane;
import javax.swing.tree.TreeNode;

public class ObjAdminHandler
implements AdminEventListener {
    private static String OBJSTORELIST_FILENAME = "objstorelist.properties";
    private static AdminConsoleResources acr = Globals.getAdminConsoleResources();
    private static String[] close;
    private AdminApp app;
    private AController controller;
    private ObjStoreAddDialog objStoreAddDialog = null;
    private ObjStorePropsDialog objStorePropsDialog = null;
    private ObjStorePasswdDialog objStorePasswdDialog = null;
    private ObjStoreDestAddDialog objStoreDestAddDialog = null;
    private ObjStoreDestPropsDialog objStoreDestPropsDialog = null;
    private ObjStoreConFactoryAddDialog objStoreConFactoryAddDialog = null;
    private ObjStoreConFactoryPropsDialog objStoreConFactoryPropsDialog = null;

    public ObjAdminHandler(AdminApp app, AController controller) {
        this.app = app;
        this.controller = controller;
    }

    public void init() {
        this.loadObjStoreList();
    }

    @Override
    public void adminEventDispatched(AdminEvent e) {
        if (e instanceof DialogEvent) {
            this.handleDialogEvents((DialogEvent)e);
        } else if (e instanceof ObjAdminEvent) {
            this.handleObjAdminEvents((ObjAdminEvent)e);
        }
    }

    public void handleDialogEvents(DialogEvent de) {
        ConsoleObj selObj = this.app.getSelectedObj();
        int dialogType = de.getDialogType();
        switch (dialogType) {
            case 0: {
                ObjStore os;
                if (selObj instanceof ObjStoreListCObj) {
                    if (this.objStoreAddDialog == null) {
                        this.objStoreAddDialog = new ObjStoreAddDialog(this.app.getFrame(), (ObjStoreListCObj)selObj);
                        this.objStoreAddDialog.addAdminEventListener(this);
                        this.objStoreAddDialog.setLocationRelativeTo(this.app.getFrame());
                    }
                    this.objStoreAddDialog.show();
                    break;
                }
                if (selObj instanceof ObjStoreDestListCObj) {
                    ObjStore os2;
                    if (this.objStoreDestAddDialog == null) {
                        this.objStoreDestAddDialog = new ObjStoreDestAddDialog(this.app.getFrame());
                        this.objStoreDestAddDialog.addAdminEventListener(this);
                        this.objStoreDestAddDialog.setLocationRelativeTo(this.app.getFrame());
                    }
                    if (!(os2 = ((ObjStoreDestListCObj)selObj).getObjStore()).isOpen()) {
                        JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3006", os2.getID()), acr.getString("A1129") + ": " + acr.getString("A1218", "A3006"), 0, 0, null, close, close[0]);
                    }
                    this.objStoreDestAddDialog.show((ObjStoreDestListCObj)selObj);
                    break;
                }
                if (!(selObj instanceof ObjStoreConFactoryListCObj)) break;
                if (this.objStoreConFactoryAddDialog == null) {
                    this.objStoreConFactoryAddDialog = new ObjStoreConFactoryAddDialog(this.app.getFrame());
                    this.objStoreConFactoryAddDialog.addAdminEventListener(this);
                    this.objStoreConFactoryAddDialog.setLocationRelativeTo(this.app.getFrame());
                }
                if (!(os = ((ObjStoreConFactoryListCObj)selObj).getObjStore()).isOpen()) {
                    JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3006", os.getID()), acr.getString("A1130") + ": " + acr.getString("A1218", "A3006"), 0, 0, null, close, close[0]);
                    return;
                }
                this.objStoreConFactoryAddDialog.show((ObjStoreConFactoryListCObj)selObj);
                break;
            }
            case 1: {
                if (selObj instanceof ObjStoreCObj) {
                    this.doDeleteObjStore(selObj);
                    break;
                }
                if (selObj instanceof ObjStoreDestCObj) {
                    this.doDeleteDestination(selObj);
                    break;
                }
                if (!(selObj instanceof ObjStoreConFactoryCObj)) break;
                this.doDeleteConnFactory(selObj);
                break;
            }
            case 3: {
                ObjStore os;
                if (selObj instanceof ObjStoreCObj) {
                    if (this.objStorePropsDialog == null) {
                        ObjStoreCObj osCObj = (ObjStoreCObj)selObj;
                        ObjStoreListCObj oslCObj = (ObjStoreListCObj)osCObj.getParent();
                        this.objStorePropsDialog = new ObjStorePropsDialog(this.app.getFrame(), oslCObj);
                        this.objStorePropsDialog.addAdminEventListener(this);
                        this.objStorePropsDialog.setLocationRelativeTo(this.app.getFrame());
                    }
                    this.objStorePropsDialog.show((ObjStoreCObj)selObj);
                    break;
                }
                if (selObj instanceof ObjStoreDestCObj) {
                    ObjStore os3;
                    if (this.objStoreDestPropsDialog == null) {
                        this.objStoreDestPropsDialog = new ObjStoreDestPropsDialog(this.app.getFrame());
                        this.objStoreDestPropsDialog.addAdminEventListener(this);
                        this.objStoreDestPropsDialog.setLocationRelativeTo(this.app.getFrame());
                    }
                    if (!(os3 = ((ObjStoreDestCObj)selObj).getObjStore()).isOpen()) {
                        JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3006", os3.getID()), acr.getString("A1300") + ": " + acr.getString("A1218", "A3006"), 0, 0, null, close, close[0]);
                        return;
                    }
                    this.objStoreDestPropsDialog.show((ObjStoreDestCObj)selObj);
                    break;
                }
                if (!(selObj instanceof ObjStoreConFactoryCObj)) break;
                if (this.objStoreConFactoryPropsDialog == null) {
                    this.objStoreConFactoryPropsDialog = new ObjStoreConFactoryPropsDialog(this.app.getFrame());
                    this.objStoreConFactoryPropsDialog.addAdminEventListener(this);
                    this.objStoreConFactoryPropsDialog.setLocationRelativeTo(this.app.getFrame());
                }
                if (!(os = ((ObjStoreConFactoryCObj)selObj).getObjStore()).isOpen()) {
                    JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3006", os.getID()), acr.getString("A1301") + ": " + acr.getString("A1218", "A3006"), 0, 0, null, close, close[0]);
                    return;
                }
                this.objStoreConFactoryPropsDialog.show((ObjStoreConFactoryCObj)selObj);
                break;
            }
            case 8: {
                if (!(selObj instanceof ObjStoreCObj)) break;
                this.doConnectObjStore(selObj);
                break;
            }
            case 9: {
                if (!(selObj instanceof ObjStoreCObj)) break;
                this.doDisconnectObjStore(selObj);
                break;
            }
            case 10: {
                JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A1222"), acr.getString("A1223"), 0, 1, null, close, close[0]);
                break;
            }
        }
    }

    public void handleObjAdminEvents(ObjAdminEvent oae) {
        ConsoleObj selObj = this.app.getSelectedObj();
        int type = oae.getType();
        switch (type) {
            case 1: {
                this.doAddObjStore(oae);
                break;
            }
            case 2: {
                this.doUpdateObjStore(oae, selObj);
                break;
            }
            case 4: {
                this.doAddDestination(oae, selObj);
                break;
            }
            case 5: {
                this.doUpdateDestination(oae, selObj);
                break;
            }
            case 6: {
                this.doAddConnFactory(oae, selObj);
                break;
            }
            case 7: {
                this.doUpdateConnFactory(oae, selObj);
                break;
            }
            case 8: {
                this.doUpdateCredentials(oae, selObj);
            }
        }
    }

    private void doAddObjStore(ObjAdminEvent oae) {
        ObjStoreAttrs osa = oae.getObjStoreAttrs();
        ObjStoreManager osMgr = this.app.getObjStoreListCObj().getObjStoreManager();
        boolean connect = oae.isConnectAttempt();
        ObjStoreCObj osCObj = null;
        ObjStore os = this.createStore(osMgr, osa, connect);
        if (os != null) {
            osCObj = new ObjStoreCObj(os);
            if (os.isOpen()) {
                this.readObjStore(osCObj, os);
            }
        }
        if (osCObj != null) {
            this.app.getExplorer().addObjStore(osCObj);
            this.app.getInspector().refresh();
            this.app.getStatusArea().appendText(acr.getString("A6000", osCObj.toString()));
        }
        if (oae.isOKAction() && os != null) {
            this.objStoreAddDialog.hide();
        }
        this.saveObjStoreList();
    }

    private void doUpdateObjStore(ObjAdminEvent oae, ConsoleObj selObj) {
        String newName;
        ObjStoreAttrs osa = oae.getObjStoreAttrs();
        ObjStoreManager osMgr = this.app.getObjStoreListCObj().getObjStoreManager();
        boolean connect = oae.isConnectAttempt();
        ObjStore prevOs = ((ObjStoreCObj)selObj).getObjStore();
        ObjStore os = this.updateStore(prevOs, newName = oae.getObjStoreID(), osMgr, osa, connect);
        if (os == null) {
            return;
        }
        if (os.isOpen()) {
            this.readObjStore(selObj, os);
        }
        ((ObjStoreCObj)selObj).setObjStore(os);
        ObjStoreDestListCObj destListCObj = (ObjStoreDestListCObj)selObj.getChildAt(0);
        ObjStoreConFactoryListCObj cfListCObj = (ObjStoreConFactoryListCObj)selObj.getChildAt(1);
        destListCObj.setObjStore(os);
        cfListCObj.setObjStore(os);
        this.app.getExplorer().nodeChanged(selObj);
        this.app.getStatusArea().appendText(acr.getString("A6001", selObj.toString()));
        this.app.getInspector().selectedObjectUpdated();
        this.controller.setActions(selObj);
        if (!connect) {
            this.clearStore(selObj);
        }
        if (oae.isOKAction() && os != null) {
            this.objStorePropsDialog.hide();
        }
        this.saveObjStoreList();
    }

    private boolean readObjStore(ConsoleObj osCObj, ObjStore os) {
        ConsoleObj node;
        Vector v = null;
        try {
            v = os.list();
        }
        catch (Exception e) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3007", os.getID(), e.toString()), acr.getString("A1088") + ": " + acr.getString("A1218", "A3007"), 0, 0, null, close, close[0]);
            try {
                os.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        ObjStoreDestListCObj destListCObj = (ObjStoreDestListCObj)osCObj.getChildAt(0);
        ObjStoreConFactoryListCObj cfListCObj = (ObjStoreConFactoryListCObj)osCObj.getChildAt(1);
        Enumeration<TreeNode> e = destListCObj.children();
        while (e.hasMoreElements()) {
            node = (ConsoleObj)e.nextElement();
            this.app.getExplorer().removeFromParent(node);
            e = destListCObj.children();
        }
        e = cfListCObj.children();
        while (e.hasMoreElements()) {
            node = (ConsoleObj)e.nextElement();
            this.app.getExplorer().removeFromParent(node);
            e = cfListCObj.children();
        }
        for (int i = 0; i < v.size(); ++i) {
            NameClassPair obj = (NameClassPair)v.get(i);
            String lookupName = obj.getName();
            Object object = null;
            try {
                object = os.retrieve(lookupName);
            }
            catch (Exception e2) {
                JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3037", lookupName, os.getID()), acr.getString("A1088") + ": " + acr.getString("A1218", "A3037"), 0, 0, null, close, close[0]);
                continue;
            }
            if (Topic.class.getName().equals(obj.getClassName()) || Queue.class.getName().equals(obj.getClassName())) {
                ObjStoreDestCObj destCObj = new ObjStoreDestCObj((ObjStoreCObj)osCObj, lookupName, object);
                this.app.getExplorer().addToParent(destListCObj, destCObj);
                continue;
            }
            if (!TopicConnectionFactory.class.getName().equals(obj.getClassName()) && !QueueConnectionFactory.class.getName().equals(obj.getClassName()) && !ConnectionFactory.class.getName().equals(obj.getClassName()) && !XATopicConnectionFactory.class.getName().equals(obj.getClassName()) && !XAQueueConnectionFactory.class.getName().equals(obj.getClassName()) && !XAConnectionFactory.class.getName().equals(obj.getClassName())) continue;
            ObjStoreConFactoryCObj cfCObj = new ObjStoreConFactoryCObj((ObjStoreCObj)osCObj, lookupName, object);
            this.app.getExplorer().addToParent(cfListCObj, cfCObj);
        }
        return true;
    }

    private void clearStore(ConsoleObj osCObj) {
        ConsoleObj node;
        ObjStoreDestListCObj destListCObj = (ObjStoreDestListCObj)osCObj.getChildAt(0);
        ObjStoreConFactoryListCObj cfListCObj = (ObjStoreConFactoryListCObj)osCObj.getChildAt(1);
        Enumeration<TreeNode> e = destListCObj.children();
        while (e.hasMoreElements()) {
            node = (ConsoleObj)e.nextElement();
            this.app.getExplorer().removeFromParent(node);
            e = destListCObj.children();
        }
        e = cfListCObj.children();
        while (e.hasMoreElements()) {
            node = (ConsoleObj)e.nextElement();
            this.app.getExplorer().removeFromParent(node);
            e = cfListCObj.children();
        }
    }

    private ObjStore createStore(ObjStoreManager osMgr, ObjStoreAttrs osa, boolean attemptToConnect) {
        ObjStore os = null;
        if (osMgr == null || osa == null) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3023"), acr.getString("A1088") + ": " + acr.getString("A1218", "A3023"), 0, 0, null, close, close[0]);
            return null;
        }
        try {
            os = osMgr.createStore(osa);
        }
        catch (Exception ex) {
            JOptionPane.showOptionDialog(this.app.getFrame(), ex.toString(), acr.getString("A1088"), 0, 0, null, close, close[0]);
            return null;
        }
        if (attemptToConnect) {
            try {
                if (os != null) {
                    os.open();
                }
            }
            catch (Exception e) {
                JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3008", e.toString()), acr.getString("A1088") + ": " + acr.getString("A1218", "A3008"), 0, 0, null, close, close[0]);
                os = null;
                try {
                    osMgr.destroyStore(osa.getID());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return os;
    }

    private ObjStore updateStore(ObjStore prevOs, String newName, ObjStoreManager osMgr, ObjStoreAttrs osa, boolean attemptToConnect) {
        ObjStore os = null;
        boolean created = false;
        if (osMgr == null || osa == null) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3023"), acr.getString("A1088") + ": " + acr.getString("A1218", "A3023"), 0, 0, null, close, close[0]);
            return null;
        }
        ObjStoreAttrs prevAttrs = prevOs.getObjStoreAttrs();
        os = osMgr.getStore(prevOs.getID());
        if (os == null) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3023"), acr.getString("A1088") + ": " + acr.getString("A1218", "A3023"), 0, 0, null, close, close[0]);
        }
        try {
            if (newName != null && os != null && !newName.equals(os.getID())) {
                os = osMgr.createStore(osa);
                created = true;
            } else if (os != null) {
                os.setObjStoreAttrs(osa);
            }
        }
        catch (Exception ex) {
            JOptionPane.showOptionDialog(this.app.getFrame(), ex.toString(), acr.getString("A1309"), 0, 0, null, close, close[0]);
            return null;
        }
        if (attemptToConnect) {
            try {
                if (os != null) {
                    os.open();
                }
            }
            catch (Exception e) {
                JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3008", e.toString()), acr.getString("A1309") + ": " + acr.getString("A1218", "A3008"), 0, 0, null, close, close[0]);
                try {
                    if (created) {
                        osMgr.destroyStore(osa.getID());
                    } else {
                        os.setObjStoreAttrs(prevAttrs);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
        }
        if (os != null && created) {
            try {
                if (prevOs.isOpen()) {
                    prevOs.close();
                }
                osMgr.destroyStore(prevOs.getID());
                if (!attemptToConnect && os.isOpen()) {
                    os.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (os != null && !attemptToConnect && os.isOpen()) {
            try {
                os.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return os;
    }

    private void doConnectObjStore(ConsoleObj selObj) {
        ObjStore os = ((ObjStoreCObj)selObj).getObjStore();
        if (os.isOpen()) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3009", selObj.toString()), acr.getString("A1140") + ": " + acr.getString("A1218", "A3009"), 0, 0, null, close, close[0]);
            return;
        }
        ObjStoreAttrs osa = os.getObjStoreAttrs();
        Vector missingAuthInfo = os.checkAuthentication(osa);
        int missingAuthInfoSize = missingAuthInfo.size();
        if (missingAuthInfo != null && missingAuthInfoSize > 0) {
            if (this.objStorePasswdDialog == null && missingAuthInfoSize > 0) {
                this.objStorePasswdDialog = new ObjStorePasswdDialog(this.app.getFrame());
                this.objStorePasswdDialog.addAdminEventListener(this);
                this.objStorePasswdDialog.setLocationRelativeTo(this.app.getFrame());
            }
            if (missingAuthInfoSize > 0) {
                this.objStorePasswdDialog.show(os, missingAuthInfo);
            }
        } else {
            boolean success = this.finishDoConnectObjStore(selObj, os);
            if (success) {
                this.app.getStatusArea().appendText(acr.getString("A6002", selObj.toString()));
            }
        }
    }

    private boolean finishDoConnectObjStore(ConsoleObj selObj, ObjStore os) {
        try {
            os.open();
        }
        catch (AuthenticationException ae) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3024"), acr.getString("A1140") + ": " + acr.getString("A1218", "A3024"), 0, 0, null, close, close[0]);
            this.closeObjStore(os, selObj);
            return false;
        }
        catch (Exception e) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3011", selObj.toString(), e.toString()), acr.getString("A1140") + ": " + acr.getString("A1218", "A3011"), 0, 0, null, close, close[0]);
            this.closeObjStore(os, selObj);
            return false;
        }
        boolean success = this.readObjStore(selObj, os);
        if (success) {
            this.app.getExplorer().nodeChanged(selObj);
            this.app.getInspector().selectedObjectUpdated();
            this.app.getInspector().refresh();
        }
        this.controller.setActions(selObj);
        return true;
    }

    private void doDisconnectObjStore(ConsoleObj selObj) {
        ObjStore os = ((ObjStoreCObj)selObj).getObjStore();
        if (!os.isOpen()) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3010", selObj.toString()), acr.getString("A1143") + ": " + acr.getString("A1218", "A3010"), 0, 0, null, close, close[0]);
            return;
        }
        try {
            if (os != null) {
                os.close();
            }
        }
        catch (Exception e) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3012", selObj.toString()), acr.getString("A1143") + ": " + acr.getString("A1218", "A3012"), 0, 0, null, close, close[0]);
            return;
        }
        this.clearStore(selObj);
        this.app.getExplorer().nodeChanged(selObj);
        this.app.getStatusArea().appendText(acr.getString("A6003", selObj.toString()));
        this.app.getInspector().refresh();
        this.app.getInspector().selectedObjectUpdated();
        this.controller.setActions(selObj);
    }

    private void doDeleteObjStore(ConsoleObj selObj) {
        int result = JOptionPane.showConfirmDialog(this.app.getFrame(), acr.getString("A5000", selObj.toString()), acr.getString("A1134"), 0);
        if (result == 1) {
            return;
        }
        ObjStore os = ((ObjStoreCObj)selObj).getObjStore();
        try {
            os.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        ObjStoreManager osMgr = this.app.getObjStoreListCObj().getObjStoreManager();
        try {
            osMgr.destroyStore(os.getID());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.app.getExplorer().removeFromParent(selObj);
        this.app.getStatusArea().appendText(acr.getString("A6004", os.getID()));
        this.controller.clearSelection();
        this.saveObjStoreList();
    }

    private void doDeleteDestination(ConsoleObj selObj) {
        ObjStore os = ((ObjStoreDestCObj)selObj).getObjStore();
        int result = JOptionPane.showConfirmDialog(this.app.getFrame(), acr.getString("A5001", selObj.toString(), os.getID()), acr.getString("A1135"), 0);
        if (result == 1) {
            return;
        }
        String lookupName = selObj.toString();
        try {
            os.delete(lookupName);
        }
        catch (Exception e) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3013", selObj.toString(), e.toString()), acr.getString("A1135") + ": " + acr.getString("A1218", "A3013"), 0, 0, null, close, close[0]);
            return;
        }
        this.app.getStatusArea().appendText(acr.getString("A6005", selObj.toString(), os.getID()));
        ObjStoreDestListCObj destList = (ObjStoreDestListCObj)selObj.getParent();
        this.app.getExplorer().removeFromParent(selObj);
        this.app.getExplorer().select(destList);
        this.app.getInspector().refresh();
    }

    private void doDeleteConnFactory(ConsoleObj selObj) {
        ObjStore os = ((ObjStoreConFactoryCObj)selObj).getObjStore();
        int result = JOptionPane.showConfirmDialog(this.app.getFrame(), acr.getString("A5003", selObj.toString(), os.getID()), acr.getString("A1136"), 0);
        if (result == 1) {
            return;
        }
        String lookupName = selObj.toString();
        try {
            os.delete(lookupName);
        }
        catch (Exception e) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3017", selObj.toString(), e.toString()), acr.getString("A1136") + ": " + acr.getString("A1218", "A3017"), 0, 0, null, close, close[0]);
            return;
        }
        this.app.getStatusArea().appendText(acr.getString("A6010", selObj.toString(), os.getID()));
        ObjStoreConFactoryListCObj cfList = (ObjStoreConFactoryListCObj)selObj.getParent();
        this.app.getExplorer().removeFromParent(selObj);
        this.app.getExplorer().select(cfList);
        this.app.getInspector().refresh();
    }

    private void doUpdateDestination(ObjAdminEvent oae, ConsoleObj selObj) {
        ObjStore os = oae.getObjStore();
        String lookupName = oae.getLookupName();
        boolean readOnly = oae.isReadOnly();
        Object currentObj = ((ObjStoreDestCObj)selObj).getObject();
        Object updatedObject = this.updateObject(currentObj, oae.getDestinationType(), oae.getObjProperties(), readOnly);
        if (updatedObject == null) {
            return;
        }
        try {
            os.add(lookupName, updatedObject, true);
        }
        catch (NameAlreadyExistsException nameAlreadyExistsException) {
        }
        catch (Exception e) {
            JOptionPane.showOptionDialog(this.app.getFrame(), e.toString(), acr.getString("A1300"), 0, 0, null, close, close[0]);
            return;
        }
        ((ObjStoreDestCObj)selObj).setObject(updatedObject);
        this.app.getStatusArea().appendText(acr.getString("A6006", selObj.toString(), os.getID()));
        this.app.getInspector().selectedObjectUpdated();
        if (oae.isOKAction()) {
            this.objStoreDestPropsDialog.hide();
        }
    }

    private Object updateObject(Object object, int type, Properties objProps, boolean readOnly) {
        Object updatedObject = null;
        String titleId = "A1088";
        String readOnlyValue = null;
        readOnlyValue = readOnly ? "true" : "false";
        try {
            if (type == 1) {
                titleId = "A1300";
                updatedObject = JMSObjFactory.updateQueue(object, objProps, readOnlyValue);
            } else if (type == 2) {
                titleId = "A1300";
                updatedObject = JMSObjFactory.updateTopic(object, objProps, readOnlyValue);
            } else if (type == 3) {
                titleId = "A1301";
                updatedObject = JMSObjFactory.updateQueueConnectionFactory(object, objProps, readOnlyValue);
            } else if (type == 4) {
                titleId = "A1301";
                updatedObject = JMSObjFactory.updateTopicConnectionFactory(object, objProps, readOnlyValue);
            } else if (type == 7) {
                titleId = "A1301";
                updatedObject = JMSObjFactory.updateConnectionFactory(object, objProps, readOnlyValue);
            } else if (type == 5) {
                titleId = "A1301";
                updatedObject = JMSObjFactory.updateXAQueueConnectionFactory(object, objProps, readOnlyValue);
            } else if (type == 6) {
                titleId = "A1301";
                updatedObject = JMSObjFactory.updateXATopicConnectionFactory(object, objProps, readOnlyValue);
            } else if (type == 8) {
                titleId = "A1301";
                updatedObject = JMSObjFactory.updateXAConnectionFactory(object, objProps, readOnlyValue);
            }
        }
        catch (Exception e) {
            this.handleExceptions(e, titleId);
            return null;
        }
        return updatedObject;
    }

    private void doUpdateCredentials(ObjAdminEvent oae, ConsoleObj selObj) {
        ObjStore os = oae.getObjStore();
        boolean success = this.finishDoConnectObjStore(selObj, os);
        if (success) {
            this.app.getStatusArea().appendText(acr.getString("A6002", selObj.toString()));
        }
        ObjStoreAttrs osa = oae.getObjStoreAttrs();
        Vector missingInfo = oae.getMissingAuthInfo();
        for (int i = 0; i < missingInfo.size(); ++i) {
            String key = (String)missingInfo.elementAt(i);
            osa.remove(key);
        }
        try {
            os.setObjStoreAttrs(osa);
        }
        catch (ObjStoreException ose) {
            JOptionPane.showOptionDialog(this.app.getFrame(), ose.toString(), acr.getString("A1088"), 0, 0, null, close, close[0]);
        }
        if (success && oae.isOKAction()) {
            this.objStorePasswdDialog.hide();
        }
    }

    private void doUpdateConnFactory(ObjAdminEvent oae, ConsoleObj selObj) {
        ObjStore os = oae.getObjStore();
        String lookupName = oae.getLookupName();
        boolean readOnly = oae.isReadOnly();
        Object currentObj = ((ObjStoreConFactoryCObj)selObj).getObject();
        Object updatedObject = this.updateObject(currentObj, oae.getFactoryType(), oae.getObjProperties(), readOnly);
        if (updatedObject == null) {
            return;
        }
        try {
            os.add(lookupName, updatedObject, true);
        }
        catch (NameAlreadyExistsException nameAlreadyExistsException) {
        }
        catch (Exception e) {
            JOptionPane.showOptionDialog(this.app.getFrame(), e.toString(), acr.getString("A1301"), 0, 0, null, close, close[0]);
            return;
        }
        ((ObjStoreConFactoryCObj)selObj).setObject(updatedObject);
        this.app.getStatusArea().appendText(acr.getString("A6009", selObj.toString(), os.getID()));
        this.app.getInspector().selectedObjectUpdated();
        if (oae.isOKAction()) {
            this.objStoreConFactoryPropsDialog.hide();
        }
    }

    private void doAddDestination(ObjAdminEvent oae, ConsoleObj selObj) {
        Object object = null;
        ObjStore os = oae.getObjStore();
        int destType = oae.getDestinationType();
        String lookupName = oae.getLookupName();
        Properties objProps = oae.getObjProperties();
        boolean readOnly = oae.isReadOnly();
        boolean overwrite = false;
        if (os.isOpen()) {
            Object newObj = null;
            try {
                if (destType == 2) {
                    newObj = JMSObjFactory.createTopic(objProps);
                } else if (destType == 1) {
                    newObj = JMSObjFactory.createQueue(objProps);
                }
            }
            catch (Exception e) {
                this.handleExceptions(e, "A1129");
                return;
            }
            if (readOnly) {
                JMSObjFactory.doReadOnlyForAdd(newObj, "true");
            } else {
                JMSObjFactory.doReadOnlyForAdd(newObj, "false");
            }
            try {
                object = os.retrieve(lookupName);
            }
            catch (NameNotFoundException e) {
            }
            catch (Exception ex) {
                JOptionPane.showOptionDialog(this.app.getFrame(), ex.toString(), acr.getString("A1129"), 0, 0, null, close, close[0]);
                return;
            }
            if (object != null) {
                int result = JOptionPane.showConfirmDialog(this.app.getFrame(), acr.getString("A5002", lookupName), acr.getString("A1129"), 0);
                if (result == 1) {
                    return;
                }
                overwrite = true;
            }
            try {
                os.add(lookupName, newObj, true);
            }
            catch (Exception ex) {
                JOptionPane.showOptionDialog(this.app.getFrame(), ex.toString(), acr.getString("A1129"), 0, 0, null, close, close[0]);
                return;
            }
            if (os != null) {
                if (overwrite) {
                    this.removeChild(selObj, lookupName);
                    this.removeChild((ConsoleObj)selObj.getParent().getChildAt(1), lookupName);
                }
                ObjStoreDestCObj destCObj = new ObjStoreDestCObj((ObjStoreCObj)selObj.getParent(), lookupName, newObj);
                this.app.getExplorer().addToParent(selObj, destCObj);
                this.app.getInspector().refresh();
                this.app.getStatusArea().appendText(acr.getString("A6007", lookupName, os.getID()));
                if (oae.isOKAction()) {
                    this.objStoreDestAddDialog.hide();
                }
            }
        }
    }

    private void doAddConnFactory(ObjAdminEvent oae, ConsoleObj selObj) {
        Object object = null;
        ObjStore os = oae.getObjStore();
        int factoryType = oae.getFactoryType();
        String lookupName = oae.getLookupName();
        Properties objProps = oae.getObjProperties();
        boolean readOnly = oae.isReadOnly();
        boolean overwrite = false;
        if (os.isOpen()) {
            Object newObj = null;
            try {
                if (factoryType == 3) {
                    newObj = JMSObjFactory.createQueueConnectionFactory(objProps);
                } else if (factoryType == 4) {
                    newObj = JMSObjFactory.createTopicConnectionFactory(objProps);
                } else if (factoryType == 7) {
                    newObj = JMSObjFactory.createConnectionFactory(objProps);
                } else if (factoryType == 5) {
                    newObj = JMSObjFactory.createXAQueueConnectionFactory(objProps);
                } else if (factoryType == 6) {
                    newObj = JMSObjFactory.createXATopicConnectionFactory(objProps);
                } else if (factoryType == 8) {
                    newObj = JMSObjFactory.createXAConnectionFactory(objProps);
                }
            }
            catch (Exception e) {
                this.handleExceptions(e, "A1130");
                return;
            }
            if (readOnly) {
                JMSObjFactory.doReadOnlyForAdd(newObj, "true");
            } else {
                JMSObjFactory.doReadOnlyForAdd(newObj, "false");
            }
            try {
                object = os.retrieve(lookupName);
            }
            catch (NameNotFoundException e) {
            }
            catch (Exception ex) {
                JOptionPane.showOptionDialog(this.app.getFrame(), ex.toString(), acr.getString("A1130"), 0, 0, null, close, close[0]);
                return;
            }
            if (object != null) {
                int result = JOptionPane.showConfirmDialog(this.app.getFrame(), acr.getString("A5002", lookupName), acr.getString("A1130"), 0);
                if (result == 1) {
                    return;
                }
                overwrite = true;
            }
            try {
                os.add(lookupName, newObj, true);
            }
            catch (Exception ex) {
                JOptionPane.showOptionDialog(this.app.getFrame(), ex.toString(), acr.getString("A1130"), 0, 0, null, close, close[0]);
                return;
            }
            if (os != null) {
                if (overwrite) {
                    this.removeChild(selObj, lookupName);
                    this.removeChild((ConsoleObj)selObj.getParent().getChildAt(0), lookupName);
                }
                ObjStoreConFactoryCObj conFacCObj = new ObjStoreConFactoryCObj((ObjStoreCObj)selObj.getParent(), lookupName, newObj);
                this.app.getExplorer().addToParent(selObj, conFacCObj);
                this.app.getInspector().refresh();
                this.app.getStatusArea().appendText(acr.getString("A6008", lookupName, os.getID()));
                if (oae.isOKAction()) {
                    this.objStoreConFactoryAddDialog.hide();
                }
            }
        }
    }

    private void removeChild(ConsoleObj parent, String childName) {
        Enumeration<TreeNode> e = parent.children();
        while (e.hasMoreElements()) {
            ConsoleObj node = (ConsoleObj)e.nextElement();
            if (!node.toString().equals(childName)) continue;
            this.app.getExplorer().removeFromParent(node);
            e = parent.children();
        }
    }

    private void loadObjStoreList() {
        ConsoleObjStoreManager osMgr = (ConsoleObjStoreManager)this.app.getObjStoreListCObj().getObjStoreManager();
        try {
            osMgr.setFileName(OBJSTORELIST_FILENAME);
            osMgr.readObjStoresFromFile();
        }
        catch (Exception ex) {
            String errStr = acr.getString("A3014", ex.getMessage());
            JOptionPane.showOptionDialog(this.app.getFrame(), errStr, acr.getString("A1521") + ": " + acr.getString("A1218", "A3014"), 0, 0, null, close, close[0]);
        }
        Vector v = osMgr.getAllStores();
        for (int i = 0; i < v.size(); ++i) {
            ObjStore os = (ObjStore)v.get(i);
            ObjStoreCObj osCObj = new ObjStoreCObj(os);
            if (os.isOpen()) {
                this.readObjStore(osCObj, os);
            }
            this.app.getExplorer().addObjStore(osCObj);
        }
        this.app.getInspector().refresh();
    }

    private void saveObjStoreList() {
        ConsoleObjStoreManager osMgr = (ConsoleObjStoreManager)this.app.getObjStoreListCObj().getObjStoreManager();
        try {
            osMgr.setFileName(OBJSTORELIST_FILENAME);
            osMgr.writeObjStoresToFile();
        }
        catch (Exception ex) {
            String errStr = acr.getString("A3015", ex.getMessage());
            JOptionPane.showOptionDialog(this.app.getFrame(), errStr, acr.getString("A1088") + ": " + acr.getString("A1218", "A3015"), 0, 0, null, close, close[0]);
        }
    }

    public void handleConsoleActionEvents(ConsoleActionEvent cae) {
        int type = cae.getType();
        switch (type) {
            case 5: {
                this.doRefresh();
            }
        }
    }

    private void doRefresh() {
        ConsoleObj selObj = this.app.getSelectedObj();
        if (selObj instanceof ObjStoreCObj) {
            this.doRefreshObjStore(selObj);
        } else if (selObj instanceof ObjStoreDestListCObj) {
            this.doRefreshObjStore(selObj);
        } else if (selObj instanceof ObjStoreDestCObj) {
            ObjStoreDestCObj destCObj = (ObjStoreDestCObj)selObj;
            ObjStoreCObj osCObj = destCObj.getObjStoreCObj();
            this.doRefreshObjStore(osCObj.getObjStoreDestListCObj());
        } else if (selObj instanceof ObjStoreConFactoryListCObj) {
            this.doRefreshObjStore(selObj);
        } else if (selObj instanceof ObjStoreConFactoryCObj) {
            ObjStoreConFactoryCObj cfCObj = (ObjStoreConFactoryCObj)selObj;
            ObjStoreCObj osCObj = cfCObj.getObjStoreCObj();
            this.doRefreshObjStore(osCObj.getObjStoreConFactoryListCObj());
        }
    }

    private void doRefreshObjStore(ConsoleObj selObj) {
        ObjStore os = null;
        ConsoleObj cObj = selObj;
        if (selObj instanceof ObjStoreCObj) {
            os = ((ObjStoreCObj)selObj).getObjStore();
            cObj = selObj;
        } else if (selObj instanceof ObjStoreDestListCObj) {
            os = ((ObjStoreDestListCObj)selObj).getObjStore();
            cObj = (ConsoleObj)selObj.getParent();
        } else if (selObj instanceof ObjStoreConFactoryListCObj) {
            os = ((ObjStoreConFactoryListCObj)selObj).getObjStore();
            cObj = (ConsoleObj)selObj.getParent();
        }
        if (!os.isOpen()) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3006", selObj.toString()), acr.getString("A1102") + ": " + acr.getString("A1218", "A3006"), 0, 0, null, close, close[0]);
            return;
        }
        boolean success = this.finishDoConnectObjStore(cObj, os);
        if (success) {
            this.controller.setActions(selObj);
            this.app.getInspector().refresh();
            if (selObj instanceof ObjStoreCObj) {
                this.app.getStatusArea().appendText(acr.getString("A6028", os.getID()));
            } else if (selObj instanceof ObjStoreDestListCObj) {
                this.app.getStatusArea().appendText(acr.getString("A6029", os.getID()));
            } else if (selObj instanceof ObjStoreConFactoryListCObj) {
                this.app.getStatusArea().appendText(acr.getString("A6030", os.getID()));
            }
        }
    }

    private void handleExceptions(Exception e, String titleId) {
        if (e instanceof InvalidPropertyException) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3042", e.getMessage()), acr.getString(titleId) + ": " + acr.getString("A1218", "A3042"), 0, 0, null, close, close[0]);
        } else if (e instanceof InvalidPropertyValueException) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3043", e.getMessage()), acr.getString(titleId) + ": " + acr.getString("A1218", "A3043"), 0, 0, null, close, close[0]);
        } else {
            JOptionPane.showOptionDialog(this.app.getFrame(), e.toString(), acr.getString(titleId), 0, 0, null, close, close[0]);
        }
    }

    private void closeObjStore(ObjStore os, ConsoleObj selObj) {
        if (os == null) {
            return;
        }
        try {
            if (os.isOpen()) {
                os.close();
                if (selObj instanceof ObjStoreCObj) {
                    this.clearStore(selObj);
                    this.app.getExplorer().nodeChanged(selObj);
                    this.app.getInspector().refresh();
                    this.controller.setActions(selObj);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        String[] stringArray = new String[1];
        stringArray[0] = acr.getString("A1081");
        close = stringArray;
    }
}

