/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.api;

import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import java.util.Properties;

public abstract class MessageTransformer<T, S> {
    public static final String SUN_MQ = "SUN_MQ";
    public static final String STOMP = "STOMP";
    private Object _obj = null;
    private Object _branchTo = null;
    private String _bridgeType = null;
    private boolean _notransfer = false;

    public final void init(Object obj, String bridgeType) {
        this._obj = obj;
        this._branchTo = null;
        this._bridgeType = bridgeType;
        this._notransfer = false;
    }

    public final Object getBranchTo() {
        return this._branchTo;
    }

    public final boolean isNoTransfer() {
        return this._notransfer;
    }

    protected final Message createJMSMessage(JMSMessageType type) throws Exception {
        Session ss = (Session)this._obj;
        if (ss == null) {
            throw new IllegalStateException("The MessageTransformer is not initialized !");
        }
        switch (type) {
            case MESSAGE: {
                return ss.createMessage();
            }
            case TEXTMESSAGE: {
                return ss.createTextMessage();
            }
            case BYTESMESSAGE: {
                return ss.createBytesMessage();
            }
            case MAPMESSAGE: {
                return ss.createMapMessage();
            }
            case STREAMMESSAGE: {
                return ss.createStreamMessage();
            }
            case OBJECTMESSAGE: {
                return ss.createObjectMessage();
            }
        }
        throw new IllegalArgumentException("Unexpected message type " + (Object)((Object)type));
    }

    protected final Queue createQueue(String queueName) throws Exception {
        Session ss = (Session)this._obj;
        if (ss == null) {
            throw new IllegalStateException("The MessageTransformer is not initialized !");
        }
        return ss.createQueue(queueName);
    }

    protected final Topic createTopic(String topicName) throws Exception {
        Session ss = (Session)this._obj;
        if (ss == null) {
            throw new IllegalStateException("The MessageTransformer is not initialized !");
        }
        return ss.createTopic(topicName);
    }

    protected final void branchTo(Object d) throws Exception {
        if (this._obj == null) {
            throw new IllegalStateException("The MessageTransformer is not initialized !");
        }
        if (!this._bridgeType.equals("JMS")) {
            throw new UnsupportedOperationException("MessageTransformer.branchTo() is not supported for bridge type " + this._bridgeType);
        }
        if (d == null) {
            throw new IllegalArgumentException("null passed to MessageTransformer.branchTo()");
        }
        if (!(d instanceof String) && !(d instanceof Destination)) {
            throw new IllegalArgumentException("Unexpected branchTo object type: " + d.getClass().getName());
        }
        this._branchTo = d;
    }

    protected final void noTransfer() throws Exception {
        if (this._obj == null) {
            throw new IllegalStateException("The MessageTransformer is not initialized !");
        }
        if (!this._bridgeType.equals("JMS")) {
            throw new UnsupportedOperationException("MessageTransformer.noTransfer() is not supported for bridge type " + this._bridgeType);
        }
        this._notransfer = true;
    }

    public abstract T transform(S var1, boolean var2, String var3, String var4, String var5, Properties var6) throws Exception;

    public static enum JMSMessageType {
        MESSAGE,
        TEXTMESSAGE,
        BYTESMESSAGE,
        MAPMESSAGE,
        STREAMMESSAGE,
        OBJECTMESSAGE;

    }
}

