/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.jms.xml;

import com.sun.messaging.bridge.service.jms.JMSBridge;
import com.sun.messaging.bridge.service.jms.xml.ConnectionFactoryElement;
import com.sun.messaging.bridge.service.jms.xml.DMQElement;
import com.sun.messaging.bridge.service.jms.xml.DestinationElement;
import com.sun.messaging.bridge.service.jms.xml.LinkElement;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;

public class JMSBridgeElement {
    private Properties _attrs = null;
    private LinkedHashMap<String, LinkElement> _links = new LinkedHashMap();
    private LinkedHashMap<String, DMQElement> _dmqs = new LinkedHashMap();
    private LinkedHashMap<String, DestinationElement> _dests = new LinkedHashMap();
    private LinkedHashMap<String, ConnectionFactoryElement> _cfs = new LinkedHashMap();

    public void setAttributes(Properties a) {
        this._attrs = a;
        if (a != null && (this.getName().equals("imq.bridge.jms.dmq") || this.getName().equals("built-in-dmq"))) {
            throw new IllegalArgumentException("jmsbridge name " + this.getName() + " is reserved.");
        }
    }

    public String getName() {
        return this._attrs.getProperty("name");
    }

    public boolean tagBridgeName() {
        return Boolean.valueOf(this._attrs.getProperty("message-transfer-tag-bridge-name", "false"));
    }

    public boolean logMessageTransfer() {
        return Boolean.valueOf(this._attrs.getProperty("log-message-transfer", "log-message-transfer"));
    }

    public void addLink(LinkElement l) throws Exception {
        String name = l.getName();
        if (name.equals("imq.bridge.jms.dmq") || name.equals("built-in-dmq") || name.equals("JMS_SUN_JMSBRIDGE_NAME")) {
            throw new IllegalArgumentException(JMSBridge.getJMSBridgeResources().getKString("BSJ4029", "link name=" + name));
        }
        LinkElement pre = this._links.get(name);
        if (pre != null) {
            throw new IllegalArgumentException(JMSBridge.getJMSBridgeResources().getKString("BSJ4032", "link", "name=" + name));
        }
        this._links.put(name, l);
    }

    public Map getLinks() {
        return this._links;
    }

    public void addDMQ(DMQElement d) throws Exception {
        String name = d.getName();
        if (name.equals("imq.bridge.jms.dmq")) {
            throw new IllegalArgumentException(JMSBridge.getJMSBridgeResources().getKString("BSJ4029", "dmq name=" + name));
        }
        DMQElement pre = this._dmqs.get(name);
        if (pre != null) {
            throw new IllegalArgumentException(JMSBridge.getJMSBridgeResources().getKString("BSJ4032", "dmq", "name=" + name));
        }
        this._dmqs.put(name, d);
    }

    public DMQElement getBuiltInDMQ() throws Exception {
        DMQElement dmq = this._dmqs.get("built-in-dmq");
        if (dmq == null) {
            dmq = new DMQElement();
            Properties prop = new Properties();
            prop.setProperty("name", "built-in-dmq");
            dmq.setAttributes(prop);
        }
        return dmq;
    }

    public Map getDMQs() {
        return this._dmqs;
    }

    public void addCF(String ref, ConnectionFactoryElement ecf) throws Exception {
        if (ref == null) {
            throw new IllegalArgumentException("ref-name null for " + ecf);
        }
        if (ref.equals("built-in-dmq") || ref.equals("imq.bridge.jms.dmq")) {
            throw new IllegalArgumentException("connection-factory ref-name " + ref + " is reserved.");
        }
        ConnectionFactoryElement pre = this._cfs.get(ref);
        if (pre != null) {
            throw new IllegalArgumentException(JMSBridge.getJMSBridgeResources().getKString("BSJ4032", "connection-factory", "ref-name=" + ref));
        }
        this._cfs.put(ref, ecf);
    }

    public ConnectionFactoryElement getCF(String ref) throws Exception {
        ConnectionFactoryElement ecf = this._cfs.get(ref);
        if (ecf == null) {
            throw new IllegalArgumentException(JMSBridge.getJMSBridgeResources().getKString("BSJ4033", "connection-factory", "ref-name=" + ref));
        }
        return ecf;
    }

    public Map getAllCF() {
        return this._cfs;
    }

    public void addDestination(String ref, DestinationElement ed) throws Exception {
        if (ref == null) {
            throw new IllegalArgumentException("ref-name null for " + ed);
        }
        if (ref.equals("built-in-dmq") || ref.equals("imq.bridge.jms.dmq") || ref.equals("AS_SOURCE")) {
            throw new IllegalArgumentException(JMSBridge.getJMSBridgeResources().getKString("BSJ4029", "destination ref-name=" + ref));
        }
        DestinationElement pre = this._dests.get(ref);
        if (pre != null) {
            throw new IllegalArgumentException(JMSBridge.getJMSBridgeResources().getKString("BSJ4032", "destination", "ref-name=" + ref));
        }
        this._dests.put(ref, ed);
    }

    public DestinationElement getDestination(String ref) throws Exception {
        DestinationElement ed = this._dests.get(ref);
        if (ed == null) {
            throw new IllegalArgumentException(JMSBridge.getJMSBridgeResources().getKString("BSJ4033", "destination", "ref-name=" + ref));
        }
        return ed;
    }
}

