/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util.lists;

import com.sun.messaging.jmq.util.lists.SetEntry;
import java.util.Comparator;

class PrioritySetEntry<E>
extends SetEntry<E> {
    int priority = 0;

    public PrioritySetEntry(E o, int priority) {
        super(o);
        this.priority = priority;
    }

    public int getPriority() {
        return this.priority;
    }

    @Override
    protected Comparator createSortComparator(Comparator comp) {
        return new PrioritySetEntryComparator(comp);
    }

    static class PrioritySetEntryComparator
    implements Comparator {
        Comparator datacmp = null;

        public PrioritySetEntryComparator(Comparator c) {
            this.datacmp = c;
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof PrioritySetEntry && o2 instanceof PrioritySetEntry) {
                if (((PrioritySetEntry)o1).priority != ((PrioritySetEntry)o2).priority) {
                    return ((PrioritySetEntry)o1).priority - ((PrioritySetEntry)o2).priority;
                }
                Object d1 = ((PrioritySetEntry)o1).data;
                Object d2 = ((PrioritySetEntry)o2).data;
                return this.datacmp.compare(d1, d2);
            }
            if (o1 instanceof PrioritySetEntry) {
                Object d1 = ((SetEntry)o1).data;
                return this.datacmp.compare(d1, o2);
            }
            if (o2 instanceof PrioritySetEntry) {
                Object d2 = ((SetEntry)o2).data;
                return this.datacmp.compare(o1, d2);
            }
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            return o1.hashCode() - o2.hashCode();
        }
    }
}

