/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.core;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.core.Monitor;
import java.lang.invoke.CallSite;
import java.util.Hashtable;
import java.util.Iterator;

class DestListMonitor
extends Monitor {
    public DestListMonitor(Destination d) {
        super(d);
    }

    @Override
    protected Hashtable getMonitorData() {
        Hashtable mapMessages = new Hashtable();
        Globals.getDestinationList();
        Iterator[] itrs = DestinationList.getAllDestinations(this.d.getPartitionedStore());
        Iterator itr = itrs[0];
        while (itr.hasNext()) {
            String key;
            Destination oneDest = (Destination)itr.next();
            if (oneDest.isInternal() || oneDest.isAdmin() || oneDest.getDestinationName().equals("__JMQAdmin") || oneDest.getDestinationName().equals("__JMQBridgeAdmin")) continue;
            Hashtable<String, Object> values = new Hashtable<String, Object>();
            if (oneDest.isQueue()) {
                key = "mq.metrics.destination.queue." + oneDest.getDestinationName();
                values.put("type", "queue");
            } else {
                key = "mq.metrics.destination.topic." + oneDest.getDestinationName();
                values.put("type", "topic");
            }
            values.put("name", oneDest.getDestinationName());
            values.put("isTemporary", oneDest.isTemporary());
            mapMessages.put((CallSite)((Object)key), values);
        }
        return mapMessages;
    }
}

