/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.core;

import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.BrokerStateHandler;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.core.MessageDeliveryTimeInfo;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.lists.RemoveReason;
import com.sun.messaging.jmq.jmsservice.BrokerEvent;
import com.sun.messaging.jmq.util.admin.DestinationInfo;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.timer.TimerEventHandler;
import com.sun.messaging.jmq.util.timer.WakeupableTimer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class MessageDeliveryTimeTimer
implements TimerEventHandler {
    protected static boolean DEBUG = MessageDeliveryTimeTimer.getDEBUG();
    private Logger logger = Globals.getLogger();
    private BrokerResources br = Globals.getBrokerResources();
    private SortedSet<MessageDeliveryTimeInfo> messages = null;
    private WakeupableTimer mytimer = null;
    private String startLogString = null;
    private String exitLogString = null;
    private Destination destination = null;
    private DestinationList DL = Globals.getDestinationList();
    private boolean destroyed = false;

    private static boolean getDEBUG() {
        return Destination.DEBUG || Globals.getLogger().getLevel() <= 4;
    }

    public MessageDeliveryTimeTimer(Destination d) {
        this.destination = d;
        this.messages = new TreeSet<MessageDeliveryTimeInfo>(MessageDeliveryTimeInfo.getComparator());
        this.startLogString = this.br.getKString("B1450", d.getDestinationUID());
        this.exitLogString = this.br.getKString("B1451", d.getDestinationUID());
    }

    public String toString() {
        return "[DeliveryDelayTimer]" + this.destination.getDestinationUID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessage(MessageDeliveryTimeInfo di) {
        if (DEBUG) {
            this.logger.log(8, "DeliveryTimeTimer.addMessage(" + di + ")");
        }
        long dtime = di.getDeliveryTime();
        boolean notify = di.isDeliveryReady();
        if (!notify) {
            di.setDeliveryReadyListener(this);
        }
        di.setOnTimerState();
        notify = di.isDeliveryReady();
        MessageDeliveryTimeTimer messageDeliveryTimeTimer = this;
        synchronized (messageDeliveryTimeTimer) {
            MessageDeliveryTimeInfo first;
            if (this.destroyed) {
                return;
            }
            if (notify && this.messages.size() > 0 && dtime > (first = this.messages.first()).getDeliveryTime()) {
                notify = false;
            }
            this.messages.add(di);
            if (this.mytimer == null) {
                this.addTimer();
            }
            if (notify) {
                this.mytimer.wakeup(dtime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deliveryReady(MessageDeliveryTimeInfo di) {
        boolean notify = true;
        long dtime = di.getDeliveryTime();
        MessageDeliveryTimeTimer messageDeliveryTimeTimer = this;
        synchronized (messageDeliveryTimeTimer) {
            MessageDeliveryTimeInfo first;
            if (this.destroyed) {
                return;
            }
            if (this.messages.size() > 0 && dtime > (first = this.messages.first()).getDeliveryTime()) {
                notify = false;
            }
            if (notify) {
                this.mytimer.wakeup(dtime);
            }
        }
    }

    public synchronized void removeMessage(MessageDeliveryTimeInfo di) {
        boolean b = this.messages.remove(di);
        if (DEBUG && b) {
            this.logger.log(8, "Removed message " + di + " from delivery delay timer " + this);
        }
    }

    public synchronized void destroy() {
        if (this.mytimer != null) {
            this.removeTimer();
        }
        this.messages.clear();
        this.destroyed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSizeInfo(Set msgset, DestinationInfo dinfo) {
        HashSet<MessageDeliveryTimeInfo> s = null;
        MessageDeliveryTimeTimer messageDeliveryTimeTimer = this;
        synchronized (messageDeliveryTimeTimer) {
            if (this.messages.size() == 0) {
                return 0;
            }
            s = new HashSet<MessageDeliveryTimeInfo>(this.messages);
        }
        ArrayList<MessageDeliveryTimeInfo> indelays = new ArrayList<MessageDeliveryTimeInfo>();
        int cnt = 0;
        MessageDeliveryTimeInfo di2 = null;
        for (MessageDeliveryTimeInfo di2 : s) {
            if (di2.getOnTimerState() != Boolean.TRUE) continue;
            ++cnt;
            if (msgset != null) {
                indelays.add(di2);
                continue;
            }
            if (dinfo == null) continue;
            ++dinfo.nInDelayMessages;
        }
        if (msgset == null) {
            return cnt;
        }
        cnt = 0;
        PacketReference ref2 = null;
        for (PacketReference ref2 : msgset) {
            if (!indelays.contains(new MessageDeliveryTimeInfo(ref2.getSysMessageID(), 1L))) continue;
            ++cnt;
            if (dinfo == null) continue;
            ++dinfo.nInDelayMessages;
            dinfo.nInDelayMessageBytes += ref2.getSize();
        }
        return cnt;
    }

    private void addTimer() {
        try {
            this.mytimer = new WakeupableTimer("MessageDeliveryTimeTimer", this, 0L, 0L, this.startLogString, this.exitLogString);
        }
        catch (Exception ex) {
            this.logger.logStack(32, this.br.getKString("B4401", this.destination.getDestinationUID()), ex);
        }
    }

    private void removeTimer() {
        try {
            if (this.mytimer != null) {
                this.mytimer.cancel();
            }
        }
        catch (IllegalStateException ex) {
            this.logger.logStack(4, "Exception on cancel " + this, ex);
        }
    }

    protected void routeTransactedMessage(PacketReference ref) throws BrokerException {
        MessageDeliveryTimeInfo di = ref.getDeliveryTimeInfo();
        try {
            this.destination.routeNewMessageWithDeliveryDelay(ref);
            di.setDeliveryReady();
        }
        catch (Exception e) {
            String emsg = this.br.getKString("B4427", ref, this.destination.getDestinationUID());
            this.logger.logStack(32, emsg, e);
            throw new BrokerException(emsg, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void consumerClosed(Consumer c) {
        if (this.destination.isQueue()) {
            return;
        }
        if (!(c instanceof Subscription) && c.getSubscription() != null) {
            return;
        }
        if (DEBUG) {
            this.logger.log(8, "Processing delivery delayed messages in destination " + this.destination.getDestinationUID() + " on closing consumer " + c);
        }
        TreeSet<MessageDeliveryTimeInfo> s = null;
        MessageDeliveryTimeTimer messageDeliveryTimeTimer = this;
        synchronized (messageDeliveryTimeTimer) {
            s = new TreeSet<MessageDeliveryTimeInfo>(this.messages);
        }
        int cnt = 0;
        PacketReference ref = null;
        MessageDeliveryTimeInfo di2 = null;
        for (MessageDeliveryTimeInfo di2 : s) {
            ref = DestinationList.get(this.destination.getPartitionedStore(), di2.getSysMessageID());
            if (ref == null || ref.isExpired() || !di2.setInProcessing(true)) continue;
            try {
                if (!ref.removeConsumerForDeliveryDelayed(c)) continue;
                try {
                    if (DEBUG) {
                        this.logger.log(8, "Removing message " + di2 + " in destination " + this.destination.getDestinationUID() + " on closing consumer [" + c.getConsumerUID() + ":" + c.getStoredConsumerUID() + "]");
                    }
                    this.destination.removeMessage(ref.getSysMessageID(), RemoveReason.REMOVED_OTHER);
                }
                finally {
                    ref.postAcknowledgedRemoval();
                }
                ++cnt;
            }
            catch (Exception e) {
                Object[] args = new Object[]{ref, this.destination.getDestinationUID(), "[" + c.getConsumerUID() + ":" + c.getStoredConsumerUID() + "]"};
                this.logger.logStack(16, this.br.getKString("B4426", args), e);
            }
            finally {
                di2.setInProcessing(false);
            }
        }
        if (cnt > 0) {
            Object[] args = new Object[]{String.valueOf(cnt), this.destination.getDestinationUID(), "[" + c.getConsumerUID() + ":" + c.getStoredConsumerUID() + "]"};
            this.logger.log(8, this.br.getKString("B1465", args));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long runTask() {
        LinkedHashSet<MessageDeliveryTimeInfo> dues = new LinkedHashSet<MessageDeliveryTimeInfo>();
        MessageDeliveryTimeInfo di2 = null;
        int count = 0;
        MessageDeliveryTimeTimer messageDeliveryTimeTimer = this;
        synchronized (messageDeliveryTimeTimer) {
            for (MessageDeliveryTimeInfo di2 : this.messages) {
                if (!di2.isDeliveryReady()) continue;
                if (!di2.isDeliveryDue() || count > this.destination.getMaxPrefetch()) break;
                if (!di2.setInProcessing(true)) continue;
                dues.add(di2);
                ++count;
            }
        }
        if (count > 0) {
            this.logger.log(8, this.br.getKString("B1452", count, this.destination.getDestinationUID()));
        }
        count = 0;
        Iterator itr = dues.iterator();
        PacketReference ref = null;
        while (itr.hasNext()) {
            di2 = (MessageDeliveryTimeInfo)itr.next();
            MessageDeliveryTimeTimer messageDeliveryTimeTimer2 = this;
            synchronized (messageDeliveryTimeTimer2) {
                this.messages.remove(di2);
            }
            di2.setOffTimerState();
            ref = DestinationList.get(this.destination.getPartitionedStore(), di2.getSysMessageID());
            if (ref == null || ref.isDestroyed() || ref.isInvalid()) continue;
            HashSet<ConsumerUID> s = new HashSet<ConsumerUID>();
            try {
                Collection cuids = ref.getAllConsumerUIDForDeliveryDelayed();
                if (DEBUG) {
                    this.logger.log(8, "Delivery time arrived message " + ref + "[" + di2 + "] in destination " + this.destination.getDestinationUID() + " had consumers: " + cuids);
                }
                Iterator itr1 = cuids.iterator();
                ConsumerUID cuid = null;
                while (itr1.hasNext()) {
                    cuid = (ConsumerUID)itr1.next();
                    if (cuid == PacketReference.getQueueUID()) continue;
                    s.add(cuid);
                }
                if (DEBUG) {
                    this.logger.log(8, "Forward delivery time arrived message " + ref + "[" + di2 + "] in destination " + this.destination.getDestinationUID() + (String)(this.destination.isQueue() ? "" : " to consumers " + s));
                }
                this.destination.forwardDeliveryDelayedMessage(s, ref);
            }
            catch (Exception e) {
                this.logger.logStack(32, this.br.getKString("B4402", ref, this.destination.getDestinationUID()) + "[" + s + "]", e);
            }
        }
        dues.clear();
        di2 = null;
        int msize = 0;
        MessageDeliveryTimeTimer e = this;
        synchronized (e) {
            msize = this.messages.size();
            itr = this.messages.iterator();
            while (itr.hasNext() && !(di2 = (MessageDeliveryTimeInfo)itr.next()).isDeliveryReady()) {
            }
        }
        long ret = 0L;
        if (di2 != null) {
            ret = di2.getDeliveryTime();
        }
        if (DEBUG) {
            this.logger.log(8, "MessageDeliveryTimeTimer:runTask() return " + ret + " , next ready message " + di2 + ", destination " + this.destination.getDestinationUID() + " with current delivery delay messages " + msize);
        }
        return ret;
    }

    @Override
    public void handleOOMError(Throwable e) {
        Globals.handleGlobalError(e, "OOM:MessageDeliveryTimeTimer");
    }

    @Override
    public void handleLogInfo(String msg) {
        this.logger.log(8, msg);
    }

    @Override
    public void handleLogWarn(String msg, Throwable e) {
        if (e == null) {
            this.logger.log(16, msg);
        } else {
            this.logger.logStack(16, msg, e);
        }
    }

    @Override
    public void handleLogError(String msg, Throwable e) {
        if (e == null) {
            this.logger.log(32, msg);
        } else {
            this.logger.logStack(32, msg, e);
        }
    }

    @Override
    public void handleTimerExit(Throwable e) {
        if (!this.destination.isValid() || this.mytimer == null) {
            return;
        }
        String emsg = this.exitLogString + ": " + e.getMessage();
        Broker broker = Broker.getBroker();
        Globals.getBrokerStateHandler();
        broker.exit(BrokerStateHandler.getRestartCode(), emsg, BrokerEvent.Type.RESTART, e, false, true, false);
    }
}

