/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminCmdHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminDataHandler;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.DestType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Hashtable;

public class ReplaceMessageHandler
extends AdminCmdHandler {
    private static boolean DEBUG = ReplaceMessageHandler.getDEBUG();

    public ReplaceMessageHandler(AdminDataHandler parent) {
        super(parent);
    }

    @Override
    public boolean handle(IMQConnection con, Packet cmd_msg, Hashtable cmd_props) {
        if (DEBUG) {
            this.logger.log(4, this.getClass().getName() + ": Replace message: " + cmd_props);
        }
        int status = 200;
        String errMsg = null;
        String destination = (String)cmd_props.get("JMQDestination");
        Integer destType = (Integer)cmd_props.get("JMQDestType");
        String msgID = (String)cmd_props.get("JMQMessageID");
        Object body = null;
        if (destType == null) {
            errMsg = "REPLACE_MESSAGE: destination type not specified";
            this.logger.log(32, errMsg);
            status = 500;
        }
        body = this.getBodyObject(cmd_msg);
        String newMsgID = null;
        Hashtable<String, String> newMsgIDHash = null;
        if (status == 200) {
            try {
                newMsgID = this.replaceMessage(msgID, destination, body, DestType.isQueue(destType));
                newMsgIDHash = new Hashtable<String, String>();
                newMsgIDHash.put("JMQMessageID", newMsgID);
            }
            catch (Exception e) {
                status = 500;
                errMsg = e.getMessage();
                boolean logstack = true;
                if (e instanceof BrokerException && ((status = ((BrokerException)e).getStatusCode()) == 405 || status == 404 || status == 400 || status == 409)) {
                    logstack = false;
                }
                Object[] args = new Object[]{msgID, destination, e.getMessage()};
                errMsg = this.rb.getKString("B4421", args);
                if (logstack) {
                    this.logger.logStack(32, errMsg, e);
                }
                this.logger.log(32, errMsg, e);
            }
        }
        Packet reply = new Packet(con.useDirectBuffers());
        reply.setPacketType(5);
        ReplaceMessageHandler.setProperties(reply, 91, status, errMsg, newMsgIDHash);
        this.parent.sendReply(con, cmd_msg, reply);
        return true;
    }

    public String replaceMessage(String msgID, String destination, Object body, boolean isQueue) throws BrokerException, IOException {
        if (msgID == null) {
            String emsg = "REPLACE_MESSAGE: Message ID not specified";
            throw new BrokerException(emsg, 400);
        }
        if (destination == null) {
            String emsg = "REPLACE_MESSAGE: Message ID not specified";
            throw new BrokerException(emsg, 400);
        }
        if (body == null || !(body instanceof HashMap)) {
            String emsg = "REPLACE_MESSAGE: New message body specified or is of incorrect type";
            throw new BrokerException(emsg, 400);
        }
        HashMap hashMapBody = (HashMap)body;
        Destination[] ds = DestinationList.getDestination(null, destination, isQueue);
        Destination d = ds[0];
        if (d == null) {
            String emsg = "REPLACE_MESSAGE: " + this.rb.getString("B4017", destination);
            throw new BrokerException(emsg, 404);
        }
        if (DEBUG) {
            d.debug();
        }
        d.load();
        SysMessageID sysMsgID = SysMessageID.get(msgID);
        PacketReference pr = ReplaceMessageHandler.getPacketReference(sysMsgID);
        if (pr == null) {
            String emsg = "REPLACE_MESSAGE: Could not locate message " + msgID + " in destination " + destination;
            throw new BrokerException(emsg, 404);
        }
        this.logger.log(8, this.rb.getKString("B1455", msgID, d.getDestinationUID()));
        if (!pr.isLocal()) {
            Object[] args = new Object[]{msgID, d.getDestinationUID(), pr.getBrokerAddress()};
            String emsg = this.rb.getKString("B3305", args);
            throw new BrokerException(emsg, 405);
        }
        int oldPacketType = pr.getPacket().getPacketType();
        Integer newPacketType = (Integer)hashMapBody.get("MessageBodyType");
        if (newPacketType == null) {
            String emsg = "REPLACE_MESSAGE: MessageBodyType not specified";
            throw new BrokerException(emsg, 400);
        }
        if (oldPacketType != newPacketType) {
            String emsg = "REPLACE_MESSAGE: Existing message and new message types do not match.";
            throw new BrokerException(emsg, 400);
        }
        byte[] bytes = ReplaceMessageHandler.getBytesFromMessage(hashMapBody);
        String newMsgID = d.replaceMessageString(sysMsgID, null, bytes);
        if (newMsgID == null) {
            String emsg = "REPLACE_MESSAGE: New message ID not returned as expected.";
            throw new BrokerException(emsg);
        }
        Object[] args = new Object[]{msgID, newMsgID, d.getDestinationUID()};
        this.logger.log(8, this.rb.getKString("B1456", args));
        return newMsgID;
    }

    public static byte[] getBytesFromMessage(HashMap h) throws BrokerException {
        byte[] ba = null;
        Object msgBody = h.get("MessageBody");
        Integer msgType = (Integer)h.get("MessageBodyType");
        switch (msgType) {
            case 1: {
                try {
                    String textMsg = (String)msgBody;
                    ba = textMsg.getBytes("UTF8");
                    break;
                }
                catch (Exception e) {
                    String emsg = "Caught exception while creating text message body";
                    throw new BrokerException(emsg, e);
                }
            }
            case 2: 
            case 4: {
                ba = (byte[])msgBody;
                break;
            }
            case 3: {
                try {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                    HashMap map = (HashMap)msgBody;
                    objectOutputStream.writeObject(map);
                    objectOutputStream.flush();
                    ba = byteArrayOutputStream.toByteArray();
                    break;
                }
                catch (Exception e) {
                    String emsg = "Caught exception while creating map message body";
                    throw new BrokerException(emsg, e);
                }
            }
            case 5: {
                try {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                    objectOutputStream.writeObject(msgBody);
                    objectOutputStream.flush();
                    ba = byteArrayOutputStream.toByteArray();
                    break;
                }
                catch (Exception e) {
                    String emsg = "Caught exception while creating object message body";
                    throw new BrokerException(emsg, e);
                }
            }
            default: {
                String emsg = "Unsupported message type for admin REPLACE_MESSAGE handler: " + msgType;
                throw new BrokerException(emsg, 400);
            }
        }
        return ba;
    }

    public static PacketReference getPacketReference(SysMessageID sysMsgID) {
        Globals.getDestinationList();
        return DestinationList.get(null, sysMsgID);
    }
}

