/*
 * Copyright (c) 1997, 2018 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Distribution License v. 1.0, which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

package org.glassfish.pfl.basic.logex;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/** Indicates that stack traces should be added to log records for logging
 * methods in the interface (if on an interface), or for a particular method.
 * As a class annotation, this establishes the default which may be overridden
 * by @NoStackTrace on a method.
 *
 * By default, a stack trace is added only to log records for level WARNING or
 * higher.
 *
 * @author Ken Cavanaugh
 */
@Documented
@Target({ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
public @interface StackTrace {

}
