/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.soteria.servlet;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.glassfish.soteria.Utils;

public class RequestData
implements Serializable {
    private Cookie[] cookies;
    private Map<String, List<String>> headers;
    private List<Locale> locales;
    private Map<String, String[]> parameters;
    private String method;
    private String requestURL;
    private String queryString;

    public static RequestData of(HttpServletRequest request) {
        RequestData requestData = new RequestData();
        requestData.cookies = RequestData.copyCookies(request.getCookies());
        requestData.headers = RequestData.copyHeaders(request);
        requestData.parameters = RequestData.copyParameters(request.getParameterMap());
        requestData.locales = Collections.list(request.getLocales());
        requestData.method = request.getMethod();
        requestData.requestURL = request.getRequestURL().toString();
        requestData.queryString = request.getQueryString();
        return requestData;
    }

    private static Cookie[] copyCookies(Cookie[] cookies) {
        if (Utils.isEmpty(cookies)) {
            return cookies;
        }
        ArrayList<Cookie> copiedCookies = new ArrayList<Cookie>();
        for (Cookie cookie : cookies) {
            copiedCookies.add((Cookie)cookie.clone());
        }
        return copiedCookies.toArray(new Cookie[copiedCookies.size()]);
    }

    private static Map<String, List<String>> copyHeaders(HttpServletRequest request) {
        HashMap<String, List<String>> copiedHeaders = new HashMap<String, List<String>>();
        for (String headerName : Collections.list(request.getHeaderNames())) {
            copiedHeaders.put(headerName, Collections.list(request.getHeaders(headerName)));
        }
        return copiedHeaders;
    }

    private static Map<String, String[]> copyParameters(Map<String, String[]> parameters) {
        if (RequestData.isEmptyMap(parameters)) {
            return Collections.emptyMap();
        }
        HashMap<String, String[]> copiedParameters = new HashMap<String, String[]>();
        for (Map.Entry<String, String[]> parameter : parameters.entrySet()) {
            copiedParameters.put(parameter.getKey(), (String[])Arrays.copyOf((Object[])parameter.getValue(), parameter.getValue().length));
        }
        return copiedParameters;
    }

    private static boolean isEmptyMap(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public Cookie[] getCookies() {
        return this.cookies;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public List<Locale> getLocales() {
        return this.locales;
    }

    public Map<String, String[]> getParameters() {
        return this.parameters;
    }

    public String getMethod() {
        return this.method;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getRequestURL() {
        return this.requestURL;
    }

    public String getFullRequestURL() {
        return this.buildFullRequestURL(this.requestURL, this.queryString);
    }

    public boolean matchesRequest(HttpServletRequest request) {
        return this.getFullRequestURL().equals(this.buildFullRequestURL(request.getRequestURL().toString(), request.getQueryString()));
    }

    public String toString() {
        return String.format("%s %s", this.method, this.getFullRequestURL());
    }

    private String buildFullRequestURL(String requestURL, String queryString) {
        return requestURL + (Utils.isEmpty(queryString) ? "" : "?" + queryString);
    }
}

