/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.loader;

import com.sun.logging.LogDomains;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.annotation.HandlesTypes;
import org.glassfish.deployment.common.ClassDependencyBuilder;
import org.glassfish.hk2.classmodel.reflect.AnnotatedElement;
import org.glassfish.hk2.classmodel.reflect.AnnotationType;
import org.glassfish.hk2.classmodel.reflect.ClassModel;
import org.glassfish.hk2.classmodel.reflect.InterfaceModel;
import org.glassfish.hk2.classmodel.reflect.Member;
import org.glassfish.hk2.classmodel.reflect.Parameter;
import org.glassfish.hk2.classmodel.reflect.Type;
import org.glassfish.hk2.classmodel.reflect.Types;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletContainerInitializerUtil {
    private static final Logger log = LogDomains.getLogger(ServletContainerInitializerUtil.class, (String)"javax.enterprise.system.container.web");
    private static final ResourceBundle rb = log.getResourceBundle();

    public static Iterable<ServletContainerInitializer> getServletContainerInitializers(Map<String, String> webFragmentMap, List<String> absoluteOrderingList, boolean hasOthers, ClassLoader cl) {
        if (absoluteOrderingList != null && !hasOthers) {
            if (!(cl instanceof URLClassLoader)) {
                log.log(Level.WARNING, "servletContainerInitializerUtil.wrongClassLoaderType", cl.getClass().getCanonicalName());
                return null;
            }
            URLClassLoader webAppCl = (URLClassLoader)cl;
            ArrayList<URL> newClassLoaderUrlList = new ArrayList<URL>();
            for (URL classLoaderUrl : webAppCl.getURLs()) {
                String path;
                if (!"file".equals(classLoaderUrl.getProtocol())) continue;
                File file = new File(classLoaderUrl.getFile());
                try {
                    file = file.getCanonicalFile();
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (!file.exists() || !(path = file.getAbsolutePath()).endsWith(".jar") || ServletContainerInitializerUtil.isFragmentMissingFromAbsoluteOrdering(file.getName(), webFragmentMap, absoluteOrderingList)) continue;
                newClassLoaderUrlList.add(classLoaderUrl);
            }
            URL[] urlsForNewClassLoader = new URL[newClassLoaderUrlList.size()];
            cl = new URLClassLoader(newClassLoaderUrlList.toArray(urlsForNewClassLoader), webAppCl.getParent());
        }
        return ServiceLoader.load(ServletContainerInitializer.class, cl);
    }

    public static Map<Class<?>, List<Class<? extends ServletContainerInitializer>>> getInterestList(Iterable<ServletContainerInitializer> initializers) {
        if (null == initializers) {
            return null;
        }
        HashMap interestList = null;
        for (ServletContainerInitializer sc : initializers) {
            Class<?> sciClass;
            HandlesTypes ann;
            if (interestList == null) {
                interestList = new HashMap();
            }
            if ((ann = (sciClass = sc.getClass()).getAnnotation(HandlesTypes.class)) == null) {
                List currentInitializerList = (List)interestList.get(ServletContainerInitializerUtil.class);
                if (currentInitializerList == null) {
                    ArrayList arr = new ArrayList();
                    arr.add(sciClass);
                    interestList.put(ServletContainerInitializerUtil.class, arr);
                    continue;
                }
                currentInitializerList.add(sciClass);
                continue;
            }
            Class[] interestedClasses = ann.value();
            if (interestedClasses == null || interestedClasses.length == 0) continue;
            for (Class c : interestedClasses) {
                List currentInitializerList = (List)interestList.get(c);
                if (currentInitializerList == null) {
                    ArrayList arr = new ArrayList();
                    arr.add(sciClass);
                    interestList.put(c, arr);
                    continue;
                }
                currentInitializerList.add(sciClass);
            }
        }
        return interestList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Class<? extends ServletContainerInitializer>, Set<Class<?>>> getInitializerList(Iterable<ServletContainerInitializer> initializers, Map<Class<?>, List<Class<? extends ServletContainerInitializer>>> interestList, Types types, ClassLoader cl) {
        if (interestList == null) {
            return null;
        }
        Map<Class<ServletContainerInitializer>, Set<Class<?>>> initializerList = null;
        if (interestList.containsKey(ServletContainerInitializerUtil.class)) {
            initializerList = new HashMap();
            List<Class<? extends ServletContainerInitializer>> initializersWithoutHandleTypes = interestList.get(ServletContainerInitializerUtil.class);
            for (Class<? extends ServletContainerInitializer> c : initializersWithoutHandleTypes) {
                initializerList.put(c, null);
            }
        }
        if (interestList.keySet().size() > 1 || interestList.keySet().size() == 1 && !interestList.containsKey(ServletContainerInitializerUtil.class)) {
            if (types == null || Boolean.getBoolean("org.glassfish.web.parsing")) {
                ClassDependencyBuilder classInfo = new ClassDependencyBuilder();
                for (URL u : ((URLClassLoader)cl).getURLs()) {
                    String path = u.getPath();
                    try {
                        if (path.endsWith(".jar")) {
                            JarFile jf = new JarFile(path);
                            try {
                                Enumeration<JarEntry> entries = jf.entries();
                                while (entries.hasMoreElements()) {
                                    JarEntry anEntry = entries.nextElement();
                                    if (anEntry.isDirectory() || !anEntry.getName().endsWith(".class")) continue;
                                    InputStream jarInputStream = null;
                                    try {
                                        int r2;
                                        jarInputStream = jf.getInputStream(anEntry);
                                        int size = (int)anEntry.getSize();
                                        byte[] classData = new byte[size];
                                        for (int bytesRead = 0; bytesRead < size; bytesRead += r2) {
                                            r2 = jarInputStream.read(classData, bytesRead, size - bytesRead);
                                        }
                                        classInfo.loadClassData(classData);
                                    }
                                    catch (Throwable t) {
                                        if (!log.isLoggable(Level.FINE)) continue;
                                        log.log(Level.FINE, "servletContainerInitializerUtil.classLoadingError", new Object[]{anEntry.getName(), t.toString()});
                                    }
                                    finally {
                                        if (jarInputStream == null) continue;
                                        jarInputStream.close();
                                    }
                                }
                                continue;
                            }
                            finally {
                                jf.close();
                            }
                        }
                        File file = new File(path);
                        if (!file.exists()) continue;
                        if (file.isDirectory()) {
                            ServletContainerInitializerUtil.scanDirectory(file, classInfo);
                            continue;
                        }
                        log.log(Level.WARNING, "servletContainerInitializerUtil.invalidUrlClassLoaderPath", path);
                    }
                    catch (IOException ioex) {
                        String msg = rb.getString("servletContainerInitializerUtil.ioError");
                        msg = MessageFormat.format(msg, path);
                        log.log(Level.SEVERE, msg, ioex);
                        return null;
                    }
                }
                initializerList = ServletContainerInitializerUtil.checkAgainstInterestList(classInfo, interestList, initializerList, cl);
            } else {
                initializerList = ServletContainerInitializerUtil.checkAgainstInterestList(types, interestList, initializerList, cl);
            }
        }
        for (ServletContainerInitializer initializer : initializers) {
            if (initializerList.containsKey(initializer.getClass())) continue;
            initializerList.put(initializer.getClass(), null);
        }
        return initializerList;
    }

    private static boolean isFragmentMissingFromAbsoluteOrdering(String jarName, Map<String, String> webFragmentMap, List<String> absoluteOrderingList) {
        return webFragmentMap != null && absoluteOrderingList != null && !absoluteOrderingList.contains(webFragmentMap.get(jarName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void scanDirectory(File dir, ClassDependencyBuilder classInfo) {
        File[] files;
        for (File file : files = dir.listFiles()) {
            if (file.isFile()) {
                String fileName = file.getPath();
                if (!fileName.endsWith(".class")) continue;
                try {
                    byte[] classData = null;
                    FileInputStream is = null;
                    try {
                        is = new FileInputStream(fileName);
                        int size = ((InputStream)is).available();
                        classData = new byte[size];
                        ((InputStream)is).read(classData);
                        classInfo.loadClassData(classData);
                    }
                    finally {
                        if (is != null) {
                            ((InputStream)is).close();
                        }
                    }
                }
                catch (Throwable t) {
                    if (!log.isLoggable(Level.WARNING)) continue;
                    log.log(Level.WARNING, "servletContainerInitializerUtil.classLoadingError", new Object[]{fileName, t.toString()});
                }
                continue;
            }
            ServletContainerInitializerUtil.scanDirectory(file, classInfo);
        }
    }

    private static Map<Class<? extends ServletContainerInitializer>, Set<Class<?>>> checkAgainstInterestList(Types classInfo, Map<Class<?>, List<Class<? extends ServletContainerInitializer>>> interestList, Map<Class<? extends ServletContainerInitializer>, Set<Class<?>>> initializerList, ClassLoader cl) {
        if (classInfo == null) {
            return initializerList;
        }
        for (Class<?> c : interestList.keySet()) {
            Type type2 = classInfo.getBy(c.getName());
            if (type2 == null) continue;
            HashSet resultSet = new HashSet();
            if (type2 instanceof AnnotationType) {
                for (AnnotatedElement ae : ((AnnotationType)type2).allAnnotatedTypes()) {
                    if (ae instanceof Member) {
                        ae = ((Member)ae).getDeclaringType();
                    } else if (ae instanceof Parameter) {
                        ae = ((Parameter)ae).getMethod().getDeclaringType();
                    }
                    if (!(ae instanceof Type)) continue;
                    try {
                        resultSet.add(cl.loadClass(ae.getName()));
                    }
                    catch (Throwable throwable) {
                        if (!log.isLoggable(Level.WARNING)) continue;
                        log.log(Level.WARNING, "servletContainerInitializerUtil.classLoadingError", new Object[]{ae.getName(), throwable.toString()});
                    }
                }
            } else {
                Collection classes = type2 instanceof InterfaceModel ? ((InterfaceModel)type2).allImplementations() : ((ClassModel)type2).allSubTypes();
                for (ClassModel classModel : classes) {
                    try {
                        resultSet.add(cl.loadClass(classModel.getName()));
                    }
                    catch (Throwable t) {
                        if (!log.isLoggable(Level.WARNING)) continue;
                        log.log(Level.WARNING, "servletContainerInitializerUtil.classLoadingError", new Object[]{classModel.getName(), t.toString()});
                    }
                }
            }
            if (initializerList == null) {
                initializerList = new HashMap();
            }
            List<Class<ServletContainerInitializer>> containerInitializers = interestList.get(c);
            for (Class clazz : containerInitializers) {
                Set<Class<?>> classSet = initializerList.get(clazz);
                if (classSet == null) {
                    classSet = new HashSet();
                }
                classSet.addAll(resultSet);
                initializerList.put(clazz, classSet);
            }
        }
        return initializerList;
    }

    private static Map<Class<? extends ServletContainerInitializer>, Set<Class<?>>> checkAgainstInterestList(ClassDependencyBuilder classInfo, Map<Class<?>, List<Class<? extends ServletContainerInitializer>>> interestList, Map<Class<? extends ServletContainerInitializer>, Set<Class<?>>> initializerList, ClassLoader cl) {
        for (Class<?> c : interestList.keySet()) {
            Set resultFromClassInfo = classInfo.computeResult(c.getName());
            if (resultFromClassInfo.isEmpty()) continue;
            HashSet resultSet = new HashSet();
            Iterator iter = resultFromClassInfo.iterator();
            while (iter.hasNext()) {
                String className = ((String)iter.next()).replace('/', '.');
                try {
                    Class<?> aClass = cl.loadClass(className);
                    resultSet.add(aClass);
                }
                catch (Throwable t) {
                    if (!log.isLoggable(Level.WARNING)) continue;
                    log.log(Level.WARNING, "servletContainerInitializerUtil.classLoadingError", new Object[]{className, t.toString()});
                }
            }
            if (initializerList == null) {
                initializerList = new HashMap();
            }
            List<Class<? extends ServletContainerInitializer>> containerInitializers = interestList.get(c);
            for (Class<? extends ServletContainerInitializer> initializer : containerInitializers) {
                Set<Class<?>> classSet = initializerList.get(initializer);
                if (classSet == null) {
                    classSet = new HashSet();
                }
                classSet.addAll(resultSet);
                initializerList.put(initializer, classSet);
            }
        }
        return initializerList;
    }
}

