/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.component;

import com.sun.webui.jsf.component.Button;
import com.sun.webui.jsf.component.DropDown;
import com.sun.webui.jsf.component.HelpInline;
import com.sun.webui.jsf.component.Label;
import com.sun.webui.jsf.component.Listbox;
import com.sun.webui.jsf.component.StaticText;
import com.sun.webui.jsf.component.TextField;
import com.sun.webui.jsf.component.WebuiInput;
import com.sun.webui.jsf.model.FileChooserModel;
import com.sun.webui.jsf.model.Option;
import com.sun.webui.jsf.model.ResourceItem;
import com.sun.webui.jsf.model.ResourceModel;
import com.sun.webui.jsf.model.ResourceModelException;
import com.sun.webui.jsf.util.ClientSniffer;
import com.sun.webui.jsf.util.ComponentUtilities;
import com.sun.webui.jsf.util.ConversionUtilities;
import com.sun.webui.jsf.util.LogUtil;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.jsf.validator.FileChooserFilterValidator;
import com.sun.webui.jsf.validator.FileChooserLookInValidator;
import com.sun.webui.jsf.validator.FileChooserSelectValidator;
import com.sun.webui.jsf.validator.FileChooserSortValidator;
import com.sun.webui.theme.Theme;
import jakarta.el.ValueExpression;
import jakarta.faces.FacesException;
import jakarta.faces.application.FacesMessage;
import jakarta.faces.component.EditableValueHolder;
import jakarta.faces.component.NamingContainer;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.convert.Converter;
import jakarta.faces.convert.ConverterException;
import jakarta.faces.event.FacesEvent;
import jakarta.faces.event.ValueChangeEvent;
import jakarta.faces.render.Renderer;
import jakarta.faces.validator.ValidatorException;
import java.io.File;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

public final class FileChooser
extends WebuiInput
implements NamingContainer {
    public static final String ALPHABETIC = "alphabetic";
    public static final String ALPHABETIC_ASC = "alphabetica";
    public static final String ALPHABETIC_DSC = "alphabeticd";
    public static final String SIZE = "size";
    public static final String SIZE_ASC = "sizea";
    public static final String SIZE_DSC = "sized";
    public static final String LASTMODIFIED = "time";
    public static final String LASTMODIFIED_ASC = "timea";
    public static final String LASTMODIFIED_DSC = "timed";
    public static final String FILECHOOSER_SERVERNAME_STATICTEXT_FACET = "serverNameText";
    public static final String FILECHOOSER_SERVERNAME_LABEL_FACET = "serverLabel";
    public static final String FILECHOOSER_ENTERPRESS_HELP_FACET = "enterPressHelp";
    public static final String FILECHOOSER_MULTISELECT_HELP_FACET = "multiSelectHelp";
    public static final String FILECHOOSER_LOOKIN_TEXTFIELD_FACET = "lookinField";
    public static final String FILECHOOSER_LOOKIN_LABEL_FACET = "lookinLabel";
    public static final String FILECHOOSER_LABEL_FACET = "fileChooserLabel";
    public static final String FILECHOOSER_FILTERON_TEXTFIELD_FACET = "filterField";
    public static final String FILECHOOSER_FILTER_LABEL_FACET = "filterLabel";
    public static final String FILECHOOSER_SELECTED_TEXTFIELD_FACET = "selectedField";
    public static final String FILECHOOSER_SELECT_LABEL_FACET = "selectedLabel";
    public static final String FILECHOOSER_UPLEVEL_BUTTON_FACET = "upButton";
    public static final String FILECHOOSER_OPENFOLDER_BUTTON_FACET = "openButton";
    public static final String FILECHOOSER_SORTMENU_FACET = "sortMenu";
    public static final String FILECHOOSER_SORT_LABEL_FACET = "sortLabel";
    public static final String FILECHOOSER_HIDDEN_BUTTON_FACET = "hiddenButton";
    public static final String FILECHOOSER_LISTBOX_FACET = "listEntries";
    public static final String FILECHOOSER_HIDDENFIELD_ID = "_hiddenField";
    private static final String NULLMODEL = "Null model value.";
    public static final String HYPHEN = "-";
    private boolean openFolderChanged;
    private boolean filterChanged;
    private String lastOpenFolder;
    private boolean fileAndFolderChooser = false;
    private boolean visible = true;
    private boolean visibleSet = false;
    private int tabIndex = Integer.MIN_VALUE;
    private boolean tabIndexSet = false;
    private boolean descending = false;
    private boolean descendingSet = false;
    private boolean disabled = false;
    private boolean disabledSet = false;
    private boolean folderChooser = false;
    private boolean folderChooserSet = false;
    private Object lookin = null;
    private ResourceModel model = null;
    private boolean multiple = false;
    private boolean multipleSet = false;
    private boolean readOnly = false;
    private boolean readOnlySet = false;
    private int rows = 12;
    private boolean rowsSet = false;
    private String sortField = "alphabetic";
    private boolean sortFieldSet = false;
    private String style = null;
    private String styleClass = null;

    public FileChooser() {
        this.setRendererType("com.sun.webui.jsf.FileChooser");
    }

    public String getFamily() {
        return "com.sun.webui.jsf.FileChooser";
    }

    public String getEscapeChar() {
        return this.getModel().getEscapeChar();
    }

    public String getDelimiterChar() {
        return this.getModel().getDelimiterChar();
    }

    public String getCurrentFolder() {
        return this.getModel().getCurrentDir();
    }

    public String getSeparatorString() {
        return this.getModel().getSeparatorString();
    }

    public String getParentFolder() {
        return this.getModel().getParentFolder();
    }

    public void setFileAndFolderChooser(boolean flag) {
        if (flag) {
            this.doSetFolderChooser(false);
        }
        this.fileAndFolderChooser = flag;
    }

    public boolean isFileAndFolderChooser() {
        return this.fileAndFolderChooser;
    }

    public boolean isFolderChooser() {
        if (this.isFileAndFolderChooser()) {
            return false;
        }
        return this.doIsFolderChooser();
    }

    public void setFolderChooser(boolean newChooser) {
        if (this.isFileAndFolderChooser()) {
            this.doSetFolderChooser(false);
        } else {
            this.doSetFolderChooser(newChooser);
        }
    }

    public ResourceModel getModel() {
        ResourceModel zModel = this.doGetModel();
        if (zModel == null) {
            FileChooser.log(NULLMODEL);
            zModel = new FileChooserModel();
            Object obj = this.getLookin();
            String currentDir = null;
            if (obj != null) {
                if (obj instanceof File) {
                    currentDir = ((File)obj).getAbsolutePath();
                } else if (obj instanceof String) {
                    currentDir = (String)obj;
                }
            }
            zModel.setCurrentDir(currentDir);
            this.setModel(zModel);
        }
        return zModel;
    }

    public String[] getRoots() {
        return this.getModel().getRoots();
    }

    public void processDecodes(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        Iterator<Object> it = this.getFacets().keySet().iterator();
        while (it.hasNext()) {
            UIComponent facet = (UIComponent)this.getFacets().get(it.next());
            facet.processDecodes(context);
        }
        for (UIComponent child : this.getChildren()) {
            child.processDecodes(context);
        }
        boolean invalid = false;
        EditableValueHolder evh = (EditableValueHolder)this.getLookInTextField();
        if (evh != null && !evh.isImmediate()) {
            ((UIComponent)evh).processValidators(context);
        }
        invalid = invalid || !evh.isValid();
        evh = (EditableValueHolder)this.getFilterTextField();
        if (evh != null && !evh.isImmediate()) {
            ((UIComponent)evh).processValidators(context);
        }
        invalid = invalid || !evh.isValid();
        evh = (EditableValueHolder)this.getSelectedTextField();
        if (evh != null && !evh.isImmediate()) {
            ((UIComponent)evh).processValidators(context);
        }
        invalid = invalid || !evh.isValid();
        evh = (EditableValueHolder)this.getSortComponent();
        if (evh != null && !evh.isImmediate()) {
            ((UIComponent)evh).processValidators(context);
        }
        invalid = invalid || !evh.isValid();
        evh = (EditableValueHolder)this.getListComponent();
        if (evh != null && !this.isImmediate()) {
            ((UIComponent)evh).processValidators(context);
        }
        invalid = invalid || !evh.isValid();
        this.decode(context);
        if (this.isImmediate()) {
            if (!invalid) {
                this.validate(context);
            } else {
                this.setValid(false);
            }
        } else if (invalid) {
            this.setValid(false);
        }
        if (!this.isValid()) {
            context.renderResponse();
        }
    }

    public void processValidators(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        Iterator it = this.getFacetsAndChildren();
        Listbox lb = null;
        while (it.hasNext()) {
            UIComponent child = (UIComponent)it.next();
            if (child instanceof Listbox) {
                lb = (Listbox)child;
                continue;
            }
            child.processValidators(context);
            if (!(child instanceof EditableValueHolder) || ((EditableValueHolder)child).isValid()) continue;
            this.setValid(false);
        }
        if (lb != null) {
            lb.processValidators(context);
            if (!lb.isValid()) {
                this.setValid(false);
            }
        }
        try {
            if (!this.isImmediate()) {
                this.validate(context);
            }
        }
        catch (RuntimeException rte) {
            context.renderResponse();
        }
        if (!this.isValid()) {
            context.renderResponse();
        }
    }

    public void validate(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        Object submittedValue = this.getSubmittedValue();
        if (submittedValue == null) {
            return;
        }
        if (!this.isMultiple() && ((String[])submittedValue).length > 1) {
            FacesMessage fmsg = null;
            if (this.isFolderChooser()) {
                fmsg = FileChooser.createFacesMessage("filechooser.tooManyFileErrSum", "filechooser.tooManyFileErrDet", null, null);
            } else if (this.isFileAndFolderChooser()) {
                fmsg = FileChooser.createFacesMessage("filechooser.tooManyFileFolderErrSum", "filechooser.tooManyFileFolderErrDet", null, null);
                fmsg = FileChooser.createFacesMessage("filechooser.tooManyFolderErrSum", "filechooser.tooManyFolderErrDet", null, null);
            }
            context.addMessage(this.getClientId(context), fmsg);
            this.setValid(false);
            return;
        }
        ResourceModel zModel = this.getModel();
        this.lastOpenFolder = zModel.getCurrentDir();
        Object newValue = null;
        try {
            newValue = this.getConvertedValue(context, submittedValue);
        }
        catch (ConverterException ce) {
            this.setValid(false);
        }
        if (!this.lastOpenFolder.equals(zModel.getCurrentDir())) {
            EditableValueHolder evh = (EditableValueHolder)this.getLookInTextField();
            evh.setSubmittedValue((Object)zModel.getCurrentDir());
            try {
                ((UIComponent)evh).processValidators(context);
            }
            catch (ValidatorException ve) {
                this.setValid(false);
                evh.setSubmittedValue((Object)this.lastOpenFolder);
                zModel.setCurrentDir(this.lastOpenFolder);
                return;
            }
        }
        if (this.isValid()) {
            Object previous = this.getValue();
            this.setValue(newValue);
            this.setSubmittedValue(null);
            if (this.compareValues(previous, newValue)) {
                this.queueEvent((FacesEvent)new ValueChangeEvent((UIComponent)this, previous, newValue));
            }
        }
    }

    protected boolean compareValues(Object previous, Object value) {
        if (previous == null || value == null) {
            return super.compareValues(previous, value);
        }
        if (value instanceof Object[]) {
            int length = Array.getLength(value);
            if (Array.getLength(previous) != length) {
                return true;
            }
            for (int i = 0; i < length; ++i) {
                Object newValue = Array.get(value, i);
                Object prevValue = Array.get(previous, i);
                if (newValue == null) {
                    if (prevValue == null) continue;
                    return true;
                }
                if (prevValue == null) {
                    return true;
                }
                if (prevValue.equals(newValue)) continue;
                return true;
            }
            return false;
        }
        return super.compareValues(previous, value);
    }

    public void validateLookInComponent(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        ResourceModel zModel = this.getModel();
        String lookInValue = (String)value;
        try {
            zModel.setCurrentDir(lookInValue);
        }
        catch (ResourceModelException cme) {
            ((EditableValueHolder)component).setSubmittedValue(null);
            FacesMessage fmsg = cme.getFacesMessage();
            context.addMessage(this.getClientId(context), fmsg);
            throw new ValidatorException(fmsg);
        }
    }

    public void validateFilterComponent(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        ResourceModel zModel = this.getModel();
        String filterValue = (String)value;
        String lastFilter = zModel.getFilterValue();
        try {
            zModel.setFilterValue(filterValue);
        }
        catch (ResourceModelException cme) {
            ((EditableValueHolder)component).setSubmittedValue(null);
            FacesMessage fmsg = cme.getFacesMessage();
            context.addMessage(this.getClientId(context), fmsg);
            throw new ValidatorException(fmsg);
        }
        this.filterChanged = !lastFilter.equals(zModel.getFilterValue());
    }

    public void validateSortComponent(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        ResourceModel zModel = this.getModel();
        String sortValue = (String)value;
        try {
            zModel.setSortValue(sortValue);
        }
        catch (ResourceModelException cme) {
            ((EditableValueHolder)component).setSubmittedValue(null);
            FacesMessage fmsg = cme.getFacesMessage();
            context.addMessage(this.getClientId(context), fmsg);
            throw new ValidatorException(fmsg);
        }
    }

    public void validateSelectComponent(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        if (this.openFolderChanged || this.filterChanged) {
            ((EditableValueHolder)component).setSubmittedValue(null);
            ((EditableValueHolder)component).setValid(false);
            return;
        }
        if (value != null && ((String)value).length() > 0) {
            String[] selections = FileChooser.decodeSelections((String)value, this.getEscapeChar(), this.getDelimiterChar());
            this.setSubmittedValue(selections);
        }
    }

    public void updateModel(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isValid() || !this.isLocalValueSet()) {
            return;
        }
        ValueExpression vb = this.getValueExpression("selected");
        if (vb != null) {
            try {
                vb.setValue(context.getELContext(), this.getLocalValue());
                this.setValue(null);
                this.setLocalValueSet(false);
            }
            catch (FacesException e) {
                FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, "jakarta.faces.component.UIInput.CONVERSION", e.getMessage());
                context.addMessage(this.getClientId(context), message);
                this.setValid(false);
            }
            catch (IllegalArgumentException e) {
                FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, "jakarta.faces.component.UIInput.CONVERSION", e.getMessage());
                context.addMessage(this.getClientId(context), message);
                this.setValid(false);
            }
            catch (Exception e) {
                FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, "jakarta.faces.component.UIInput.CONVERSION", e.getMessage());
                context.addMessage(this.getClientId(context), message);
                this.setValid(false);
            }
        }
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        Renderer renderer = this.getRenderer(context);
        if (renderer != null) {
            return renderer.getConvertedValue(context, (UIComponent)this, submittedValue);
        }
        return this.getConvertedValue(context, (FileChooser)component, submittedValue);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getConvertedValue(FacesContext context, FileChooser chooser, Object submittedValue) throws ConverterException {
        ResourceModel zModel = chooser.getModel();
        if (submittedValue == null) {
            return null;
        }
        if (!(submittedValue instanceof String[])) {
            String msg = "FileChooser getConvertedValue requires String[] for its submittedValue.";
            FileChooser.log(msg);
            throw new ConverterException(msg);
        }
        Object[] chooserValues = null;
        try {
            this.lastOpenFolder = zModel.getCurrentDir();
            if (this.isFolderChooser()) {
                chooserValues = zModel.getSelectedContent((String[])submittedValue, true);
            } else if (this.isFileAndFolderChooser()) {
                Object[] fVals = zModel.getSelectedContent((String[])submittedValue, false);
                Object[] dVals = zModel.getSelectedContent((String[])submittedValue, true);
                int dsize = 0;
                if (dVals != null) {
                    dsize = dVals.length;
                }
                int fsize = 0;
                if (fVals != null) {
                    fsize = fVals.length;
                }
                if (fsize + dsize > 0) {
                    chooserValues = fVals instanceof File[] ? new File[dsize + fsize] : new Object[dsize + fsize];
                    int k = 0;
                    for (int i = 0; i < dsize; ++i) {
                        chooserValues[k++] = dVals[i];
                    }
                    for (int j = 0; j < fsize; ++j) {
                        chooserValues[k++] = fVals[j];
                    }
                }
            } else {
                chooserValues = zModel.getSelectedContent((String[])submittedValue, false);
            }
            this.openFolderChanged = !this.lastOpenFolder.equals(zModel.getCurrentDir());
        }
        catch (ResourceModelException cme) {
            FacesMessage fmsg = cme.getFacesMessage();
            context.addMessage(this.getClientId(context), fmsg);
            String msg = fmsg.getDetail() == null ? fmsg.getSummary() : fmsg.getDetail();
            throw new ConverterException(msg);
        }
        if (chooserValues == null || chooserValues.length == 0) {
            return null;
        }
        if (!(chooserValues instanceof File[])) {
            return chooserValues;
        }
        File[] realChooserValues = (File[])chooserValues;
        boolean isMultiple = this.isMultiple();
        Object value = this.getValue();
        Converter converter = chooser.getConverter();
        if (converter == null) {
            converter = this.getConverterFromValue(value);
        }
        ValueExpression valueExpr = chooser.getValueExpression("value");
        Class<Object> vclazz = null;
        if (valueExpr != null) {
            vclazz = valueExpr.getType(context.getELContext());
        } else if (value != null) {
            vclazz = value.getClass();
        }
        if (vclazz == null) {
            if (isMultiple) {
                if (converter != null) return this.convertFileArrayToObjectArray(context, converter, realChooserValues);
                return realChooserValues;
            }
            if (converter != null) return this.convertFileToObject(context, converter, realChooserValues[0]);
            return realChooserValues[0];
        }
        if (isMultiple) {
            void var12_26;
            if (vclazz.isArray()) {
                if (converter != null) return this.convertFileArrayToObjectArray(context, converter, realChooserValues);
                if (vclazz.getComponentType().isAssignableFrom(File.class)) {
                    return realChooserValues;
                }
                if (!vclazz.getComponentType().isAssignableFrom(String.class)) return null;
                return FileChooser.convertFileArrayToStringArray(realChooserValues);
            }
            Object var12_21 = null;
            if (vclazz.isAssignableFrom(ArrayList.class)) {
                ArrayList arrayList = new ArrayList();
                return this.convertFileArrayToList(context, converter, realChooserValues, (List)var12_26);
            }
            if (vclazz.isAssignableFrom(Vector.class)) {
                Vector vector = new Vector();
                return this.convertFileArrayToList(context, converter, realChooserValues, (List)var12_26);
            }
            if (vclazz.isAssignableFrom(LinkedList.class)) {
                LinkedList linkedList = new LinkedList();
                return this.convertFileArrayToList(context, converter, realChooserValues, (List)var12_26);
            }
            try {
                List list = (List)vclazz.newInstance();
                return this.convertFileArrayToList(context, converter, realChooserValues, (List)var12_26);
            }
            catch (Throwable t) {
                throw new ConverterException("FileChooser is configured for multiple selection but the value is not bound to an assignable type.");
            }
        }
        if (converter != null) {
            return converter.getAsObject(context, (UIComponent)chooser, FileChooser.convertFileToString(realChooserValues[0]));
        }
        if (vclazz.isAssignableFrom(File.class)) {
            return realChooserValues[0];
        }
        if (!vclazz.isAssignableFrom(String.class)) return realChooserValues[0];
        return FileChooser.convertFileToString(realChooserValues[0]);
    }

    private Converter getConverterFromValue(Object value) {
        if (value == null) {
            return null;
        }
        Converter converter = null;
        try {
            Class<Object> clazz = value.getClass();
            if (this.isMultiple()) {
                if (clazz.isArray()) {
                    clazz = clazz.getComponentType();
                } else if (value instanceof List && !((List)value).isEmpty()) {
                    Object listItem = ((List)value).get(0);
                    clazz = listItem != null ? listItem.getClass() : null;
                } else {
                    clazz = null;
                    FileChooser.log("Failed to obtain a class for the FileChooser multiple value.");
                    return null;
                }
            }
            if (clazz != null) {
                converter = ConversionUtilities.getConverterForClass(clazz);
            }
        }
        catch (Exception e) {
            String msg = "Failed to obtain a class for FileChooser value.";
            FileChooser.log(msg + "\nException: " + e.getStackTrace());
        }
        return converter;
    }

    protected Object convertFileArrayToObjectArray(FacesContext context, Converter converter, File[] fileArray) throws ConverterException {
        if (fileArray == null) {
            return null;
        }
        Object[] objArray = new Object[fileArray.length];
        if (converter == null) {
            for (int i = 0; i < fileArray.length; ++i) {
                objArray[i] = fileArray[i];
            }
        } else {
            for (int i = 0; i < fileArray.length; ++i) {
                objArray[i] = converter.getAsObject(context, (UIComponent)this, FileChooser.convertFileToString(fileArray[i]));
            }
        }
        return objArray;
    }

    protected List convertFileArrayToList(FacesContext context, Converter converter, File[] fileArray, List list) throws ConverterException {
        if (list == null) {
            return null;
        }
        if (converter != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                list.add(converter.getAsObject(context, (UIComponent)this, FileChooser.convertFileToString(fileArray[i])));
            }
        } else {
            for (int i = 0; i < fileArray.length; ++i) {
                list.add(fileArray[i]);
            }
        }
        return list;
    }

    protected Object convertFileToObject(FacesContext context, Converter converter, File file) throws ConverterException {
        if (converter == null) {
            return file;
        }
        String fileString = FileChooser.convertFileToString(file);
        if (fileString == null) {
            return null;
        }
        return converter.getAsObject(context, (UIComponent)this, fileString);
    }

    protected static String convertFileToString(File file) {
        if (file != null) {
            return file.getAbsolutePath();
        }
        return null;
    }

    protected static String[] convertFileArrayToStringArray(File[] fileArray) {
        if (fileArray == null) {
            return null;
        }
        String[] strArray = new String[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            strArray[i] = FileChooser.convertFileToString(fileArray[i]);
        }
        return strArray;
    }

    protected String[] convertValueToStringArray(FacesContext context, Converter converter, Object value) throws ConverterException {
        if (value == null) {
            return null;
        }
        Class<?> vclazz = value.getClass();
        if (!this.isMultiple()) {
            return new String[]{this.convertValueToString(context, converter, value)};
        }
        if (vclazz.isArray()) {
            return this.convertObjectArrayToStringArray(context, converter, (Object[])value);
        }
        if (value instanceof List) {
            return this.convertObjectListToStringArray(context, converter, (List)value);
        }
        String msg = "FileChooser is configured for multiple selection but the value is not an assignable type.";
        FileChooser.log(msg);
        throw new ConverterException(msg);
    }

    protected String convertValueToString(FacesContext context, Converter converter, Object value) throws ConverterException {
        if (value == null) {
            return null;
        }
        if (converter != null) {
            return converter.getAsString(context, (UIComponent)this, value);
        }
        if (value instanceof File) {
            return FileChooser.convertFileToString((File)value);
        }
        if (value instanceof String) {
            return (String)value;
        }
        FileChooser.log("Resorting to object.toString() to convert single value to String.");
        return value.toString();
    }

    protected String[] convertObjectArrayToStringArray(FacesContext context, Converter converter, Object[] value) throws ConverterException {
        if (value == null) {
            return null;
        }
        if (converter != null) {
            String[] strArray = new String[value.length];
            for (int i = 0; i < value.length; ++i) {
                strArray[i] = converter.getAsString(context, (UIComponent)this, value[i]);
            }
            return strArray;
        }
        if (value instanceof File[]) {
            return FileChooser.convertFileArrayToStringArray((File[])value);
        }
        if (value instanceof String[]) {
            return (String[])value;
        }
        FileChooser.log("Resorting to object.toString() to convert multiple array value to String[].");
        String[] strArray = new String[value.length];
        for (int i = 0; i < value.length; ++i) {
            strArray[i] = value[i].toString();
        }
        return strArray;
    }

    protected String[] convertObjectListToStringArray(FacesContext context, Converter converter, List list) throws ConverterException {
        if (list == null) {
            return null;
        }
        if (converter != null) {
            String[] strArray = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                strArray[i] = converter.getAsString(context, (UIComponent)this, list.get(i));
            }
            return strArray;
        }
        String[] strArray = new String[list.size()];
        if (list.isEmpty()) {
            return strArray;
        }
        Object listItem = list.get(0);
        if (listItem instanceof File) {
            File[] fileArray = new File[list.size()];
            fileArray = list.toArray(fileArray);
            return FileChooser.convertFileArrayToStringArray(fileArray);
        }
        if (listItem instanceof String) {
            return list.toArray(strArray);
        }
        FileChooser.log("Resorting to object.toString() to convert multiple list value to String[].");
        for (int i = 0; i < list.size(); ++i) {
            strArray[i] = list.get(i).toString();
        }
        return strArray;
    }

    private Listbox populateListComponent(Listbox fileList) {
        ResourceModel zModel = this.getModel();
        ResourceItem[] items = zModel.getFolderContent(zModel.getCurrentDir(), this.isFolderChooser(), false);
        if (items != null && items.length != 0) {
            Option[] optList = new Option[items.length];
            for (int i = 0; i < items.length; ++i) {
                optList[i] = new Option(items[i].getItemKey(), items[i].getItemLabel());
                optList[i].setDisabled(items[i].isItemDisabled());
            }
            fileList.setItems(optList);
        } else {
            FileChooser.populateEmptyList(fileList);
        }
        return fileList;
    }

    private static void populateEmptyList(Listbox fileList) {
        Theme theme = FileChooser.getTheme();
        int fileNameLen = Integer.parseInt(theme.getMessage("filechooser.fileNameLen"));
        int fileSizeLen = Integer.parseInt(theme.getMessage("filechooser.fileSizeLen"));
        int fileDateLen = Integer.parseInt(theme.getMessage("filechooser.fileDateLen"));
        String label = "";
        String value = "0";
        int len = fileNameLen + fileSizeLen + fileDateLen + 10;
        for (int i = 0; i < len; ++i) {
            label = label + HYPHEN;
        }
        Option[] fileEntries = new Option[]{new Option(value, label)};
        fileEntries[0].setDisabled(true);
        fileList.setItems(fileEntries);
    }

    public UIComponent getServerNameText() {
        UIComponent facet = this.getFacet(FILECHOOSER_SERVERNAME_STATICTEXT_FACET);
        if (facet != null) {
            return facet;
        }
        StaticText child = new StaticText();
        child.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, FILECHOOSER_SERVERNAME_STATICTEXT_FACET));
        child.setParent((UIComponent)this);
        Theme theme = FileChooser.getTheme();
        child.setText(theme.getMessage("filechooser.lookinColumn"));
        child.setStyleClass(theme.getStyleClass("FILECHOOSER_NAME_TXT"));
        ResourceModel zModel = this.getModel();
        String serverName = zModel.getServerName();
        child.setText(serverName);
        return child;
    }

    public UIComponent getEnterInlineHelp() {
        UIComponent facet = this.getFacet(FILECHOOSER_ENTERPRESS_HELP_FACET);
        if (facet != null) {
            return facet;
        }
        HelpInline child = new HelpInline();
        child.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, FILECHOOSER_ENTERPRESS_HELP_FACET));
        child.setParent((UIComponent)this);
        Theme theme = FileChooser.getTheme();
        child.setText(theme.getMessage("filechooser.enterKeyHelp"));
        child.setType("field");
        return child;
    }

    public UIComponent getMultiSelectHelp() {
        if (!this.isMultiple()) {
            return null;
        }
        UIComponent facet = this.getFacet(FILECHOOSER_MULTISELECT_HELP_FACET);
        if (facet != null) {
            return facet;
        }
        HelpInline child = new HelpInline();
        child.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, FILECHOOSER_MULTISELECT_HELP_FACET));
        child.setParent((UIComponent)this);
        Theme theme = FileChooser.getTheme();
        child.setText(theme.getMessage("filechooser.multiSelectHelp"));
        child.setType("field");
        return child;
    }

    public UIComponent getServerNameLabel() {
        UIComponent facet = this.getFacet(FILECHOOSER_SERVERNAME_LABEL_FACET);
        if (facet != null) {
            return facet;
        }
        Label child = new Label();
        child.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, FILECHOOSER_SERVERNAME_LABEL_FACET));
        child.setParent((UIComponent)this);
        child.setLabelLevel(2);
        Theme theme = FileChooser.getTheme();
        child.setText(theme.getMessage("filechooser.serverPrompt"));
        child.setStyleClass(theme.getStyleClass("LABEL_LEVEL_TWO_TEXT"));
        return child;
    }

    public UIComponent getFileChooserTitle() {
        UIComponent facet = this.getFacet(FILECHOOSER_LABEL_FACET);
        if (facet != null) {
            return facet;
        }
        StaticText child = new StaticText();
        child.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, FILECHOOSER_LABEL_FACET));
        child.setParent((UIComponent)this);
        Theme theme = FileChooser.getTheme();
        child.setText(theme.getMessage("filechooser.title"));
        return child;
    }

    public UIComponent getLookInTextField() {
        UIComponent facet = this.getFacet(FILECHOOSER_LOOKIN_TEXTFIELD_FACET);
        if (facet != null) {
            return facet;
        }
        TextField child = (TextField)ComponentUtilities.getPrivateFacet((UIComponent)this, FILECHOOSER_LOOKIN_TEXTFIELD_FACET, true);
        if (child == null) {
            child = new TextField();
            child.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, FILECHOOSER_LOOKIN_TEXTFIELD_FACET));
            child.addValidator(new FileChooserLookInValidator());
            child.setSubmittedValue(this.getModel().getCurrentDir());
            ComponentUtilities.putPrivateFacet((UIComponent)this, FILECHOOSER_LOOKIN_TEXTFIELD_FACET, (UIComponent)child);
        }
        Theme theme = FileChooser.getTheme();
        child.setColumns(Integer.parseInt(theme.getMessage("filechooser.lookinColumn")));
        child.setStyleClass(theme.getStyleClass("FILECHOOSER_NAME_TXT").concat(" ").concat(theme.getStyleClass("FILECHOOSER_WIDTH_TXT")));
        int tindex = this.getTabIndex();
        if (tindex > 0 && tindex < Short.MAX_VALUE) {
            child.setTabIndex(tindex);
        }
        return child;
    }

    public UIComponent getLookInLabel() {
        UIComponent facet = this.getFacet(FILECHOOSER_LOOKIN_LABEL_FACET);
        if (facet != null) {
            return facet;
        }
        Label child = (Label)ComponentUtilities.getPrivateFacet((UIComponent)this, FILECHOOSER_LOOKIN_LABEL_FACET, true);
        if (child == null) {
            child = new Label();
            child.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, FILECHOOSER_LOOKIN_LABEL_FACET));
            child.setLabelLevel(2);
            ComponentUtilities.putPrivateFacet((UIComponent)this, FILECHOOSER_LOOKIN_LABEL_FACET, (UIComponent)child);
        }
        Theme theme = FileChooser.getTheme();
        child.setText(theme.getMessage("filechooser.lookin"));
        child.setFor(this.getLookInTextField().getClientId(this.getFacesContext()));
        return child;
    }

    public UIComponent getFilterTextField() {
        FacesContext context;
        ClientSniffer sniffer;
        TextField facet = (TextField)this.getFacet(FILECHOOSER_FILTERON_TEXTFIELD_FACET);
        if (facet != null) {
            return facet;
        }
        TextField child = (TextField)ComponentUtilities.getPrivateFacet((UIComponent)this, FILECHOOSER_FILTERON_TEXTFIELD_FACET, true);
        if (child == null) {
            child = new TextField();
            child.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, FILECHOOSER_FILTERON_TEXTFIELD_FACET));
            child.addValidator(new FileChooserFilterValidator());
            child.setSubmittedValue(this.getModel().getFilterValue());
            ComponentUtilities.putPrivateFacet((UIComponent)this, FILECHOOSER_FILTERON_TEXTFIELD_FACET, (UIComponent)child);
        }
        int size = (sniffer = ClientSniffer.getInstance(context = FacesContext.getCurrentInstance())).isNav6up() ? 32 : 18;
        child.setColumns(size);
        int tindex = this.getTabIndex();
        if (tindex > 0 && tindex < Short.MAX_VALUE) {
            child.setTabIndex(tindex);
        }
        return child;
    }

    public UIComponent getFilterLabel() {
        UIComponent facet = this.getFacet(FILECHOOSER_FILTER_LABEL_FACET);
        if (facet != null) {
            return facet;
        }
        Label child = (Label)ComponentUtilities.getPrivateFacet((UIComponent)this, FILECHOOSER_FILTER_LABEL_FACET, true);
        if (child == null) {
            child = new Label();
            child.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, FILECHOOSER_FILTER_LABEL_FACET));
            child.setLabelLevel(2);
            ComponentUtilities.putPrivateFacet((UIComponent)this, FILECHOOSER_FILTER_LABEL_FACET, (UIComponent)child);
        }
        Theme theme = FileChooser.getTheme();
        if (this.isFolderChooser()) {
            child.setText(theme.getMessage("filechooser.folderFilter"));
        } else {
            child.setText(theme.getMessage("filechooser.fileFilter"));
        }
        child.setFor(this.getFilterTextField().getClientId(this.getFacesContext()));
        return child;
    }

    public UIComponent getSelectedTextField() {
        UIComponent facet = this.getFacet(FILECHOOSER_SELECTED_TEXTFIELD_FACET);
        if (facet != null) {
            return facet;
        }
        TextField child = (TextField)ComponentUtilities.getPrivateFacet((UIComponent)this, FILECHOOSER_SELECTED_TEXTFIELD_FACET, true);
        if (child == null) {
            child = new TextField();
            child.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, FILECHOOSER_SELECTED_TEXTFIELD_FACET));
            child.addValidator(new FileChooserSelectValidator());
            ComponentUtilities.putPrivateFacet((UIComponent)this, FILECHOOSER_SELECTED_TEXTFIELD_FACET, (UIComponent)child);
        }
        Theme theme = FileChooser.getTheme();
        if (this.isMultiple()) {
            child.setColumns(Integer.parseInt(theme.getMessage("filechooser.multipleColumn")));
        } else {
            child.setColumns(Integer.parseInt(theme.getMessage("filechooser.singleColumn")));
        }
        if (this.isFolderChooser()) {
            child.setStyleClass(theme.getStyleClass("FILECHOOSER_FOLD_STYLE"));
        } else {
            child.setStyleClass(theme.getStyleClass("FILECHOOSER_FILE_STYLE"));
        }
        int tindex = this.getTabIndex();
        if (tindex > 0 && tindex < Short.MAX_VALUE) {
            child.setTabIndex(tindex);
        }
        return child;
    }

    public UIComponent getSelectLabel() {
        UIComponent facet = this.getFacet(FILECHOOSER_SELECT_LABEL_FACET);
        if (facet != null) {
            return facet;
        }
        Label child = (Label)ComponentUtilities.getPrivateFacet((UIComponent)this, FILECHOOSER_SELECT_LABEL_FACET, true);
        if (child == null) {
            child = new Label();
            child.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, FILECHOOSER_SELECT_LABEL_FACET));
            child.setLabelLevel(2);
            ComponentUtilities.putPrivateFacet((UIComponent)this, FILECHOOSER_SELECT_LABEL_FACET, (UIComponent)child);
        }
        Theme theme = FileChooser.getTheme();
        child.setFor(this.getSelectedTextField().getClientId(this.getFacesContext()));
        boolean ismultiple = this.isMultiple();
        String labelKey = this.isFolderChooser() ? (ismultiple ? "filechooser.selectedFolders" : "filechooser.selectedFolder") : (this.isFileAndFolderChooser() ? (ismultiple ? "filechooser.selectedFileAndFolders" : "filechooser.selectedFileAndFolder") : (ismultiple ? "filechooser.selectedFiles" : "filechooser.selectedFile"));
        child.setText(theme.getMessage(labelKey));
        return child;
    }

    public UIComponent getSortComponent() {
        ResourceModel zModel;
        String sortVal;
        UIComponent facet = this.getFacet(FILECHOOSER_SORTMENU_FACET);
        if (facet != null) {
            return facet;
        }
        DropDown jdd = (DropDown)ComponentUtilities.getPrivateFacet((UIComponent)this, FILECHOOSER_SORTMENU_FACET, true);
        if (jdd == null) {
            jdd = new DropDown();
            jdd.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, FILECHOOSER_SORTMENU_FACET));
            jdd.setSubmitForm(true);
            jdd.setLabelLevel(2);
            jdd.addValidator(new FileChooserSortValidator());
            jdd.setImmediate(true);
            ComponentUtilities.putPrivateFacet((UIComponent)this, FILECHOOSER_SORTMENU_FACET, (UIComponent)jdd);
        }
        Theme theme = FileChooser.getTheme();
        Option[] sortFields = new Option[]{new Option(ALPHABETIC_ASC, theme.getMessage("filechooser.sortOption1")), new Option(ALPHABETIC_DSC, theme.getMessage("filechooser.sortOption4")), new Option(LASTMODIFIED_ASC, theme.getMessage("filechooser.sortOption2")), new Option(LASTMODIFIED_DSC, theme.getMessage("filechooser.sortOption5")), new Option(SIZE_ASC, theme.getMessage("filechooser.sortOption3")), new Option(SIZE_DSC, theme.getMessage("filechooser.sortOption6"))};
        jdd.setItems(sortFields);
        jdd.setStyleClass(theme.getStyleClass("MENU_JUMP"));
        int tindex = this.getTabIndex();
        if (tindex > 0 && tindex < Short.MAX_VALUE) {
            jdd.setTabIndex(tindex);
        }
        if ((sortVal = (zModel = this.getModel()).getSortValue()) == null) {
            String sField = this.getSortField();
            sField = this.isDescending() ? sField.concat("d") : sField.concat("a");
            jdd.setSelected(sField);
            zModel.setSortValue(sField);
        } else {
            jdd.setSelected(sortVal);
        }
        return jdd;
    }

    public UIComponent getSortComponentLabel() {
        UIComponent facet = this.getFacet(FILECHOOSER_SORT_LABEL_FACET);
        if (facet != null) {
            return facet;
        }
        Label child = (Label)ComponentUtilities.getPrivateFacet((UIComponent)this, FILECHOOSER_SORT_LABEL_FACET, true);
        if (child == null) {
            child = new Label();
            child.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, FILECHOOSER_SORT_LABEL_FACET));
            child.setLabelLevel(2);
            ComponentUtilities.putPrivateFacet((UIComponent)this, FILECHOOSER_SORT_LABEL_FACET, (UIComponent)child);
        }
        Theme theme = FileChooser.getTheme();
        child.setText(theme.getMessage("filechooser.sortBy"));
        child.setFor(this.getSortComponent().getClientId(this.getFacesContext()));
        return child;
    }

    public UIComponent getListComponent() {
        Listbox fileList = (Listbox)ComponentUtilities.getPrivateFacet((UIComponent)this, FILECHOOSER_LISTBOX_FACET, true);
        if (fileList == null) {
            fileList = new Listbox();
            fileList.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, FILECHOOSER_LISTBOX_FACET));
            fileList.setMonospace(true);
            ComponentUtilities.putPrivateFacet((UIComponent)this, FILECHOOSER_LISTBOX_FACET, (UIComponent)fileList);
        }
        fileList.setRows(this.getRows());
        Theme theme = FileChooser.getTheme();
        if (this.isFolderChooser()) {
            fileList.setToolTip(theme.getMessage("filechooser.listTitleFolder"));
        } else if (this.isFileAndFolderChooser()) {
            fileList.setToolTip(theme.getMessage("filechooser.listTitleFileAndFolder"));
        } else {
            fileList.setToolTip(theme.getMessage("filechooser.listTitleFile"));
        }
        fileList.setMultiple(this.isMultiple());
        fileList.setValue(null);
        int tindex = this.getTabIndex();
        if (tindex > 0 && tindex < Short.MAX_VALUE) {
            fileList.setTabIndex(tindex);
        }
        return this.populateListComponent(fileList);
    }

    public UIComponent getUpLevelButton(boolean newDisabled) {
        UIComponent facet = this.getFacet(FILECHOOSER_UPLEVEL_BUTTON_FACET);
        if (facet != null) {
            return facet;
        }
        Theme theme = FileChooser.getTheme();
        Button child = (Button)ComponentUtilities.getPrivateFacet((UIComponent)this, FILECHOOSER_UPLEVEL_BUTTON_FACET, true);
        if (child == null) {
            child = new Button();
            child.setStyleClass(theme.getStyleClass("FILECHOOSER_IMG_BTN"));
            child.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, FILECHOOSER_UPLEVEL_BUTTON_FACET));
            child.setIcon("FC_UP_1LEVEL");
            child.setImmediate(true);
            ComponentUtilities.putPrivateFacet((UIComponent)this, FILECHOOSER_UPLEVEL_BUTTON_FACET, (UIComponent)child);
        }
        child.setText(theme.getMessage("filechooser.upOneLevel"));
        child.setToolTip(theme.getMessage("filechooser.upOneLevelTitle"));
        child.setDisabled(newDisabled);
        int tindex = this.getTabIndex();
        if (tindex > 0 && tindex < Short.MAX_VALUE) {
            child.setTabIndex(tindex);
        }
        return child;
    }

    public UIComponent getOpenFolderButton() {
        UIComponent facet = this.getFacet(FILECHOOSER_OPENFOLDER_BUTTON_FACET);
        if (facet != null) {
            return facet;
        }
        Theme theme = FileChooser.getTheme();
        Button child = (Button)ComponentUtilities.getPrivateFacet((UIComponent)this, FILECHOOSER_OPENFOLDER_BUTTON_FACET, true);
        if (child == null) {
            child = new Button();
            child.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, FILECHOOSER_OPENFOLDER_BUTTON_FACET));
            child.setDisabled(false);
            child.setImmediate(true);
            child.setIcon("FC_OPEN_FOLDER");
            ComponentUtilities.putPrivateFacet((UIComponent)this, FILECHOOSER_OPENFOLDER_BUTTON_FACET, (UIComponent)child);
        }
        child.setText(theme.getMessage("filechooser.openFolder"));
        child.setToolTip(theme.getMessage("filechooser.openFolderTitle"));
        int tindex = this.getTabIndex();
        if (tindex > 0 && tindex < Short.MAX_VALUE) {
            child.setTabIndex(tindex);
        }
        return child;
    }

    public UIComponent getHiddenFCButton() {
        Button child = (Button)ComponentUtilities.getPrivateFacet((UIComponent)this, FILECHOOSER_HIDDEN_BUTTON_FACET, true);
        if (child == null) {
            child = new Button();
            child.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, FILECHOOSER_HIDDEN_BUTTON_FACET));
            child.setPrimary(true);
            ComponentUtilities.putPrivateFacet((UIComponent)this, FILECHOOSER_HIDDEN_BUTTON_FACET, (UIComponent)child);
        }
        return child;
    }

    public void displayAlert(String summary, String detail, String[] summaryArgs, String[] detailArgs) {
        FacesContext context = FacesContext.getCurrentInstance();
        FacesMessage fmsg = FileChooser.createFacesMessage(summary, detail, summaryArgs, detailArgs);
        context.addMessage(this.getClientId(context), fmsg);
    }

    private static void log(String msg) {
        if (LogUtil.fineEnabled(FileChooser.class)) {
            LogUtil.fine(FileChooser.class, msg);
        }
    }

    private String getEncodedSelections() {
        Object value = this.getValue();
        Converter converter = this.getConverter();
        if (converter == null) {
            converter = this.getConverterFromValue(value);
        }
        String[] selections = null;
        try {
            selections = this.convertValueToStringArray(FacesContext.getCurrentInstance(), converter, value);
        }
        catch (ConverterException ce) {
            FileChooser.log("Failed to convert and encode initial selections.");
        }
        return FileChooser.encodeSelections(selections, this.getEscapeChar(), this.getDelimiterChar());
    }

    private static Theme getTheme() {
        return ThemeUtilities.getTheme(FacesContext.getCurrentInstance());
    }

    private static FacesMessage createFacesMessage(String summary, String detail, String[] summaryArgs, String[] detailArgs) {
        FacesContext context = FacesContext.getCurrentInstance();
        Theme theme = ThemeUtilities.getTheme(context);
        String summaryMsg = theme.getMessage(summary, summaryArgs);
        String detailMsg = theme.getMessage(detail, detailArgs);
        FacesMessage fmsg = new FacesMessage(FacesMessage.SEVERITY_ERROR, summaryMsg, detailMsg);
        return fmsg;
    }

    public ValueExpression getValueExpression(String name) {
        if (name.equals("selected")) {
            return super.getValueExpression("value");
        }
        return super.getValueExpression(name);
    }

    public void setValueExpression(String name, ValueExpression binding) {
        if (name.equals("selected")) {
            super.setValueExpression("value", binding);
            return;
        }
        super.setValueExpression(name, binding);
    }

    public boolean isRequired() {
        return super.isRequired();
    }

    public boolean isVisible() {
        if (this.visibleSet) {
            return this.visible;
        }
        ValueExpression vb = this.getValueExpression("visible");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return this.visible;
    }

    public void setVisible(boolean newVisible) {
        this.visible = newVisible;
        this.visibleSet = true;
    }

    public int getTabIndex() {
        if (this.tabIndexSet) {
            return this.tabIndex;
        }
        ValueExpression vb = this.getValueExpression("tabIndex");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return Integer.MIN_VALUE;
            }
            return (Integer)result;
        }
        return Integer.MIN_VALUE;
    }

    public void setTabIndex(int newTabIndex) {
        this.tabIndex = newTabIndex;
        this.tabIndexSet = true;
    }

    public Object getValue() {
        return super.getValue();
    }

    public boolean isDescending() {
        Object result;
        if (this.descendingSet) {
            return this.descending;
        }
        ValueExpression vb = this.getValueExpression("descending");
        if (vb != null && (result = vb.getValue(this.getFacesContext().getELContext())) != null) {
            return (Boolean)result;
        }
        boolean defaultValue = this.descending;
        try {
            defaultValue = Boolean.parseBoolean(FileChooser.getTheme().getMessage("filechooser.descending"));
        }
        catch (Exception e) {
            FileChooser.log("Failed to obtain the default value from the theme.Using the default value " + defaultValue + ".");
        }
        return defaultValue;
    }

    public void setDescending(boolean newDescending) {
        this.descending = newDescending;
        this.descendingSet = true;
    }

    public boolean isDisabled() {
        if (this.disabledSet) {
            return this.disabled;
        }
        ValueExpression vb = this.getValueExpression("disabled");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return false;
    }

    public void setDisabled(boolean newDisabled) {
        this.disabled = newDisabled;
        this.disabledSet = true;
    }

    private boolean doIsFolderChooser() {
        if (this.folderChooserSet) {
            return this.folderChooser;
        }
        ValueExpression vb = this.getValueExpression("folderChooser");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return false;
    }

    private void doSetFolderChooser(boolean newFolderChooser) {
        this.folderChooser = newFolderChooser;
        this.folderChooserSet = true;
    }

    public Object getLookin() {
        if (this.lookin != null) {
            return this.lookin;
        }
        ValueExpression vb = this.getValueExpression("lookin");
        if (vb != null) {
            return vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setLookin(Object newLookin) {
        this.lookin = newLookin;
    }

    private ResourceModel doGetModel() {
        if (this.model != null) {
            return this.model;
        }
        ValueExpression vb = this.getValueExpression("model");
        if (vb != null) {
            return (ResourceModel)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setModel(ResourceModel newModel) {
        this.model = newModel;
    }

    public boolean isMultiple() {
        if (this.multipleSet) {
            return this.multiple;
        }
        ValueExpression vb = this.getValueExpression("multiple");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return false;
    }

    public void setMultiple(boolean newMultiple) {
        this.multiple = newMultiple;
        this.multipleSet = true;
    }

    public boolean isReadOnly() {
        if (this.readOnlySet) {
            return this.readOnly;
        }
        ValueExpression vb = this.getValueExpression("readOnly");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return false;
    }

    public void setReadOnly(boolean newReadOnly) {
        this.readOnly = newReadOnly;
        this.readOnlySet = true;
    }

    public int getRows() {
        Object result;
        if (this.rowsSet) {
            return this.rows;
        }
        ValueExpression vb = this.getValueExpression("rows");
        if (vb != null && (result = vb.getValue(this.getFacesContext().getELContext())) != null && (Integer)result > 0) {
            return (Integer)result;
        }
        int defaultRows = this.rows;
        try {
            defaultRows = Integer.parseInt(FileChooser.getTheme().getMessage("filechooser.rows"));
            if (defaultRows < 1) {
                defaultRows = this.rows;
            }
        }
        catch (NumberFormatException e) {
            FileChooser.log("Failed to obtain the default value from the theme.Using the default value " + defaultRows + ".");
        }
        return defaultRows;
    }

    public void setRows(int newRows) {
        if (newRows < 1) {
            throw new IllegalArgumentException(FileChooser.getTheme().getMessage("filechooser.invalidRows"));
        }
        this.rows = newRows;
        this.rowsSet = true;
    }

    public Object getSelected() {
        return this.getValue();
    }

    public void setSelected(Object newSelected) {
        this.setValue(newSelected);
    }

    public String getSortField() {
        String result;
        if (this.sortFieldSet) {
            return this.sortField;
        }
        ValueExpression vb = this.getValueExpression("sortField");
        if (vb != null && ((result = (String)vb.getValue(this.getFacesContext().getELContext())) != null || result.trim().length() > 0) && ((result = result.trim()).equals(ALPHABETIC) || result.equals(SIZE) || result.equals(LASTMODIFIED))) {
            return result;
        }
        String defaultValue = FileChooser.getTheme().getMessage("filechooser.sortField");
        if (defaultValue == null || defaultValue.length() < 1) {
            defaultValue = this.sortField;
            FileChooser.log("Failed to obtain the default value from the theme.Using the default value " + defaultValue + ".");
        }
        return defaultValue;
    }

    public void setSortField(String newSortField) {
        if (newSortField == null) {
            throw new IllegalArgumentException(FileChooser.getTheme().getMessage("filechooser.nullSortField"));
        }
        String sort = newSortField.trim();
        if (sort.length() < 1) {
            throw new IllegalArgumentException(FileChooser.getTheme().getMessage("filechooser.whitespaceSortField"));
        }
        if (!(sort.equals(ALPHABETIC) || sort.equals(SIZE) || sort.equals(LASTMODIFIED))) {
            throw new IllegalArgumentException(FileChooser.getTheme().getMessage("filechooser.invalidSortField"));
        }
        this.sortField = sort;
        this.sortFieldSet = true;
    }

    public String getStyle() {
        if (this.style != null) {
            return this.style;
        }
        ValueExpression vb = this.getValueExpression("style");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setStyle(String newStyle) {
        this.style = newStyle;
    }

    public String getStyleClass() {
        if (this.styleClass != null) {
            return this.styleClass;
        }
        ValueExpression vb = this.getValueExpression("styleClass");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setStyleClass(String newStyleClass) {
        this.styleClass = newStyleClass;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        if (state == null) {
            return;
        }
        Object[] values = (Object[])((Object[])state)[0];
        super.restoreState(context, values[0]);
        this.descending = (Boolean)values[1];
        this.descendingSet = (Boolean)values[2];
        this.disabled = (Boolean)values[3];
        this.disabledSet = (Boolean)values[4];
        this.folderChooser = (Boolean)values[5];
        this.folderChooserSet = (Boolean)values[6];
        this.lookin = values[7];
        this.model = (ResourceModel)values[8];
        this.multiple = (Boolean)values[9];
        this.multipleSet = (Boolean)values[10];
        this.readOnly = (Boolean)values[11];
        this.readOnlySet = (Boolean)values[12];
        this.rows = (Integer)values[13];
        this.rowsSet = (Boolean)values[14];
        this.sortField = (String)values[15];
        this.style = (String)values[16];
        this.styleClass = (String)values[17];
        this.fileAndFolderChooser = (Boolean)((Object[])state)[1];
    }

    @Override
    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.descending ? Boolean.TRUE : Boolean.FALSE, this.descendingSet ? Boolean.TRUE : Boolean.FALSE, this.disabled ? Boolean.TRUE : Boolean.FALSE, this.disabledSet ? Boolean.TRUE : Boolean.FALSE, this.folderChooser ? Boolean.TRUE : Boolean.FALSE, this.folderChooserSet ? Boolean.TRUE : Boolean.FALSE, this.lookin, this.model, this.multiple ? Boolean.TRUE : Boolean.FALSE, this.multipleSet ? Boolean.TRUE : Boolean.FALSE, this.readOnly ? Boolean.TRUE : Boolean.FALSE, this.readOnlySet ? Boolean.TRUE : Boolean.FALSE, this.rows, this.rowsSet ? Boolean.TRUE : Boolean.FALSE, this.sortField, this.style, this.styleClass};
        Object[] values2 = new Object[]{values, this.fileAndFolderChooser ? Boolean.TRUE : Boolean.FALSE};
        return values2;
    }

    private static String encodeSelections(String[] selections, String escapeChar, String delimiter) {
        if (selections == null || selections.length == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder(FileChooser.escapeString(selections[0], escapeChar, delimiter));
        for (int i = 1; i < selections.length; ++i) {
            sb.append(delimiter);
            sb.append(FileChooser.escapeString(selections[i], escapeChar, delimiter));
        }
        return sb.toString();
    }

    private static String[] decodeSelections(String selections, String escapeChar, String delimiter) {
        if (selections == null) {
            return null;
        }
        char del = delimiter.toCharArray()[0];
        char esc = escapeChar.toCharArray()[0];
        char[] charArray = selections.toCharArray();
        int escseen = 0;
        int ind = 0;
        int j = 0;
        ArrayList<String> strArray = new ArrayList<String>();
        for (int i = 0; i < selections.length(); ++i) {
            if (charArray[i] == del && escseen % 2 == 0) {
                strArray.add(ind++, FileChooser.unescapeString(selections.substring(j, i), escapeChar, delimiter));
                j = i + 1;
            }
            if (charArray[i] == esc) {
                ++escseen;
                continue;
            }
            escseen = 0;
        }
        strArray.add(ind, FileChooser.unescapeString(selections.substring(j), escapeChar, delimiter));
        return strArray.toArray(new String[strArray.size()]);
    }

    private static String escapeString(String str, String escapeChar, String delimiter) {
        String escaped = escapeChar;
        if (escapeChar.equals("\\")) {
            escaped = escapeChar + escapeChar;
        }
        String regEx = escaped;
        String s0 = str.replaceAll(regEx, escaped + escaped);
        regEx = delimiter;
        s0 = s0.replaceAll(regEx, escaped + delimiter);
        return s0;
    }

    private static String unescapeString(String str, String escapeChar, String delimiter) {
        String escaped = escapeChar;
        if (escapeChar.equals("\\")) {
            escaped = escapeChar + escapeChar;
        }
        String regEx = escaped + delimiter;
        String s0 = str.replaceAll(regEx, delimiter);
        regEx = escaped + escaped;
        s0 = s0.replaceAll(regEx, escaped);
        return s0;
    }
}

