/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.DatePrototypeBuiltinsFactory;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.IsObjectNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.cast.JSNumberToBigIntNode;
import com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.oracle.truffle.js.nodes.cast.JSToObjectNode;
import com.oracle.truffle.js.nodes.cast.JSToPrimitiveNode;
import com.oracle.truffle.js.nodes.cast.OrdinaryToPrimitiveNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.intl.InitializeDateTimeFormatNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSDate;
import com.oracle.truffle.js.runtime.builtins.JSDateObject;
import com.oracle.truffle.js.runtime.builtins.intl.JSDateTimeFormat;
import com.oracle.truffle.js.runtime.builtins.intl.JSDateTimeFormatObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalInstant;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.util.TemporalUtil;
import java.util.EnumSet;

public final class DatePrototypeBuiltins {
    public static final JSBuiltinsContainer BUILTINS = JSBuiltinsContainer.fromEnum(JSDate.PROTOTYPE_NAME, DatePrototype.class);
    private static final boolean NO_UTC = false;

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum DatePrototype implements BuiltinEnum<DatePrototype>
    {
        valueOf(0),
        toString(0),
        toDateString(0),
        toTimeString(0),
        toLocaleString(0),
        toLocaleDateString(0),
        toLocaleTimeString(0),
        toUTCString(0),
        toISOString(0),
        getTime(0),
        getFullYear(0),
        getUTCFullYear(0),
        getMonth(0),
        getUTCMonth(0),
        getDate(0),
        getUTCDate(0),
        getDay(0),
        getUTCDay(0),
        getHours(0),
        getUTCHours(0),
        getMinutes(0),
        getUTCMinutes(0),
        getSeconds(0),
        getUTCSeconds(0),
        getMilliseconds(0),
        getUTCMilliseconds(0),
        setTime(1),
        setDate(1),
        setUTCDate(1),
        setFullYear(3),
        setUTCFullYear(3),
        setMonth(2),
        setUTCMonth(2),
        setHours(4),
        setUTCHours(4),
        setMinutes(3),
        setUTCMinutes(3),
        setSeconds(2),
        setUTCSeconds(2),
        setMilliseconds(1),
        setUTCMilliseconds(1),
        getTimezoneOffset(0),
        toJSON(1),
        _toPrimitive(1){

            @Override
            public Object getKey() {
                return Symbol.SYMBOL_TO_PRIMITIVE;
            }

            @Override
            public boolean isWritable() {
                return false;
            }
        }
        ,
        toTemporalInstant(0),
        getYear(0),
        setYear(1);

        private final int length;
        private final boolean isUTC;

        private DatePrototype(int length) {
            this.length = length;
            this.isUTC = this.name().startsWith("UTC", 2) || this.name().startsWith("UTC", 3);
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public boolean isAnnexB() {
            return EnumSet.of(getYear, setYear).contains(this);
        }

        @Override
        public boolean isOptional() {
            return this == toTemporalInstant;
        }

        @Override
        public int getECMAScriptVersion() {
            return switch (this.ordinal()) {
                case 43 -> 6;
                default -> BuiltinEnum.super.getECMAScriptVersion();
            };
        }

        @Override
        public Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget) {
            switch (this.ordinal()) {
                case 0: 
                case 9: {
                    return DatePrototypeBuiltinsFactory.JSDateValueOfNodeGen.create(context, builtin, this.args().withThis().createArgumentNodes(context));
                }
                case 1: 
                case 7: {
                    return DatePrototypeBuiltinsFactory.JSDateToStringNodeGen.create(context, builtin, this.isUTC, this.args().withThis().createArgumentNodes(context));
                }
                case 2: {
                    return DatePrototypeBuiltinsFactory.JSDateToDateStringNodeGen.create(context, builtin, this.args().withThis().createArgumentNodes(context));
                }
                case 3: {
                    return DatePrototypeBuiltinsFactory.JSDateToTimeStringNodeGen.create(context, builtin, this.args().withThis().createArgumentNodes(context));
                }
                case 4: {
                    return context.isOptionIntl402() ? DatePrototypeBuiltinsFactory.JSDateToStringIntlNodeGen.create(context, builtin, this.args().withThis().fixedArgs(2).createArgumentNodes(context)) : DatePrototypeBuiltinsFactory.JSDateToStringNodeGen.create(context, builtin, this.isUTC, this.args().withThis().createArgumentNodes(context));
                }
                case 5: {
                    return context.isOptionIntl402() ? DatePrototypeBuiltinsFactory.JSDateToLocaleDateStringIntlNodeGen.create(context, builtin, this.args().withThis().fixedArgs(2).createArgumentNodes(context)) : DatePrototypeBuiltinsFactory.JSDateToLocaleDateStringNodeGen.create(context, builtin, this.args().withThis().createArgumentNodes(context));
                }
                case 6: {
                    return context.isOptionIntl402() ? DatePrototypeBuiltinsFactory.JSDateToLocaleTimeStringIntlNodeGen.create(context, builtin, this.args().withThis().fixedArgs(2).createArgumentNodes(context)) : DatePrototypeBuiltinsFactory.JSDateToLocaleTimeStringNodeGen.create(context, builtin, this.args().withThis().createArgumentNodes(context));
                }
                case 8: {
                    return DatePrototypeBuiltinsFactory.JSDateToISOStringNodeGen.create(context, builtin, this.args().withThis().createArgumentNodes(context));
                }
                case 10: 
                case 11: {
                    return DatePrototypeBuiltinsFactory.JSDateGetFullYearNodeGen.create(context, builtin, this.isUTC, this.args().withThis().createArgumentNodes(context));
                }
                case 45: {
                    return DatePrototypeBuiltinsFactory.JSDateGetYearNodeGen.create(context, builtin, this.args().withThis().createArgumentNodes(context));
                }
                case 12: 
                case 13: {
                    return DatePrototypeBuiltinsFactory.JSDateGetMonthNodeGen.create(context, builtin, this.isUTC, this.args().withThis().createArgumentNodes(context));
                }
                case 14: 
                case 15: {
                    return DatePrototypeBuiltinsFactory.JSDateGetDateNodeGen.create(context, builtin, this.isUTC, this.args().withThis().createArgumentNodes(context));
                }
                case 16: 
                case 17: {
                    return DatePrototypeBuiltinsFactory.JSDateGetDayNodeGen.create(context, builtin, this.isUTC, this.args().withThis().createArgumentNodes(context));
                }
                case 18: 
                case 19: {
                    return DatePrototypeBuiltinsFactory.JSDateGetHoursNodeGen.create(context, builtin, this.isUTC, this.args().withThis().createArgumentNodes(context));
                }
                case 20: 
                case 21: {
                    return DatePrototypeBuiltinsFactory.JSDateGetMinutesNodeGen.create(context, builtin, this.isUTC, this.args().withThis().createArgumentNodes(context));
                }
                case 22: 
                case 23: {
                    return DatePrototypeBuiltinsFactory.JSDateGetSecondsNodeGen.create(context, builtin, this.isUTC, this.args().withThis().createArgumentNodes(context));
                }
                case 24: 
                case 25: {
                    return DatePrototypeBuiltinsFactory.JSDateGetMillisecondsNodeGen.create(context, builtin, this.isUTC, this.args().withThis().createArgumentNodes(context));
                }
                case 26: {
                    return DatePrototypeBuiltinsFactory.JSDateSetTimeNodeGen.create(context, builtin, this.args().withThis().fixedArgs(1).createArgumentNodes(context));
                }
                case 27: 
                case 28: {
                    return DatePrototypeBuiltinsFactory.JSDateSetDateNodeGen.create(context, builtin, this.isUTC, this.args().withThis().fixedArgs(1).createArgumentNodes(context));
                }
                case 29: 
                case 30: {
                    return DatePrototypeBuiltinsFactory.JSDateSetFullYearNodeGen.create(context, builtin, this.isUTC, this.args().withThis().varArgs().createArgumentNodes(context));
                }
                case 46: {
                    return DatePrototypeBuiltinsFactory.JSDateSetYearNodeGen.create(context, builtin, this.args().withThis().fixedArgs(1).createArgumentNodes(context));
                }
                case 31: 
                case 32: {
                    return DatePrototypeBuiltinsFactory.JSDateSetMonthNodeGen.create(context, builtin, this.isUTC, this.args().withThis().varArgs().createArgumentNodes(context));
                }
                case 33: 
                case 34: {
                    return DatePrototypeBuiltinsFactory.JSDateSetHoursNodeGen.create(context, builtin, this.isUTC, this.args().withThis().varArgs().createArgumentNodes(context));
                }
                case 35: 
                case 36: {
                    return DatePrototypeBuiltinsFactory.JSDateSetMinutesNodeGen.create(context, builtin, this.isUTC, this.args().withThis().varArgs().createArgumentNodes(context));
                }
                case 37: 
                case 38: {
                    return DatePrototypeBuiltinsFactory.JSDateSetSecondsNodeGen.create(context, builtin, this.isUTC, this.args().withThis().varArgs().createArgumentNodes(context));
                }
                case 39: 
                case 40: {
                    return DatePrototypeBuiltinsFactory.JSDateSetMillisecondsNodeGen.create(context, builtin, this.isUTC, this.args().withThis().fixedArgs(1).createArgumentNodes(context));
                }
                case 41: {
                    return DatePrototypeBuiltinsFactory.JSDateGetTimezoneOffsetNodeGen.create(context, builtin, this.args().withThis().createArgumentNodes(context));
                }
                case 42: {
                    return DatePrototypeBuiltinsFactory.JSDateToJSONNodeGen.create(context, builtin, this.args().withThis().fixedArgs(1).createArgumentNodes(context));
                }
                case 43: {
                    return DatePrototypeBuiltinsFactory.JSDateToPrimitiveNodeGen.create(context, builtin, this.args().withThis().fixedArgs(1).createArgumentNodes(context));
                }
                case 44: {
                    return DatePrototypeBuiltinsFactory.JSDateToTemporalInstantNodeGen.create(context, builtin, this.args().withThis().fixedArgs(1).createArgumentNodes(context));
                }
            }
            return null;
        }
    }

    public static abstract class JSDateToTemporalInstantNode
    extends JSDateOperation {
        public JSDateToTemporalInstantNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin, false);
        }

        @Specialization
        protected final Object toTemporalInstant(Object thisObject, @Cached JSNumberToBigIntNode numberToBigInt) {
            JSDateObject dateObject = this.asDate(thisObject);
            double t = dateObject.getTimeMillis();
            BigInt ns = numberToBigInt.executeBigInt(t).multiply(TemporalUtil.BI_NS_PER_MS);
            return JSTemporalInstant.create(this.getContext(), this.getRealm(), ns);
        }
    }

    public static abstract class JSDateToPrimitiveNode
    extends JSBuiltinNode {
        public JSDateToPrimitiveNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected final Object toPrimitive(Object obj, Object hint, @Cached IsObjectNode isObjectNode, @Cached DateToPrimitiveHelperNode dateToPrimitiveHelper, @Cached InlinedBranchProfile errorBranch) {
            if (isObjectNode.executeBoolean(obj)) {
                return dateToPrimitiveHelper.execute(this, obj, hint);
            }
            errorBranch.enter((Node)this);
            throw Errors.createTypeErrorNotAnObject(obj);
        }

        @GenerateInline
        @GenerateCached(value=false)
        @ImportStatic(value={Strings.class})
        static abstract class DateToPrimitiveHelperNode
        extends JavaScriptBaseNode {
            DateToPrimitiveHelperNode() {
            }

            abstract Object execute(Node var1, Object var2, Object var3);

            @Specialization(guards={"equals(strEqual, HINT_NUMBER, hint)"})
            static Object toPrimitiveHintNumber(Object obj, TruffleString hint, @Cached @Cached.Shared TruffleString.EqualNode strEqual, @Cached @Cached.Shared OrdinaryToPrimitiveNode ordinaryToPrimitive) {
                return ordinaryToPrimitive.execute(obj, JSToPrimitiveNode.Hint.Number);
            }

            @Specialization(guards={"equals(strEqual, HINT_STRING, hint) || equals(strEqual, HINT_DEFAULT, hint)"})
            static Object toPrimitiveHintStringOrDefault(Object obj, TruffleString hint, @Cached @Cached.Shared TruffleString.EqualNode strEqual, @Cached @Cached.Shared OrdinaryToPrimitiveNode ordinaryToPrimitive) {
                return ordinaryToPrimitive.execute(obj, JSToPrimitiveNode.Hint.String);
            }

            @Fallback
            static Object invalidHint(Object obj, Object hint) {
                assert (!(Strings.HINT_STRING.equals(hint) || Strings.HINT_NUMBER.equals(hint) || Strings.HINT_DEFAULT.equals(hint))) : hint;
                throw Errors.createTypeError("invalid hint");
            }
        }
    }

    public static abstract class JSDateToJSONNode
    extends JSBuiltinNode {
        @Node.Child
        private PropertyGetNode getToISOStringFnNode;
        @Node.Child
        private JSFunctionCallNode callToISOStringFnNode;
        @Node.Child
        private JSToObjectNode toObjectNode = JSToObjectNode.create();
        @Node.Child
        private JSToPrimitiveNode toPrimitiveNode = JSToPrimitiveNode.create();

        public JSDateToJSONNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object toJSON(Object thisDate, Object key) {
            double d;
            Object o = this.toObjectNode.execute(thisDate);
            Object tv = this.toPrimitiveNode.executeHintNumber(o);
            if (JSRuntime.isNumber(tv) && (Double.isInfinite(d = JSRuntime.doubleValue((Number)tv)) || Double.isNaN(d))) {
                return Null.instance;
            }
            Object toISO = this.getToISOStringFn(o);
            return this.getCallToISOStringFnNode().executeCall(JSArguments.create(o, toISO, JSArguments.EMPTY_ARGUMENTS_ARRAY));
        }

        private Object getToISOStringFn(Object obj) {
            if (this.getToISOStringFnNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getToISOStringFnNode = (PropertyGetNode)this.insert(PropertyGetNode.create(Strings.TO_ISO_STRING, false, this.getContext()));
            }
            return this.getToISOStringFnNode.getValue(obj);
        }

        private JSFunctionCallNode getCallToISOStringFnNode() {
            if (this.callToISOStringFnNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.callToISOStringFnNode = (JSFunctionCallNode)this.insert(JSFunctionCallNode.createCall());
            }
            return this.callToISOStringFnNode;
        }
    }

    public static abstract class JSDateGetTimezoneOffsetNode
    extends JSDateOperation {
        public JSDateGetTimezoneOffsetNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin, false);
        }

        @Specialization
        protected double getTimezoneOffset(Object thisDate) {
            double t = this.asDateMillis(thisDate);
            if (this.isNaN.profile(Double.isNaN(t))) {
                return Double.NaN;
            }
            return (t - JSDate.localTime(t, this)) / 60000.0;
        }
    }

    public static abstract class JSDateSetMillisecondsNode
    extends JSDateOperationWithToNumberNode {
        public JSDateSetMillisecondsNode(JSContext context, JSBuiltin builtin, boolean isUTC) {
            super(context, builtin, isUTC);
        }

        @Specialization
        protected double setMilliseconds(Object thisDate, Object msParam) {
            JSDateObject dateObject = this.asDate(thisDate);
            double t = dateObject.getTimeMillis();
            double ms = this.toDouble(msParam);
            if (Double.isNaN(t)) {
                return Double.NaN;
            }
            double u = JSDate.setMilliseconds(t, ms, this.isUTC, this);
            dateObject.setTimeMillis(u);
            return u;
        }
    }

    public static abstract class JSDateSetSecondsNode
    extends JSDateOperationWithToNumberNode {
        public JSDateSetSecondsNode(JSContext context, JSBuiltin builtin, boolean isUTC) {
            super(context, builtin, isUTC);
        }

        @Specialization
        protected double setSeconds(Object thisDate, Object[] args) {
            JSDateObject dateObject = this.asDate(thisDate);
            double t = dateObject.getTimeMillis();
            double sec = this.toDouble(JSRuntime.getArgOrUndefined(args, 0));
            double ms = this.toDouble(JSRuntime.getArgOrUndefined(args, 1));
            if (Double.isNaN(t)) {
                return Double.NaN;
            }
            double u = JSDate.setSeconds(t, sec, ms, args.length >= 2, this.isUTC, this);
            dateObject.setTimeMillis(u);
            return u;
        }
    }

    public static abstract class JSDateSetMinutesNode
    extends JSDateOperationWithToNumberNode {
        public JSDateSetMinutesNode(JSContext context, JSBuiltin builtin, boolean isUTC) {
            super(context, builtin, isUTC);
        }

        @Specialization
        protected double doOperation(Object thisDate, Object[] args) {
            JSDateObject dateObject = this.asDate(thisDate);
            double t = dateObject.getTimeMillis();
            double min = this.toDouble(JSRuntime.getArgOrUndefined(args, 0));
            double sec = this.toDouble(JSRuntime.getArgOrUndefined(args, 1));
            double ms = this.toDouble(JSRuntime.getArgOrUndefined(args, 2));
            if (Double.isNaN(t)) {
                return Double.NaN;
            }
            double u = JSDate.setMinutes(t, min, sec, args.length >= 2, ms, args.length >= 3, this.isUTC, this);
            dateObject.setTimeMillis(u);
            return u;
        }
    }

    public static abstract class JSDateSetHoursNode
    extends JSDateOperationWithToNumberNode {
        public JSDateSetHoursNode(JSContext context, JSBuiltin builtin, boolean isUTC) {
            super(context, builtin, isUTC);
        }

        @Specialization
        protected double setHours(Object thisDate, Object[] args) {
            JSDateObject dateObject = this.asDate(thisDate);
            double t = dateObject.getTimeMillis();
            double hour = this.toDouble(JSRuntime.getArgOrUndefined(args, 0));
            double min = this.toDouble(JSRuntime.getArgOrUndefined(args, 1));
            double sec = this.toDouble(JSRuntime.getArgOrUndefined(args, 2));
            double ms = this.toDouble(JSRuntime.getArgOrUndefined(args, 3));
            if (Double.isNaN(t)) {
                return Double.NaN;
            }
            double u = JSDate.setHours(t, hour, min, args.length >= 2, sec, args.length >= 3, ms, args.length >= 4, this.isUTC, this);
            dateObject.setTimeMillis(u);
            return u;
        }
    }

    public static abstract class JSDateSetMonthNode
    extends JSDateOperationWithToNumberNode {
        public JSDateSetMonthNode(JSContext context, JSBuiltin builtin, boolean isUTC) {
            super(context, builtin, isUTC);
        }

        @Specialization
        protected double setMonth(Object thisDate, Object[] args) {
            JSDateObject dateObject = this.asDate(thisDate);
            double t = dateObject.getTimeMillis();
            double month = this.toDouble(JSRuntime.getArgOrUndefined(args, 0));
            double date = this.toDouble(JSRuntime.getArgOrUndefined(args, 1));
            if (Double.isNaN(t)) {
                return Double.NaN;
            }
            double u = JSDate.setMonth(t, month, date, args.length >= 2, this.isUTC, this);
            dateObject.setTimeMillis(u);
            return u;
        }
    }

    public static abstract class JSDateSetFullYearNode
    extends JSDateOperationWithToNumberNode {
        public JSDateSetFullYearNode(JSContext context, JSBuiltin builtin, boolean isUTC) {
            super(context, builtin, isUTC);
        }

        @Specialization
        protected double setFullYear(Object thisDate, Object[] args) {
            JSDateObject dateObject = this.asDate(thisDate);
            double t = dateObject.getTimeMillis();
            double iYear = this.toDouble(JSRuntime.getArgOrUndefined(args, 0));
            double iMonth = this.toDouble(JSRuntime.getArgOrUndefined(args, 1));
            double iDay = this.toDouble(JSRuntime.getArgOrUndefined(args, 2));
            double u = JSDate.setFullYear(t, iYear, iMonth, args.length >= 2, iDay, args.length >= 3, this.isUTC, this);
            dateObject.setTimeMillis(u);
            return u;
        }
    }

    public static abstract class JSDateSetYearNode
    extends JSDateOperationWithToNumberNode {
        public JSDateSetYearNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin, false);
        }

        @Specialization
        protected double setYear(Object thisDate, Object year) {
            JSDateObject dateObject = this.asDate(thisDate);
            double t = dateObject.getTimeMillis();
            double u = JSDate.setYear(t, this.toDouble(year), this);
            dateObject.setTimeMillis(u);
            return u;
        }
    }

    public static abstract class JSDateSetDateNode
    extends JSDateOperationWithToNumberNode {
        public JSDateSetDateNode(JSContext context, JSBuiltin builtin, boolean isUTC) {
            super(context, builtin, isUTC);
        }

        @Specialization
        protected double doOperation(Object thisDate, Object date) {
            JSDateObject dateObject = this.asDate(thisDate);
            double t = dateObject.getTimeMillis();
            double dt = this.toDouble(date);
            if (Double.isNaN(t)) {
                return Double.NaN;
            }
            double u = JSDate.setDate(t, dt, this.isUTC, this);
            dateObject.setTimeMillis(u);
            return u;
        }
    }

    public static abstract class JSDateSetTimeNode
    extends JSDateOperationWithToNumberNode {
        public JSDateSetTimeNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin, false);
        }

        @Specialization
        protected double doOperation(Object thisDate, Object time) {
            return JSDate.setTime(this.asDate(thisDate), this.toDouble(time));
        }
    }

    public static abstract class JSDateGetMillisecondsNode
    extends JSDateOperation {
        public JSDateGetMillisecondsNode(JSContext context, JSBuiltin builtin, boolean isUTC) {
            super(context, builtin, isUTC);
        }

        @Specialization
        protected double doOperation(Object thisDate) {
            double t = this.asDateMillis(thisDate);
            if (this.isNaN.profile(Double.isNaN(t))) {
                return Double.NaN;
            }
            return JSDate.msFromTime(t);
        }
    }

    public static abstract class JSDateGetSecondsNode
    extends JSDateOperation {
        public JSDateGetSecondsNode(JSContext context, JSBuiltin builtin, boolean isUTC) {
            super(context, builtin, isUTC);
        }

        @Specialization
        protected double doOperation(Object thisDate) {
            double t = this.asDateMillis(thisDate);
            if (this.isNaN.profile(Double.isNaN(t))) {
                return Double.NaN;
            }
            if (!this.isUTC) {
                t = JSDate.localTime(t, this);
            }
            return JSDate.secFromTime(t);
        }
    }

    public static abstract class JSDateGetMinutesNode
    extends JSDateOperation {
        public JSDateGetMinutesNode(JSContext context, JSBuiltin builtin, boolean isUTC) {
            super(context, builtin, isUTC);
        }

        @Specialization
        protected double doOperation(Object thisDate) {
            double t = this.asDateMillis(thisDate);
            if (this.isNaN.profile(Double.isNaN(t))) {
                return Double.NaN;
            }
            if (!this.isUTC) {
                t = JSDate.localTime(t, this);
            }
            return JSDate.minFromTime(t);
        }
    }

    public static abstract class JSDateGetHoursNode
    extends JSDateOperation {
        public JSDateGetHoursNode(JSContext context, JSBuiltin builtin, boolean isUTC) {
            super(context, builtin, isUTC);
        }

        @Specialization
        protected double doOperation(Object thisDate) {
            double t = this.asDateMillis(thisDate);
            if (this.isNaN.profile(Double.isNaN(t))) {
                return Double.NaN;
            }
            if (!this.isUTC) {
                t = JSDate.localTime(t, this);
            }
            return JSDate.hourFromTime(t);
        }
    }

    public static abstract class JSDateGetDayNode
    extends JSDateOperation {
        public JSDateGetDayNode(JSContext context, JSBuiltin builtin, boolean isUTC) {
            super(context, builtin, isUTC);
        }

        @Specialization
        protected double doOperation(Object thisDate) {
            double t = this.asDateMillis(thisDate);
            if (this.isNaN.profile(Double.isNaN(t))) {
                return Double.NaN;
            }
            t = this.isUTC ? t : JSDate.localTime(t, this);
            return JSDate.weekDay(t);
        }
    }

    public static abstract class JSDateGetDateNode
    extends JSDateOperation {
        public JSDateGetDateNode(JSContext context, JSBuiltin builtin, boolean isUTC) {
            super(context, builtin, isUTC);
        }

        @Specialization
        protected double doOperation(Object thisDate) {
            double t = this.asDateMillis(thisDate);
            if (this.isNaN.profile(Double.isNaN(t))) {
                return Double.NaN;
            }
            t = this.isUTC ? t : JSDate.localTime(t, this);
            return JSDate.dateFromTime(t);
        }
    }

    public static abstract class JSDateGetMonthNode
    extends JSDateOperation {
        public JSDateGetMonthNode(JSContext context, JSBuiltin builtin, boolean isUTC) {
            super(context, builtin, isUTC);
        }

        @Specialization
        protected double doOperation(Object thisDate) {
            double t = this.asDateMillis(thisDate);
            if (Double.isNaN(t)) {
                return Double.NaN;
            }
            t = this.isUTC ? t : JSDate.localTime(t, this);
            return JSDate.monthFromTime(t);
        }
    }

    public static abstract class JSDateGetYearNode
    extends JSDateOperation {
        public JSDateGetYearNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin, false);
        }

        @Specialization
        protected double doOperation(Object thisDate) {
            double t = this.asDateMillis(thisDate);
            if (this.isNaN.profile(Double.isNaN(t))) {
                return Double.NaN;
            }
            t = JSDate.localTime(t, this);
            return (double)JSDate.yearFromTime((long)t) - 1900.0;
        }
    }

    public static abstract class JSDateGetFullYearNode
    extends JSDateOperation {
        public JSDateGetFullYearNode(JSContext context, JSBuiltin builtin, boolean isUTC) {
            super(context, builtin, isUTC);
        }

        @Specialization
        protected double doOperation(Object thisDate) {
            double t = this.asDateMillis(thisDate);
            if (this.isNaN.profile(Double.isNaN(t))) {
                return Double.NaN;
            }
            t = this.isUTC ? t : JSDate.localTime(t, this);
            return JSDate.yearFromTime((long)t);
        }
    }

    public static abstract class JSDateToISOStringNode
    extends JSDateOperation {
        public JSDateToISOStringNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin, false);
        }

        @Specialization
        protected TruffleString doOperation(Object thisDate) {
            double t = this.asDateMillis(thisDate);
            JSDateToISOStringNode.checkTimeValid(t);
            return JSDate.toISOStringIntl(t, this.getRealm());
        }
    }

    public static abstract class JSDateToLocaleTimeStringIntlNode
    extends JSDateOperation {
        @Node.Child
        InitializeDateTimeFormatNode initDateTimeFormatNode;

        public JSDateToLocaleTimeStringIntlNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin, false);
            this.initDateTimeFormatNode = InitializeDateTimeFormatNode.createInitalizeDateTimeFormatNode(context, InitializeDateTimeFormatNode.Required.TIME, InitializeDateTimeFormatNode.Defaults.TIME);
        }

        @Specialization
        protected TruffleString doOperation(Object thisDate, Object locales, Object options) {
            double t = this.asDateMillis(thisDate);
            if (this.isNaN.profile(Double.isNaN(t))) {
                return JSDate.INVALID_DATE_STRING;
            }
            JSDateTimeFormatObject formatter = this.createDateTimeFormat(this.initDateTimeFormatNode, locales, options);
            return JSDateTimeFormat.format(formatter, t);
        }
    }

    public static abstract class JSDateToLocaleTimeStringNode
    extends JSDateOperation {
        public JSDateToLocaleTimeStringNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin, false);
        }

        @Specialization
        protected TruffleString doOperation(Object thisDate) {
            double t = this.asDateMillis(thisDate);
            if (this.isNaN.profile(Double.isNaN(t))) {
                return JSDate.INVALID_DATE_STRING;
            }
            return JSDate.format(this.getRealm().getJSShortTimeLocalFormat(), t);
        }
    }

    public static abstract class JSDateToLocaleDateStringIntlNode
    extends JSDateOperation {
        @Node.Child
        InitializeDateTimeFormatNode initDateTimeFormatNode;

        public JSDateToLocaleDateStringIntlNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin, false);
            this.initDateTimeFormatNode = InitializeDateTimeFormatNode.createInitalizeDateTimeFormatNode(context, InitializeDateTimeFormatNode.Required.DATE, InitializeDateTimeFormatNode.Defaults.DATE);
        }

        @Specialization
        protected TruffleString doOperation(Object thisDate, Object locales, Object options) {
            double t = this.asDateMillis(thisDate);
            if (this.isNaN.profile(Double.isNaN(t))) {
                return JSDate.INVALID_DATE_STRING;
            }
            JSDateTimeFormatObject formatter = this.createDateTimeFormat(this.initDateTimeFormatNode, locales, options);
            return JSDateTimeFormat.format(formatter, t);
        }
    }

    public static abstract class JSDateToLocaleDateStringNode
    extends JSDateOperation {
        public JSDateToLocaleDateStringNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin, false);
        }

        @Specialization
        protected TruffleString doOperation(Object thisDate) {
            double t = this.asDateMillis(thisDate);
            if (this.isNaN.profile(Double.isNaN(t))) {
                return JSDate.INVALID_DATE_STRING;
            }
            return JSDate.format(this.getRealm().getJSShortDateLocalFormat(), t);
        }
    }

    public static abstract class JSDateToTimeStringNode
    extends JSDateOperation {
        public JSDateToTimeStringNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin, false);
        }

        @Specialization
        protected TruffleString doOperation(Object thisDate) {
            double t = this.asDateMillis(thisDate);
            if (this.isNaN.profile(Double.isNaN(t))) {
                return JSDate.INVALID_DATE_STRING;
            }
            return JSDate.format(this.getRealm().getJSShortTimeFormat(), t);
        }
    }

    public static abstract class JSDateToDateStringNode
    extends JSDateOperation {
        public JSDateToDateStringNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin, false);
        }

        @Specialization
        protected TruffleString doOperation(Object thisDate) {
            double t = this.asDateMillis(thisDate);
            if (this.isNaN.profile(Double.isNaN(t))) {
                return JSDate.INVALID_DATE_STRING;
            }
            return JSDate.format(this.getRealm().getJSShortDateFormat(), t);
        }
    }

    public static abstract class JSDateToStringIntlNode
    extends JSDateOperation {
        @Node.Child
        InitializeDateTimeFormatNode initDateTimeFormatNode;

        public JSDateToStringIntlNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin, false);
            this.initDateTimeFormatNode = InitializeDateTimeFormatNode.createInitalizeDateTimeFormatNode(context, InitializeDateTimeFormatNode.Required.ANY, InitializeDateTimeFormatNode.Defaults.ALL);
        }

        @Specialization
        protected TruffleString doOperation(Object thisDate, Object locales, Object options) {
            double t = this.asDateMillis(thisDate);
            if (this.isNaN.profile(Double.isNaN(t))) {
                return JSDate.INVALID_DATE_STRING;
            }
            JSDateTimeFormatObject formatter = this.createDateTimeFormat(this.initDateTimeFormatNode, locales, options);
            return JSDateTimeFormat.format(formatter, t);
        }
    }

    public static abstract class JSDateToStringNode
    extends JSDateOperation {
        public JSDateToStringNode(JSContext context, JSBuiltin builtin, boolean isUTC) {
            super(context, builtin, isUTC);
        }

        @Specialization
        protected TruffleString doOperation(Object thisDate) {
            double t = this.asDateMillis(thisDate);
            if (this.isUTC) {
                if (this.isNaN.profile(Double.isNaN(t))) {
                    return JSDate.INVALID_DATE_STRING;
                }
                return JSDate.format(this.getRealm().getJSDateUTCFormat(), t);
            }
            return JSDate.toString(t, this.getRealm());
        }
    }

    public static abstract class JSDateValueOfNode
    extends JSDateOperation {
        public JSDateValueOfNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin, false);
        }

        @Specialization
        protected double doOperation(Object thisDate) {
            return this.asDateMillis(thisDate);
        }
    }

    public static abstract class JSDateOperationWithToNumberNode
    extends JSDateOperation {
        @Node.Child
        protected JSToNumberNode toNumberNode = JSToNumberNode.create();

        public JSDateOperationWithToNumberNode(JSContext context, JSBuiltin builtin, boolean isUTC) {
            super(context, builtin, isUTC);
        }

        protected double toDouble(Object target) {
            return JSRuntime.doubleValue(this.toNumberNode.executeNumber(target));
        }
    }

    public static abstract class JSDateOperation
    extends JSBuiltinNode {
        protected final boolean isUTC;
        private final ConditionProfile isDate = ConditionProfile.create();
        protected final ConditionProfile isNaN = ConditionProfile.create();
        @Node.Child
        private InteropLibrary interopLibrary;

        public JSDateOperation(JSContext context, JSBuiltin builtin, boolean isUTC) {
            super(context, builtin);
            this.isUTC = isUTC;
        }

        protected final JSDateObject asDate(Object object) {
            if (this.isDate.profile(JSDate.isJSDate(object))) {
                return (JSDateObject)((Object)object);
            }
            throw Errors.createTypeErrorNotADate();
        }

        protected final double asDateMillis(Object thisDate) {
            if (this.isDate.profile(JSDate.isJSDate(thisDate))) {
                return ((JSDateObject)((Object)thisDate)).getTimeMillis();
            }
            InteropLibrary interop = this.interopLibrary;
            if (interop == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.interopLibrary = interop = (InteropLibrary)this.insert((Node)((InteropLibrary)InteropLibrary.getFactory().createDispatched(5)));
            }
            if (interop.isInstant(thisDate)) {
                return JSDate.getDateValueFromInstant(thisDate, interop);
            }
            throw Errors.createTypeErrorNotADate();
        }

        protected static void checkTimeValid(double time) {
            if (!JSDate.isTimeValid(time)) {
                throw Errors.createRangeError("time value is not a finite number");
            }
        }

        protected JSDateTimeFormatObject createDateTimeFormat(InitializeDateTimeFormatNode initDateTimeFormatNode, Object locales, Object options) {
            JSDateTimeFormatObject dateTimeFormatObj = JSDateTimeFormat.create(this.getContext(), this.getRealm());
            initDateTimeFormatNode.executeInit(dateTimeFormatObj, locales, options);
            return dateTimeFormatObj;
        }
    }
}

