/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.helper;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedCountingConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.helper.IsPristineObjectNode;
import com.oracle.truffle.js.builtins.helper.JSRegExpExecIntlNodeGen;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.IsJSClassNode;
import com.oracle.truffle.js.nodes.access.IsJSObjectNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.nodes.cast.JSToLengthNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.unary.IsCallableNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSArrayObject;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.builtins.JSRegExp;
import com.oracle.truffle.js.runtime.builtins.JSRegExpObject;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.TRegexUtil;

public abstract class JSRegExpExecIntlNode
extends JavaScriptBaseNode {
    static final int LIMIT = 3;
    protected final JSContext context;
    @Node.Child
    private PropertyGetNode getExecNode;
    @Node.Child
    private IsJSObjectNode isJSObjectNode;
    @Node.Child
    private IsPristineObjectNode isPristineObjectNode;
    @Node.Child
    private IsCallableNode isCallableNode = IsCallableNode.create();
    @Node.Child
    private JSFunctionCallNode specialCallNode;

    JSRegExpExecIntlNode(JSContext context) {
        this.context = context;
    }

    @NeverDefault
    public static JSRegExpExecIntlNode create(JSContext context) {
        return JSRegExpExecIntlNodeGen.create(context);
    }

    public abstract Object execute(Object var1, TruffleString var2);

    @Specialization
    protected final Object doRegExp(JSRegExpObject regExp, TruffleString input, @Cached(value="create(context)") JSRegExpExecBuiltinNode builtinExec, @Cached InlinedConditionProfile isPristineProfile, @Cached @Cached.Shared InlinedConditionProfile isCallableProfile, @Cached @Cached.Shared InlinedConditionProfile validResultProfile) {
        if (this.context.getEcmaScriptVersion() >= 6) {
            if (isPristineProfile.profile((Node)this, this.isPristine(regExp))) {
                return builtinExec.execute(regExp, input);
            }
            Object exec = this.getExecProperty(regExp);
            if (isCallableProfile.profile((Node)this, this.isCallable(exec))) {
                return this.callJSFunction(regExp, input, exec, validResultProfile);
            }
        }
        return builtinExec.execute(regExp, input);
    }

    @Fallback
    protected final Object doOther(Object regExp, TruffleString input, @Cached @Cached.Shared InlinedConditionProfile isCallableProfile, @Cached @Cached.Shared InlinedConditionProfile validResultProfile) {
        assert (!JSRegExp.isJSRegExp(regExp));
        Object exec = this.getExecProperty(regExp);
        if (isCallableProfile.profile((Node)this, this.isCallable(exec))) {
            return this.callJSFunction(regExp, input, exec, validResultProfile);
        }
        throw Errors.createTypeError("RegExp expected");
    }

    private Object callJSFunction(Object regExp, Object input, Object exec, InlinedConditionProfile validResultProfile) {
        Object result = this.doCallJSFunction(exec, regExp, input);
        if (validResultProfile.profile((Node)this, result == Null.instance || this.isJSObject(result) && result != Undefined.instance)) {
            return result;
        }
        throw Errors.createTypeError("object or null expected");
    }

    private boolean isPristine(JSDynamicObject regExp) {
        if (this.isPristineObjectNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.isPristineObjectNode = (IsPristineObjectNode)this.insert(IsPristineObjectNode.createRegExpExecAndMatch(this.context));
        }
        return this.isPristineObjectNode.execute(regExp);
    }

    private Object getExecProperty(Object regExp) {
        if (this.getExecNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.getExecNode = (PropertyGetNode)this.insert(PropertyGetNode.create(Strings.EXEC, false, this.context));
        }
        return this.getExecNode.getValue(regExp);
    }

    private boolean isCallable(Object obj) {
        if (this.isCallableNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.isCallableNode = (IsCallableNode)this.insert(IsCallableNode.create());
        }
        return this.isCallableNode.executeBoolean(obj);
    }

    private boolean isJSObject(Object obj) {
        if (this.isJSObjectNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.isJSObjectNode = (IsJSObjectNode)this.insert(IsJSObjectNode.create());
        }
        return this.isJSObjectNode.executeBoolean(obj);
    }

    private Object doCallJSFunction(Object exec, Object regExp, Object input) {
        if (this.specialCallNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.specialCallNode = (JSFunctionCallNode)this.insert(JSFunctionCallNode.createCall());
        }
        return this.specialCallNode.executeCall(JSArguments.createOneArg(regExp, exec, input));
    }

    @NeverDefault
    public static IsJSClassNode createIsJSRegExpNode() {
        return IsJSClassNode.create(JSRegExp.INSTANCE);
    }

    private static Object executeCompiledRegex(Object compiledRegex, Object input, long fromIndex, Node node, TRegexUtil.InvokeExecMethodNode invokeExec) {
        return TRegexUtil.TRegexCompiledRegexAccessor.exec(compiledRegex, input, fromIndex, node, invokeExec);
    }

    @GenerateCached(alwaysInlineCached=true)
    @ImportStatic(value={JSRegExp.class, JSRegExpExecIntlNode.class})
    public static abstract class JSRegExpExecBuiltinNode
    extends JavaScriptBaseNode {
        private final JSContext context;
        @Node.Child
        private PropertySetNode setRegexResultNode;
        @Node.Child
        private PropertySetNode setRegexOriginalInputNode;
        @Node.Child
        private DynamicObjectLibrary setInputNode;
        @Node.Child
        private DynamicObjectLibrary setIndexNode;
        @Node.Child
        private DynamicObjectLibrary setGroupsNode;
        @Node.Child
        private DynamicObjectLibrary setIndicesNode;
        @Node.Child
        private DynamicObjectLibrary setIndicesRegexResultNode;
        @Node.Child
        private DynamicObjectLibrary setIndicesGroupsNode;
        private final int ecmaScriptVersion;
        @Node.Child
        private JSToLengthNode toLengthNode;
        @Node.Child
        private PropertyGetNode getLastIndexNode;
        @Node.Child
        private PropertySetNode setLastIndexNode;
        @Node.Child
        private BuildGroupsObjectNode groupsBuilder;

        JSRegExpExecBuiltinNode(JSContext context) {
            this.context = context;
            this.ecmaScriptVersion = context.getEcmaScriptVersion();
            this.setRegexResultNode = PropertySetNode.createSetHidden(JSArray.LAZY_REGEX_RESULT_ID, context);
            this.setRegexOriginalInputNode = PropertySetNode.createSetHidden(JSArray.LAZY_REGEX_ORIGINAL_INPUT_ID, context);
            this.setInputNode = JSObjectUtil.createDispatched(JSRegExp.INPUT);
            this.setIndexNode = JSObjectUtil.createDispatched(JSRegExp.INDEX);
            this.setGroupsNode = JSObjectUtil.createDispatched(JSRegExp.GROUPS);
            this.setIndicesNode = JSObjectUtil.createDispatched(JSRegExp.INDICES);
            this.setIndicesRegexResultNode = JSObjectUtil.createDispatched(JSArray.LAZY_REGEX_RESULT_ID);
            this.setIndicesGroupsNode = JSObjectUtil.createDispatched(JSRegExp.GROUPS);
            this.getLastIndexNode = PropertyGetNode.create(JSRegExp.LAST_INDEX, context);
            this.toLengthNode = JSToLengthNode.create();
        }

        @NeverDefault
        public static JSRegExpExecBuiltinNode create(JSContext context) {
            return JSRegExpExecIntlNodeGen.JSRegExpExecBuiltinNodeGen.create(context);
        }

        private Object getEmptyResult() {
            return this.ecmaScriptVersion >= 6 ? Null.instance : this.context.getTRegexEmptyResult();
        }

        public abstract Object execute(JSRegExpObject var1, TruffleString var2);

        @Specialization(guards={"getCompiledRegex(regExp) == cachedCompiledRegex"}, limit="LIMIT")
        Object doCached(JSRegExpObject regExp, TruffleString input, @Bind Node node, @Cached(value="getCompiledRegex(regExp)") Object cachedCompiledRegex, @Cached @Cached.Shared InlinedConditionProfile invalidLastIndex, @Cached @Cached.Shared InlinedCountingConditionProfile match, @Cached @Cached.Shared InlinedConditionProfile areLegacyFeaturesEnabled, @Cached @Cached.Shared TRegexUtil.InteropReadBooleanMemberNode readIsMatch, @Cached @Cached.Shared TRegexUtil.InvokeGetGroupBoundariesMethodNode getStart, @Cached @Cached.Shared TRegexUtil.InvokeGetGroupBoundariesMethodNode getEnd, @Cached @Cached.Shared TRegexUtil.InvokeExecMethodNode invokeExec, @Cached @Cached.Shared TRegexUtil.InteropReadMemberNode readFlags, @Cached @Cached.Shared TRegexUtil.InteropReadBooleanMemberNode readGlobal, @Cached @Cached.Shared TRegexUtil.InteropReadBooleanMemberNode readSticky, @Cached @Cached.Shared TRegexUtil.InteropReadBooleanMemberNode readHasIndices, @Cached @Cached.Shared TRegexUtil.InteropReadIntMemberNode readGroupCount) {
            return this.doExec(regExp, cachedCompiledRegex, input, node, invalidLastIndex, match, areLegacyFeaturesEnabled, readIsMatch, getStart, getEnd, invokeExec, readFlags, readGlobal, readSticky, readHasIndices, readGroupCount);
        }

        @Specialization(replaces={"doCached"})
        Object doDynamic(JSRegExpObject regExp, TruffleString input, @Bind Node node, @Cached @Cached.Shared InlinedConditionProfile invalidLastIndex, @Cached @Cached.Shared InlinedCountingConditionProfile match, @Cached @Cached.Shared InlinedConditionProfile areLegacyFeaturesEnabled, @Cached @Cached.Shared TRegexUtil.InteropReadBooleanMemberNode readIsMatch, @Cached @Cached.Shared TRegexUtil.InvokeGetGroupBoundariesMethodNode getStart, @Cached @Cached.Shared TRegexUtil.InvokeGetGroupBoundariesMethodNode getEnd, @Cached @Cached.Shared TRegexUtil.InvokeExecMethodNode invokeExec, @Cached @Cached.Shared TRegexUtil.InteropReadMemberNode readFlags, @Cached @Cached.Shared TRegexUtil.InteropReadBooleanMemberNode readGlobal, @Cached @Cached.Shared TRegexUtil.InteropReadBooleanMemberNode readSticky, @Cached @Cached.Shared TRegexUtil.InteropReadBooleanMemberNode readHasIndices, @Cached @Cached.Shared TRegexUtil.InteropReadIntMemberNode readGroupCount) {
            return this.doExec(regExp, JSRegExp.getCompiledRegex(regExp), input, node, invalidLastIndex, match, areLegacyFeaturesEnabled, readIsMatch, getStart, getEnd, invokeExec, readFlags, readGlobal, readSticky, readHasIndices, readGroupCount);
        }

        private Object doExec(JSRegExpObject regExp, Object compiledRegex, TruffleString input, Node node, InlinedConditionProfile invalidLastIndex, InlinedCountingConditionProfile match, InlinedConditionProfile areLegacyFeaturesEnabled, TRegexUtil.InteropReadBooleanMemberNode readIsMatch, TRegexUtil.InvokeGetGroupBoundariesMethodNode getStart, TRegexUtil.InvokeGetGroupBoundariesMethodNode getEnd, TRegexUtil.InvokeExecMethodNode invokeExec, TRegexUtil.InteropReadMemberNode readFlags, TRegexUtil.InteropReadBooleanMemberNode readGlobal, TRegexUtil.InteropReadBooleanMemberNode readSticky, TRegexUtil.InteropReadBooleanMemberNode readHasIndices, TRegexUtil.InteropReadIntMemberNode readGroupCount) {
            Object flags = TRegexUtil.TRegexCompiledRegexAccessor.flags(compiledRegex, node, readFlags);
            boolean global = TRegexUtil.TRegexFlagsAccessor.global(flags, node, readGlobal);
            boolean sticky = this.ecmaScriptVersion >= 6 && TRegexUtil.TRegexFlagsAccessor.sticky(flags, node, readSticky);
            boolean hasIndices = TRegexUtil.TRegexFlagsAccessor.hasIndices(flags, node, readHasIndices);
            long lastIndex = this.getLastIndex(regExp);
            if (global || sticky) {
                if (invalidLastIndex.profile(node, lastIndex < 0L || lastIndex > (long)Strings.length(input))) {
                    this.setLastIndex(regExp, 0);
                    return this.getEmptyResult();
                }
            } else {
                lastIndex = 0L;
            }
            JSRealm thisRealm = this.getRealm();
            Object result = JSRegExpExecIntlNode.executeCompiledRegex(compiledRegex, input, lastIndex, node, invokeExec);
            if (this.context.isOptionRegexpStaticResult() && TRegexUtil.TRegexResultAccessor.isMatch(result, node, readIsMatch) && this.isSameRealm(regExp, thisRealm)) {
                if (areLegacyFeaturesEnabled.profile(node, JSRegExp.getLegacyFeaturesEnabled(regExp))) {
                    thisRealm.setStaticRegexResult(this.context, compiledRegex, input, lastIndex, result);
                } else {
                    thisRealm.invalidateStaticRegexResult();
                }
            }
            if (match.profile(node, TRegexUtil.TRegexResultAccessor.isMatch(result, node, readIsMatch))) {
                assert (!sticky || (long)TRegexUtil.TRegexResultAccessor.captureGroupStart(result, 0, node, getStart) == lastIndex);
                if (global || sticky) {
                    this.setLastIndex(regExp, TRegexUtil.TRegexResultAccessor.captureGroupEnd(result, 0, node, getEnd));
                }
                if (this.ecmaScriptVersion < 6) {
                    return result;
                }
                int groupCount = TRegexUtil.TRegexCompiledRegexAccessor.groupCount(compiledRegex, node, readGroupCount);
                return this.getMatchResult(regExp, result, groupCount, input, hasIndices, thisRealm);
            }
            if (this.ecmaScriptVersion < 8 || global || sticky) {
                this.setLastIndex(regExp, 0);
            }
            return this.getEmptyResult();
        }

        private boolean isSameRealm(JSRegExpObject regExp, JSRealm thisRealm) {
            if (this.context.isSingleRealm()) {
                assert (JSRegExp.getRealm(regExp) == thisRealm);
                return true;
            }
            return JSRegExp.getRealm(regExp) == thisRealm;
        }

        private JSArrayObject getMatchResult(JSRegExpObject regExp, Object regexResult, int groupCount, TruffleString inputStr, boolean hasIndices, JSRealm realm) {
            JSDynamicObject groups = this.getGroupsObject(regExp, regexResult, inputStr, false);
            JSArrayObject resultArray = JSArray.createLazyRegexArray(this.context, realm, groupCount);
            this.setRegexResultNode.setValue(resultArray, regexResult);
            this.setRegexOriginalInputNode.setValue(resultArray, inputStr);
            this.setIndexNode.putConstant((DynamicObject)resultArray, (Object)JSRegExp.INDEX, (Object)JSRegExp.LAZY_INDEX_PROXY, JSAttributes.getDefault() | 0x10);
            this.setInputNode.put((DynamicObject)resultArray, (Object)JSRegExp.INPUT, (Object)inputStr);
            this.setGroupsNode.put((DynamicObject)resultArray, (Object)JSRegExp.GROUPS, (Object)groups);
            if (this.context.isOptionRegexpMatchIndices() && hasIndices) {
                JSDynamicObject indicesGroups = this.getGroupsObject(regExp, regexResult, inputStr, true);
                JSArrayObject indicesArray = JSArray.createLazyRegexIndicesArray(this.context, realm, groupCount);
                this.setIndicesRegexResultNode.put((DynamicObject)indicesArray, (Object)JSRegExp.GROUPS_RESULT_ID, regexResult);
                this.setIndicesGroupsNode.put((DynamicObject)indicesArray, (Object)JSRegExp.GROUPS, (Object)indicesGroups);
                this.setIndicesNode.put((DynamicObject)resultArray, (Object)JSRegExp.INDICES, (Object)indicesArray);
            }
            return resultArray;
        }

        private JSDynamicObject getGroupsObject(JSRegExpObject regExp, Object result, Object input, boolean isIndices) {
            if (this.groupsBuilder == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.groupsBuilder = (BuildGroupsObjectNode)this.insert(BuildGroupsObjectNode.create());
            }
            return this.groupsBuilder.execute(regExp, result, input, isIndices);
        }

        private long getLastIndex(JSDynamicObject regExp) {
            Object lastIndex = this.getLastIndexNode.getValue((Object)regExp);
            if (this.ecmaScriptVersion < 6) {
                return JSRuntime.toInteger(lastIndex);
            }
            return this.toLengthNode.executeLong(lastIndex);
        }

        private void setLastIndex(JSDynamicObject regExp, int value) {
            if (this.setLastIndexNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.setLastIndexNode = (PropertySetNode)this.insert(PropertySetNode.create(JSRegExp.LAST_INDEX, false, this.context, true));
            }
            this.setLastIndexNode.setValueInt((Object)regExp, value);
        }
    }

    @ImportStatic(value={JSRegExp.class, JSRegExpExecIntlNode.class})
    public static abstract class BuildGroupsObjectNode
    extends JavaScriptBaseNode {
        public static BuildGroupsObjectNode create() {
            return JSRegExpExecIntlNodeGen.BuildGroupsObjectNodeGen.create();
        }

        public abstract JSDynamicObject execute(JSRegExpObject var1, Object var2, Object var3, boolean var4);

        @Specialization(guards={"getGroupsFactory(regExp) == cachedGroupsFactory || getCompiledRegex(regExp) == cachedCompiledRegex"}, limit="LIMIT")
        final JSDynamicObject doCachedGroupsFactory(JSRegExpObject regExp, Object regexResult, TruffleString input, boolean isIndices, @Cached(value="getCompiledRegex(regExp)") Object cachedCompiledRegex, @Cached(value="getGroupsFactory(regExp)") JSObjectFactory cachedGroupsFactory, @Cached(value="createIsJSRegExpNode()") IsJSClassNode isJSRegExpNode) {
            return BuildGroupsObjectNode.doIt(this.getRealm(), cachedGroupsFactory, regexResult, input, isIndices);
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        final JSDynamicObject doVaryingGroupsFactory(JSRegExpObject regExp, Object regexResult, TruffleString input, boolean isIndices) {
            return BuildGroupsObjectNode.doIt(this.getRealm(), JSRegExp.getGroupsFactory(regExp), regexResult, input, isIndices);
        }

        private static JSDynamicObject doIt(JSRealm realm, JSObjectFactory groupsFactory, Object regexResult, TruffleString input, boolean isIndices) {
            if (groupsFactory == null) {
                return Undefined.instance;
            }
            return JSRegExp.createGroupsObject(realm, groupsFactory, regexResult, input, isIndices);
        }
    }

    @ImportStatic(value={JSRegExp.class, JSRegExpExecIntlNode.class})
    public static abstract class JSRegExpExecIntlIgnoreLastIndexNode
    extends JavaScriptBaseNode {
        private final JSContext context;
        private final boolean doStaticResultUpdate;

        JSRegExpExecIntlIgnoreLastIndexNode(JSContext context, boolean doStaticResultUpdate) {
            this.context = context;
            this.doStaticResultUpdate = doStaticResultUpdate;
        }

        @NeverDefault
        public static JSRegExpExecIntlIgnoreLastIndexNode create(JSContext context, boolean doStaticResultUpdate) {
            return JSRegExpExecIntlNodeGen.JSRegExpExecIntlIgnoreLastIndexNodeGen.create(context, doStaticResultUpdate);
        }

        public abstract Object execute(JSRegExpObject var1, Object var2, long var3);

        @Specialization(guards={"getCompiledRegex(regExp) == cachedCompiledRegex"}, limit="LIMIT")
        Object doCached(JSRegExpObject regExp, TruffleString input, long lastIndex, @Cached(value="getCompiledRegex(regExp)") Object cachedCompiledRegex, @Bind Node node, @Cached @Cached.Shared InlinedConditionProfile areLegacyFeaturesEnabled, @Cached @Cached.Shared TRegexUtil.InvokeExecMethodNode invokeExec, @Cached @Cached.Shared TRegexUtil.InteropReadBooleanMemberNode readIsMatch) {
            return this.doExec(regExp, input, lastIndex, cachedCompiledRegex, node, areLegacyFeaturesEnabled, invokeExec, readIsMatch);
        }

        @Specialization(replaces={"doCached"})
        Object doUncached(JSRegExpObject regExp, TruffleString input, long lastIndex, @Cached @Cached.Shared InlinedConditionProfile areLegacyFeaturesEnabled, @Cached @Cached.Shared TRegexUtil.InvokeExecMethodNode invokeExec, @Cached @Cached.Shared TRegexUtil.InteropReadBooleanMemberNode readIsMatch) {
            Object compiledRegex = JSRegExp.getCompiledRegex(regExp);
            return this.doExec(regExp, input, lastIndex, compiledRegex, this, areLegacyFeaturesEnabled, invokeExec, readIsMatch);
        }

        private Object doExec(JSRegExpObject regExp, TruffleString input, long lastIndex, Object compiledRegex, Node node, InlinedConditionProfile areLegacyFeaturesEnabled, TRegexUtil.InvokeExecMethodNode invokeExec, TRegexUtil.InteropReadBooleanMemberNode readIsMatch) {
            JSRealm thisRealm;
            Object result = JSRegExpExecIntlNode.executeCompiledRegex(compiledRegex, input, lastIndex, node, invokeExec);
            if (this.doStaticResultUpdate && this.context.isOptionRegexpStaticResult() && TRegexUtil.TRegexResultAccessor.isMatch(result, node, readIsMatch) && (thisRealm = this.getRealm()) == JSRegExp.getRealm(regExp)) {
                if (areLegacyFeaturesEnabled.profile(node, JSRegExp.getLegacyFeaturesEnabled(regExp))) {
                    thisRealm.setStaticRegexResult(this.context, compiledRegex, input, lastIndex, result);
                } else {
                    thisRealm.invalidateStaticRegexResult();
                }
            }
            return result;
        }
    }
}

