/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.temporal;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.temporal.TemporalDifferenceDateNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.builtins.temporal.ISODateRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalInstant;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalInstantObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDate;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateTime;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateTimeObject;
import com.oracle.truffle.js.runtime.builtins.temporal.NormalizedDurationRecord;
import com.oracle.truffle.js.runtime.util.TemporalConstants;
import com.oracle.truffle.js.runtime.util.TemporalUtil;

@ImportStatic(value={TemporalConstants.class})
public abstract class DifferenceZonedDateTimeNode
extends JavaScriptBaseNode {
    protected DifferenceZonedDateTimeNode() {
    }

    public abstract NormalizedDurationRecord execute(BigInt var1, BigInt var2, TruffleString var3, TruffleString var4, TemporalUtil.Unit var5, JSTemporalPlainDateTimeObject var6);

    @Specialization
    final NormalizedDurationRecord differenceZonedDateTime(BigInt ns1, BigInt ns2, TruffleString timeZone, TruffleString calendar, TemporalUtil.Unit largestUnit, JSTemporalPlainDateTimeObject startDateTime, @Cached TemporalDifferenceDateNode differenceDateNode) {
        int sign = ns2.compareTo(ns1);
        if (sign == 0) {
            return new NormalizedDurationRecord(0.0, 0.0, 0.0, 0.0, TemporalUtil.zeroTimeDuration());
        }
        JSContext ctx = this.getJSContext();
        JSRealm realm = this.getRealm();
        JSTemporalInstantObject endInstant = JSTemporalInstant.create(ctx, realm, ns2);
        JSTemporalPlainDateTimeObject endDateTime = TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(ctx, realm, timeZone, endInstant, calendar);
        int maxDayCorrection = sign == 1 ? 2 : 1;
        int dayCorrection = 0;
        BigInt timeDuration = TemporalUtil.differenceTime(startDateTime.getHour(), startDateTime.getMinute(), startDateTime.getSecond(), startDateTime.getMillisecond(), startDateTime.getMicrosecond(), startDateTime.getNanosecond(), endDateTime.getHour(), endDateTime.getMinute(), endDateTime.getSecond(), endDateTime.getMillisecond(), endDateTime.getMicrosecond(), endDateTime.getNanosecond());
        int normalizedTimeDurationSign = TemporalUtil.normalizedTimeDurationSign(timeDuration);
        if (normalizedTimeDurationSign == -sign) {
            ++dayCorrection;
        }
        JSTemporalPlainDateTimeObject intermediateDateTime = null;
        BigInt norm = null;
        boolean success = false;
        while (dayCorrection <= maxDayCorrection) {
            ISODateRecord intermediateDate = TemporalUtil.balanceISODate(endDateTime.getYear(), endDateTime.getMonth(), endDateTime.getDay() - dayCorrection * sign);
            intermediateDateTime = JSTemporalPlainDateTime.create(ctx, realm, intermediateDate.year(), intermediateDate.month(), intermediateDate.day(), startDateTime.getHour(), startDateTime.getMinute(), startDateTime.getSecond(), startDateTime.getMillisecond(), startDateTime.getMicrosecond(), startDateTime.getNanosecond(), calendar);
            BigInt intermediateNs = TemporalUtil.getEpochNanosecondsFor(ctx, realm, timeZone, intermediateDateTime, TemporalUtil.Disambiguation.COMPATIBLE);
            norm = TemporalUtil.normalizedTimeDurationFromEpochNanosecondsDifference(ns2, intermediateNs);
            int timeSign = TemporalUtil.normalizedTimeDurationSign(norm);
            if (sign != -timeSign) {
                success = true;
                break;
            }
            ++dayCorrection;
        }
        if (success) {
            JSTemporalPlainDateObject date1 = JSTemporalPlainDate.create(ctx, realm, startDateTime.getYear(), startDateTime.getMonth(), startDateTime.getDay(), calendar, null, InlinedBranchProfile.getUncached());
            JSTemporalPlainDateObject date2 = JSTemporalPlainDate.create(ctx, realm, intermediateDateTime.getYear(), intermediateDateTime.getMonth(), intermediateDateTime.getDay(), calendar, null, InlinedBranchProfile.getUncached());
            TemporalUtil.Unit dateLargestUnit = TemporalUtil.largerOfTwoTemporalUnits(largestUnit, TemporalUtil.Unit.DAY);
            JSTemporalDurationObject dateDifference = differenceDateNode.execute(calendar, date1, date2, dateLargestUnit);
            return TemporalUtil.createNormalizedDurationRecord(dateDifference.getYears(), dateDifference.getMonths(), dateDifference.getWeeks(), dateDifference.getDays(), norm);
        }
        throw Errors.createRangeError("custom calendar or time zone methods returned inconsistent values");
    }
}

