/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.temporal;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalCalendarIdentifierNodeGen;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalCalendarHolder;
import com.oracle.truffle.js.runtime.util.IntlUtil;
import com.oracle.truffle.js.runtime.util.TemporalUtil;

@GenerateUncached
@ImportStatic(value={Strings.class})
public abstract class ToTemporalCalendarIdentifierNode
extends JavaScriptBaseNode {
    protected ToTemporalCalendarIdentifierNode() {
    }

    @NeverDefault
    public static ToTemporalCalendarIdentifierNode create() {
        return ToTemporalCalendarIdentifierNodeGen.create();
    }

    @NeverDefault
    public static ToTemporalCalendarIdentifierNode getUncached() {
        return ToTemporalCalendarIdentifierNodeGen.getUncached();
    }

    public abstract TruffleString executeString(Object var1);

    @Specialization
    protected TruffleString doJSTemporalCalendarHolder(JSTemporalCalendarHolder temporalCalendarLike) {
        return temporalCalendarLike.getCalendar();
    }

    @Specialization
    public TruffleString doString(TruffleString temporalCalendarLike, @Cached TruffleString.ToJavaStringNode toJavaString, @Cached TruffleString.FromJavaStringNode fromJavaString) {
        TruffleString identifier = TemporalUtil.parseTemporalCalendarString(temporalCalendarLike);
        String identifierJLS = toJavaString.execute((AbstractTruffleString)identifier);
        return Strings.fromJavaString(fromJavaString, IntlUtil.canonicalizeCalendar(identifierJLS));
    }

    @Specialization(guards={"!isString(temporalCalendarLike)", "!isJSTemporalCalendarHolder(temporalCalendarLike)"})
    public TruffleString doOther(Object temporalCalendarLike) {
        throw Errors.createTypeErrorNotAString(temporalCalendarLike);
    }
}

