/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.ObjectHeaderImpl;
import com.oracle.svm.core.genscavenge.Space;
import com.oracle.svm.core.genscavenge.UnalignedHeapChunk;
import com.oracle.svm.core.graal.meta.SharedRuntimeMethod;
import com.oracle.svm.core.heap.ObjectReferenceVisitor;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.hub.DynamicHub;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;

class RuntimeCodeCacheReachabilityAnalyzer
implements ObjectReferenceVisitor {
    private boolean unreachableObjects;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    RuntimeCodeCacheReachabilityAnalyzer() {
    }

    public void initialize() {
        this.unreachableObjects = false;
    }

    public boolean hasUnreachableObjects() {
        return this.unreachableObjects;
    }

    @Override
    public boolean visitObjectReference(Pointer ptrPtrToObject, boolean compressed) {
        assert (!this.unreachableObjects);
        Word ptrToObj = ReferenceAccess.singleton().readObjectAsUntrackedPointer(ptrPtrToObject, compressed);
        if (ptrToObj.isNonNull() && !RuntimeCodeCacheReachabilityAnalyzer.isReachable((Pointer)ptrToObj)) {
            this.unreachableObjects = true;
            return false;
        }
        return true;
    }

    public static boolean isReachable(Pointer ptrToObj) {
        assert (ptrToObj.isNonNull());
        UnsignedWord header = ObjectHeaderImpl.readHeaderFromPointer(ptrToObj);
        ObjectHeaderImpl ohi = ObjectHeaderImpl.getObjectHeaderImpl();
        if (ohi.isForwardedHeader(header) || ohi.isBootImageHeader(header)) {
            return true;
        }
        Space space = RuntimeCodeCacheReachabilityAnalyzer.getSpace(ptrToObj, header);
        if (space == HeapImpl.getHeapImpl().getOldGeneration().getToSpace()) {
            return true;
        }
        Class<?> clazz = DynamicHub.toClass(ObjectHeaderImpl.dynamicHubFromObjectHeader(header));
        return RuntimeCodeCacheReachabilityAnalyzer.isWhitelistedClass(clazz);
    }

    private static Space getSpace(Pointer ptrToObj, UnsignedWord header) {
        if (ObjectHeaderImpl.getObjectHeaderImpl().isAlignedHeader(header)) {
            AlignedHeapChunk.AlignedHeader chunk = AlignedHeapChunk.getEnclosingAlignedHeapChunkFromPointer(ptrToObj);
            return chunk.getSpace();
        }
        UnalignedHeapChunk.UnalignedHeader chunk = UnalignedHeapChunk.getEnclosingUnalignedHeapChunkFromPointer(ptrToObj);
        return chunk.getSpace();
    }

    private static boolean isWhitelistedClass(Class<?> clazz) {
        return SpeculationLog.SpeculationReason.class.isAssignableFrom(clazz) || SharedRuntimeMethod.class.isAssignableFrom(clazz);
    }
}

