/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.c.NonmovableArray;
import com.oracle.svm.core.c.NonmovableArrays;
import com.oracle.svm.core.util.ByteArrayReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.Set;
import org.graalvm.compiler.core.common.util.TypeConversion;
import org.graalvm.compiler.core.common.util.UnsafeArrayTypeWriter;

public abstract class ReferenceMapEncoder {
    private final HashMap<Input, Long> usageCounts = new HashMap();
    protected final HashMap<Input, Long> encodings = new HashMap();
    protected final UnsafeArrayTypeWriter writeBuffer = UnsafeArrayTypeWriter.create((boolean)ByteArrayReader.supportsUnalignedMemoryAccess());

    public void add(Input input) {
        if (input == null || input.isEmpty()) {
            return;
        }
        Long oldCount = this.usageCounts.get(input);
        Long newCount = oldCount == null ? 1L : oldCount + 1L;
        this.usageCounts.put(input, newCount);
    }

    public NonmovableArray<Byte> encodeAll() {
        assert (this.writeBuffer.getBytesWritten() == 0L) : "encodeAll() must not be called multiple times";
        ArrayList<Map.Entry<Input, Long>> sortedEntries = new ArrayList<Map.Entry<Input, Long>>(this.usageCounts.entrySet());
        sortedEntries.sort((o1, o2) -> -Long.compare((Long)o1.getValue(), (Long)o2.getValue()));
        this.encodeAll(sortedEntries);
        int length = TypeConversion.asS4((long)this.writeBuffer.getBytesWritten());
        NonmovableArray<Byte> array = NonmovableArrays.createByteArray(length);
        this.writeBuffer.toByteBuffer(NonmovableArrays.asByteBuffer(array));
        return array;
    }

    public long lookupEncoding(Input referenceMap) {
        if (referenceMap == null) {
            return -1L;
        }
        if (referenceMap.isEmpty()) {
            return 0L;
        }
        Long result = this.encodings.get(referenceMap);
        assert (result != null && result != -1L && result != 0L);
        return result;
    }

    protected abstract void encodeAll(List<Map.Entry<Input, Long>> var1);

    public static interface Input {
        public boolean isEmpty();

        public OffsetIterator getOffsets();
    }

    public static interface OffsetIterator
    extends PrimitiveIterator.OfInt {
        @Override
        public boolean hasNext();

        @Override
        public int nextInt();

        public boolean isNextCompressed();

        public boolean isNextDerived();

        public Set<Integer> getDerivedOffsets(int var1);
    }
}

