/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.meta;

import com.oracle.graal.pointsto.infrastructure.OriginalClassProvider;
import com.oracle.graal.pointsto.infrastructure.WrappedJavaType;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.meta.SharedType;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.meta.HostedArrayClass;
import com.oracle.svm.hosted.meta.HostedClass;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedInterface;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedUniverse;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.BitSet;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;

public abstract class HostedType
implements SharedType,
WrappedJavaType,
Comparable<HostedType>,
OriginalClassProvider {
    protected final HostedUniverse universe;
    protected final AnalysisType wrapped;
    private final JavaKind kind;
    private final JavaKind storageKind;
    private final HostedClass superClass;
    private final HostedInterface[] interfaces;
    private HostedType enclosingType;
    protected HostedArrayClass arrayType;
    protected HostedType[] subTypes;
    protected HostedField[] staticFields;
    protected HostedMethod[] vtable;
    protected int instanceOfFromTypeID;
    protected int instanceOfNumTypeIDs;
    protected BitSet instanceOfBits;
    protected int typeID;
    protected int[] assignableFromMatches;
    protected HostedType uniqueConcreteImplementation;
    protected HostedMethod[] allDeclaredMethods;
    protected HostedType strengthenStampType;
    private final boolean isCloneable;

    public HostedType(HostedUniverse universe, AnalysisType wrapped, JavaKind kind, JavaKind storageKind, HostedClass superClass, HostedInterface[] interfaces, boolean isCloneable) {
        this.universe = universe;
        this.wrapped = wrapped;
        this.kind = kind;
        this.storageKind = storageKind;
        this.superClass = superClass;
        this.interfaces = interfaces;
        this.typeID = -1;
        this.isCloneable = isCloneable;
    }

    public HostedType getStrengthenStampType() {
        return this.strengthenStampType;
    }

    public void setInstanceOfRange(int instanceOfFromTypeID, int instanceOfNumTypeIDs) {
        this.instanceOfFromTypeID = instanceOfFromTypeID;
        this.instanceOfNumTypeIDs = instanceOfNumTypeIDs;
    }

    public HostedType[] getSubTypes() {
        assert (this.subTypes != null);
        return this.subTypes;
    }

    public HostedMethod[] getVTable() {
        assert (this.vtable != null);
        return this.vtable;
    }

    public int getTypeID() {
        assert (this.typeID != -1);
        return this.typeID;
    }

    public int[] getAssignableFromMatches() {
        assert (this.assignableFromMatches != null);
        return this.assignableFromMatches;
    }

    public boolean isWordType() {
        return this.kind != this.storageKind;
    }

    public HostedMethod[] getAllDeclaredMethods() {
        assert (this.allDeclaredMethods != null) : "not initialized yet";
        return this.allDeclaredMethods;
    }

    public HostedType getUniqueConcreteImplementation() {
        return this.uniqueConcreteImplementation;
    }

    @Override
    public DynamicHub getHub() {
        return this.universe.hostVM().dynamicHub((ResolvedJavaType)this.wrapped);
    }

    @Override
    public int getInstanceOfFromTypeID() {
        return this.instanceOfFromTypeID;
    }

    @Override
    public int getInstanceOfNumTypeIDs() {
        return this.instanceOfNumTypeIDs;
    }

    public AnalysisType getWrapped() {
        return this.wrapped;
    }

    public boolean isInstantiated() {
        return this.wrapped.isInstantiated();
    }

    public final String getName() {
        return this.wrapped.getName();
    }

    public final JavaKind getJavaKind() {
        return this.kind;
    }

    @Override
    public final JavaKind getStorageKind() {
        return this.storageKind;
    }

    public final ResolvedJavaType resolve(ResolvedJavaType accessingClass) {
        return this;
    }

    public final boolean hasFinalizer() {
        return false;
    }

    public final Assumptions.AssumptionResult<Boolean> hasFinalizableSubclass() {
        return new Assumptions.AssumptionResult((Object)false);
    }

    public final boolean isInitialized() {
        return this.wrapped.isInitialized();
    }

    public void initialize() {
        this.wrapped.initialize();
    }

    public final HostedArrayClass getArrayClass() {
        return this.arrayType;
    }

    public HostedType getArrayClass(int dimension) {
        HostedType result = this;
        for (int i = 0; i < dimension; ++i) {
            result = result.arrayType;
            if (result != null) continue;
            return null;
        }
        return result;
    }

    public abstract HostedField[] getInstanceFields(boolean var1);

    public ResolvedJavaField[] getStaticFields() {
        assert (this.staticFields != null);
        return this.staticFields;
    }

    public final HostedClass getSuperclass() {
        return this.superClass;
    }

    public final HostedInterface[] getInterfaces() {
        return this.interfaces;
    }

    public abstract HostedType getComponentType();

    public abstract HostedType getBaseType();

    public abstract int getArrayDimension();

    public Assumptions.AssumptionResult<ResolvedJavaType> findLeafConcreteSubtype() {
        HostedType result = this.getSingleImplementor();
        if (result == null) {
            return null;
        }
        return new Assumptions.AssumptionResult((Object)result);
    }

    public HostedType getSingleImplementor() {
        return this.uniqueConcreteImplementation;
    }

    public final boolean isAssignableFrom(ResolvedJavaType other) {
        boolean result = this.getHub().isAssignableFromHub(((HostedType)other).getHub());
        assert (result == this.wrapped.isAssignableFrom((ResolvedJavaType)((HostedType)other).wrapped));
        return result;
    }

    public final ResolvedJavaType findLeastCommonAncestor(ResolvedJavaType otherType) {
        return this.universe.lookup((JavaType)this.wrapped.findLeastCommonAncestor((ResolvedJavaType)((HostedType)otherType).wrapped));
    }

    @Override
    public ResolvedJavaMethod resolveConcreteMethod(ResolvedJavaMethod m, ResolvedJavaType ct) {
        HostedMethod method = (HostedMethod)m;
        HostedType callerType = (HostedType)ct;
        if (this.isWordType()) {
            return this.wrappedResolveMethod(method, callerType);
        }
        ResolvedJavaMethod found = SharedType.super.resolveConcreteMethod(method, callerType);
        assert (this.isAbstract() || found == null || this.checkWrappedResolveMethod(method, found, callerType));
        return found;
    }

    private boolean checkWrappedResolveMethod(HostedMethod method, ResolvedJavaMethod found, HostedType callerType) {
        ResolvedJavaMethod wrappedMethod = this.wrappedResolveMethod(method, callerType);
        return wrappedMethod == null || found.equals(wrappedMethod);
    }

    private ResolvedJavaMethod wrappedResolveMethod(HostedMethod method, HostedType callerType) {
        HostedMethod result;
        AnalysisMethod orig = this.wrapped.resolveConcreteMethod((ResolvedJavaMethod)method.wrapped, (ResolvedJavaType)callerType.wrapped);
        HostedMethod hostedMethod = result = orig == null ? null : this.universe.lookup((JavaMethod)orig);
        if (result != null && !this.isWordType() && !Arrays.asList(method.getImplementations()).contains(result)) {
            result = null;
        }
        return result;
    }

    public final int getModifiers() {
        return this.wrapped.getModifiers();
    }

    public final boolean isInstance(JavaConstant obj) {
        assert (this.universe.lookup(obj) == obj) : "constant should not have analysis-universe dependent value";
        return this.wrapped.isInstance(obj);
    }

    public ResolvedJavaField findInstanceFieldWithOffset(long offset, JavaKind expectedKind) {
        return null;
    }

    public Annotation[] getAnnotations() {
        return this.wrapped.getAnnotations();
    }

    public Annotation[] getDeclaredAnnotations() {
        return this.wrapped.getDeclaredAnnotations();
    }

    public final <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return (T)this.wrapped.getAnnotation(annotationClass);
    }

    public String getSourceFileName() {
        return this.wrapped.getSourceFileName();
    }

    public String toString() {
        return "HostedType<" + this.toJavaName(true) + "   " + this.wrapped.toString() + ">";
    }

    public boolean isLocal() {
        return this.wrapped.isLocal();
    }

    public boolean isMember() {
        return this.wrapped.isLocal();
    }

    public HostedType getEnclosingType() {
        return this.enclosingType;
    }

    public HostedMethod[] getDeclaredConstructors() {
        return this.universe.lookup((JavaMethod[])this.wrapped.getDeclaredConstructors());
    }

    public HostedMethod[] getDeclaredMethods() {
        return this.universe.lookup((JavaMethod[])this.wrapped.getDeclaredMethods());
    }

    public ResolvedJavaMethod getClassInitializer() {
        return this.universe.lookup((JavaMethod)this.wrapped.getClassInitializer());
    }

    public boolean isLinked() {
        return this.wrapped.isLinked();
    }

    public boolean isCloneableWithAllocation() {
        return this.isCloneable;
    }

    public ResolvedJavaType getHostClass() {
        return this.universe.lookup((JavaType)this.wrapped.getHostClass());
    }

    public void setEnclosingType(HostedType enclosingType) {
        this.enclosingType = enclosingType;
    }

    public Class<?> getJavaClass() {
        return OriginalClassProvider.getJavaClass((SnippetReflectionProvider)this.universe.getSnippetReflection(), (ResolvedJavaType)this.wrapped);
    }

    @Override
    public int compareTo(HostedType other) {
        if (this.equals(other)) {
            return 0;
        }
        if (this.getClass().equals(other.getClass())) {
            return this.compareToEqualClass(other);
        }
        int result = this.ordinal() - other.ordinal();
        assert (result != 0) : "Types not distinguishable: " + this + ", " + other;
        return result;
    }

    int compareToEqualClass(HostedType other) {
        assert (this.getClass().equals(other.getClass()));
        return this.getName().compareTo(other.getName());
    }

    private int ordinal() {
        if (this.isInterface()) {
            return 4;
        }
        if (this.isArray()) {
            return 3;
        }
        if (this.isInstanceClass()) {
            return 2;
        }
        if (this.getJavaKind() != JavaKind.Object) {
            return 1;
        }
        throw VMError.shouldNotReachHere();
    }
}

