/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.reflect.proxy;

import com.oracle.svm.core.configure.ConfigurationFiles;
import com.oracle.svm.core.jdk.proxy.DynamicProxyRegistry;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.VMError;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationHandler;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

public class DynamicProxySupport
implements DynamicProxyRegistry {
    private static final String proxyConfigFilesOption = SubstrateOptionsParser.commandArgument(ConfigurationFiles.Options.DynamicProxyConfigurationFiles, "<comma-separated-config-files>");
    private static final String proxyConfigResourcesOption = SubstrateOptionsParser.commandArgument(ConfigurationFiles.Options.DynamicProxyConfigurationResources, "<comma-separated-config-resources>");
    private final ClassLoader classLoader;
    private final Map<ProxyCacheKey, Class<?>> proxyCache;

    public DynamicProxySupport(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.proxyCache = new ConcurrentHashMap();
    }

    @Override
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void addProxyClass(Class<?> ... interfaces) {
        Class[] intfs = (Class[])interfaces.clone();
        ProxyCacheKey key = new ProxyCacheKey(intfs);
        Class proxyClass = this.proxyCache.computeIfAbsent(key, k -> DynamicProxyRegistry.getProxyClass(this.classLoader, intfs));
        try {
            RuntimeReflection.register((Executable[])new Executable[]{proxyClass.getConstructor(InvocationHandler.class)});
        }
        catch (NoSuchMethodException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    @Override
    public Class<?> getProxyClass(Class<?> ... interfaces) {
        ProxyCacheKey key = new ProxyCacheKey((Class[])interfaces);
        if (!this.proxyCache.containsKey(key)) {
            throw VMError.unsupportedFeature("Proxy class defined by interfaces " + Arrays.toString(interfaces) + " not found. Generating proxy classes at runtime is not supported. Proxy classes need to be defined at image build time by specifying the list of interfaces that they implement. To define proxy classes use " + proxyConfigFilesOption + " and " + proxyConfigResourcesOption + " options.");
        }
        return this.proxyCache.get(key);
    }

    @Override
    public boolean isProxyClass(Class<?> clazz) {
        return this.proxyCache.containsValue(clazz);
    }

    static final class ProxyCacheKey {
        private final Class<?>[] interfaces;

        private ProxyCacheKey(Class<?> ... interfaces) {
            this.interfaces = interfaces;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ProxyCacheKey) {
                ProxyCacheKey that = (ProxyCacheKey)obj;
                return Arrays.equals(this.interfaces, that.interfaces);
            }
            return false;
        }

        public int hashCode() {
            return Arrays.hashCode(this.interfaces);
        }

        public String toString() {
            return Arrays.toString(this.interfaces);
        }
    }
}

