/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.image.ImageHeap;
import com.oracle.svm.core.image.ImageHeapLayoutInfo;
import com.oracle.svm.core.image.ImageHeapLayouter;
import com.oracle.svm.core.image.ImageHeapObject;
import com.oracle.svm.core.image.ImageHeapPartition;
import com.oracle.svm.core.util.VMError;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractImageHeapLayouter<T extends AbstractImageHeapPartition>
implements ImageHeapLayouter {
    private static final int READ_ONLY_PRIMITIVE = 0;
    private static final int READ_ONLY_REFERENCE = 1;
    private static final int READ_ONLY_RELOCATABLE = 2;
    private static final int WRITABLE_PRIMITIVE = 3;
    private static final int WRITABLE_REFERENCE = 4;
    private static final int WRITABLE_HUGE = 5;
    private static final int READ_ONLY_HUGE = 6;
    private static final int PARTITION_COUNT = 7;
    private final T[] partitions = this.createPartitionsArray(7);

    public T[] getPartitions() {
        return this.partitions;
    }

    public AbstractImageHeapLayouter() {
        this.partitions[0] = this.createPartition("readOnlyPrimitive", false, false, false);
        this.partitions[1] = this.createPartition("readOnlyReference", true, false, false);
        this.partitions[2] = this.createPartition("readOnlyRelocatable", true, false, false);
        this.partitions[3] = this.createPartition("writablePrimitive", false, true, false);
        this.partitions[4] = this.createPartition("writableReference", true, true, false);
        this.partitions[5] = this.createPartition("writableHuge", true, true, true);
        this.partitions[6] = this.createPartition("readOnlyHuge", true, false, true);
    }

    @Override
    public void assignObjectToPartition(ImageHeapObject info, boolean immutable, boolean references, boolean relocatable) {
        T partition = this.choosePartition(info, immutable, references, relocatable);
        info.setHeapPartition((ImageHeapPartition)partition);
        ((AbstractImageHeapPartition)partition).assign(info);
    }

    @Override
    public ImageHeapLayoutInfo layout(ImageHeap imageHeap, int pageSize) {
        int objectAlignment = ConfigurationValues.getObjectLayout().getAlignment();
        assert (pageSize % objectAlignment == 0) : "Page size does not match object alignment";
        for (AbstractImageHeapPartition partition : this.getPartitions()) {
            int startAlignment = objectAlignment;
            int endAlignment = objectAlignment;
            if (partition == this.getReadOnlyRelocatable()) {
                startAlignment = pageSize;
                endAlignment = pageSize;
            } else if (partition == this.getWritablePrimitive()) {
                startAlignment = pageSize;
            } else if (partition == this.getWritableHuge()) {
                endAlignment = pageSize;
            }
            partition.setStartAlignment(startAlignment);
            partition.setEndAlignment(endAlignment);
        }
        ImageHeapLayoutInfo layoutInfo = this.doLayout(imageHeap);
        for (AbstractImageHeapPartition partition : this.getPartitions()) {
            assert (partition.getStartOffset() % (long)partition.getStartAlignment() == 0L);
            assert ((partition.getStartOffset() + partition.getSize()) % (long)partition.getEndAlignment() == 0L);
        }
        assert (layoutInfo.getReadOnlyRelocatableOffset() % (long)pageSize == 0L && layoutInfo.getReadOnlyRelocatableSize() % (long)pageSize == 0L);
        assert (layoutInfo.getWritableOffset() % (long)pageSize == 0L && layoutInfo.getWritableSize() % (long)pageSize == 0L);
        return layoutInfo;
    }

    @Override
    public void writeMetadata(ByteBuffer imageHeapBytes, long imageHeapOffsetInBuffer) {
    }

    protected abstract ImageHeapLayoutInfo doLayout(ImageHeap var1);

    protected T getReadOnlyPrimitive() {
        return (T)this.getPartitions()[0];
    }

    protected T getReadOnlyReference() {
        return (T)this.getPartitions()[1];
    }

    protected T getReadOnlyRelocatable() {
        return (T)this.getPartitions()[2];
    }

    protected T getWritablePrimitive() {
        return (T)this.getPartitions()[3];
    }

    protected T getWritableReference() {
        return (T)this.getPartitions()[4];
    }

    protected T getWritableHuge() {
        return (T)this.getPartitions()[5];
    }

    protected T getReadOnlyHuge() {
        return (T)this.getPartitions()[6];
    }

    protected long getHugeObjectThreshold() {
        return Long.MAX_VALUE;
    }

    private T choosePartition(ImageHeapObject info, boolean immutable, boolean hasReferences, boolean hasRelocatables) {
        if (immutable) {
            if (hasRelocatables) {
                VMError.guarantee(info.getSize() < this.getHugeObjectThreshold(), "Objects with relocatable pointers cannot be huge objects");
                return this.getReadOnlyRelocatable();
            }
            if (info.getSize() >= this.getHugeObjectThreshold()) {
                VMError.guarantee(!(info.getObject() instanceof DynamicHub), "Class metadata (dynamic hubs) cannot be huge objects");
                return this.getReadOnlyHuge();
            }
            return hasReferences ? this.getReadOnlyReference() : this.getReadOnlyPrimitive();
        }
        assert (!(info.getObject() instanceof DynamicHub)) : "Class metadata (dynamic hubs) cannot be writable";
        if (info.getSize() >= this.getHugeObjectThreshold()) {
            return this.getWritableHuge();
        }
        return hasReferences ? this.getWritableReference() : this.getWritablePrimitive();
    }

    protected ImageHeapLayoutInfo createLayoutInfo(long heapStartOffset, long writableBeginOffset) {
        long writableEnd = this.getWritableHuge().getStartOffset() + this.getWritableHuge().getSize();
        long writableSize = writableEnd - writableBeginOffset;
        long imageHeapSize = this.getReadOnlyHuge().getStartOffset() + this.getReadOnlyHuge().getSize() - heapStartOffset;
        return new ImageHeapLayoutInfo(writableBeginOffset, writableSize, this.getReadOnlyRelocatable().getStartOffset(), this.getReadOnlyRelocatable().getSize(), imageHeapSize);
    }

    protected abstract T[] createPartitionsArray(int var1);

    protected abstract T createPartition(String var1, boolean var2, boolean var3, boolean var4);

    public static abstract class AbstractImageHeapPartition
    implements ImageHeapPartition {
        private final String name;
        private final boolean writable;
        private int startAlignment = -1;
        private int endAlignment = -1;
        private final List<ImageHeapObject> objects = new ArrayList<ImageHeapObject>();

        public AbstractImageHeapPartition(String name, boolean writable) {
            this.name = name;
            this.writable = writable;
        }

        public void assign(ImageHeapObject obj) {
            assert (obj.getPartition() == this);
            this.objects.add(obj);
        }

        public void setStartAlignment(int alignment) {
            assert (this.startAlignment == -1) : "Start alignment already assigned: " + this.startAlignment;
            this.startAlignment = alignment;
        }

        public final int getStartAlignment() {
            assert (this.startAlignment >= 0) : "Start alignment not yet assigned";
            return this.startAlignment;
        }

        public void setEndAlignment(int endAlignment) {
            assert (this.endAlignment == -1) : "End alignment already assigned: " + this.endAlignment;
            this.endAlignment = endAlignment;
        }

        public final int getEndAlignment() {
            assert (this.endAlignment >= 0) : "End alignment not yet assigned";
            return this.endAlignment;
        }

        public List<ImageHeapObject> getObjects() {
            return this.objects;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public boolean isWritable() {
            return this.writable;
        }

        public String toString() {
            return this.name;
        }
    }
}

