/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.genscavenge.GCAccounting;
import com.oracle.svm.core.genscavenge.GCImpl;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.HeapPolicy;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.util.TimeUtils;
import com.oracle.svm.core.util.UserError;
import org.graalvm.compiler.options.Option;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.word.UnsignedWord;

public abstract class CollectionPolicy {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    static CollectionPolicy getInitialPolicy(Feature.FeatureAccess access) {
        return CollectionPolicy.instantiatePolicy(access, CollectionPolicy.class, Options.InitialCollectionPolicy.getValue());
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static <T> T instantiatePolicy(Feature.FeatureAccess access, Class<T> policyClass, String className) {
        Object result;
        Class policy = access.findClassByName(className);
        if (policy == null) {
            throw UserError.abort("Policy %s does not exist. It must be a fully qualified class name.", className);
        }
        try {
            result = policy.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw UserError.abort("Policy %s cannot be instantiated.", className);
        }
        if (!policyClass.isInstance(result)) {
            throw UserError.abort("Policy %s does not extend %s.", className, policyClass.getTypeName());
        }
        return policyClass.cast(result);
    }

    public abstract boolean collectIncrementally();

    public abstract boolean collectCompletely();

    CollectionPolicy() {
    }

    public abstract void nameToLog(Log var1);

    public abstract String getName();

    static GCAccounting getAccounting() {
        return GCImpl.getGCImpl().getAccounting();
    }

    public static class BySpaceAndTime
    extends CollectionPolicy {
        @Override
        public boolean collectIncrementally() {
            return true;
        }

        @Override
        public boolean collectCompletely() {
            return BySpaceAndTime.estimateUsedHeapAtNextIncrementalCollection().aboveThan(HeapPolicy.getMaximumHeapSize()) || GCImpl.getChunkBytes().aboveThan(HeapPolicy.getMinimumHeapSize()) && BySpaceAndTime.enoughTimeSpentOnIncrementalGCs();
        }

        private static UnsignedWord estimateUsedHeapAtNextIncrementalCollection() {
            UnsignedWord currentYoungBytes = HeapImpl.getHeapImpl().getYoungGeneration().getChunkBytes();
            UnsignedWord maxYoungBytes = HeapPolicy.getMaximumYoungGenerationSize();
            UnsignedWord oldBytes = BySpaceAndTime.getAccounting().getOldGenerationAfterChunkBytes();
            return currentYoungBytes.add(maxYoungBytes).add(oldBytes);
        }

        private static boolean enoughTimeSpentOnIncrementalGCs() {
            int incrementalWeight = Options.PercentTimeInIncrementalCollection.getValue();
            assert (incrementalWeight >= 0 && incrementalWeight <= 100) : "BySpaceAndTimePercentTimeInIncrementalCollection should be in the range [0..100].";
            long actualIncrementalNanos = BySpaceAndTime.getAccounting().getIncrementalCollectionTotalNanos();
            long completeNanos = BySpaceAndTime.getAccounting().getCompleteCollectionTotalNanos();
            long totalNanos = actualIncrementalNanos + completeNanos;
            long expectedIncrementalNanos = TimeUtils.weightedNanos(incrementalWeight, totalNanos);
            return TimeUtils.nanoTimeLessThan(expectedIncrementalNanos, actualIncrementalNanos);
        }

        @Override
        public void nameToLog(Log log) {
            log.string(this.getName()).string(": ").signed(Options.PercentTimeInIncrementalCollection.getValue()).string("% in incremental collections");
        }

        @Override
        public String getName() {
            return "by space and time";
        }
    }

    public static class NeverCollect
    extends CollectionPolicy {
        @Override
        public boolean collectIncrementally() {
            return false;
        }

        @Override
        public boolean collectCompletely() {
            return false;
        }

        @Override
        public void nameToLog(Log log) {
            log.string(this.getName());
        }

        @Override
        public String getName() {
            return "never collect";
        }
    }

    public static class OnlyCompletely
    extends CollectionPolicy {
        @Override
        public boolean collectIncrementally() {
            return false;
        }

        @Override
        public boolean collectCompletely() {
            return true;
        }

        @Override
        public void nameToLog(Log log) {
            log.string(this.getName());
        }

        @Override
        public String getName() {
            return "only completely";
        }
    }

    public static class OnlyIncrementally
    extends CollectionPolicy {
        @Override
        public boolean collectIncrementally() {
            return true;
        }

        @Override
        public boolean collectCompletely() {
            return false;
        }

        @Override
        public void nameToLog(Log log) {
            log.string(this.getName());
        }

        @Override
        public String getName() {
            return "only incrementally";
        }
    }

    public static class Options {
        @Option(help={"The initial garbage collection policy, as a fully-qualified class name (might require quotes or escaping)."})
        public static final HostedOptionKey<String> InitialCollectionPolicy = new HostedOptionKey<String>(BySpaceAndTime.class.getName());
        @Option(help={"Percentage of total collection time that should be spent on young generation collections."})
        public static final RuntimeOptionKey<Integer> PercentTimeInIncrementalCollection = new RuntimeOptionKey<Integer>(50);
    }
}

