/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.MemoryWalker;
import com.oracle.svm.core.annotate.AlwaysInline;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.genscavenge.CardTable;
import com.oracle.svm.core.genscavenge.HeapChunk;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.HeapVerifier;
import com.oracle.svm.core.genscavenge.ObjectHeaderImpl;
import com.oracle.svm.core.genscavenge.OldGeneration;
import com.oracle.svm.core.heap.ObjectVisitor;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.util.UnsignedUtils;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.replacements.nodes.AssertionNode;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.struct.RawStructure;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public final class UnalignedHeapChunk {
    private UnalignedHeapChunk() {
    }

    static Pointer getCardTableStart(UnalignedHeader that) {
        return HeapChunk.asPointer(that).add(UnalignedHeapChunk.getCardTableStartOffset());
    }

    static Pointer getCardTableLimit(UnalignedHeader that) {
        return HeapChunk.asPointer(that).add(UnalignedHeapChunk.getCardTableLimitOffset());
    }

    static Pointer getObjectStart(UnalignedHeader that) {
        return HeapChunk.asPointer(that).add(UnalignedHeapChunk.getObjectStartOffset());
    }

    public static UnsignedWord getOverhead() {
        return UnalignedHeapChunk.getObjectStartOffset();
    }

    static UnsignedWord getChunkSizeForObject(UnsignedWord objectSize) {
        UnsignedWord objectStart = UnalignedHeapChunk.getObjectStartOffset();
        UnsignedWord alignment = WordFactory.unsigned((int)ConfigurationValues.getObjectLayout().getAlignment());
        return UnsignedUtils.roundUp(objectStart.add(objectSize), alignment);
    }

    @Uninterruptible(reason="Returns uninitialized memory.", callerMustBe=true)
    public static Pointer allocateMemory(UnalignedHeader that, UnsignedWord size) {
        UnsignedWord available = HeapChunk.availableObjectMemory(that);
        Pointer result = (Pointer)WordFactory.nullPointer();
        if (size.belowOrEqual(available)) {
            result = HeapChunk.getTopPointer(that);
            Pointer newTop = result.add(size);
            HeapChunk.setTopPointerCarefully(that, newTop);
        }
        return result;
    }

    static UnalignedHeader getEnclosingChunk(Object obj) {
        Word objPointer = Word.objectToUntrackedPointer((Object)obj);
        return UnalignedHeapChunk.getEnclosingChunkFromObjectPointer((Pointer)objPointer);
    }

    static UnalignedHeader getEnclosingChunkFromObjectPointer(Pointer objPointer) {
        Pointer chunkPointer = objPointer.subtract(UnalignedHeapChunk.getObjectStartOffset());
        return (UnalignedHeader)chunkPointer;
    }

    public static boolean walkObjects(UnalignedHeader that, ObjectVisitor visitor) {
        return HeapChunk.walkObjectsFrom(that, UnalignedHeapChunk.getObjectStart(that), visitor);
    }

    @AlwaysInline(value="GC performance")
    public static boolean walkObjectsInline(UnalignedHeader that, ObjectVisitor visitor) {
        return HeapChunk.walkObjectsFromInline(that, UnalignedHeapChunk.getObjectStart(that), visitor);
    }

    public static void dirtyCardForObject(Object obj, boolean verifyOnly) {
        UnalignedHeader chunk = UnalignedHeapChunk.getEnclosingChunk(obj);
        Pointer cardTableStart = UnalignedHeapChunk.getCardTableStart(chunk);
        UnsignedWord objectIndex = UnalignedHeapChunk.getObjectIndex();
        if (verifyOnly) {
            AssertionNode.assertion((boolean)false, (boolean)CardTable.isDirtyEntryAtIndexUnchecked(cardTableStart, objectIndex), (String)"card must be dirty", (Object)"", (Object)"", (long)0L, (long)0L);
        } else {
            CardTable.dirtyEntryAtIndex(cardTableStart, objectIndex);
        }
    }

    static boolean verifyOnlyCleanCards(UnalignedHeader that) {
        Log trace = Log.noopLog().string("[UnalignedHeapChunk.verifyOnlyCleanCards:");
        trace.string("  that: ").hex((WordBase)that);
        boolean result = true;
        Pointer rememberedSetStart = UnalignedHeapChunk.getCardTableStart(that);
        UnsignedWord objectIndex = UnalignedHeapChunk.getObjectIndex();
        if (CardTable.isDirtyEntryAtIndex(rememberedSetStart, objectIndex)) {
            result = false;
            Log witness = Log.log().string("[UnalignedHeapChunk.verifyOnlyCleanCards:");
            witness.string("  that: ").hex((WordBase)that).string("  dirty card at index: ").unsigned((WordBase)objectIndex).string("]").newline();
        }
        trace.string("  returns: ").bool(result).string("]").newline();
        return result;
    }

    public static boolean walkDirtyObjects(UnalignedHeader that, ObjectVisitor visitor, boolean clean) {
        Log trace = Log.noopLog().string("[UnalignedHeapChunk.walkDirtyObjects:");
        trace.string("  clean: ").bool(clean).string("  that: ").hex((WordBase)that).string("  ");
        boolean result = true;
        Pointer rememberedSetStart = UnalignedHeapChunk.getCardTableStart(that);
        UnsignedWord objectIndex = UnalignedHeapChunk.getObjectIndex();
        trace.string("  rememberedSetStart: ").hex((WordBase)rememberedSetStart).string("  objectIndex: ").unsigned((WordBase)objectIndex);
        if (CardTable.isDirtyEntryAtIndex(rememberedSetStart, objectIndex)) {
            if (clean) {
                CardTable.cleanEntryAtIndex(rememberedSetStart, objectIndex);
            }
            Pointer objectsStart = UnalignedHeapChunk.getObjectStart(that);
            Object obj = objectsStart.toObject();
            trace.string("  obj: ").object(obj);
            if (!visitor.visitObjectInline(obj)) {
                result = false;
            }
        }
        trace.string("  returns: ").bool(result).string("]").newline();
        return result;
    }

    static void cleanRememberedSet(UnalignedHeader that) {
        Log trace = Log.noopLog().string("[UnalignedHeapChunk.cleanRememberedSet:").newline();
        trace.string("  that: ").hex((WordBase)that);
        CardTable.cleanTableToPointer(UnalignedHeapChunk.getCardTableStart(that), UnalignedHeapChunk.getCardTableLimit(that));
        trace.string("]").newline();
    }

    static void setUpRememberedSet(UnalignedHeader that) {
        Object obj = UnalignedHeapChunk.getObjectStart(that).toObject();
        ObjectHeaderImpl.setRememberedSetBit(obj);
    }

    @Fold
    static UnsignedWord getCardTableStartOffset() {
        UnsignedWord headerSize = WordFactory.unsigned((int)SizeOf.get(UnalignedHeader.class));
        UnsignedWord alignment = WordFactory.unsigned((int)ConfigurationValues.getObjectLayout().getAlignment());
        return UnsignedUtils.roundUp(headerSize, alignment);
    }

    @Fold
    static UnsignedWord getCardTableSize() {
        UnsignedWord requiredSize = CardTable.tableSizeForMemorySize(WordFactory.unsigned((int)1));
        UnsignedWord alignment = WordFactory.unsigned((int)ConfigurationValues.getObjectLayout().getAlignment());
        return UnsignedUtils.roundUp(requiredSize, alignment);
    }

    @Fold
    static UnsignedWord getCardTableLimitOffset() {
        UnsignedWord tableStart = UnalignedHeapChunk.getCardTableStartOffset();
        UnsignedWord tableSize = UnalignedHeapChunk.getCardTableSize();
        UnsignedWord tableLimit = tableStart.add(tableSize);
        UnsignedWord alignment = WordFactory.unsigned((int)ConfigurationValues.getObjectLayout().getAlignment());
        return UnsignedUtils.roundUp(tableLimit, alignment);
    }

    @Fold
    static UnsignedWord getObjectStartOffset() {
        UnsignedWord cardTableLimitOffset = UnalignedHeapChunk.getCardTableLimitOffset();
        UnsignedWord alignment = WordFactory.unsigned((int)ConfigurationValues.getObjectLayout().getAlignment());
        return UnsignedUtils.roundUp(cardTableLimitOffset, alignment);
    }

    @Fold
    static UnsignedWord getObjectIndex() {
        return (UnsignedWord)WordFactory.zero();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord getCommittedObjectMemory(UnalignedHeader that) {
        return HeapChunk.getEndOffset(that).subtract(UnalignedHeapChunk.getObjectStartOffset());
    }

    static boolean verify(UnalignedHeader that) {
        return UnalignedHeapChunk.verify(that, UnalignedHeapChunk.getObjectStart(that));
    }

    private static boolean verify(UnalignedHeader that, Pointer start) {
        VMOperation.guaranteeInProgress("Should only be called as a VMOperation.");
        Log trace = HeapVerifier.getTraceLog().string("[UnalignedHeapChunk.verify");
        trace.string("  that: ").hex((WordBase)that).string("  start: ").hex((WordBase)start).string("  top: ").hex((WordBase)HeapChunk.getTopPointer(that)).string("  end: ").hex((WordBase)HeapChunk.getEndPointer(that)).newline();
        UnsignedWord objHeader = ObjectHeaderImpl.readHeaderFromPointer(start);
        if (ObjectHeaderImpl.isForwardedHeader(objHeader)) {
            Log witness = HeapImpl.getHeapImpl().getHeapVerifier().getWitnessLog().string("[UnalignedHeapChunk.verify:");
            witness.string("  that: ").hex((WordBase)that).string("  start: ").hex((WordBase)start).string("  top: ").hex((WordBase)HeapChunk.getTopPointer(that)).string("  end: ").hex((WordBase)HeapChunk.getEndPointer(that));
            witness.string("  space: ").string(HeapChunk.getSpace(that).getName());
            witness.string("  should not be forwarded").string("]").newline();
            return false;
        }
        if (!ObjectHeaderImpl.isUnalignedHeader(start, objHeader)) {
            Log witness = HeapImpl.getHeapImpl().getHeapVerifier().getWitnessLog().string("[UnalignedHeapChunk.verify:");
            witness.string("  that: ").hex((WordBase)that).string("  start: ").hex((WordBase)start).string("  end: ").hex((WordBase)HeapChunk.getEndPointer(that));
            witness.string("  space: ").string(HeapChunk.getSpace(that).getName());
            witness.string("  obj: ").hex((WordBase)start).string("  objHeader: ").hex((WordBase)objHeader);
            witness.string("  does not have an unaligned header").string("]").newline();
            return false;
        }
        Object obj = start.toObject();
        Pointer objEnd = LayoutEncoding.getObjectEnd(obj);
        if (objEnd.notEqual((UnsignedWord)HeapChunk.getTopPointer(that))) {
            Log witness = HeapImpl.getHeapImpl().getHeapVerifier().getWitnessLog().string("[UnalignedHeapChunk.verify:");
            witness.string("  that: ").hex((WordBase)that).string("  start: ").hex((WordBase)start).string("  end: ").hex((WordBase)HeapChunk.getEndPointer(that));
            witness.string("  space: ").string(HeapChunk.getSpace(that).getName());
            witness.string("  obj: ").object(obj).string("  objEnd: ").hex((WordBase)objEnd);
            witness.string("  should be the only object in the chunk").string("]").newline();
            return false;
        }
        if (!UnalignedHeapChunk.verifyRememberedSet(that)) {
            Log witnessLog = HeapImpl.getHeapImpl().getHeapVerifier().getWitnessLog().string("[UnalignedHeadChunk remembered set fails to verify");
            witnessLog.string("  that: ").hex((WordBase)that).string("  remembered set fails to verify.").string("]").newline();
        }
        boolean result = HeapChunk.verifyObjects(that, start);
        trace.string("  returns: ").bool(result).string("]").newline();
        return result;
    }

    private static boolean verifyRememberedSet(UnalignedHeader that) {
        UnsignedWord objectIndex;
        Pointer rememberedSet;
        boolean isDirty;
        Pointer objStart;
        Object obj;
        boolean containsYoungReferences;
        OldGeneration oldGen = HeapImpl.getHeapImpl().getOldGeneration();
        if (HeapChunk.getSpace(that) == oldGen.getFromSpace() && (containsYoungReferences = CardTable.containsReferenceToYoungSpace(obj = (objStart = UnalignedHeapChunk.getObjectStart(that)).toObject())) && !(isDirty = CardTable.isDirtyEntryAtIndex(rememberedSet = UnalignedHeapChunk.getCardTableStart(that), objectIndex = UnalignedHeapChunk.getObjectIndex()))) {
            Log witness = HeapImpl.getHeapImpl().getHeapVerifier().getWitnessLog().string("[UnalignedHeapChunk.verify:");
            witness.string("  that: ").hex((WordBase)that);
            witness.string("  containsYoungReferences implies isDirty").string("]").newline();
            return false;
        }
        return true;
    }

    @Fold
    public static MemoryWalker.HeapChunkAccess<UnalignedHeader> getMemoryWalkerAccess() {
        return (MemoryWalker.HeapChunkAccess)ImageSingletons.lookup(MemoryWalkerAccessImpl.class);
    }

    public static final class TestingBackDoor {
        private TestingBackDoor() {
        }

        public static UnsignedWord getCardTableStartOffset() {
            return UnalignedHeapChunk.getCardTableStartOffset();
        }

        public static UnsignedWord getObjectStartOffset() {
            return UnalignedHeapChunk.getObjectStartOffset();
        }
    }

    static final class MemoryWalkerAccessImpl
    extends HeapChunk.MemoryWalkerAccessImpl<UnalignedHeader> {
        @Platforms(value={Platform.HOSTED_ONLY.class})
        MemoryWalkerAccessImpl() {
        }

        @Override
        public boolean isAligned(UnalignedHeader heapChunk) {
            return false;
        }

        @Override
        public UnsignedWord getAllocationStart(UnalignedHeader heapChunk) {
            return UnalignedHeapChunk.getObjectStart(heapChunk);
        }
    }

    @RawStructure
    public static interface UnalignedHeader
    extends HeapChunk.Header<UnalignedHeader> {
    }
}

