/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.KeepOriginal;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.jdk.JavaLangSubstitutions;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@TargetClass(value=ClassValue.class)
@Substitute
final class Target_java_lang_ClassValue {
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=JavaLangSubstitutions.ClassValueInitializer.class)
    private final ConcurrentMap<Class<?>, Object> values = new ConcurrentHashMap();

    @Substitute
    private Target_java_lang_ClassValue() {
    }

    @KeepOriginal
    native Object computeValue(Class<?> var1);

    @Substitute
    private Object get(Class<?> type) {
        Object result = this.values.get(type);
        if (result == null) {
            Object oldValue;
            Object newValue = this.computeValue(type);
            if (newValue == null) {
                newValue = JavaLangSubstitutions.ClassValueSupport.NULL_MARKER;
            }
            Object v = result = (oldValue = this.values.putIfAbsent(type, newValue)) != null ? oldValue : newValue;
        }
        if (result == JavaLangSubstitutions.ClassValueSupport.NULL_MARKER) {
            result = null;
        }
        return result;
    }

    @Substitute
    private void remove(Class<?> type) {
        this.values.remove(type);
    }
}

