/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.thread;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.headers.LibC;
import com.oracle.svm.core.posix.headers.Pthread;
import com.oracle.svm.core.posix.pthread.PthreadVMLockSupport;
import com.oracle.svm.core.thread.VMThreads;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

public final class PosixVMThreads
extends VMThreads {
    private static final CGlobalData<CCharPointer> FAIL_FATALLY_FDOPEN_MODE = CGlobalDataFactory.createCString("w");
    private static final CGlobalData<CCharPointer> FAIL_FATALLY_MESSAGE_FORMAT = CGlobalDataFactory.createCString("Fatal error: %s (code %d)\n");

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected VMThreads.OSThreadHandle getCurrentOSThreadHandle() {
        return Pthread.pthread_self();
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected VMThreads.OSThreadId getCurrentOSThreadId() {
        return Pthread.pthread_self();
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.")
    protected void joinNoTransition(VMThreads.OSThreadHandle osThreadHandle) {
        Pthread.pthread_t pthread = (Pthread.pthread_t)osThreadHandle;
        PosixUtils.checkStatusIs0(Pthread.pthread_join_no_transition(pthread, (WordPointer)WordFactory.nullPointer()), "Pthread.joinNoTransition");
    }

    @Override
    @Uninterruptible(reason="Thread state not set up.")
    protected boolean initializeOnce() {
        return PthreadVMLockSupport.initialize();
    }

    @CFunction(value="fdopen", transition=CFunction.Transition.NO_TRANSITION)
    private static native FILE fdopen(int var0, CCharPointer var1);

    @CFunction(value="fprintf", transition=CFunction.Transition.NO_TRANSITION)
    private static native int fprintfSD(FILE var0, CCharPointer var1, CCharPointer var2, int var3);

    @Override
    @Uninterruptible(reason="Thread state not set up.")
    public void failFatally(int code, CCharPointer message) {
        FILE stderr = PosixVMThreads.fdopen(2, FAIL_FATALLY_FDOPEN_MODE.get());
        PosixVMThreads.fprintfSD(stderr, FAIL_FATALLY_MESSAGE_FORMAT.get(), message, code);
        LibC.exit(code);
    }

    static interface FILE
    extends PointerBase {
    }
}

