/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.NeverInline;
import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.ReferenceHandler;
import com.oracle.svm.core.heap.ReferenceHandlerThreadFeature;
import com.oracle.svm.core.jdk.StackTraceUtils;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.jdk.management.ManagementSupport;
import com.oracle.svm.core.locks.VMMutex;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.monitor.MonitorSupport;
import com.oracle.svm.core.nodes.CFunctionEpilogueNode;
import com.oracle.svm.core.nodes.CFunctionPrologueNode;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.thread.JavaContinuations;
import com.oracle.svm.core.thread.JavaVMOperation;
import com.oracle.svm.core.thread.ParkEvent;
import com.oracle.svm.core.thread.Target_java_lang_Thread;
import com.oracle.svm.core.thread.Target_java_lang_ThreadGroup;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMOperationControl;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalObject;
import com.oracle.svm.core.util.TimeUtils;
import com.oracle.svm.core.util.VMError;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.core.common.SuppressFBWarnings;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Isolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.ObjectHandle;
import org.graalvm.nativeimage.ObjectHandles;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.struct.RawField;
import org.graalvm.nativeimage.c.struct.RawStructure;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public abstract class JavaThreads {
    static final FastThreadLocalObject<Thread> currentThread = (FastThreadLocalObject)FastThreadLocalFactory.createObject(Thread.class).setMaxOffset(127);
    static final UninterruptibleUtils.AtomicInteger nonDaemonThreads = new UninterruptibleUtils.AtomicInteger(1);
    private final AtomicInteger unattachedStartedThreads = new AtomicInteger(0);
    final AtomicLong threadSeqNumber = new AtomicLong();
    final AtomicInteger threadInitNumber = new AtomicInteger();
    final ThreadGroup mainGroup = Thread.currentThread().getThreadGroup();
    public final ThreadGroup systemGroup;
    final Thread mainThread;
    final Thread[] mainGroupThreadsArray;

    @Fold
    public static JavaThreads singleton() {
        return (JavaThreads)ImageSingletons.lookup(JavaThreads.class);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected JavaThreads() {
        VMError.guarantee(this.mainGroup.getName().equals("main"), "Wrong ThreadGroup for main");
        this.systemGroup = this.mainGroup.getParent();
        VMError.guarantee(this.systemGroup.getParent() == null && this.systemGroup.getName().equals("system"), "Wrong ThreadGroup for system");
        this.mainThread = new Thread(this.mainGroup, "main");
        this.mainThread.setDaemon(false);
        this.mainGroupThreadsArray = new Thread[4];
        this.mainGroupThreadsArray[0] = this.mainThread;
    }

    @SuppressFBWarnings(value={"BC"}, justification="Cast for @TargetClass")
    static Thread fromTarget(Target_java_lang_Thread thread) {
        return (Thread)Thread.class.cast(thread);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    @SuppressFBWarnings(value={"BC"}, justification="Cast for @TargetClass")
    private static Target_java_lang_Thread toTarget(Thread thread) {
        return (Target_java_lang_Thread)Target_java_lang_Thread.class.cast(thread);
    }

    public static int getThreadStatus(Thread thread) {
        return JavaContinuations.LoomCompatibilityUtil.getThreadStatus(JavaThreads.toTarget(thread));
    }

    public static void setThreadStatus(Thread thread, int threadStatus) {
        JavaContinuations.LoomCompatibilityUtil.setThreadStatus(JavaThreads.toTarget(thread), threadStatus);
    }

    protected static UninterruptibleUtils.AtomicReference<ParkEvent> getUnsafeParkEvent(Thread thread) {
        return JavaThreads.toTarget((Thread)thread).unsafeParkEvent;
    }

    protected static UninterruptibleUtils.AtomicReference<ParkEvent> getSleepParkEvent(Thread thread) {
        return JavaThreads.toTarget((Thread)thread).sleepParkEvent;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected static boolean wasStartedByCurrentIsolate(IsolateThread thread) {
        Thread javaThread = currentThread.get(thread);
        return JavaThreads.wasStartedByCurrentIsolate(javaThread);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected static boolean wasStartedByCurrentIsolate(Thread thread) {
        return JavaThreads.toTarget((Thread)thread).wasStartedByCurrentIsolate;
    }

    public static Thread fromVMThread(IsolateThread vmThread) {
        return currentThread.get(vmThread);
    }

    public static boolean isVirtual(Thread thread) {
        if (!JavaContinuations.useLoom()) {
            return false;
        }
        return JavaThreads.toTarget(thread).isVirtual();
    }

    public static IsolateThread getIsolateThreadUnsafe(Thread t) {
        return JavaThreads.toTarget((Thread)t).isolateThread;
    }

    public static IsolateThread getIsolateThread(Thread t) {
        VMThreads.guaranteeOwnsThreadMutex("Threads mutex must be locked before accessing/iterating the thread list.");
        return JavaThreads.getIsolateThreadUnsafe(t);
    }

    @SuppressFBWarnings(value={"BC"}, justification="Cast for @TargetClass")
    static Target_java_lang_ThreadGroup toTarget(ThreadGroup threadGroup) {
        return (Target_java_lang_ThreadGroup)Target_java_lang_ThreadGroup.class.cast(threadGroup);
    }

    static void cleanupBeforeDetach(IsolateThread thread) {
        VMError.guarantee(thread.equal((ComparableWord)CurrentIsolate.getCurrentThread()), "Cleanup must execute in detaching thread");
        Target_java_lang_Thread javaThread = SubstrateUtil.cast(currentThread.get(thread), Target_java_lang_Thread.class);
        javaThread.exit();
    }

    public void joinAllNonDaemons() {
        int expectedNonDaemonThreads = Thread.currentThread().isDaemon() ? 0 : 1;
        JavaThreads.joinAllNonDaemonsTransition(expectedNonDaemonThreads);
    }

    @NeverInline(value="Must not be inlined in a caller that has an exception handler: We only support InvokeNode and not InvokeWithExceptionNode between a CFunctionPrologueNode and CFunctionEpilogueNode")
    private static void joinAllNonDaemonsTransition(int expectedNonDaemonThreads) {
        CFunctionPrologueNode.cFunctionPrologue(3);
        JavaThreads.joinAllNonDaemonsInNative(expectedNonDaemonThreads);
        CFunctionEpilogueNode.cFunctionEpilogue(3);
    }

    @Uninterruptible(reason="Must not stop while in native.")
    @NeverInline(value="Provide a return address for the Java frame anchor.")
    private static void joinAllNonDaemonsInNative(int expectedNonDaemonThreads) {
        VMThreads.THREAD_MUTEX.lockNoTransition();
        try {
            while (nonDaemonThreads.get() > expectedNonDaemonThreads) {
                VMThreads.THREAD_LIST_CONDITION.blockNoTransition();
            }
        }
        finally {
            VMThreads.THREAD_MUTEX.unlock();
        }
    }

    public static boolean currentJavaThreadInitialized() {
        return currentThread.get() != null;
    }

    public static boolean ensureJavaThread() {
        return JavaThreads.ensureJavaThread(null, null, true);
    }

    public static boolean ensureJavaThread(String name, ThreadGroup group, boolean asDaemon) {
        if (currentThread.get() == null) {
            JavaThreads.assignJavaThread(JavaThreads.fromTarget(new Target_java_lang_Thread(name, group, asDaemon)), true);
            return true;
        }
        return false;
    }

    public static void assignJavaThread(Thread thread, boolean manuallyStarted) {
        JavaThreads.assignJavaThread0(thread);
        if (manuallyStarted) {
            JavaThreads.setThreadStatus(thread, 5);
            ThreadGroup group = thread.getThreadGroup();
            JavaThreads.toTarget(group).addUnstarted();
            JavaThreads.toTarget(group).add(thread);
            if (!thread.isDaemon()) {
                nonDaemonThreads.incrementAndGet();
            }
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void assignJavaThread0(Thread thread) {
        VMError.guarantee(currentThread.get() == null, "overwriting existing java.lang.Thread");
        currentThread.set(thread);
        assert (JavaThreads.toTarget((Thread)thread).isolateThread.isNull());
        JavaThreads.toTarget((Thread)thread).isolateThread = CurrentIsolate.getCurrentThread();
    }

    @Uninterruptible(reason="Called during isolate initialization")
    public void initializeIsolate() {
        JavaThreads.assignJavaThread0(this.mainThread);
    }

    public boolean tearDown() {
        if (!SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            return true;
        }
        return JavaThreads.tearDownJavaThreads();
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while detaching a thread.")
    public static void detachThread(IsolateThread vmThread) {
        VMThreads.THREAD_MUTEX.assertIsOwner("Must hold the VMThreads mutex");
        assert (VMThreads.StatusSupport.isStatusIgnoreSafepoints(vmThread) || VMOperation.isInProgress());
        Thread thread = currentThread.get(vmThread);
        ParkEvent.detach(JavaThreads.getUnsafeParkEvent(thread));
        ParkEvent.detach(JavaThreads.getSleepParkEvent(thread));
        JavaThreads.toTarget((Thread)thread).isolateThread = (IsolateThread)WordFactory.nullPointer();
        if (!thread.isDaemon()) {
            nonDaemonThreads.decrementAndGet();
        }
    }

    private static boolean tearDownJavaThreads() {
        Log trace = Log.noopLog().string("[JavaThreads.tearDownIsolateThreads:").newline().flush();
        VMThreads.setTearingDown();
        ArrayList<Thread> threads = new ArrayList<Thread>();
        FetchApplicationThreadsOperation operation = new FetchApplicationThreadsOperation(threads);
        operation.enqueue();
        for (Thread thread : threads) {
            if (thread == Thread.currentThread() || thread == null) continue;
            Log.noopLog().string("  interrupting: ").string(thread.getName()).newline().flush();
            thread.interrupt();
        }
        boolean result = JavaThreads.waitForTearDown();
        trace.string("  returns: ").bool(result).string("]").newline().flush();
        return result;
    }

    private static boolean waitForTearDown() {
        long startNanos;
        assert (JavaThreads.isApplicationThread(CurrentIsolate.getCurrentThread())) : "we count the application threads until only the current one remains";
        Log trace = Log.noopLog().string("[JavaThreads.waitForTearDown:").newline();
        long warningNanos = SubstrateOptions.getTearDownWarningNanos();
        String warningMessage = "JavaThreads.waitForTearDown is taking too long.";
        long failureNanos = SubstrateOptions.getTearDownFailureNanos();
        String failureMessage = "JavaThreads.waitForTearDown took too long.";
        long loopNanos = startNanos = System.nanoTime();
        AtomicBoolean printLaggards = new AtomicBoolean(false);
        Log counterLog = warningNanos == 0L ? trace : Log.log();
        CheckReadyForTearDownOperation operation = new CheckReadyForTearDownOperation(counterLog, printLaggards);
        while (true) {
            long previousLoopNanos = loopNanos;
            operation.enqueue();
            if (operation.isReadyForTearDown()) {
                trace.string("  returns true]").newline();
                return true;
            }
            loopNanos = TimeUtils.doNotLoopTooLong(startNanos, loopNanos, warningNanos, "JavaThreads.waitForTearDown is taking too long.");
            boolean fatallyTooLong = TimeUtils.maybeFatallyTooLong(startNanos, failureNanos, "JavaThreads.waitForTearDown took too long.");
            if (fatallyTooLong) {
                trace.string("Took too long to tear down the VM.").newline();
                return false;
            }
            printLaggards.set(previousLoopNanos != loopNanos);
            Thread.yield();
        }
    }

    private static boolean isApplicationThread(IsolateThread isolateThread) {
        return !VMOperationControl.isDedicatedVMOperationThread(isolateThread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"NN"}, justification="notifyAll is necessary for Java semantics, no shared state needs to be modified beforehand")
    protected static void exit(Thread thread) {
        JavaThreads.toTarget(thread).exit();
        JavaThreads.setThreadStatus(thread, 2);
        Thread thread2 = thread;
        synchronized (thread2) {
            thread.notifyAll();
        }
    }

    protected void prepareStartData(Thread thread, ThreadStartData startData) {
        startData.setIsolate(CurrentIsolate.getIsolate());
        startData.setThreadHandle(ObjectHandles.getGlobal().create((Object)thread));
        if (!thread.isDaemon()) {
            nonDaemonThreads.incrementAndGet();
        }
    }

    void startThread(Thread thread, long stackSize) {
        this.unattachedStartedThreads.incrementAndGet();
        this.doStartThread(thread, stackSize);
    }

    protected abstract void doStartThread(Thread var1, long var2);

    @SuppressFBWarnings(value={"Ru"}, justification="We really want to call Thread.run and not Thread.start because we are in the low-level thread start routine")
    protected static void threadStartRoutine(ObjectHandle threadHandle) {
        Thread thread = (Thread)ObjectHandles.getGlobal().get(threadHandle);
        JavaThreads.assignJavaThread(thread, false);
        ObjectHandles.getGlobal().destroy(threadHandle);
        JavaThreads.singleton().unattachedStartedThreads.decrementAndGet();
        JavaThreads.singleton().beforeThreadRun(thread);
        ManagementSupport.getSingleton().noteThreadStart(thread);
        try {
            if (VMThreads.isTearingDown()) {
                Thread.currentThread().interrupt();
            }
            thread.run();
        }
        catch (Throwable ex) {
            JavaThreads.dispatchUncaughtException(thread, ex);
        }
        finally {
            JavaThreads.exit(thread);
            ManagementSupport.getSingleton().noteThreadFinish(thread);
        }
    }

    protected void beforeThreadRun(Thread thread) {
    }

    protected abstract void setNativeName(Thread var1, String var2);

    protected abstract void yield();

    protected static void wakeUpVMConditionWaiters(Thread thread) {
        if (ReferenceHandler.useDedicatedThread() && thread == ((ReferenceHandlerThreadFeature)ImageSingletons.lookup(ReferenceHandlerThreadFeature.class)).getThread()) {
            Heap.getHeap().wakeUpReferencePendingListWaiters();
        }
    }

    @NeverInline(value="Starting a stack walk in the caller frame")
    static StackTraceElement[] getStackTrace(Thread thread) {
        if (thread == Thread.currentThread()) {
            return StackTraceUtils.getStackTrace(false, KnownIntrinsics.readCallerStackPointer());
        }
        StackTraceElement[][] result = new StackTraceElement[1][0];
        JavaVMOperation.enqueueBlockingSafepoint("getStackTrace", () -> {
            result[0] = JavaThreads.getStackTrace(JavaThreads.getIsolateThread(thread));
        });
        return result[0];
    }

    static Map<Thread, StackTraceElement[]> getAllStackTraces() {
        HashMap<Thread, StackTraceElement[]> result = new HashMap<Thread, StackTraceElement[]>();
        JavaVMOperation.enqueueBlockingSafepoint("getAllStackTraces", () -> {
            IsolateThread cur = VMThreads.firstThread();
            while (cur.isNonNull()) {
                result.put(JavaThreads.fromVMThread(cur), JavaThreads.getStackTrace(cur));
                cur = VMThreads.nextThread(cur);
            }
        });
        return result;
    }

    @NeverInline(value="Starting a stack walk in the caller frame")
    private static StackTraceElement[] getStackTrace(IsolateThread thread) {
        if (thread == CurrentIsolate.getCurrentThread()) {
            return StackTraceUtils.getStackTrace(false, KnownIntrinsics.readCallerStackPointer());
        }
        return StackTraceUtils.getStackTrace(false, thread);
    }

    public static void dispatchUncaughtException(Thread thread, Throwable throwable) {
        Thread.UncaughtExceptionHandler handler = thread.getUncaughtExceptionHandler();
        if (handler == null) {
            handler = Thread.getDefaultUncaughtExceptionHandler();
        }
        if (handler != null) {
            try {
                handler.uncaughtException(thread, throwable);
            }
            catch (Throwable throwable2) {}
        } else {
            System.err.print("Exception in thread \"" + Thread.currentThread().getName() + "\" ");
            throwable.printStackTrace();
        }
    }

    static void initializeNewThread(Target_java_lang_Thread tjlt, ThreadGroup groupArg, Runnable target, String name, long stackSize) {
        boolean daemon;
        int priority;
        ThreadGroup group;
        if (name == null) {
            throw new NullPointerException("name cannot be null");
        }
        tjlt.name = name;
        Thread parent = currentThread.get();
        ThreadGroup threadGroup = group = groupArg != null ? groupArg : parent.getThreadGroup();
        if (JavaThreads.toTarget(parent) == tjlt) {
            priority = 5;
            daemon = false;
        } else {
            priority = parent.getPriority();
            daemon = parent.isDaemon();
        }
        JavaContinuations.LoomCompatibilityUtil.initThreadFields(tjlt, group, target, stackSize, priority, daemon, 0);
        if (!JavaContinuations.useLoom()) {
            JavaThreads.toTarget(group).addUnstarted();
        }
        tjlt.contextClassLoader = parent.getContextClassLoader();
        tjlt.tid = Target_java_lang_Thread.nextThreadID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void park() {
        VMOperationControl.guaranteeOkayToBlock("[JavaThreads.park(): Should not park when it is not okay to block.]");
        Thread thread = Thread.currentThread();
        if (thread.isInterrupted()) {
            return;
        }
        ParkEvent parkEvent = JavaThreads.ensureUnsafeParkEvent(thread);
        int oldStatus = JavaThreads.getThreadStatus(thread);
        int newStatus = MonitorSupport.singleton().maybeAdjustNewParkStatus(657);
        JavaThreads.setThreadStatus(thread, newStatus);
        try {
            parkEvent.condWait();
        }
        finally {
            JavaThreads.setThreadStatus(thread, oldStatus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void park(long delayNanos) {
        VMOperationControl.guaranteeOkayToBlock("[JavaThreads.park(long): Should not park when it is not okay to block.]");
        Thread thread = Thread.currentThread();
        if (thread.isInterrupted()) {
            return;
        }
        ParkEvent parkEvent = JavaThreads.ensureUnsafeParkEvent(thread);
        int oldStatus = JavaThreads.getThreadStatus(thread);
        int newStatus = MonitorSupport.singleton().maybeAdjustNewParkStatus(673);
        JavaThreads.setThreadStatus(thread, newStatus);
        try {
            parkEvent.condTimedWait(delayNanos);
        }
        finally {
            JavaThreads.setThreadStatus(thread, oldStatus);
        }
    }

    static void unpark(Thread thread) {
        JavaThreads.ensureUnsafeParkEvent(thread).unpark();
    }

    private static ParkEvent ensureUnsafeParkEvent(Thread thread) {
        return ParkEvent.initializeOnce(JavaThreads.getUnsafeParkEvent(thread), false);
    }

    static void sleep(long millis) throws InterruptedException {
        if (millis < 0L) {
            throw new IllegalArgumentException("timeout value is negative");
        }
        JavaThreads.sleep0(TimeUtils.millisToNanos(millis));
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void sleep0(long delayNanos) {
        VMOperationControl.guaranteeOkayToBlock("[JavaThreads.sleep(long): Should not sleep when it is not okay to block.]");
        Thread thread = Thread.currentThread();
        ParkEvent sleepEvent = ParkEvent.initializeOnce(JavaThreads.getSleepParkEvent(thread), true);
        sleepEvent.reset();
        if (thread.isInterrupted()) {
            return;
        }
        int oldStatus = JavaThreads.getThreadStatus(thread);
        JavaThreads.setThreadStatus(thread, 225);
        try {
            sleepEvent.condTimedWait(delayNanos);
        }
        finally {
            JavaThreads.setThreadStatus(thread, oldStatus);
        }
    }

    static void interrupt(Thread thread) {
        ParkEvent sleepEvent = JavaThreads.getSleepParkEvent(thread).get();
        if (sleepEvent != null) {
            sleepEvent.unpark();
        }
    }

    static boolean isAlive(int threadStatus) {
        return threadStatus != 0 && threadStatus != 2;
    }

    private static class CheckReadyForTearDownOperation
    extends JavaVMOperation {
        private final Log trace;
        private final AtomicBoolean printLaggards;
        private boolean readyForTearDown;

        CheckReadyForTearDownOperation(Log trace, AtomicBoolean printLaggards) {
            super("CheckReadyForTearDown", VMOperation.SystemEffect.NONE);
            this.trace = trace;
            this.printLaggards = printLaggards;
        }

        boolean isReadyForTearDown() {
            return this.readyForTearDown;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void operate() {
            int unattachedStartedCount;
            int attachedCount = 0;
            VMMutex lock = VMThreads.THREAD_MUTEX.lock();
            try {
                IsolateThread isolateThread = VMThreads.firstThread();
                while (isolateThread.isNonNull()) {
                    if (JavaThreads.isApplicationThread(isolateThread)) {
                        ++attachedCount;
                        if (this.printLaggards.get() && this.trace.isEnabled() && isolateThread != this.queuingThread) {
                            this.trace.string("  laggard isolateThread: ").hex((WordBase)isolateThread);
                            Thread thread = JavaThreads.fromVMThread(isolateThread);
                            if (thread != null) {
                                String name = thread.getName();
                                Thread.State status = thread.getState();
                                boolean interruptedStatus = thread.isInterrupted();
                                this.trace.string("  thread.getName(): ").string(name).string("  interruptedStatus: ").bool(interruptedStatus).string("  getState(): ").string(status.name());
                            }
                            this.trace.newline().flush();
                        }
                    }
                    isolateThread = VMThreads.nextThread(isolateThread);
                }
                unattachedStartedCount = JavaThreads.singleton().unattachedStartedThreads.get();
            }
            finally {
                lock.unlock();
            }
            this.readyForTearDown = attachedCount == 1 && unattachedStartedCount == 0;
        }
    }

    private static class FetchApplicationThreadsOperation
    extends JavaVMOperation {
        private final List<Thread> list;

        FetchApplicationThreadsOperation(List<Thread> list) {
            super("FetchApplicationThreads", VMOperation.SystemEffect.NONE);
            this.list = list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void operate() {
            this.list.clear();
            VMMutex lock = VMThreads.THREAD_MUTEX.lock();
            try {
                IsolateThread isolateThread = VMThreads.firstThread();
                while (isolateThread.isNonNull()) {
                    Thread thread;
                    if (JavaThreads.isApplicationThread(isolateThread) && (thread = JavaThreads.fromVMThread(isolateThread)) != null) {
                        this.list.add(thread);
                    }
                    isolateThread = VMThreads.nextThread(isolateThread);
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    @RawStructure
    protected static interface ThreadStartData
    extends PointerBase {
        @RawField
        public ObjectHandle getThreadHandle();

        @RawField
        public void setThreadHandle(ObjectHandle var1);

        @RawField
        public Isolate getIsolate();

        @RawField
        public void setIsolate(Isolate var1);
    }
}

