/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.jdk;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.graal.GraalFeature;
import com.oracle.svm.core.jdk.JNIRegistrationUtil;
import com.oracle.svm.util.ReflectionUtil;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.RuntimeReflectionSupport;

@AutomaticFeature
class JDKRegistrations
extends JNIRegistrationUtil
implements GraalFeature {
    JDKRegistrations() {
    }

    public void duringSetup(Feature.DuringSetupAccess a) {
        JDKRegistrations.rerunClassInit((Feature.FeatureAccess)a, "java.io.RandomAccessFile", "java.lang.ProcessEnvironment", "java.io.File$TempDirectory", "java.nio.file.TempFileHelper", "java.lang.Terminator");
        if (JavaVersionUtil.JAVA_SPEC <= 8) {
            if (JDKRegistrations.isPosix()) {
                JDKRegistrations.rerunClassInit((Feature.FeatureAccess)a, "java.lang.UNIXProcess");
            }
        } else {
            JDKRegistrations.rerunClassInit((Feature.FeatureAccess)a, "java.lang.ProcessImpl", "java.lang.ProcessHandleImpl", "java.lang.ProcessHandleImpl$Info", "java.io.FilePermission");
        }
        if (JavaVersionUtil.JAVA_SPEC >= 15) {
            JDKRegistrations.rerunClassInit((Feature.FeatureAccess)a, "jdk.internal.loader.NativeLibraries$LibraryPaths");
        }
        if (JavaVersionUtil.JAVA_SPEC >= 16) {
            JDKRegistrations.rerunClassInit((Feature.FeatureAccess)a, "sun.nio.ch.UnixDomainSockets");
        }
        ((RuntimeReflectionSupport)ImageSingletons.lookup(RuntimeReflectionSupport.class)).preregisterAsWritableForAnalysis(ReflectionUtil.lookupField(CopyOnWriteArrayList.class, (String)"lock"));
        ((RuntimeReflectionSupport)ImageSingletons.lookup(RuntimeReflectionSupport.class)).preregisterAsWritableForAnalysis(ReflectionUtil.lookupField(AtomicReferenceArray.class, (String)"array"));
        JDKRegistrations.rerunClassInit((Feature.FeatureAccess)a, "java.lang.ApplicationShutdownHooks", "java.io.DeleteOnExitHook");
    }
}

