/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jni.hosted;

import com.oracle.svm.jni.hosted.JNIGraphKit;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.java.FrameStateBuilder;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.InvokeWithExceptionNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValuePhiNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.java.AbstractNewObjectNode;
import org.graalvm.compiler.nodes.java.ExceptionObjectNode;
import org.graalvm.compiler.nodes.java.NewInstanceNode;

public class JNIJavaCallWrapperMethodSupport {
    public ValueNode createNewObjectCall(JNIGraphKit kit, ResolvedJavaMethod invokeMethod, FrameStateBuilder state, ValueNode ... args) {
        assert (invokeMethod.isConstructor()) : "Cannot create a NewObject call to the non-constructor method " + invokeMethod;
        ResolvedJavaType receiverClass = invokeMethod.getDeclaringClass();
        AbstractNewObjectNode createdReceiver = this.createNewInstance(kit, receiverClass, true);
        int bci = kit.bci();
        args[0] = createdReceiver;
        this.startInvokeWithRetainedException(kit, invokeMethod, CallTargetNode.InvokeKind.Special, state, bci, args);
        AbstractMergeNode merge = kit.endInvokeWithException();
        merge.setStateAfter(state.create(bci, (StateSplit)merge));
        Stamp objectStamp = StampFactory.forDeclaredType(null, (JavaType)receiverClass, (boolean)true).getTrustedStamp();
        FloatingNode exceptionValue = kit.unique((FloatingNode)ConstantNode.defaultForKind((JavaKind)JavaKind.Object));
        return (ValueNode)kit.getGraph().addWithoutUnique((Node)new ValuePhiNode(objectStamp, merge, new ValueNode[]{createdReceiver, exceptionValue}));
    }

    protected AbstractNewObjectNode createNewInstance(JNIGraphKit kit, ResolvedJavaType type, boolean fillContents) {
        return (AbstractNewObjectNode)kit.append((ValueNode)new NewInstanceNode(type, fillContents));
    }

    public ValueNode createMethodCall(JNIGraphKit kit, ResolvedJavaMethod invokeMethod, CallTargetNode.InvokeKind invokeKind, FrameStateBuilder state, ValueNode ... args) {
        int bci = kit.bci();
        InvokeWithExceptionNode invoke = this.startInvokeWithRetainedException(kit, invokeMethod, invokeKind, state, bci, args);
        AbstractMergeNode invokeMerge = kit.endInvokeWithException();
        if (invoke.getStackKind() == JavaKind.Void && !invokeMethod.isConstructor()) {
            invokeMerge.setStateAfter(state.create(bci, (StateSplit)invokeMerge));
            return null;
        }
        InvokeWithExceptionNode successValue = invokeMethod.isConstructor() ? args[0] : invoke;
        FloatingNode exceptionValue = kit.unique((FloatingNode)ConstantNode.defaultForKind((JavaKind)successValue.getStackKind()));
        ValueNode[] inputs = new ValueNode[]{successValue, exceptionValue};
        ValueNode returnValue = (ValueNode)kit.getGraph().addWithoutUnique((Node)new ValuePhiNode(successValue.stamp(NodeView.DEFAULT), invokeMerge, inputs));
        JavaKind returnKind = returnValue.getStackKind();
        state.push(returnKind, returnValue);
        invokeMerge.setStateAfter(state.create(bci, (StateSplit)invokeMerge));
        state.pop(returnKind);
        return returnValue;
    }

    protected InvokeWithExceptionNode startInvokeWithRetainedException(JNIGraphKit kit, ResolvedJavaMethod invokeMethod, CallTargetNode.InvokeKind kind, FrameStateBuilder state, int bci, ValueNode ... args) {
        InvokeWithExceptionNode formerPendingException = kit.getAndClearPendingException();
        InvokeWithExceptionNode invoke = kit.startInvokeWithException(invokeMethod, kind, state, bci, args);
        kit.noExceptionPart();
        kit.setPendingException((ValueNode)formerPendingException);
        kit.exceptionPart();
        ExceptionObjectNode exceptionObject = kit.exceptionObject();
        kit.setPendingException((ValueNode)exceptionObject);
        return invoke;
    }
}

